/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.his.cer.foundation.model;

import com.mmm.his.cer.foundation.model.FlagsEmpty;
import com.mmm.his.cer.foundation.model.GfcEnum;
import com.mmm.his.cer.foundation.model.IFlags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Flags
implements IFlags {
    private static final long serialVersionUID = -7112681615816415386L;
    private Map<Class<?>, GfcEnum> flagMap = new HashMap();
    public static final IFlags NULL_FLAGS = new FlagsEmpty();

    @Override
    public <T extends GfcEnum> T setFlag(T enumValue) {
        Class<?> enumClass = enumValue.getClass();
        GfcEnum oldEnum = this.flagMap.get(enumClass);
        this.flagMap.put(enumClass, enumValue);
        return (T)oldEnum;
    }

    @Override
    public <T extends GfcEnum> T unsetFlag(Class<T> enumClass) {
        return (T)this.flagMap.remove(enumClass);
    }

    @Override
    public void clear() {
        this.flagMap.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.flagMap.isEmpty();
    }

    @Override
    public boolean isFlagSet(Class<? extends Enum> enumClass) {
        return this.flagMap.containsKey(enumClass);
    }

    @Override
    public boolean isFlagTypeSet(Class interfaceClass) {
        for (Class<?> clazz : this.flagMap.keySet()) {
            if (!clazz.isInstance(interfaceClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFlagValueSet(GfcEnum enumValue) {
        return this.flagMap.containsValue(enumValue);
    }

    @Override
    public <T extends GfcEnum> T getFlag(Class<T> enumClass) {
        return (T)this.flagMap.get(enumClass);
    }

    @Override
    public Collection<GfcEnum> getFlags() {
        return this.flagMap.values();
    }

    @Override
    public Collection<GfcEnum> getFlags(Class interfaceClass) {
        ArrayList<GfcEnum> list = new ArrayList<GfcEnum>();
        for (Class<?> clazz : this.flagMap.keySet()) {
            if (!interfaceClass.isAssignableFrom(clazz)) continue;
            list.add(this.flagMap.get(clazz));
        }
        return list;
    }

    @Override
    public int size() {
        return this.flagMap.size();
    }
}

