/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import com.mmmhis.domain.DomainString;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class DateFormatter {
    private SimpleDateFormat fmt;
    private String pattern;

    public DateFormatter(String pattern) throws IllegalArgumentException {
        this.fmt = new SimpleDateFormat(this.constructPattern(pattern));
        this.fmt.setTimeZone(TimeZone.getDefault());
    }

    public Date parse(String text) throws ParseException {
        return this.fmt.parse(text);
    }

    public String format(Calendar date) {
        return this.format(date.getTime());
    }

    public String format() {
        return this.format(new Date());
    }

    public String format(Date date) {
        return this.fmt.format(date);
    }

    private String constructPattern(String text) throws IllegalArgumentException {
        DomainString sb = new DomainString();
        boolean escaped = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!escaped) {
                switch (c) {
                    case '\t': 
                    case ' ': 
                    case '(': 
                    case ')': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case ';': {
                        sb.append(c);
                        escaped = false;
                        break;
                    }
                    case '%': {
                        if (escaped) {
                            sb.append(c);
                            escaped = false;
                            break;
                        }
                        escaped = true;
                        break;
                    }
                    default: {
                        sb.append("'" + c + "'");
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case 'a': {
                    sb.append("EE");
                    break;
                }
                case 'A': {
                    sb.append("EEEE");
                    break;
                }
                case 'b': {
                    sb.append("MMM");
                    break;
                }
                case 'B': {
                    sb.append("MMMM");
                    break;
                }
                case 'd': {
                    sb.append("dd");
                    break;
                }
                case 'e': {
                    sb.append('d');
                    break;
                }
                case 'H': {
                    sb.append("HH");
                    break;
                }
                case 'I': {
                    sb.append("hh");
                    break;
                }
                case 'j': {
                    sb.append("DDD");
                    break;
                }
                case 'm': {
                    sb.append("MM");
                    break;
                }
                case 'M': {
                    sb.append("mm");
                    break;
                }
                case 'N': {
                    sb.append('G');
                    break;
                }
                case 'p': {
                    sb.append('a');
                    break;
                }
                case 'r': {
                    sb.append(this.constructPattern("%I:%M:%S %p"));
                    break;
                }
                case 'R': {
                    sb.append(this.constructPattern("%H:%M"));
                    break;
                }
                case 'C': 
                case 'S': {
                    sb.append("ss");
                    break;
                }
                case 't': {
                    sb.append('\t');
                    break;
                }
                case 'T': {
                    sb.append(this.constructPattern("%H:%M:%S"));
                    break;
                }
                case 'u': {
                    sb.append("EE");
                    break;
                }
                case 'U': {
                    sb.append("ww");
                    break;
                }
                case 'L': 
                case 's': {
                    sb.append("SSS");
                    break;
                }
                case 'y': {
                    sb.append("yy");
                    break;
                }
                case 'Y': {
                    sb.append("yyyy");
                    break;
                }
                case 'Z': {
                    sb.append("zzzz");
                    break;
                }
            }
            escaped = false;
        }
        return sb.toString();
    }
}

