/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import java.util.Arrays;

public class DomainBitString {
    private byte[] bits;
    private int num_bits;
    private int num_bytes;
    public static final int[] mask = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    public static final int[] unmask = new int[]{127, 191, 223, 239, 247, 251, 253, 254};

    public DomainBitString(int nb) {
        this.num_bits = nb;
        this.num_bytes = this.num_bits / 8;
        if (this.num_bits % 8 != 0) {
            ++this.num_bytes;
        }
        this.bits = new byte[this.num_bytes];
        Arrays.fill(this.bits, (byte)0);
    }

    public DomainBitString(byte[] inb, int off, int len) {
        this.num_bytes = len;
        this.num_bits = len * 8;
        this.bits = new byte[len];
        System.arraycopy(inb, off, this.bits, 0, len);
    }

    public int length() {
        return this.num_bytes;
    }

    public boolean on(int off) {
        if (off < 0 || off >= this.num_bits) {
            return false;
        }
        int bix = off / 8;
        int btest = this.bits[bix] & 0xFF;
        int boff = off % 8;
        return (btest & mask[boff]) != 0;
    }

    public boolean off(int off) {
        if (off < 0 || off >= this.num_bits) {
            return true;
        }
        int bix = off / 8;
        int btest = this.bits[bix] & 0xFF;
        int boff = off % 8;
        return (btest & mask[boff]) == 0;
    }

    public int bit(int off) {
        if (off < 0 || off >= this.num_bits) {
            return 0;
        }
        int bix = off / 8;
        int btest = this.bits[bix] & 0xFF;
        int boff = off % 8;
        if ((btest & mask[boff]) != 0) {
            return 1;
        }
        return 0;
    }

    public void set(int off) {
        if (off < 0 || off >= this.num_bits) {
            return;
        }
        int bix = off / 8;
        int boff = off % 8;
        int btest = this.bits[bix] & 0xFF;
        this.bits[bix] = (byte)(btest |= mask[boff]);
    }

    public void setAll() {
        Arrays.fill(this.bits, (byte)-1);
    }

    public void clear(int off) {
        if (off < 0 || off >= this.num_bits) {
            return;
        }
        int bix = off / 8;
        int boff = off % 8;
        int btest = this.bits[bix] & 0xFF;
        this.bits[bix] = (byte)(btest &= unmask[boff]);
    }

    public void clearAll() {
        Arrays.fill(this.bits, (byte)0);
    }

    public boolean any() {
        for (int i = 0; i < this.num_bytes; ++i) {
            if (this.bits[i] == 0) continue;
            return true;
        }
        return false;
    }

    public boolean any(DomainBitString other) {
        if (this.num_bits != other.num_bits) {
            return false;
        }
        for (int i = 0; i < this.num_bytes; ++i) {
            int b1 = this.bits[i] & 0xFF;
            int b2 = other.bits[i] & 0xFF;
            if ((b1 & b2) == 0) continue;
            return true;
        }
        return false;
    }

    public void setAndOf(DomainBitString a, DomainBitString b) {
        int i;
        int lim = this.num_bytes;
        if (a.num_bytes < lim) {
            lim = a.num_bytes;
        }
        if (b.num_bytes < lim) {
            lim = b.num_bytes;
        }
        for (i = 0; i < lim; ++i) {
            int ai = a.bits[i] & 0xFF;
            int bi = b.bits[i] & 0xFF;
            this.bits[i] = (byte)(ai & bi);
        }
        while (i < this.num_bytes) {
            this.bits[i++] = 0;
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer(this.num_bits);
        for (int off = 0; off < this.num_bits; ++off) {
            int bix = off / 8;
            int btest = this.bits[bix] & 0xFF;
            int boff = off % 8;
            if ((btest & mask[boff]) != 0) {
                b.append('1');
                continue;
            }
            b.append('0');
        }
        return b.toString();
    }
}

