/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import com.mmmhis.domain.DomainEcUtil;
import com.mmmhis.domain.DomainEnvironment;
import com.mmmhis.domain.db.DBFile;
import java.lang.reflect.Field;

public abstract class DomainComponent {
    public DomainEnvironment _env;
    protected int _classID;
    protected String[] _resourceList;

    public DomainComponent(DomainEnvironment env) {
        this._env = env;
    }

    public int getClassID() {
        return this._classID;
    }

    public void setClassID(int v) {
        this._classID = v;
    }

    public void setResourceList(String[] resourceList) {
        this._resourceList = resourceList;
    }

    public abstract String getSignature();

    public abstract Object newAttributeInstance(int var1);

    public abstract byte[] getGatewayFrameIndex();

    public abstract byte[] getAttributeFrameIndex();

    public abstract byte[] getCodeListFrameIndex();

    public byte[] getCodeList(String name) {
        Field field = null;
        DomainComponent obj = null;
        int results = 0;
        int[] ptr = new int[1];
        boolean[] branch = new boolean[1];
        byte[] nameBytes = name.getBytes();
        name = name.replace('.', '_');
        try {
            obj = this;
            byte[] framesIndex = obj.getCodeListFrameIndex();
            if (framesIndex != null) {
                ptr[0] = 0;
                results = DomainEcUtil.ecIndex(nameBytes, framesIndex, 0, ptr, null, branch);
                if (results == 0) {
                    Class<?>[] classes = obj.getClass().getDeclaredClasses();
                    for (int i = 0; i < classes.length; ++i) {
                        if (!classes[i].getName().endsWith(name)) continue;
                        field = classes[i].getDeclaredField("cl");
                        field.setAccessible(true);
                        return (byte[])field.get(this);
                    }
                }
            }
        }
        catch (Exception ex) {
            return null;
        }
        return null;
    }

    public void releaseResources() {
        DBFile.ReleaseFileMaps(this._resourceList);
    }

    protected void finalize() {
        this.releaseResources();
    }
}

