/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import com.mmmhis.domain.DomainEnvironment;
import com.mmmhis.domain.DomainFloat;
import com.mmmhis.domain.DomainInteger;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.DomainVariable;
import com.mmmhis.domain.ec.EcMath;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public final class DomainCurrency
extends DomainFloat {
    static final long serialVersionUID = 3175130839095537809L;
    private static DecimalFormat format = null;

    public DomainCurrency() {
    }

    private DomainCurrency(DomainCurrency dc) {
        this(dc.getValue());
    }

    public DomainCurrency(double value) {
        super(value);
    }

    public DomainCurrency(DomainEnvironment _env, String s) {
        super(_env, s);
    }

    public DomainCurrency(DomainEnvironment _env, DomainString s) {
        super(_env, s);
    }

    public DomainCurrency(DomainCurrency[] a, int i) {
        super(a, i);
    }

    @Override
    public DomainVariable copy() {
        return new DomainCurrency(this);
    }

    public DomainCurrency setValueC(double value) {
        this.value = value;
        return this;
    }

    @Override
    public String toString() {
        return DomainCurrency.strfmon("%!+^n", this.value);
    }

    public String toString(String fmtString) {
        return DomainCurrency.strfmon(fmtString, this.value);
    }

    public static String toString(double d) {
        return DomainCurrency.strfmon("%!+^n", d);
    }

    private static DecimalFormat getDecimalFormat() {
        if (format == null) {
            format = (DecimalFormat)NumberFormat.getCurrencyInstance();
            DomainCurrency.SetCurrencyFormatToOracle8default(format);
        }
        return format;
    }

    private static void SetCurrencyFormatToOracle8default(DecimalFormat format) {
        Locale currentLocale = Locale.getDefault();
        if (currentLocale.equals(Locale.CANADA)) {
            format.applyPattern("\u00a4#,##0.00");
        } else if (currentLocale.equals(Locale.CANADA_FRENCH)) {
            format.applyPattern("#,##0.00 \u00a4;(#,##0.00\u00a4)");
        } else if (currentLocale.equals(Locale.CHINA)) {
            format.applyPattern("\u00a4#,##0.00");
        } else if (currentLocale.equals(Locale.FRANCE)) {
            format.applyPattern("#,##0.00 \u00a4");
        } else if (currentLocale.equals(Locale.GERMANY)) {
            format.applyPattern("#,##0.00 \u00a4");
        } else if (currentLocale.equals(Locale.ITALY)) {
            format.applyPattern("\u00a4 #,##0.00");
        } else if (currentLocale.equals(Locale.JAPAN)) {
            format.applyPattern("\u00a4#,##0");
        } else if (currentLocale.equals(Locale.KOREA)) {
            format.applyPattern("\u00a4#,##0");
        } else if (currentLocale.equals(Locale.PRC)) {
            format.applyPattern("\u00a4#,##0.00");
        } else if (currentLocale.equals(Locale.TAIWAN)) {
            format.applyPattern("\u00a4#,##0.00");
        } else if (currentLocale.equals(Locale.UK)) {
            format.applyPattern("\u00a4#,##0.00");
        } else if (currentLocale.equals(Locale.US)) {
            format.applyPattern("\u00a4#,##0.00;(\u00a4#,##0.00)");
        }
    }

    protected static synchronized String strfmon(String fmt, double value) {
        int fillChar = 0;
        boolean suppressCurrency = false;
        boolean posSignStyle = false;
        boolean intl = false;
        int rightPrec = 2;
        int leftPrec = -1;
        DomainString buffer = new DomainString(47);
        DecimalFormatSymbols symbols = DomainCurrency.getDecimalFormat().getDecimalFormatSymbols();
        String defaultCurrencySymbol = symbols.getCurrencySymbol();
        String defaultPattern = format.toPattern();
        char[] fmtBuffer = fmt.toCharArray();
        int fmtIndex = 0;
        block12: while (fmtIndex < fmtBuffer.length) {
            int begin;
            if (fmtBuffer[fmtIndex] != '%' || fmtBuffer[++fmtIndex] == '%') {
                buffer.append(fmtBuffer[fmtIndex]);
                ++fmtIndex;
                continue;
            }
            posSignStyle = true;
            fillChar = 32;
            boolean dontGroup = false;
            suppressCurrency = false;
            boolean alignLeft = false;
            intl = false;
            block13: while (true) {
                switch (fmtBuffer[fmtIndex++]) {
                    case '=': {
                        if (fmtBuffer[fmtIndex] == '\u0000') continue block13;
                        fillChar = fmtBuffer[fmtIndex++];
                        continue block13;
                    }
                    case '!': {
                        suppressCurrency = true;
                        continue block13;
                    }
                    case '+': {
                        posSignStyle = true;
                        continue block13;
                    }
                    case '(': {
                        posSignStyle = false;
                        continue block13;
                    }
                    case '^': {
                        dontGroup = true;
                        continue block13;
                    }
                    case '-': {
                        alignLeft = true;
                        continue block13;
                    }
                }
                break;
            }
            if (Character.isDigit(fmtBuffer[--fmtIndex])) {
                begin = fmtIndex;
                while (Character.isDigit(fmtBuffer[fmtIndex])) {
                    ++fmtIndex;
                }
                leftPrec = DomainInteger.parseInt(new DomainString(fmtBuffer, begin, fmtIndex - begin), 10);
            }
            if (fmtBuffer[fmtIndex] == '#') {
                begin = ++fmtIndex;
                while (Character.isDigit(fmtBuffer[fmtIndex])) {
                    ++fmtIndex;
                }
                leftPrec = DomainInteger.parseInt(new DomainString(fmtBuffer, begin, fmtIndex - begin), 10);
            }
            if (fmtBuffer[fmtIndex] == '.') {
                begin = ++fmtIndex;
                while (Character.isDigit(fmtBuffer[fmtIndex])) {
                    ++fmtIndex;
                }
                rightPrec = DomainInteger.parseInt(new DomainString(fmtBuffer, begin, fmtIndex - begin), 10);
            }
            switch (fmtBuffer[fmtIndex]) {
                case 'i': {
                    intl = true;
                    ++fmtIndex;
                    break;
                }
                case 'n': {
                    intl = false;
                    ++fmtIndex;
                    break;
                }
                default: {
                    break block12;
                }
            }
            format.setGroupingUsed(!dontGroup);
            if (leftPrec != -1) {
                format.setMaximumIntegerDigits(leftPrec);
            }
            format.setMaximumFractionDigits(rightPrec);
            format.setMinimumFractionDigits(rightPrec);
            if (suppressCurrency) {
                symbols.setCurrencySymbol("");
                format.setDecimalFormatSymbols(symbols);
            } else if (intl) {
                symbols.setCurrencySymbol(symbols.getInternationalCurrencySymbol() + " ");
                format.setDecimalFormatSymbols(symbols);
            }
            if (posSignStyle) {
                char[] patternChars = format.toPattern().toCharArray();
                DomainString patternBuffer = new DomainString(patternChars.length);
                for (int i = 0; i < patternChars.length; ++i) {
                    if (patternChars[i] == '(' || patternChars[i] == ')') continue;
                    patternBuffer.append(patternChars[i]);
                }
                format.applyPattern(patternBuffer.toString());
            }
            buffer.append(format.format(EcMath.round(value, rightPrec)));
        }
        if (suppressCurrency || intl) {
            symbols.setCurrencySymbol(defaultCurrencySymbol);
            format.setDecimalFormatSymbols(symbols);
        }
        if (posSignStyle) {
            format.applyPattern(defaultPattern);
        }
        return buffer.toString();
    }

    @Override
    public DomainVariable getNewInstance(DomainVariable[] a, int i) {
        return new DomainCurrency((DomainCurrency[])a, i);
    }
}

