/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import com.mmmhis.domain.DomainByteArrayFileMap;
import com.mmmhis.domain.DomainEnvironment;
import com.mmmhis.domain.DomainInteger;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.DomainVariable;

public final class DomainFixedString
extends DomainVariable {
    private static final long serialVersionUID = 3009577544007177272L;
    char[] value;

    private void Construct(int length) {
        this.value = new char[length];
        for (int i = 0; i < length; ++i) {
            this.value[i] = 32;
        }
    }

    private void Construct(int length, String str) {
        this.Construct(length);
        if (str == null) {
            throw new NullPointerException();
        }
        int copy_length = str.length() > length ? length : str.length();
        for (int i = 0; i < copy_length; ++i) {
            this.value[i] = str.charAt(i);
        }
    }

    public DomainFixedString(int length) {
        this.Construct(length);
    }

    public DomainFixedString(int length, String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        this.Construct(length, str);
    }

    public DomainFixedString(int length, DomainString str) {
        if (str == null) {
            throw new NullPointerException();
        }
        this.Construct(length, str.toString());
    }

    public DomainFixedString(int length, DomainFixedString str) {
        if (str == null) {
            throw new NullPointerException();
        }
        this.Construct(length, str.toString());
    }

    public DomainFixedString(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        this.Construct(str.length(), str);
    }

    public DomainFixedString(DomainString str) {
        if (str == null) {
            throw new NullPointerException();
        }
        this.Construct(str.length(), str.toString());
    }

    public DomainFixedString(DomainFixedString str) {
        if (str == null) {
            throw new NullPointerException();
        }
        this.Construct(str.length(), str.toString());
    }

    public DomainFixedString(int length, DomainFixedString[] a, int i) {
        this(length);
        this.DVArray = a;
        this.DVIndex = i;
    }

    public DomainFixedString(int length, String str, DomainFixedString[] a, int i) {
        this(length, str);
        this.DVArray = a;
        this.DVIndex = i;
    }

    public DomainFixedString(int length, DomainString str, DomainFixedString[] a, int i) {
        this(length, str);
        this.DVArray = a;
        this.DVIndex = i;
    }

    public DomainFixedString(String str, DomainFixedString[] a, int i) {
        this(str);
        this.DVArray = a;
        this.DVIndex = i;
    }

    public DomainFixedString(DomainString str, DomainFixedString[] a, int i) {
        this(str);
        this.DVArray = a;
        this.DVIndex = i;
    }

    public DomainFixedString(DomainFixedString str, DomainFixedString[] a, int i) {
        this(str);
        this.DVArray = a;
        this.DVIndex = i;
    }

    public int length() {
        return this.value.length;
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = 32;
        }
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.value.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    public char[] toCharArray() {
        char[] result = new char[this.value.length];
        System.arraycopy(this.value, 0, result, 0, this.value.length);
        return result;
    }

    public byte[] toByteArray() {
        int count = this.value.length;
        int i = 0;
        byte[] byteArr = new byte[count];
        while (i < count) {
            byteArr[i] = (byte)this.value[i++];
        }
        return byteArr;
    }

    void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.value.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.value[index] = ch;
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(DomainFixedString str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(String str, int fromIndex) {
        return DomainFixedString.indexOf(this.value, 0, this.value.length, str.toCharArray(), 0, str.length(), fromIndex);
    }

    public int indexOf(DomainFixedString str, int fromIndex) {
        return DomainFixedString.indexOf(this.value, 0, this.value.length, str.value, 0, str.length(), fromIndex);
    }

    public static int indexOf(String s, DomainFixedString sub, DomainInteger position) {
        return DomainFixedString.indexOf(s.toCharArray(), 0, s.length(), sub.value, 0, sub.length(), 0, position);
    }

    public static int indexOf(DomainFixedString s, String sub, DomainInteger position) {
        return DomainFixedString.indexOf(s.value, 0, s.length(), sub.toCharArray(), 0, sub.length(), 0, position);
    }

    public static int indexOf(DomainFixedString s, DomainString sub, DomainInteger position) {
        return DomainFixedString.indexOf(s, sub.toString(), position);
    }

    public static int indexOf(DomainFixedString s, DomainFixedString sub, DomainInteger position) {
        return DomainFixedString.indexOf(s.value, 0, s.length(), sub.value, 0, sub.length(), 0, position);
    }

    public static int indexOfI(String s, String sub, DomainInteger position) {
        return DomainFixedString.indexOf(s.toLowerCase().toCharArray(), 0, s.length(), sub.toLowerCase().toCharArray(), 0, sub.length(), 0, position);
    }

    public static int indexOfI(String s, DomainFixedString sub, DomainInteger position) {
        return DomainFixedString.indexOf(s.toLowerCase().toCharArray(), 0, s.length(), DomainFixedString.toLowerCaseC((DomainFixedString)sub).value, 0, sub.length(), 0, position);
    }

    public static int indexOfI(DomainFixedString s, String sub, DomainInteger position) {
        return DomainFixedString.indexOf(DomainFixedString.toLowerCaseC((DomainFixedString)s).value, 0, s.length(), sub.toLowerCase().toCharArray(), 0, sub.length(), 0, position);
    }

    public static int indexOfI(DomainFixedString s, DomainString sub, DomainInteger position) {
        return DomainFixedString.indexOf(s, sub.toString(), position);
    }

    public static int indexOfI(DomainFixedString s, DomainFixedString sub, DomainInteger position) {
        return DomainFixedString.indexOf(DomainFixedString.toLowerCaseC((DomainFixedString)s).value, 0, s.length(), DomainFixedString.toLowerCaseC((DomainFixedString)sub).value, 0, sub.length(), 0, position);
    }

    private static int indexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex, DomainInteger position) {
        int pos = DomainFixedString.indexOf(source, sourceOffset, sourceCount, target, targetOffset, targetCount, fromIndex);
        if (pos == -1) {
            return 0;
        }
        position.setValue(pos);
        return 1;
    }

    static int indexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount || targetCount == 0) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        char first = target[targetOffset];
        int i = sourceOffset + fromIndex;
        int max = sourceOffset + (sourceCount - targetCount);
        block0: while (true) {
            if (i <= max && source[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end) {
                if (source[j++] == target[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i - sourceOffset;
    }

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, str.length());
    }

    public int lastIndexOf(DomainFixedString str) {
        return this.lastIndexOf(str, str.length());
    }

    public int lastIndexOf(String str, int fromIndex) {
        return DomainFixedString.lastIndexOf(this.value, 0, this.value.length, str.toCharArray(), 0, str.length(), fromIndex);
    }

    public int lastIndexOf(DomainFixedString str, int fromIndex) {
        return DomainFixedString.lastIndexOf(this.value, 0, this.value.length, str.value, 0, str.length(), fromIndex);
    }

    public static int lastIndexOf(String s, DomainFixedString sub, DomainInteger position) {
        return DomainFixedString.lastIndexOf(s.toCharArray(), 0, s.length(), sub.value, 0, sub.length(), s.length(), position);
    }

    public static int lastIndexOf(DomainFixedString s, String sub, DomainInteger position) {
        return DomainFixedString.lastIndexOf(s.value, 0, s.length(), sub.toCharArray(), 0, sub.length(), s.length(), position);
    }

    public static int lastIndexOf(DomainFixedString s, DomainString sub, DomainInteger position) {
        return DomainFixedString.lastIndexOf(s, sub.toString(), position);
    }

    public static int lastIndexOf(DomainFixedString s, DomainFixedString sub, DomainInteger position) {
        return DomainFixedString.lastIndexOf(s.value, 0, s.length(), sub.value, 0, sub.length(), s.length(), position);
    }

    public static int lastIndexOfI(String s, DomainFixedString sub, DomainInteger position) {
        return DomainFixedString.lastIndexOf(s.toLowerCase().toCharArray(), 0, s.length(), DomainFixedString.toLowerCaseC((DomainFixedString)sub).value, 0, sub.length(), s.length(), position);
    }

    public static int lastIndexOfI(DomainFixedString s, String sub, DomainInteger position) {
        return DomainFixedString.lastIndexOf(DomainFixedString.toLowerCaseC((DomainFixedString)s).value, 0, s.length(), sub.toLowerCase().toCharArray(), 0, sub.length(), s.length(), position);
    }

    public static int lastIndexOfI(DomainFixedString s, DomainString sub, DomainInteger position) {
        return DomainFixedString.lastIndexOf(s, sub.toString(), position);
    }

    public static int lastIndexOfI(DomainFixedString s, DomainFixedString sub, DomainInteger position) {
        return DomainFixedString.lastIndexOf(DomainFixedString.toLowerCaseC((DomainFixedString)s).value, 0, s.length(), DomainFixedString.toLowerCaseC((DomainFixedString)sub).value, 0, sub.length(), s.length(), position);
    }

    private static int lastIndexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex, DomainInteger position) {
        int pos = DomainFixedString.lastIndexOf(source, sourceOffset, sourceCount, target, targetOffset, targetCount, fromIndex);
        if (pos == -1) {
            return 0;
        }
        position.setValue(pos);
        return 1;
    }

    static int lastIndexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        int start;
        int rightIndex = sourceCount - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return -1;
        }
        int strLastIndex = targetOffset + targetCount - 1;
        char strLastChar = target[strLastIndex];
        int min = sourceOffset + targetCount - 1;
        int i = min + fromIndex;
        block0: while (true) {
            if (i >= min && source[i] != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                if (source[j--] == target[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start - sourceOffset + 1;
    }

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(int ch, int fromIndex) {
        int max = this.value.length;
        char[] v = this.value;
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= this.value.length) {
            return -1;
        }
        for (int i = fromIndex; i < max; ++i) {
            if (v[i] != ch) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String toString() {
        return new String(this.value, 0, this.value.length);
    }

    public String getValue() {
        return this.toString();
    }

    public DomainFixedString setValue(int size, String str) {
        this.Construct(size, str);
        return this;
    }

    public DomainFixedString setValue(String str) {
        this.Construct(this.value.length, str);
        return this;
    }

    public DomainFixedString setValue(DomainString str) {
        this.Construct(this.value.length, str.toString());
        return this;
    }

    public DomainFixedString setValue(DomainFixedString str) {
        if (this != str) {
            this.Construct(this.value.length, str.toString());
        }
        return this;
    }

    @Override
    public DomainVariable setValue(DomainVariable v) {
        this.setValue(v.toString());
        return this;
    }

    @Override
    public DomainVariable setValue(DomainEnvironment _env, String str) {
        _env.LastError.reset();
        if (str == null || str.length() <= 0) {
            _env.LastError.setValue(4);
            this.reset();
            return this;
        }
        return this.setValue(str);
    }

    @Override
    public DomainVariable setValue(DomainEnvironment _env, DomainString str) {
        _env.LastError.reset();
        if (str == null || str.count <= 0) {
            _env.LastError.setValue(4);
            this.reset();
            return this;
        }
        return this.setValue(str);
    }

    public DomainVariable setValue(DomainEnvironment _env, DomainFixedString str) {
        _env.LastError.reset();
        if (str == null || str.length() <= 0) {
            _env.LastError.setValue(4);
            this.reset();
            return this;
        }
        return this.setValue(str);
    }

    public DomainVariable setValue(byte[] buffer, int start, int len) {
        if (len > this.value.length) {
            len = this.value.length;
        }
        int i = len;
        while (i-- > 0) {
            this.value[i] = (char)(buffer[i + start] & 0xFF);
        }
        return this;
    }

    public DomainVariable setValue(DomainByteArrayFileMap buffer, int start, int len) {
        if (len > this.value.length) {
            len = this.value.length;
        }
        int i = len;
        while (i-- > 0) {
            this.value[i] = (char)(buffer.getByte(i + start) & 0xFF);
        }
        return this;
    }

    public int hashCode() {
        int h = 0;
        int off = 0;
        for (int i = 0; i < this.value.length; ++i) {
            h = 31 * h + this.value[off++];
        }
        return h;
    }

    public boolean equals(Object anObject) {
        DomainFixedString anotherString;
        int n;
        if (this == anObject) {
            return true;
        }
        if ((anObject instanceof DomainFixedString || anObject instanceof DomainString || anObject instanceof String) && (n = this.value.length) == (anotherString = (DomainFixedString)anObject).length()) {
            char[] v1 = this.value;
            char[] v2 = anotherString.value;
            int i = 0;
            int j = 0;
            while (n-- != 0) {
                if (v1[i++] == v2[j++]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int compareTo(Object o) {
        return this.compareTo((DomainFixedString)o);
    }

    public int compareTo(String s) {
        return this.compareTo(s.toCharArray(), s.length());
    }

    public int compareTo(DomainFixedString s) {
        return this.compareTo(s.value, s.length());
    }

    private int compareTo(char[] arr, int arrLen) {
        int len1 = this.value.length;
        int len2 = arrLen;
        int n = Math.min(len1, len2);
        char[] v1 = this.value;
        char[] v2 = arr;
        int i = 0;
        int j = 0;
        if (i == j) {
            int lim = n + i;
            for (int k = i; k < lim; ++k) {
                char c1 = v1[k];
                char c2 = v2[k];
                if (c1 == c2) continue;
                return c1 - c2;
            }
        } else {
            while (n-- != 0) {
                char c2;
                char c1;
                if ((c1 = v1[i++]) == (c2 = v2[j++])) continue;
                return c1 - c2;
            }
        }
        return len1 - len2;
    }

    public void toUpperCase() {
        String upperStr = new String(this.value).toUpperCase();
        this.Construct(this.value.length, upperStr);
    }

    public static DomainFixedString toUpperCaseC(String str) {
        return new DomainFixedString(str.toUpperCase());
    }

    public static DomainFixedString toUpperCaseC(DomainFixedString str) {
        DomainFixedString newStr = new DomainFixedString(str);
        newStr.toUpperCase();
        return newStr;
    }

    public void toLowerCase() {
        String lowerStr = new String(this.value).toLowerCase();
        this.Construct(this.value.length, lowerStr);
    }

    public static DomainFixedString toLowerCaseC(String str) {
        return new DomainFixedString(str.toLowerCase());
    }

    public static DomainFixedString toLowerCaseC(DomainFixedString str) {
        DomainFixedString newStr = new DomainFixedString(str);
        newStr.toLowerCase();
        return newStr;
    }

    public void toProperCase() {
        this.toLowerCase();
        if (this.value.length > 0) {
            this.setCharAt(0, Character.toUpperCase(this.charAt(0)));
        }
    }

    public static DomainFixedString toProperCaseC(String str) {
        DomainFixedString newStr = new DomainFixedString(str);
        newStr.toProperCase();
        return newStr;
    }

    public static DomainFixedString toProperCaseC(DomainFixedString str) {
        DomainFixedString newStr = new DomainFixedString(str);
        newStr.toProperCase();
        return newStr;
    }

    @Override
    public DomainVariable copy() {
        return new DomainFixedString(this);
    }

    @Override
    public boolean isTrue() {
        for (int i = 0; i < this.value.length; ++i) {
            if (this.value[i] == ' ') continue;
            return true;
        }
        return false;
    }

    @Override
    public DomainVariable getNewInstance(DomainVariable[] a, int i) {
        return new DomainFixedString(this.value.length, (DomainFixedString[])a, i);
    }

    private static DomainFixedString valueOf(double d) {
        return new DomainFixedString(String.valueOf(d));
    }

    public static void fixedExtract(DomainFixedString source, int position, DomainFixedString destination) {
        if (position < 0 || position > source.length() || position + destination.length() > source.length()) {
            destination.reset();
        } else {
            System.arraycopy(source.value, position, destination.value, 0, destination.length());
        }
    }

    public static int fixedCompare(DomainFixedString source, int position, DomainFixedString compare) {
        if (position < 0 || position > source.length() || position + compare.length() > source.length()) {
            return -1;
        }
        for (int index = 0; index < compare.length(); ++index) {
            if (source.value[index + position] == compare.value[index]) continue;
            if (source.value[index + position] < compare.value[index]) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public static int fixedCompareI(DomainFixedString source, int position, DomainFixedString compare) {
        DomainFixedString temp1 = DomainFixedString.toLowerCaseC(source);
        DomainFixedString temp2 = DomainFixedString.toLowerCaseC(compare);
        return DomainFixedString.fixedCompare(temp1, position, temp2);
    }

    public static void fixedOverlay(DomainFixedString destination, int position, DomainFixedString source) {
        if (position < 0 || position > destination.length() || position + source.length() > destination.length()) {
            destination.reset();
        } else {
            System.arraycopy(source.value, 0, destination.value, position, source.length());
        }
    }

    public int pack(DomainEnvironment env, String format, Object[] objs) {
        DomainString temp = new DomainString(this.toString());
        int return_value = temp.pack(env, format, objs);
        this.Construct(this.value.length, temp.toString());
        return return_value;
    }

    public int unpack(DomainEnvironment env, String format, Object[] objs) {
        DomainString temp = new DomainString(this.toString());
        int return_value = temp.unpack(env, format, objs);
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] != this) continue;
            this.Construct(this.value.length, ((DomainFixedString)objs[i]).toString());
            return return_value;
        }
        this.Construct(this.value.length, temp.toString());
        return return_value;
    }

    public DomainString strPartial(int start, int length) {
        int count = this.value.length;
        if (start < 0 || start > count || start + length > count || length < 0 || length > count) {
            return new DomainString("");
        }
        if (length == 0) {
            length = count - start;
        }
        return new DomainString(this.value, start, length);
    }

    public DomainString strPartial(DomainInteger start, int length) {
        return this.strPartial(start.getValue(), length);
    }

    public DomainString strPartial(int start, DomainInteger length) {
        return this.strPartial(start, length.getValue());
    }

    public DomainString strPartial(DomainInteger start, DomainInteger length) {
        return this.strPartial(start.getValue(), length.getValue());
    }

    public static DomainString strPartial(String s, int start, int length) {
        return new DomainString(s).strPartial(start, length);
    }

    private boolean startsWith(char[] buffer, int length, int toffset) {
        char[] ta = this.value;
        int to = toffset;
        char[] pa = buffer;
        int po = 0;
        int pc = length;
        if (toffset < 0 || toffset > this.value.length - pc) {
            return false;
        }
        while (--pc >= 0) {
            if (ta[to++] == pa[po++]) continue;
            return false;
        }
        return true;
    }

    public int strStartsWith(String prefix) {
        return this.startsWith(prefix.toCharArray(), prefix.length(), 0) ? 1 : 0;
    }

    public int strStartsWith(DomainString prefix) {
        return this.startsWith(prefix.value, prefix.count, 0) ? 1 : 0;
    }

    public int strStartsWith(DomainFixedString prefix) {
        return this.startsWith(prefix.value, prefix.value.length, 0) ? 1 : 0;
    }

    public static int strStartsWith(String source, String prefix) {
        return source.startsWith(prefix) ? 1 : 0;
    }

    public static int strStartsWith(String source, DomainFixedString prefix) {
        return source.startsWith(prefix.toString()) ? 1 : 0;
    }

    public int strEndsWith(String suffix) {
        return this.startsWith(suffix.toCharArray(), suffix.length(), this.value.length - suffix.length()) ? 1 : 0;
    }

    public int strEndsWith(DomainString suffix) {
        return this.startsWith(suffix.value, suffix.count, this.value.length - suffix.count) ? 1 : 0;
    }

    public int strEndsWith(DomainFixedString suffix) {
        return this.startsWith(suffix.value, suffix.value.length, this.value.length - suffix.value.length) ? 1 : 0;
    }

    public static int strEndsWith(String source, String suffix) {
        return source.endsWith(suffix) ? 1 : 0;
    }

    public static int strEndsWith(String source, DomainFixedString suffix) {
        return source.endsWith(suffix.toString()) ? 1 : 0;
    }
}

