/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

public final class DomainFmtManager {
    protected boolean delimited;
    protected char delimiter;
    protected int nextWidth;
    protected int nextType;
    protected int nextDim;
    protected char nextZero;
    protected boolean nextLeft;
    protected String format;
    protected int foff;
    protected int flen;

    DomainFmtManager(String fmt) {
        this.format = fmt;
        this.delimited = false;
        this.foff = 0;
        this.flen = this.format.length();
        this.nextItem();
    }

    protected void nextItem() {
        this.nextLeft = false;
        this.nextZero = (char)32;
        this.nextWidth = 0;
        this.nextDim = 1;
        this.nextType = 0;
        if (this.foff >= this.flen) {
            return;
        }
        char fmt = this.format.charAt(this.foff++);
        switch (fmt) {
            case 'a': {
                int dim = this.getWidth();
                this.nextItem();
                this.nextDim = dim;
                break;
            }
            case 'w': {
                this.delimited = false;
                this.nextItem();
                break;
            }
            case 'p': {
                this.delimited = true;
                this.delimiter = this.format.charAt(this.foff++);
                this.nextItem();
                break;
            }
            case 'i': {
                this.nextType = 1;
                this.nextWidth = this.getWidth();
                break;
            }
            case 's': {
                this.nextType = 2;
                this.nextWidth = this.getWidth();
                break;
            }
            default: {
                this.nextType = 3;
                this.nextWidth = this.getWidth();
            }
        }
    }

    private int getWidth() {
        int w = 0;
        boolean firstDigit = true;
        this.nextLeft = false;
        this.nextZero = (char)32;
        while (this.foff < this.flen) {
            char c = this.format.charAt(this.foff);
            if (c == '-') {
                this.nextLeft = true;
            } else if (c == '0') {
                if (firstDigit) {
                    this.nextZero = (char)48;
                }
                w *= 10;
            } else {
                if (c < '1' || c > '9') break;
                w = 10 * w + (c - 48);
            }
            ++this.foff;
            firstDigit = false;
        }
        return w;
    }
}

