/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import com.mmmhis.domain.DomainBufferedReader;
import com.mmmhis.domain.DomainException;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.db.DBControl;
import com.mmmhis.domain.td.TDFile;
import com.mmmhis.domain.td.TDHandle;
import com.mmmhis.domain.td.TDSection;
import com.mmmhis.domain.td.TDTag;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public final class DomainIeFile {
    public static final int IE_GET = 0;
    public static final int IE_PUT = 1;
    public static final String IE_EOR = "<EOR>";
    public static final String IE_SEPARATOR = "=";
    public static final String IE_LEGACY_EOR = "EOR:";
    public static final String IE_LEGACY_SEPARATOR = ":";
    public static final String IE_XTAG = "X";
    public static final String IE_LEGACYSTR = "legacy";
    public static final int IE_MAXTAGLENGTH = 6;
    public static final String IE_XML_VERSION = "<?xml version=\"1.0\" encoding=\"ASCII\" standalone=\"yes\"?>";
    public static final String IE_XML_ROOT = "record";
    public static final String IE_XML_EOR = "[EOR]";
    public static final String IE_XML_CASE = "upper";
    public static final String IE_XML_ATTRIBUTES = "";
    public static final String IE_XML_COMMENT = "";
    public static final int IE_IN_TAGGED = 0;
    public static final int IE_OUT_TAGGED = 1;
    public static final int IE_IN_FLAT = 2;
    public static final int IE_OUT_FLAT = 3;
    public static final int IE_IN_XML = 4;
    public static final int IE_OUT_XML = 5;
    public static final int IE_IN_CONPLUS = 6;
    public static final int IE_OUT_CONPLUS = 7;
    public static final int IE_IN_LEGACY = 8;
    public static final int IE_OUT_LEGACY = 9;
    public static final int IE_IN_DOM = 10;
    public static final int IE_OUT_DOM = 11;
    public static final String IeRC_PATH = "Interface";
    public static final String IeRC_INPUTFILE = "InputFile";
    public static final String IeRC_OUTPUTFILE = "OutputFile";
    public static final String IeRC_SEGMENT = "Segment";
    public static final String IeRC_OFFSET = "Offset";
    public static final String IeRC_DATEOUT = "DateOut";
    public static final String IeRC_DATEIN = "DateIn";
    public static final String IeRC_TIMEOUT = "TimeOut";
    public static final String IeRC_TIMEIN = "TimeIn";
    public static final String IeRC_SEPARATOR = "Separator";
    public static final String IeRC_EOR = "EOR";
    public static final String IeRC_INTERACTIVE = "Interactive";
    public static final String IeRC_CONVERT_INPUT = "ConvertInput";
    public static final String IeRC_TRUNCATE = "Truncate";
    public static final String IeRC_FLUSH = "Flush";
    public static final String IeRC_IOTYPE = "iotype";
    public static final String IeRC_DEBUG = "Interface/Debug";
    public static final String IeRC_ROOT = "root";
    public static final String IeRC_XMLVERS = "version";
    public static final String IeRC_CASE = "case";
    public static final String IeRC_ATTRIB = "attributes";
    public static final String IeRC_INDENT = "indent";
    public static final String IeRC_COMMENT = "comment";
    public static final String IeRC_IOTAGGED = "tagged";
    public static final String IeRC_IOFLAT = "flat";
    public static final String IeRC_XML = "xml";
    public static final String IeRC_LEGACY = "legacy";
    public static final String IeRC_CONPLUS = "conplus";
    public static final String IeRC_LEGACYFLAG = "interfaced";
    public static final String IeRC_MAINDIC = "MainDic";
    public static final String IeRC_SECONDDIC = "SecondDic";
    public static final String IeRC_SWITCHDIC = "SwitchDic";
    public static final String IeRC_BUFSIZE_IN = "InputBufferSize";
    public static final String IeRC_BUFSIZE_OUT = "OutputBufferSize";
    public static final String IeRC_NICEBATCHPRI = "NiceBatchPriority";
    public static final String IeRC_CtlFile = "ResourceEdit/CtlFile";
    public static final String IeRC_Increment = "ResourceEdit/Increment";
    public static final String IeRC_FilePath = "ResourceEdit/ControlFilePath";
    public static final String IeRC_RCSNewFile = "ResourceEdit/NewFile";
    public static final String IeRC_RCSFilePath = "ResourceEdit/RCSPath";
    public static final String IeRC_Current = "ResourceEdit/Current";
    public static final String IeRC_EditPrefix = "ResourceEdit/Current/Prefix";
    public static final String IeRC_NextValue = "ResourceEdit/Current/Next";
    public static final String IeRC_EditPath = "ResourceEdit/OpenFiles/";
    public static final String IeRC_NewFile_Tag = "/NewFile";
    public static final String IeRC_RCSPath_Tag = "/ResourcePath";
    public static final String IeRC_LockFile = "ResourceEdit/LockFile";
    public static final String IeRC_TempPath = "ResourceEdit/TempPath";
    public static final String IeRC_RootPath = "ResourceEdit/RootPath";
    public static final int IE_REGISTER_BIT = 1;
    public static final int IE_REBUILD_BIT = 2;
    public static final String IeRC_Flag_Tag = "/Flag";
    public static final int IE_CLOSE_RCS = 0;
    public static final int IE_MARK_REBUILD = 1;
    public static final int IE_REBUILD_ALL = 2;
    public static final int IE_CLOSE_ALL = 3;
    public static final int IE_REBUILD_FILE = 4;
    public static final int IE_CLOSE_FILE = 5;
    public static final int IE_REBUILD_RCS = 6;
    public static final int IEERROR_TOPLEVELCREATE = 257;
    public static final int IEERROR_TOPLEVELWRITE = 258;
    public static final int IEERROR_TOPLEVELFIND = 259;
    public static final int IEERROR_SECTIONCREATEFIND = 260;
    public static final int IEERROR_TAGCREATEFIND = 261;
    public static final int IEERROR_OUTOFMEMORY = 262;
    public static final int IEERROR_SIMPLENAMEREQUIRED = 263;
    public static final int IEERROR_OUTPUTSTREAM = 264;
    public static final int IEERROR_INPUTSTREAM = 265;
    public static final int IEERROR_STREAMOPEN = 266;
    public static final int IEERROR_OPEN_INSTREAM = 267;
    public static final int IEERROR_OPEN_OUTSTREAM = 268;
    public static final int IEERROR_STREAMALREADYOPEN = 269;
    int type;
    File file;
    Document currentDOM;
    int currentAttribute;
    Node currentNode;
    Reader reader;
    Writer writer;
    String name;
    TDHandle handle;
    String endOfRecord;
    String rootRecord;
    String version;
    boolean rootExists;
    boolean lowerCase;
    boolean flush;
    int indentation;
    boolean recordsWritten;
    boolean firstWritten;
    int spaces;
    String tagSeparator;
    int ioType;
    boolean segment;
    DBControl dbControl;

    public DomainIeFile(DBControl dbControl, int type) {
        this.dbControl = dbControl;
        this.type = type;
    }

    static Node domSkipTextNode(Node node) {
        while (node != null && node.getNodeType() == 3) {
            node = node.getNextSibling();
        }
        return node;
    }

    int get(String name, DomainString value) {
        switch (this.ioType) {
            case 4: 
            case 10: {
                return this.domGet(name, value);
            }
            case 0: 
            case 8: {
                if (this.handle == null) {
                    return 113;
                }
                TDTag[] tag = new TDTag[1];
                int status = this.handle.findTag(name, tag);
                if (status == 0 && value != null) {
                    value.setValue(tag[0].getValue());
                }
                return status;
            }
            case 2: {
                return this.readFlatFile(value);
            }
        }
        return 114;
    }

    int getNext(DomainString name, DomainString value) {
        switch (this.ioType) {
            case 4: 
            case 10: {
                return this.domGetNext(name, value);
            }
            case 0: 
            case 8: {
                if (this.handle == null) {
                    return 113;
                }
                TDTag[] tag = new TDTag[1];
                int status = name != null && name.getValue() != null && name.getValue().length() > 0 ? this.handle.findNextTag(name.getValue(), tag) : this.handle.getNextTag(tag);
                if (status == 0) {
                    name.setValue(tag[0].getName());
                    if (value != null) {
                        value.setValue(tag[0].getValue());
                    }
                }
                return status;
            }
            case 2: {
                return this.readFlatFile(value);
            }
        }
        return 114;
    }

    int getFirst(DomainString name, DomainString value) {
        switch (this.ioType) {
            case 4: 
            case 10: {
                return this.domGetFirst(name, value);
            }
            case 0: 
            case 8: {
                if (this.handle == null) {
                    return 113;
                }
                TDTag[] tag = new TDTag[1];
                int status = this.handle.getFirstTag(tag);
                if (status == 0) {
                    name.setValue(tag[0].getName());
                    if (value != null) {
                        value.setValue(tag[0].getValue());
                    }
                }
                return status;
            }
        }
        return 114;
    }

    int getLast(DomainString name, DomainString value) {
        switch (this.ioType) {
            case 4: 
            case 10: {
                return this.domGetLast(name, value);
            }
            case 0: 
            case 8: {
                if (this.handle == null) {
                    return 113;
                }
                TDTag[] tag = new TDTag[1];
                int status = this.handle.getLastTag(tag);
                if (status == 0) {
                    name.setValue(tag[0].getName());
                    if (value != null) {
                        value.setValue(tag[0].getValue());
                    }
                }
                return status;
            }
        }
        return 114;
    }

    int getChild(DomainString name, DomainString value) {
        switch (this.ioType) {
            case 4: 
            case 10: {
                return this.domGetChild(name, value);
            }
        }
        return 114;
    }

    int getParent(DomainString name, DomainString value) {
        switch (this.ioType) {
            case 4: 
            case 10: {
                return this.domGetParent(name, value);
            }
        }
        return 114;
    }

    int getSection(String name) {
        switch (this.ioType) {
            case 0: 
            case 8: {
                if (this.handle == null) {
                    return 113;
                }
                int status = this.handle.setPositionToPath(name, false, null);
                return status;
            }
        }
        return 114;
    }

    int getFirstSection(DomainString name) {
        switch (this.ioType) {
            case 0: 
            case 8: {
                if (this.handle == null) {
                    return 113;
                }
                TDSection[] section = new TDSection[1];
                int status = this.handle.getFirstSection(section);
                if (status == 0 && name != null) {
                    name.setValue(section[0].getName());
                }
                return status;
            }
        }
        return 114;
    }

    int getLastSection(DomainString name) {
        switch (this.ioType) {
            case 0: 
            case 8: {
                if (this.handle == null) {
                    return 113;
                }
                TDSection[] section = new TDSection[1];
                int status = this.handle.getLastSection(section);
                if (status == 0 && name != null) {
                    name.setValue(section[0].getName());
                }
                return status;
            }
        }
        return 114;
    }

    int getNextSection(DomainString name) {
        switch (this.ioType) {
            case 0: 
            case 8: {
                if (this.handle == null) {
                    return 113;
                }
                TDSection[] section = new TDSection[1];
                int status = name != null && name.getValue() != null && name.getValue().length() > 0 ? this.handle.findNextSection(name.getValue(), section) : this.handle.getNextSection(section);
                if (status == 0) {
                    name.setValue(section[0].getName());
                }
                return status;
            }
        }
        return 114;
    }

    int getPrev(DomainString name, DomainString value) {
        switch (this.ioType) {
            case 4: 
            case 10: {
                return this.domGetPrevious(name, value);
            }
            case 0: 
            case 8: {
                if (this.handle == null) {
                    return 113;
                }
                TDTag[] tag = new TDTag[1];
                int status = name != null && name.getValue() != null && name.getValue().length() > 0 ? this.handle.findPrevTag(name.getValue(), tag) : this.handle.getPrevTag(tag);
                if (status == 0) {
                    name.setValue(tag[0].getName());
                    if (value != null) {
                        value.setValue(tag[0].getValue());
                    }
                }
                return status;
            }
        }
        return 114;
    }

    int getPrevSection(DomainString name) {
        switch (this.ioType) {
            case 0: 
            case 8: {
                if (this.handle == null) {
                    return 113;
                }
                TDSection[] section = new TDSection[1];
                int status = name != null && name.getValue() != null && name.getValue().length() > 0 ? this.handle.findPrevSection(name.getValue(), section) : this.handle.getPrevSection(section);
                if (status == 0) {
                    name.setValue(section[0].getName());
                }
                return status;
            }
        }
        return 114;
    }

    int put(String name, String value) {
        switch (this.ioType) {
            case 5: 
            case 11: {
                return this.domPut(name, value);
            }
            case 1: 
            case 9: {
                if (this.handle == null) {
                    return 113;
                }
                TDTag[] tag = new TDTag[1];
                return this.handle.newTag(name, value, tag);
            }
            case 3: {
                return this.writeFlatFile(value);
            }
        }
        return 114;
    }

    int putInsert(String name, String value) {
        switch (this.ioType) {
            case 1: 
            case 9: {
                if (this.handle == null) {
                    return 113;
                }
                if (name == null || name.length() == 0) {
                    return 109;
                }
                int status = 105;
                TDTag tag = new TDTag(name, value);
                if (tag != null) {
                    status = this.handle.insertTag(tag);
                }
                return status;
            }
        }
        return 114;
    }

    int putSection(String name) {
        switch (this.ioType) {
            case 1: 
            case 9: {
                if (this.handle == null) {
                    return 113;
                }
                TDSection[] section = new TDSection[1];
                return this.handle.newSection(name, section);
            }
        }
        return 114;
    }

    int putSectionGoto(String name) {
        switch (this.ioType) {
            case 5: {
                return this.xmlPutGoto(name);
            }
            case 11: {
                return this.domPutGoto(name);
            }
            case 1: 
            case 9: {
                if (this.handle == null) {
                    return 113;
                }
                return this.handle.setPositionToPath(name, false, null);
            }
        }
        return 114;
    }

    int putChildSectionGoto(String name) {
        switch (this.ioType) {
            case 5: 
            case 11: {
                return this.domPutGotoChild(name);
            }
        }
        return 114;
    }

    int putSectionInsert(String name) {
        switch (this.ioType) {
            case 1: 
            case 9: {
                if (this.handle == null) {
                    return 113;
                }
                if (name == null || name.length() == 0) {
                    return 109;
                }
                int status = 107;
                TDSection section = new TDSection(name);
                if (section != null) {
                    status = this.handle.insertSection(section);
                }
                return status;
            }
        }
        return 114;
    }

    public int reset() throws DomainException {
        if (this.type == 0) {
            switch (this.ioType) {
                case 4: 
                case 10: {
                    return this.xmlGetReset();
                }
                case 0: 
                case 8: {
                    if (this.handle == null) {
                        this.handle = new TDHandle();
                        this.handle.attachFile(TDFile.open(false));
                    }
                    this.handle.seekToRoot();
                    this.handle.getSection().clear();
                    return this.readSection();
                }
            }
            return 114;
        }
        switch (this.ioType) {
            case 5: 
            case 11: {
                return this.xmlPutReset();
            }
            case 1: 
            case 9: {
                if (this.handle == null) {
                    this.handle = new TDHandle();
                    this.handle.attachFile(TDFile.open(false));
                    return 0;
                }
                if (this.writeSection() == 0) {
                    this.handle.seekToRoot();
                    this.handle.getSection().clear();
                }
                return 0;
            }
        }
        return 114;
    }

    public int insert(String name) {
        return this.insert(name, "");
    }

    public int insert(String name, String value) {
        switch (this.ioType) {
            case 1: 
            case 9: {
                if (this.handle == null) {
                    return 113;
                }
                if (name == null) {
                    return 109;
                }
                int status = 105;
                TDTag tag = new TDTag(name, value);
                if (tag != null) {
                    status = this.handle.insertTag(tag);
                }
                return status;
            }
        }
        return 114;
    }

    public int insertSection(String name) {
        switch (this.ioType) {
            case 1: 
            case 9: {
                if (this.handle == null) {
                    return 113;
                }
                if (name == null) {
                    return 109;
                }
                int status = 107;
                TDSection section = new TDSection(name);
                if (section != null) {
                    status = this.handle.insertSection(section);
                }
                return status;
            }
        }
        return 114;
    }

    public boolean isFlatFile() {
        return this.ioType == 2 || this.ioType == 3;
    }

    public int open(String path, boolean useDefault) throws DomainException {
        String[] sVar = new String[1];
        int[] iVar = new int[1];
        int status = 0;
        int count = 2;
        if (!this.dbControl.getVarResource(path, this.type == 0 ? IeRC_INPUTFILE : IeRC_OUTPUTFILE, sVar, null) && !useDefault) {
            --count;
        }
        String fileName = sVar[0];
        if (!this.dbControl.getVarResource(path, IeRC_IOTYPE, sVar, IeRC_IOTAGGED) && !useDefault) {
            --count;
        }
        if (count == 0) {
            return 108;
        }
        String legacy = sVar[0];
        if (sVar[0] == null && !useDefault) {
            return 7;
        }
        status = DomainIeFile.getIoType(legacy, this.type == 0, iVar);
        if (status != 0) {
            return status;
        }
        this.name = fileName;
        this.ioType = iVar[0];
        if (this.type == 0) {
            switch (this.ioType) {
                case 0: {
                    this.dbControl.getVarResource(path, IeRC_EOR, sVar, IE_EOR);
                    this.endOfRecord = sVar[0];
                    this.dbControl.getVarResource(path, IeRC_SEPARATOR, sVar, IE_SEPARATOR);
                    this.tagSeparator = sVar[0];
                    break;
                }
                case 8: {
                    this.dbControl.getVarResource(path, IeRC_EOR, sVar, IE_LEGACY_EOR);
                    this.endOfRecord = sVar[0];
                    this.dbControl.getVarResource(path, IeRC_SEPARATOR, sVar, IE_LEGACY_SEPARATOR);
                    this.tagSeparator = sVar[0];
                    break;
                }
                case 4: 
                case 10: {
                    this.dbControl.getVarResource(path, IeRC_EOR, sVar, IE_XML_EOR);
                    this.endOfRecord = sVar[0];
                    this.dbControl.getVarResource(path, IeRC_ROOT, sVar, IE_XML_ROOT);
                    this.rootRecord = sVar[0];
                    break;
                }
                case 2: {
                    break;
                }
            }
            return this.openStream(useDefault, false);
        }
        switch (this.ioType) {
            case 1: {
                this.dbControl.getVarResource(path, IeRC_EOR, sVar, IE_EOR);
                this.endOfRecord = sVar[0];
                this.dbControl.getVarResource(path, IeRC_SEPARATOR, sVar, IE_SEPARATOR);
                this.tagSeparator = sVar[0];
                break;
            }
            case 9: {
                this.dbControl.getVarResource(path, IeRC_EOR, sVar, IE_LEGACY_EOR);
                this.endOfRecord = sVar[0];
                this.dbControl.getVarResource(path, IeRC_SEPARATOR, sVar, IE_LEGACY_SEPARATOR);
                this.tagSeparator = sVar[0];
                break;
            }
            case 5: 
            case 11: {
                this.dbControl.getVarResource(path, IeRC_EOR, sVar, IE_XML_EOR);
                this.endOfRecord = sVar[0];
                this.dbControl.getVarResource(path, IeRC_ROOT, sVar, IE_XML_ROOT);
                this.rootRecord = sVar[0];
                this.dbControl.getVarResource(path, IeRC_XMLVERS, sVar, IE_XML_VERSION);
                this.version = sVar[0];
                this.dbControl.getIntVarResource(path, IeRC_INDENT, iVar, 0);
                this.indentation = iVar[0];
                this.dbControl.getVarResource(path, IeRC_SEGMENT, sVar, null);
                if (sVar[0] != null) {
                    this.segment = true;
                }
                if (!this.segment || this.rootRecord != null) break;
                status = 123;
                break;
            }
            case 3: {
                break;
            }
        }
        if (status == 0) {
            this.flush = this.dbControl.getVarResource(path, IeRC_FLUSH, sVar, null);
            boolean truncate = this.dbControl.getVarResource(path, IeRC_TRUNCATE, sVar, null);
            legacy = sVar[0];
            return this.openStream(useDefault, truncate);
        }
        return status;
    }

    int close() throws DomainException {
        if (this.type == 1) {
            switch (this.ioType) {
                case 1: 
                case 3: 
                case 5: 
                case 9: {
                    break;
                }
            }
        }
        this.closeStream();
        return 0;
    }

    int openStream(boolean useDefault, boolean truncate) throws DomainException {
        try {
            if (this.file != null) {
                throw new DomainException(269);
            }
            if (this.name != null) {
                this.file = new File(this.name);
                if (truncate && this.file.exists()) {
                    this.file.delete();
                    this.file.createNewFile();
                }
                if (this.type == 0) {
                    this.reader = new DomainBufferedReader(new FileReader(this.file));
                } else {
                    this.writer = new BufferedWriter(new FileWriter(this.file, !truncate));
                }
                return 0;
            }
            if (useDefault) {
                if (this.type == 0) {
                    this.reader = new DomainBufferedReader(new InputStreamReader(System.in));
                } else {
                    this.writer = new BufferedWriter(new OutputStreamWriter(System.out));
                }
                return 0;
            }
            return -1;
        }
        catch (FileNotFoundException ex) {
            return 120;
        }
        catch (IOException ex) {
            throw new DomainException(266, new Object[]{this.name});
        }
    }

    void closeStream() throws DomainException {
        int errorCode = 0;
        if (this.file != null && this.name != null) {
            try {
                if (this.reader != null) {
                    errorCode = 265;
                    this.reader.close();
                    this.reader = null;
                } else {
                    errorCode = 264;
                    this.writer.close();
                    this.writer = null;
                }
            }
            catch (IOException ex) {
                throw new DomainException(errorCode);
            }
        }
        if (this.handle != null) {
            this.handle.getFile().close();
            this.handle.setFile(null);
        }
    }

    public static int getIoType(String name, boolean input, int[] type) {
        if (name.equalsIgnoreCase(IeRC_IOTAGGED)) {
            type[0] = input ? 0 : 1;
        } else if (name.equalsIgnoreCase(IeRC_IOFLAT)) {
            type[0] = input ? 2 : 3;
        } else if (name.equalsIgnoreCase(IeRC_XML)) {
            type[0] = input ? 4 : 5;
        } else if (name.equalsIgnoreCase("legacy")) {
            type[0] = input ? 2 : 3;
        } else {
            return 115;
        }
        return 0;
    }

    int readFlatFile(DomainString str) {
        try {
            String line = ((BufferedReader)this.reader).readLine();
            if (line != null) {
                str.setValue(line);
                return 0;
            }
            return 102;
        }
        catch (IOException ex) {
            return 102;
        }
    }

    int writeFlatFile(String buffer) {
        try {
            this.writer.write(buffer + "\r\n");
            if (this.flush) {
                this.writer.flush();
            }
            return 0;
        }
        catch (IOException ex) {
            return 111;
        }
    }

    int readSection() {
        int status;
        switch (this.ioType) {
            case 0: 
            case 8: {
                status = this.handle.parse(this.reader, this.endOfRecord, this.tagSeparator != null ? this.tagSeparator.charAt(0) : (char)'\u0000', null);
                if (status == 103) {
                    status = 0;
                }
                if (status != 102 || this.handle.getSection().getKids() == null && this.handle.getSection().getTags() == null) break;
                status = 0;
                break;
            }
            default: {
                status = 115;
            }
        }
        if (status == 0) {
            this.handle.seekToRoot();
        }
        return status;
    }

    int writeSection() throws DomainException {
        boolean procsec = false;
        try {
            switch (this.ioType) {
                case 1: 
                case 9: {
                    this.writeSectionPrimitive(this.handle.getFile().getRoot());
                    this.writer.write(this.endOfRecord + "\n");
                    break;
                }
            }
            this.writer.flush();
            return 0;
        }
        catch (IOException ex) {
            throw new DomainException(264);
        }
    }

    void writeSectionPrimitive(TDSection root) throws DomainException {
        try {
            block9: for (TDTag tag = root.getTags(); tag != null; tag = tag.getNext()) {
                switch (this.ioType) {
                    case 9: {
                        if (!tag.getName().equals(IE_XTAG)) {
                            this.writer.write(tag.getName() + this.tagSeparator);
                        }
                        this.writer.write(tag.getValue() + "\n");
                        continue block9;
                    }
                    case 1: {
                        this.writer.write(tag.getName() + this.tagSeparator + tag.getValue() + "\n");
                        continue block9;
                    }
                }
            }
            block10: for (TDSection section = root.getKids(); section != null; section = section.getNext()) {
                switch (this.ioType) {
                    case 1: 
                    case 9: {
                        this.writer.write("<" + section.getName() + ">\n");
                        this.writeSectionPrimitive(section);
                        this.writer.write("<END>\n");
                        continue block10;
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new DomainException(264);
        }
    }

    void writeXmlItem(boolean asis, boolean indent, String item) throws DomainException {
        try {
            boolean lower;
            if (indent) {
                for (int i = 0; i < this.spaces; ++i) {
                    this.writer.write(32);
                }
            }
            boolean bl = lower = asis ? false : this.lowerCase;
            if (!lower) {
                this.writer.write(item);
            } else {
                this.writer.write(item.toLowerCase());
            }
        }
        catch (IOException ex) {
            throw new DomainException(264);
        }
    }

    private Document createDOM() {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (this.reader != null) {
                String temp;
                StringBuffer buffer = new StringBuffer();
                while ((temp = ((BufferedReader)this.reader).readLine()) != null && !temp.equals(this.endOfRecord)) {
                    buffer.append(temp.trim());
                }
                String content = buffer.toString();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
                document = builder.parse(inputStream);
                Element root = document.getDocumentElement();
                if (root != null) {
                    this.rootRecord = root.getTagName();
                }
            } else {
                document = builder.newDocument();
            }
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        return document;
    }

    private void writeDOM(Node node, boolean omitXMLDeclaration) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(node);
            StreamResult result = new StreamResult(this.writer);
            transformer.setOutputProperty(IeRC_INDENT, "yes");
            transformer.setOutputProperty("{ http://xml.apache.org/xslt }indent-amount", Integer.toString(this.indentation));
            if (omitXMLDeclaration) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void writeXmlEnd(boolean asis, boolean indent, String item) {
        int blank = item.indexOf(32);
        if (blank == -1) {
            this.writeXmlItem(asis, indent, "</" + item + ">\n");
        } else {
            this.writeXmlItem(asis, indent, "</" + item.substring(0, blank) + ">\n");
        }
    }

    private String getTextNode(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeName() != "#text") continue;
            return children.item(i).getNodeValue();
        }
        return "";
    }

    public int domGet(String name, DomainString value) {
        Node node;
        NodeList children;
        if (this.currentNode == null) {
            return 113;
        }
        if (this.currentNode.getNodeName() == this.rootRecord) {
            if (this.rootRecord.equals(name)) {
                if (value != null) {
                    value.setValue(this.getTextNode(this.currentNode));
                }
                return 0;
            }
            children = this.currentNode.getChildNodes();
        } else {
            children = this.currentNode.getParentNode().getChildNodes();
        }
        if (name.startsWith("/")) {
            node = this.currentDOM.getDocumentElement();
            name = name.substring(1);
        } else {
            node = this.currentNode.getParentNode() != null ? this.currentNode.getParentNode().getFirstChild() : this.currentNode;
        }
        boolean parsed = false;
        boolean gotoChild = false;
        while (name.indexOf(47) != -1) {
            boolean found = false;
            parsed = true;
            if (name.startsWith("..")) {
                if (node.getNodeName() == this.rootRecord) {
                    return 106;
                }
                if ((node = node.getParentNode()) != null) {
                    found = true;
                }
                name = name.substring(3);
            } else if (name.startsWith(".")) {
                found = true;
                name = name.substring(2);
            } else {
                if (gotoChild) {
                    node = node.getFirstChild();
                } else if (node.getParentNode() != null) {
                    node = node.getParentNode().getFirstChild();
                }
                String levelName = name.substring(0, name.indexOf(47));
                while (node != null) {
                    if (node.getNodeType() != 3 && node.getNodeName().equals(levelName)) {
                        name = name.substring(name.indexOf(47) + 1);
                        found = true;
                        break;
                    }
                    node = node.getNextSibling();
                }
            }
            if (!found) {
                return 106;
            }
            gotoChild = true;
        }
        if (parsed) {
            node = node.getFirstChild();
        }
        if (name.equals(".")) {
            if (value != null) {
                value.setValue(this.getTextNode(this.currentNode));
            }
            return 0;
        }
        while (node != null) {
            if (node.getNodeType() != 3 && node.getNodeName().equals(name)) {
                if (value != null) {
                    value.setValue(this.getTextNode(node));
                }
                this.currentNode = node;
                return 0;
            }
            node = node.getNextSibling();
        }
        return 106;
    }

    public int domGetNext(DomainString name, DomainString value) {
        if (this.currentNode == null) {
            return 113;
        }
        for (Node temp = this.currentNode.getNextSibling(); temp != null; temp = temp.getNextSibling()) {
            if (temp.getNodeType() == 3 || name != null && name.length() != 0 && !name.equals(temp.getNodeName())) continue;
            this.currentNode = temp;
            if (name != null) {
                name.setValue(this.currentNode.getNodeName());
            }
            if (value != null) {
                value.setValue(this.getTextNode(this.currentNode));
            }
            return 0;
        }
        return 106;
    }

    public int domGetChild(DomainString name, DomainString value) {
        if (this.currentNode == null) {
            return 113;
        }
        Node temp = this.currentNode.getFirstChild();
        if ((temp = DomainIeFile.domSkipTextNode(temp)) != null && temp.getNodeName() != this.rootRecord) {
            this.currentNode = temp;
            if (name != null) {
                name.setValue(this.currentNode.getNodeName());
            }
            if (value != null) {
                value.setValue(this.getTextNode(this.currentNode));
            }
            return 0;
        }
        return 106;
    }

    public int domGetParent(DomainString name, DomainString value) {
        if (this.currentNode == null) {
            return 113;
        }
        Node temp = this.currentNode.getParentNode();
        if (temp != null) {
            this.currentNode = temp;
            if (name != null) {
                name.setValue(this.currentNode.getNodeName());
            }
            if (value != null) {
                value.setValue(this.getTextNode(this.currentNode));
            }
            return 0;
        }
        return 106;
    }

    public int domGetFirst(DomainString name, DomainString value) {
        if (this.currentNode == null) {
            return 113;
        }
        Node temp = this.currentNode.getNodeName() == this.rootRecord ? this.currentNode.getFirstChild() : this.currentNode.getParentNode().getFirstChild();
        if ((temp = DomainIeFile.domSkipTextNode(temp)) != null) {
            this.currentNode = temp;
            if (name != null) {
                name.setValue(this.currentNode.getNodeName());
            }
            if (value != null) {
                value.setValue(this.getTextNode(this.currentNode));
            }
            return 0;
        }
        return 106;
    }

    public int domGetLast(DomainString name, DomainString value) {
        if (this.currentNode == null) {
            return 113;
        }
        Node temp = !this.currentNode.getNodeName().equals(this.rootRecord) ? this.currentNode.getParentNode() : this.currentNode;
        for (temp = temp.getLastChild(); temp != null && temp.getNodeType() == 3; temp = temp.getPreviousSibling()) {
        }
        if (temp != null) {
            this.currentNode = temp;
            if (name != null) {
                name.setValue(this.currentNode.getNodeName());
            }
            if (value != null) {
                value.setValue(this.getTextNode(this.currentNode));
            }
            return 0;
        }
        return 106;
    }

    public int domGetPrevious(DomainString name, DomainString value) {
        if (this.currentNode == null) {
            return 113;
        }
        for (Node temp = this.currentNode.getPreviousSibling(); temp != null; temp = temp.getPreviousSibling()) {
            if (temp.getNodeType() == 3 || name != null && name.length() != 0 && !name.getValue().equals(temp.getNodeName())) continue;
            this.currentNode = temp;
            if (name != null) {
                name.setValue(this.currentNode.getNodeName());
            }
            if (value != null) {
                value.setValue(this.getTextNode(this.currentNode));
            }
            return 0;
        }
        return 106;
    }

    public int domGetAttribute(String name, DomainString value) {
        if (this.currentNode == null) {
            return 113;
        }
        NamedNodeMap attributes = this.currentNode.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node temp = attributes.item(i);
                if (temp == null) continue;
                this.currentAttribute = i;
                if (value != null) {
                    value.setValue(temp.getNodeValue());
                }
                return 0;
            }
        }
        return 106;
    }

    public int domGetFirstAttribute(DomainString name, DomainString value) {
        Node temp;
        if (this.currentNode == null) {
            return 113;
        }
        NamedNodeMap attributes = this.currentNode.getAttributes();
        if (attributes != null && (temp = attributes.item(0)) != null) {
            this.currentAttribute = 0;
            if (name != null) {
                name.setValue(temp.getNodeName());
            }
            if (value != null) {
                value.setValue(temp.getNodeValue());
            }
            return 0;
        }
        return 106;
    }

    public int domGetLastAttribute(DomainString name, DomainString value) {
        Node temp;
        if (this.currentNode == null) {
            return 113;
        }
        NamedNodeMap attributes = this.currentNode.getAttributes();
        if (attributes != null && attributes.getLength() > 0 && (temp = attributes.item(attributes.getLength() - 1)) != null) {
            this.currentAttribute = attributes.getLength() - 1;
            if (name != null) {
                name.setValue(temp.getNodeName());
            }
            if (value != null) {
                value.setValue(temp.getNodeValue());
            }
            return 0;
        }
        return 106;
    }

    public int domGetNextAttribute(DomainString name, DomainString value) {
        int count = 0;
        if (this.currentNode == null) {
            return 113;
        }
        if (this.currentAttribute == -1) {
            return 106;
        }
        NamedNodeMap attributes = this.currentNode.getAttributes();
        if (attributes != null) {
            count = this.currentAttribute + 1;
            Node temp = attributes.item(count);
            for (int i = this.currentAttribute + 1; i < attributes.getLength(); ++i) {
                temp = attributes.item(i);
                if (name != null && name.length() != 0 && !name.getValue().equals(temp.getNodeName())) continue;
                this.currentAttribute = i;
                if (name != null) {
                    name.setValue(temp.getNodeName());
                }
                if (value != null) {
                    value.setValue(temp.getNodeValue());
                }
                return 0;
            }
        }
        return 106;
    }

    public int domGetPreviousAttribute(DomainString name, DomainString value) {
        if (this.currentNode == null) {
            return 113;
        }
        if (this.currentAttribute == -1) {
            return 106;
        }
        NamedNodeMap attributes = this.currentNode.getAttributes();
        if (attributes != null) {
            for (int i = this.currentAttribute - 1; i >= 0; --i) {
                Node temp = attributes.item(i);
                if (name != null && name.length() != 0 && !name.getValue().equals(temp.getNodeName())) continue;
                this.currentAttribute = i;
                if (name != null) {
                    name.setValue(temp.getNodeName());
                }
                if (value != null) {
                    value.setValue(temp.getNodeValue());
                }
                return 0;
            }
        }
        return 106;
    }

    public int domPut(String name, String value) {
        Node temp;
        if (this.currentDOM == null) {
            return 113;
        }
        if (name.charAt(0) == '?') {
            if (value == null) {
                value = "";
            }
            temp = this.currentDOM.createProcessingInstruction(name.substring(1), value);
        } else {
            temp = this.currentDOM.createElement(name);
            if (value != null) {
                temp.appendChild(this.currentDOM.createTextNode(value));
            }
        }
        if (this.currentNode == null) {
            NodeList children = this.currentDOM.getElementsByTagName(this.rootRecord);
            this.currentNode = children.item(0);
        }
        if (this.currentNode != null && this.currentNode.getNodeName() != this.rootRecord) {
            this.currentNode.getParentNode().appendChild(temp);
        } else if (this.currentNode == null) {
            if (name.charAt(0) != '?') {
                this.rootRecord = name;
            }
            this.currentNode = this.currentDOM.appendChild(temp);
        } else {
            this.currentNode.appendChild(temp);
        }
        this.currentNode = temp;
        this.currentAttribute = -1;
        return 0;
    }

    public int domPutAttribute(String name, String value) {
        if (this.currentNode == null) {
            return 113;
        }
        if (this.currentNode instanceof ProcessingInstruction) {
            ProcessingInstruction procNode = (ProcessingInstruction)this.currentNode;
            procNode.setData(procNode.getData() + " " + name + "=\"" + value + "\"");
        } else {
            ((Element)this.currentNode).setAttribute(name, value);
            this.currentAttribute = this.currentNode.getAttributes().getLength() - 1;
        }
        return 0;
    }

    public int domPutGoto(String name) {
        if (this.currentNode == null) {
            return 113;
        }
        Node tempCurrentNode = this.currentNode;
        if (name.charAt(0) == '/') {
            tempCurrentNode = this.currentDOM.getDocumentElement();
            if (!this.rootExists) {
                name = name.substring(name.indexOf("/", 1) + 1);
            }
        }
        block4: while (tempCurrentNode != null && name.length() > 0) {
            String nextNode;
            int index = name.indexOf("/");
            switch (index) {
                case -1: {
                    nextNode = name;
                    name = "";
                    break;
                }
                case 0: {
                    tempCurrentNode = tempCurrentNode.getFirstChild();
                    if (tempCurrentNode == null) {
                        return 106;
                    }
                    name = name.substring(1);
                    continue block4;
                }
                default: {
                    nextNode = name.substring(0, index);
                    name = name.substring(index);
                }
            }
            NodeList nodeList = tempCurrentNode.getNodeName() == this.rootRecord ? tempCurrentNode.getChildNodes() : tempCurrentNode.getParentNode().getChildNodes();
            Node temp = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!nextNode.equals(nodeList.item(i).getNodeName())) continue;
                temp = nodeList.item(i);
                break;
            }
            if (temp == null) {
                return 106;
            }
            tempCurrentNode = temp;
        }
        this.currentNode = tempCurrentNode;
        return 0;
    }

    public int domPutGotoParent() {
        if (this.currentNode == null) {
            return 113;
        }
        Node temp = this.currentNode.getParentNode();
        if (temp != null) {
            this.currentNode = temp;
            this.currentAttribute = -1;
            return 0;
        }
        return 106;
    }

    public int domPutGotoChild(String name) {
        Node temp;
        if (this.currentNode == null) {
            return 113;
        }
        for (temp = this.currentNode.getFirstChild(); temp != null && temp.getNodeName() == "#text"; temp = temp.getNextSibling()) {
        }
        if (temp != null) {
            this.currentNode = temp;
            this.currentAttribute = -1;
            return 0;
        }
        return 106;
    }

    public int domPutChild(String name, String value) {
        if (this.currentNode == null) {
            return 113;
        }
        Element temp = this.currentDOM.createElement(name);
        if (value != null) {
            temp.appendChild(this.currentDOM.createTextNode(value));
        }
        this.currentNode.appendChild(temp);
        this.currentNode = temp;
        this.currentAttribute = -1;
        return 0;
    }

    public int xmlPutReset() {
        int status = 0;
        if (this.currentDOM != null) {
            if (this.segment) {
                this.xmlWriteSection(true);
            } else {
                NodeList documentElements;
                if (this.recordsWritten) {
                    try {
                        this.writer.write(this.endOfRecord + "\n");
                    }
                    catch (IOException ex) {
                        status = 111;
                        return status;
                    }
                }
                if ((documentElements = this.currentDOM.getElementsByTagName("*")).getLength() > 0) {
                    this.writeDOM(this.currentDOM, this.segment);
                }
            }
            this.recordsWritten = true;
        }
        this.currentDOM = this.createDOM();
        if (this.currentDOM != null) {
            if (!this.rootRecord.equals("")) {
                this.currentNode = this.currentDOM.createElement(this.rootRecord);
                this.currentDOM.appendChild(this.currentNode);
                this.rootExists = true;
            } else {
                this.currentNode = null;
                this.rootExists = false;
            }
        }
        this.firstWritten = false;
        return status;
    }

    public int xmlGetReset() {
        int status = 0;
        this.currentDOM = this.createDOM();
        NodeList documentElements = this.currentDOM.getElementsByTagName(this.rootRecord);
        if (documentElements.getLength() == 1) {
            this.currentNode = documentElements.item(0);
        } else {
            status = 101;
        }
        return status;
    }

    public void xmlWriteSection(boolean lastSection) {
        if (this.segment) {
            try {
                if (this.currentDOM != null && this.currentNode != null && (this.currentNode == this.currentDOM.getFirstChild().getFirstChild() || lastSection)) {
                    if (!this.firstWritten) {
                        if (this.recordsWritten) {
                            this.writer.write(this.endOfRecord + "\n");
                        }
                        this.writer.write(this.version + "\n<" + this.rootRecord + ">\n");
                        this.firstWritten = true;
                    }
                    this.writeDOM(this.currentNode, this.segment);
                    Node node = this.currentDOM.getDocumentElement().removeChild(this.currentNode);
                    node = null;
                    this.currentNode = null;
                }
                if (lastSection && this.firstWritten) {
                    this.writer.write("</" + this.rootRecord + ">\n");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int xmlPutGoto(String tag) {
        int rc = this.domPutGoto(tag);
        if (rc == 0) {
            this.xmlWriteSection(false);
        }
        return rc;
    }

    public int xmlPutGotoParent() {
        int rc = this.domPutGotoParent();
        if (rc == 0) {
            this.xmlWriteSection(false);
        }
        return rc;
    }
}

