/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import java.util.Map;
import java.util.Properties;

public final class OSEnvironment {
    private static final String HOSTNAME;
    private static final String ENVPATHDEL;
    private static Properties envVars;
    private static boolean isWindows;
    private static boolean isUnix;

    private OSEnvironment() {
    }

    public static Properties get() {
        return (Properties)envVars.clone();
    }

    public static String getProperty(String key) {
        return envVars.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        String val = envVars.getProperty(key);
        return val == null ? defaultValue : val;
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isUnix() {
        return isUnix;
    }

    public static String getHostname() {
        return HOSTNAME;
    }

    public static String getEnvPathDelim() {
        return ENVPATHDEL;
    }

    public static void main(String[] args) {
        System.out.format("OS %s Path separator %s%nIsWindows %s IsLinux %s%nTemp %s%n", OSEnvironment.getHostname(), OSEnvironment.getEnvPathDelim(), String.valueOf(OSEnvironment.isWindows()), String.valueOf(OSEnvironment.isUnix()), OSEnvironment.getProperty("TEMP"));
    }

    static {
        isWindows = false;
        isUnix = false;
        String OS = System.getProperty("os.name").toLowerCase();
        if (OS.startsWith("windows")) {
            isWindows = true;
            String architecture = System.getProperty("os.arch").toLowerCase();
            HOSTNAME = architecture.endsWith("64") ? "win64" : "win32";
        } else {
            isWindows = false;
            String ver = System.getProperty("os.version");
            HOSTNAME = OS.contains("aix") ? String.format("AIX-%s", ver) : (OS.contains("hp-ux") ? String.format("HP-UX %s", ver) : (OS.contains("linux") ? "Linux" : (OS.contains("sunos") ? String.format("SunOS-%s", ver.substring(2)) : (OS.contains("unix") ? "Unix" : "Unix"))));
        }
        isUnix = !isWindows;
        ENVPATHDEL = isWindows ? ";" : ":";
        envVars = new Properties();
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            String key = entry.getKey();
            if (key.startsWith("=")) continue;
            envVars.put(key.toUpperCase(), entry.getValue());
        }
    }
}

