/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import com.mmmhis.domain.DomainCode;
import com.mmmhis.domain.DomainCurrency;
import com.mmmhis.domain.DomainDate;
import com.mmmhis.domain.DomainEnvironment;
import com.mmmhis.domain.DomainExtDate;
import com.mmmhis.domain.DomainFloat;
import com.mmmhis.domain.DomainInteger;
import com.mmmhis.domain.DomainInvalidCodeException;
import com.mmmhis.domain.DomainString;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;

public final class PrintfFormat {
    private static final char[] INF = new char[]{'I', 'n', 'f'};
    private static final char[] INF_LEADING_SIGN = new char[]{'+', 'I', 'n', 'f'};
    private static final char[] INF_LEADING_SPACE = new char[]{' ', 'I', 'n', 'f'};
    private static final char[] INF_NEGATIVE = new char[]{'-', 'I', 'n', 'f'};
    private static final char[] NAN = new char[]{'N', 'a', 'N'};
    private static final char[] NAN_LEADING_SIGN = new char[]{'+', 'N', 'a', 'N'};
    private static final char[] NAN_LEADING_SPACE = new char[]{' ', 'N', 'a', 'N'};
    private ArrayList vFmt;
    private int cPos;
    private DecimalFormatSymbols dfs;

    public PrintfFormat() throws IllegalArgumentException {
        this(Locale.getDefault());
    }

    public PrintfFormat(Locale locale) throws IllegalArgumentException {
        this.dfs = new DecimalFormatSymbols(locale);
    }

    public void setFormatArgs(String fmtArg) {
        this.vFmt = new ArrayList();
        this.cPos = 0;
        int ePos = 0;
        ConversionSpecification sFmt = null;
        String unCS = this.nonControl(fmtArg, 0);
        if (unCS != null && unCS.length() > 0) {
            sFmt = new ConversionSpecification();
            sFmt.setLiteral(unCS);
            this.vFmt.add(sFmt);
        }
        char[] fmtArr = fmtArg.toCharArray();
        while (this.cPos != -1 && this.cPos < fmtArr.length) {
            for (ePos = this.cPos + 1; ePos < fmtArr.length; ++ePos) {
                char c = '\u0000';
                c = fmtArr[ePos];
                if (c == 'i' || c != 'l' && (c == 'd' || c == 'm' || c == 'f' || c == 'g' || c == 'G' || c == 'o' || c == 'x' || c == 'X' || c == 'e' || c == 'E' || c == 'c' || c == 's' || c == 't' || c == 'p' || c == '%')) break;
            }
            ePos = Math.min(ePos + 1, fmtArg.length());
            sFmt = new ConversionSpecification(fmtArr, this.cPos, ePos);
            this.vFmt.add(sFmt);
            unCS = this.nonControl(fmtArg, ePos);
            if (unCS == null || unCS.length() <= 0) continue;
            sFmt = new ConversionSpecification();
            sFmt.setLiteral(unCS);
            this.vFmt.add(sFmt);
        }
    }

    private String nonControl(String s, int start) {
        this.cPos = s.indexOf("%", start);
        if (this.cPos == -1) {
            this.cPos = s.length();
        }
        if (this.cPos == 0) {
            return null;
        }
        return s.substring(start, this.cPos);
    }

    public DomainString sprintf(DomainEnvironment env, Object[] o) {
        Iterator iter = this.vFmt.iterator();
        ConversionSpecification cs = null;
        char c = '\u0000';
        int i = 0;
        DomainString sb = new DomainString();
        while (iter.hasNext()) {
            cs = (ConversionSpecification)iter.next();
            if (cs.isVariableFieldWidth()) {
                cs.setFieldWidthWithArg(((DomainInteger)o[i++]).getValue());
            }
            if (cs.isVariablePrecision()) {
                cs.setPrecisionWithArg(((DomainInteger)o[i++]).getValue());
            }
            if ((c = cs.getConversionCharacter()) == '\u0000') {
                sb.append(cs.getLiteral());
                continue;
            }
            if (c == '%') {
                sb.append("%");
                continue;
            }
            switch (c) {
                case 'i': {
                    sb.append(cs.internalsprintf(((DomainInteger)o[i]).getValue()));
                    break;
                }
                case 'f': 
                case 'g': {
                    sb.append(cs.internalsprintf(((DomainFloat)o[i]).getValue()));
                    break;
                }
                case 'm': {
                    String fmtString = cs.optionalL ? env.getLongCurrencyFormat() : env.getShortCurrencyFormat();
                    sb.append(((DomainCurrency)o[i]).toString(fmtString));
                    break;
                }
                case 'd': {
                    String fmtString;
                    String string = fmtString = cs.optionalL ? env.getLongDateFormat() : env.getShortDateFormat();
                    if (o[i] instanceof DomainExtDate) {
                        sb.append(((DomainExtDate)o[i]).toString(fmtString));
                        break;
                    }
                    sb.append(((DomainDate)o[i]).toString(fmtString));
                    break;
                }
                case 't': {
                    String fmtString;
                    String string = fmtString = cs.optionalL ? env.getLongTimeFormat() : env.getShortTimeFormat();
                    if (o[i] instanceof DomainExtDate) {
                        sb.append(((DomainExtDate)o[i]).toString(fmtString));
                        break;
                    }
                    sb.append(((DomainDate)o[i]).toString(fmtString));
                    break;
                }
                case 'c': {
                    sb.append(cs.internalsprintf((DomainCode)o[i]));
                    break;
                }
                case 'p': {
                    sb.append(o[i].getClass());
                    break;
                }
                default: {
                    sb.append(cs.internalsprintf((DomainString)o[i]));
                }
            }
            if (cs.isPositionalSpecification()) continue;
            ++i;
        }
        return sb;
    }

    private static char[] trim(char[] val) {
        int st;
        int len = val.length;
        int off = 0;
        for (st = 0; st < len && val[off + st] <= ' '; ++st) {
        }
        while (st < len && val[off + len - 1] <= ' ') {
            --len;
        }
        if (st > 0 || len < val.length) {
            char[] temp = val;
            val = new char[len - st];
            System.arraycopy(temp, st, val, 0, len - st);
        }
        return val;
    }

    private class ConversionSpecification {
        private boolean thousands;
        private boolean leftJustify;
        private boolean leadingSign;
        private boolean leadingSpace;
        private boolean alternateForm;
        private boolean leadingZeros;
        private boolean variableFieldWidth;
        private int fieldWidth;
        private boolean fieldWidthSet;
        private int precision;
        private static final int defaultDigits = 6;
        private boolean variablePrecision;
        private boolean precisionSet;
        private boolean positionalSpecification;
        private int argumentPosition;
        private boolean positionalFieldWidth;
        private int argumentPositionForFieldWidth;
        private boolean positionalPrecision;
        private int argumentPositionForPrecision;
        private boolean optionalL;
        private char conversionCharacter;
        private int pos;
        private char[] fmt;

        ConversionSpecification() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        ConversionSpecification(char[] fmtArg, int start, int end) throws IllegalArgumentException {
            if (fmtArg == null) {
                throw new NullPointerException();
            }
            if (fmtArg.length == 0) {
                throw new IllegalArgumentException("Control strings must have positive lengths.");
            }
            if (fmtArg[start] != '%') throw new IllegalArgumentException("Control strings must begin with %.");
            if (start == 0 && end == fmtArg.length - 1) {
                this.fmt = fmtArg;
            } else {
                this.fmt = new char[end - start];
                System.arraycopy(fmtArg, start, this.fmt, 0, end - start);
            }
            this.pos = 1;
            this.setArgPosition();
            this.setFlagCharacters();
            this.setFieldWidth();
            this.setPrecision();
            this.setOptionalL();
            if (!this.setConversionCharacter()) throw new IllegalArgumentException("Malformed conversion specification=" + new String(fmtArg, start, end - start));
            if (this.pos != end - start) throw new IllegalArgumentException("Malformed conversion specification=" + new String(fmtArg, start, end - start));
            if (this.leadingZeros && this.leftJustify) {
                this.leadingZeros = false;
            }
            if (!this.precisionSet || !this.leadingZeros || this.conversionCharacter != 'i') return;
            this.leadingZeros = false;
        }

        void setLiteral(String s) {
            this.fmt = s.toCharArray();
        }

        String getLiteral() {
            DomainString sb = new DomainString();
            int i = 0;
            while (i < this.fmt.length) {
                if (this.fmt[i] == '\\') {
                    if (++i < this.fmt.length) {
                        char c = this.fmt[i];
                        switch (c) {
                            case 'n': {
                                sb.append(System.getProperty("line.separator"));
                                break;
                            }
                            case 't': {
                                sb.append('\t');
                                break;
                            }
                            case '\\': {
                                sb.append('\\');
                                break;
                            }
                            default: {
                                sb.append('\\');
                                sb.append(c);
                            }
                        }
                        ++i;
                        continue;
                    }
                    sb.append('\\');
                    continue;
                }
                sb.append(this.fmt[i]);
                ++i;
            }
            return sb.toString();
        }

        char getConversionCharacter() {
            return this.conversionCharacter;
        }

        boolean isVariableFieldWidth() {
            return this.variableFieldWidth;
        }

        void setFieldWidthWithArg(int fw) {
            if (fw < 0) {
                this.leftJustify = true;
            }
            this.fieldWidthSet = true;
            this.fieldWidth = Math.abs(fw);
        }

        boolean isVariablePrecision() {
            return this.variablePrecision;
        }

        void setPrecisionWithArg(int pr) {
            this.precisionSet = true;
            this.precision = Math.max(pr, 0);
        }

        String internalsprintf(int s) throws IllegalArgumentException {
            String s2;
            switch (this.conversionCharacter) {
                case 'i': {
                    s2 = this.printDFormat(s);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot format a int with a format using a " + this.conversionCharacter + " conversion character.");
                }
            }
            return s2;
        }

        String internalsprintf(double s) throws IllegalArgumentException {
            String s2 = "";
            switch (this.conversionCharacter) {
                case 'f': {
                    s2 = this.printFFormat(s);
                    break;
                }
                case 'G': 
                case 'g': {
                    s2 = this.printGFormat(s);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot format a double with a format using a " + this.conversionCharacter + " conversion character.");
                }
            }
            return s2;
        }

        String internalsprintf(DomainString s) throws IllegalArgumentException {
            String s2 = "";
            if (this.conversionCharacter != 's' && this.conversionCharacter != 'S') {
                throw new IllegalArgumentException("Cannot format a String with a format using a " + this.conversionCharacter + " conversion character.");
            }
            s2 = this.printSFormat(s);
            return s2;
        }

        String internalsprintf(DomainCode c) throws DomainInvalidCodeException {
            String s2 = "";
            if (this.conversionCharacter != 'c' && this.conversionCharacter != 'C') {
                throw new IllegalArgumentException("Cannot format a DomainCode with a format using a " + this.conversionCharacter + " conversion character.");
            }
            String str = c.getEntry().getCname().toString();
            s2 = this.printCFormat(str);
            return s2;
        }

        private char[] fFormatDigits(double x) {
            int dp;
            char[] ca5;
            char[] ca4;
            char[] ca3;
            int k;
            int j;
            String sx;
            int expon = 0;
            boolean minusSign = false;
            if (this.precisionSet && this.precision < 14) {
                x = DomainFloat.round(x, this.precision);
            }
            if (x > 0.0) {
                sx = Double.toString(x);
            } else if (x < 0.0) {
                sx = Double.toString(-x);
                minusSign = true;
            } else {
                sx = Double.toString(x);
                if (sx.charAt(0) == '-') {
                    minusSign = true;
                    sx = sx.substring(1);
                }
            }
            int ePos = sx.indexOf(69);
            int rPos = sx.indexOf(46);
            int n1In = rPos != -1 ? rPos : (ePos != -1 ? ePos : sx.length());
            int n2In = rPos != -1 ? (ePos != -1 ? ePos - rPos - 1 : sx.length() - rPos - 1) : 0;
            if (ePos != -1) {
                int ie = ePos + 1;
                expon = 0;
                if (sx.charAt(ie) == '-') {
                    ++ie;
                    while (ie < sx.length() && sx.charAt(ie) == '0') {
                        ++ie;
                    }
                    if (ie < sx.length()) {
                        expon = -Integer.parseInt(sx.substring(ie));
                    }
                } else {
                    if (sx.charAt(ie) == '+') {
                        ++ie;
                    }
                    while (ie < sx.length() && sx.charAt(ie) == '0') {
                        ++ie;
                    }
                    if (ie < sx.length()) {
                        expon = Integer.parseInt(sx.substring(ie));
                    }
                }
            }
            int p = this.precisionSet ? this.precision : 6;
            char[] ca1 = sx.toCharArray();
            char[] ca2 = new char[n1In + n2In];
            for (j = 0; j < n1In; ++j) {
                ca2[j] = ca1[j];
            }
            int i = j + 1;
            for (k = 0; k < n2In; ++k) {
                ca2[j] = ca1[i];
                ++j;
                ++i;
            }
            if (n1In + expon <= 0) {
                ca3 = new char[-expon + n2In];
                j = 0;
                k = 0;
                while (k < -n1In - expon) {
                    ca3[j] = 48;
                    ++k;
                    ++j;
                }
                i = 0;
                while (i < n1In + n2In) {
                    ca3[j] = ca2[i];
                    ++i;
                    ++j;
                }
            } else {
                ca3 = ca2;
            }
            boolean carry = false;
            if (p < -expon + n2In && (carry = this.checkForCarry(ca3, i = expon < 0 ? p : p + n1In + expon))) {
                carry = this.startSymbolicCarry(ca3, i - 1, 0);
            }
            if (n1In + expon <= 0) {
                ca4 = new char[2 + p];
                ca4[0] = !carry ? 48 : 49;
                if (this.alternateForm || !this.precisionSet || this.precision != 0) {
                    ca4[1] = 46;
                    i = 0;
                    j = 2;
                    while (i < Math.min(p, ca3.length)) {
                        ca4[j] = ca3[i];
                        ++i;
                        ++j;
                    }
                    while (j < ca4.length) {
                        ca4[j] = 48;
                        ++j;
                    }
                }
            } else {
                if (!carry) {
                    ca4 = this.alternateForm || !this.precisionSet || this.precision != 0 ? new char[n1In + expon + p + 1] : new char[n1In + expon];
                    j = 0;
                } else {
                    ca4 = this.alternateForm || !this.precisionSet || this.precision != 0 ? new char[n1In + expon + p + 2] : new char[n1In + expon + 1];
                    ca4[0] = 49;
                    j = 1;
                }
                i = 0;
                while (i < Math.min(n1In + expon, ca3.length)) {
                    ca4[j] = ca3[i];
                    ++i;
                    ++j;
                }
                while (i < n1In + expon) {
                    ca4[j] = 48;
                    ++i;
                    ++j;
                }
                if (this.alternateForm || !this.precisionSet || this.precision != 0) {
                    ca4[j] = 46;
                    ++j;
                    for (k = 0; i < ca3.length && k < p; ++k) {
                        ca4[j] = ca3[i];
                        ++i;
                        ++j;
                    }
                    while (j < ca4.length) {
                        ca4[j] = 48;
                        ++j;
                    }
                }
            }
            int nZeros = 0;
            if (!this.leftJustify && this.leadingZeros) {
                int xThousands = 0;
                if (this.thousands) {
                    int xdp;
                    int xlead = 0;
                    if (ca4[0] == '+' || ca4[0] == '-' || ca4[0] == ' ') {
                        xlead = 1;
                    }
                    for (xdp = xlead; xdp < ca4.length && ca4[xdp] != '.'; ++xdp) {
                    }
                    xThousands = (xdp - xlead) / 3;
                }
                if (this.fieldWidthSet) {
                    nZeros = this.fieldWidth - ca4.length;
                }
                if (!minusSign && (this.leadingSign || this.leadingSpace) || minusSign) {
                    --nZeros;
                }
                if ((nZeros -= xThousands) < 0) {
                    nZeros = 0;
                }
            }
            j = 0;
            if (!minusSign && (this.leadingSign || this.leadingSpace) || minusSign) {
                ca5 = new char[ca4.length + nZeros + 1];
                ++j;
            } else {
                ca5 = new char[ca4.length + nZeros];
            }
            if (!minusSign) {
                if (this.leadingSign) {
                    ca5[0] = 43;
                }
                if (this.leadingSpace) {
                    ca5[0] = 32;
                }
            } else {
                ca5[0] = 45;
            }
            i = 0;
            while (i < nZeros) {
                ca5[j] = 48;
                ++i;
                ++j;
            }
            i = 0;
            while (i < ca4.length) {
                ca5[j] = ca4[i];
                ++i;
                ++j;
            }
            int lead = 0;
            if (ca5[0] == '+' || ca5[0] == '-' || ca5[0] == ' ') {
                lead = 1;
            }
            for (dp = lead; dp < ca5.length && ca5[dp] != '.'; ++dp) {
            }
            int nThousands = (dp - lead) / 3;
            if (dp < ca5.length) {
                ca5[dp] = PrintfFormat.this.dfs.getDecimalSeparator();
            }
            char[] ca6 = ca5;
            if (this.thousands && nThousands > 0) {
                ca6 = new char[ca5.length + nThousands + lead];
                ca6[0] = ca5[0];
                k = lead;
                for (i = lead; i < dp; ++i) {
                    if (i > 0 && (dp - i) % 3 == 0) {
                        ca6[k] = PrintfFormat.this.dfs.getGroupingSeparator();
                        ca6[k + 1] = ca5[i];
                        k += 2;
                        continue;
                    }
                    ca6[k] = ca5[i];
                    ++k;
                }
                while (i < ca5.length) {
                    ca6[k] = ca5[i];
                    ++i;
                    ++k;
                }
            }
            return ca6;
        }

        private String fFormatString(double x) {
            return new String(this.fFormatCharArray(x));
        }

        private char[] fFormatCharArray(double x) {
            char[] ca6 = Double.isInfinite(x) ? (x == Double.POSITIVE_INFINITY ? (this.leadingSign ? INF_LEADING_SIGN : (this.leadingSpace ? INF_LEADING_SPACE : INF)) : INF_NEGATIVE) : (Double.isNaN(x) ? (this.leadingSign ? NAN_LEADING_SIGN : (this.leadingSpace ? NAN_LEADING_SPACE : NAN)) : this.fFormatDigits(x));
            char[] ca7 = this.applyFloatPadding(ca6, false);
            return ca7;
        }

        private char[] eFormatDigits(double x, char eChar) {
            int dp;
            char[] ca3;
            int k;
            int i;
            int j;
            char[] ca2;
            int rPos;
            String sx;
            int expon = 0;
            boolean minusSign = false;
            if (this.precisionSet && this.precision < 14) {
                x = DomainFloat.round(x, this.precision);
            }
            if (x > 0.0) {
                sx = Double.toString(x);
            } else if (x < 0.0) {
                sx = Double.toString(-x);
                minusSign = true;
            } else {
                sx = Double.toString(x);
                if (sx.charAt(0) == '-') {
                    minusSign = true;
                    sx = sx.substring(1);
                }
            }
            int ePos = sx.indexOf(69);
            if (ePos == -1) {
                ePos = sx.indexOf(101);
            }
            int n1In = (rPos = sx.indexOf(46)) != -1 ? rPos : (ePos != -1 ? ePos : sx.length());
            int n2In = rPos != -1 ? (ePos != -1 ? ePos - rPos - 1 : sx.length() - rPos - 1) : 0;
            if (ePos != -1) {
                int ie = ePos + 1;
                expon = 0;
                if (sx.charAt(ie) == '-') {
                    ++ie;
                    while (ie < sx.length() && sx.charAt(ie) == '0') {
                        ++ie;
                    }
                    if (ie < sx.length()) {
                        expon = -Integer.parseInt(sx.substring(ie));
                    }
                } else {
                    if (sx.charAt(ie) == '+') {
                        ++ie;
                    }
                    while (ie < sx.length() && sx.charAt(ie) == '0') {
                        ++ie;
                    }
                    if (ie < sx.length()) {
                        expon = Integer.parseInt(sx.substring(ie));
                    }
                }
            }
            if (rPos != -1) {
                expon += rPos - 1;
            }
            int p = this.precisionSet ? this.precision : 5;
            char[] ca1 = rPos != -1 && ePos != -1 ? (sx.substring(0, rPos) + sx.substring(rPos + 1, ePos)).toCharArray() : (rPos != -1 ? (sx.substring(0, rPos) + sx.substring(rPos + 1)).toCharArray() : (ePos != -1 ? sx.substring(0, ePos).toCharArray() : sx.toCharArray()));
            boolean carry = false;
            int i0 = 0;
            if (ca1[0] != '0') {
                i0 = 0;
            } else {
                for (i0 = 0; i0 < ca1.length && ca1[i0] == '0'; ++i0) {
                }
            }
            if (i0 + p < ca1.length - 1) {
                carry = this.checkForCarry(ca1, i0 + p + 1);
                if (carry) {
                    carry = this.startSymbolicCarry(ca1, i0 + p, i0);
                }
                if (carry) {
                    ca2 = new char[i0 + p + 1];
                    ca2[i0] = 49;
                    for (j = 0; j < i0; ++j) {
                        ca2[j] = 48;
                    }
                    i = i0;
                    for (j = i0 + 1; j < p + 1; ++j) {
                        ca2[j] = ca1[i];
                        ++i;
                    }
                    ++expon;
                    ca1 = ca2;
                }
            }
            int eSize = Math.abs(expon) < 100 && !this.optionalL ? 4 : 5;
            ca2 = this.alternateForm || !this.precisionSet || this.precision != 0 ? new char[2 + p + eSize] : new char[1 + eSize];
            if (ca1[0] != '0') {
                ca2[0] = ca1[0];
                j = 1;
            } else {
                for (j = 1; j < (ePos == -1 ? ca1.length : ePos) && ca1[j] == '0'; ++j) {
                }
                if (ePos != -1 && j < ePos || ePos == -1 && j < ca1.length) {
                    ca2[0] = ca1[j];
                    expon -= j;
                    ++j;
                } else {
                    ca2[0] = 48;
                    j = 2;
                }
            }
            if (this.alternateForm || !this.precisionSet || this.precision != 0) {
                ca2[1] = 46;
                i = 2;
            } else {
                i = 1;
            }
            for (k = 0; k < p && j < ca1.length; ++k) {
                ca2[i] = ca1[j];
                ++j;
                ++i;
            }
            while (i < ca2.length - eSize) {
                ca2[i] = 48;
                ++i;
            }
            ca2[i++] = eChar;
            ca2[i++] = expon < 0 ? 45 : 43;
            if ((expon = Math.abs(expon)) >= 100) {
                switch (expon / 100) {
                    case 1: {
                        ca2[i] = 49;
                        break;
                    }
                    case 2: {
                        ca2[i] = 50;
                        break;
                    }
                    case 3: {
                        ca2[i] = 51;
                        break;
                    }
                    case 4: {
                        ca2[i] = 52;
                        break;
                    }
                    case 5: {
                        ca2[i] = 53;
                        break;
                    }
                    case 6: {
                        ca2[i] = 54;
                        break;
                    }
                    case 7: {
                        ca2[i] = 55;
                        break;
                    }
                    case 8: {
                        ca2[i] = 56;
                        break;
                    }
                    case 9: {
                        ca2[i] = 57;
                    }
                }
                ++i;
            }
            switch (expon % 100 / 10) {
                case 0: {
                    ca2[i] = 48;
                    break;
                }
                case 1: {
                    ca2[i] = 49;
                    break;
                }
                case 2: {
                    ca2[i] = 50;
                    break;
                }
                case 3: {
                    ca2[i] = 51;
                    break;
                }
                case 4: {
                    ca2[i] = 52;
                    break;
                }
                case 5: {
                    ca2[i] = 53;
                    break;
                }
                case 6: {
                    ca2[i] = 54;
                    break;
                }
                case 7: {
                    ca2[i] = 55;
                    break;
                }
                case 8: {
                    ca2[i] = 56;
                    break;
                }
                case 9: {
                    ca2[i] = 57;
                }
            }
            ++i;
            switch (expon % 10) {
                case 0: {
                    ca2[i] = 48;
                    break;
                }
                case 1: {
                    ca2[i] = 49;
                    break;
                }
                case 2: {
                    ca2[i] = 50;
                    break;
                }
                case 3: {
                    ca2[i] = 51;
                    break;
                }
                case 4: {
                    ca2[i] = 52;
                    break;
                }
                case 5: {
                    ca2[i] = 53;
                    break;
                }
                case 6: {
                    ca2[i] = 54;
                    break;
                }
                case 7: {
                    ca2[i] = 55;
                    break;
                }
                case 8: {
                    ca2[i] = 56;
                    break;
                }
                case 9: {
                    ca2[i] = 57;
                }
            }
            int nZeros = 0;
            if (!this.leftJustify && this.leadingZeros) {
                int xThousands = 0;
                if (this.thousands) {
                    int xdp;
                    int xlead = 0;
                    if (ca2[0] == '+' || ca2[0] == '-' || ca2[0] == ' ') {
                        xlead = 1;
                    }
                    for (xdp = xlead; xdp < ca2.length && ca2[xdp] != '.'; ++xdp) {
                    }
                    xThousands = (xdp - xlead) / 3;
                }
                if (this.fieldWidthSet) {
                    nZeros = this.fieldWidth - ca2.length;
                }
                if (!minusSign && (this.leadingSign || this.leadingSpace) || minusSign) {
                    --nZeros;
                }
                if ((nZeros -= xThousands) < 0) {
                    nZeros = 0;
                }
            }
            j = 0;
            if (!minusSign && (this.leadingSign || this.leadingSpace) || minusSign) {
                ca3 = new char[ca2.length + nZeros + 1];
                ++j;
            } else {
                ca3 = new char[ca2.length + nZeros];
            }
            if (!minusSign) {
                if (this.leadingSign) {
                    ca3[0] = 43;
                }
                if (this.leadingSpace) {
                    ca3[0] = 32;
                }
            } else {
                ca3[0] = 45;
            }
            for (k = 0; k < nZeros; ++k) {
                ca3[j] = 48;
                ++j;
            }
            for (i = 0; i < ca2.length && j < ca3.length; ++i, ++j) {
                ca3[j] = ca2[i];
            }
            int lead = 0;
            if (ca3[0] == '+' || ca3[0] == '-' || ca3[0] == ' ') {
                lead = 1;
            }
            for (dp = lead; dp < ca3.length && ca3[dp] != '.'; ++dp) {
            }
            int nThousands = dp / 3;
            if (dp < ca3.length) {
                ca3[dp] = PrintfFormat.this.dfs.getDecimalSeparator();
            }
            char[] ca4 = ca3;
            if (this.thousands && nThousands > 0) {
                ca4 = new char[ca3.length + nThousands + lead];
                ca4[0] = ca3[0];
                k = lead;
                for (i = lead; i < dp; ++i) {
                    if (i > 0 && (dp - i) % 3 == 0) {
                        ca4[k] = PrintfFormat.this.dfs.getGroupingSeparator();
                        ca4[k + 1] = ca3[i];
                        k += 2;
                        continue;
                    }
                    ca4[k] = ca3[i];
                    ++k;
                }
                while (i < ca3.length) {
                    ca4[k] = ca3[i];
                    ++i;
                    ++k;
                }
            }
            return ca4;
        }

        private boolean checkForCarry(char[] ca1, int icarry) {
            boolean carry = false;
            if (icarry < ca1.length && (ca1[icarry] == '5' || ca1[icarry] == '6' || ca1[icarry] == '7' || ca1[icarry] == '8' || ca1[icarry] == '9')) {
                carry = true;
            }
            return carry;
        }

        private boolean startSymbolicCarry(char[] ca, int cLast, int cFirst) {
            boolean carry = true;
            block12: for (int i = cLast; carry && i >= cFirst; --i) {
                carry = false;
                switch (ca[i]) {
                    case '0': {
                        ca[i] = 49;
                        continue block12;
                    }
                    case '1': {
                        ca[i] = 50;
                        continue block12;
                    }
                    case '2': {
                        ca[i] = 51;
                        continue block12;
                    }
                    case '3': {
                        ca[i] = 52;
                        continue block12;
                    }
                    case '4': {
                        ca[i] = 53;
                        continue block12;
                    }
                    case '5': {
                        ca[i] = 54;
                        continue block12;
                    }
                    case '6': {
                        ca[i] = 55;
                        continue block12;
                    }
                    case '7': {
                        ca[i] = 56;
                        continue block12;
                    }
                    case '8': {
                        ca[i] = 57;
                        continue block12;
                    }
                    case '9': {
                        ca[i] = 48;
                        carry = true;
                    }
                }
            }
            return carry;
        }

        private char[] eFormatCharArray(double x, char eChar) {
            char[] ca4 = Double.isInfinite(x) ? (x == Double.POSITIVE_INFINITY ? (this.leadingSign ? INF_LEADING_SIGN : (this.leadingSpace ? INF_LEADING_SPACE : INF)) : INF_NEGATIVE) : (Double.isNaN(x) ? (this.leadingSign ? NAN_LEADING_SIGN : (this.leadingSpace ? NAN_LEADING_SPACE : NAN)) : this.eFormatDigits(x, eChar));
            char[] ca5 = this.applyFloatPadding(ca4, false);
            return ca5;
        }

        private char[] applyFloatPadding(char[] ca4, boolean noDigits) {
            char[] ca5;
            block8: {
                int nBlanks;
                block10: {
                    int i;
                    block9: {
                        int i2;
                        ca5 = ca4;
                        if (!this.fieldWidthSet) break block8;
                        if (!this.leftJustify) break block9;
                        int nBlanks2 = this.fieldWidth - ca4.length;
                        if (nBlanks2 <= 0) break block8;
                        ca5 = new char[ca4.length + nBlanks2];
                        for (i2 = 0; i2 < ca4.length; ++i2) {
                            ca5[i2] = ca4[i2];
                        }
                        int j = 0;
                        while (j < nBlanks2) {
                            ca5[i2] = 32;
                            ++j;
                            ++i2;
                        }
                        break block8;
                    }
                    if (this.leadingZeros && !noDigits) break block10;
                    int nBlanks3 = this.fieldWidth - ca4.length;
                    if (nBlanks3 <= 0) break block8;
                    ca5 = new char[ca4.length + nBlanks3];
                    for (i = 0; i < nBlanks3; ++i) {
                        ca5[i] = 32;
                    }
                    for (int j = 0; j < ca4.length; ++j) {
                        ca5[i] = ca4[j];
                        ++i;
                    }
                    break block8;
                }
                if (this.leadingZeros && (nBlanks = this.fieldWidth - ca4.length) > 0) {
                    ca5 = new char[ca4.length + nBlanks];
                    int i = 0;
                    int j = 0;
                    if (ca4[0] == '-') {
                        ca5[0] = 45;
                        ++i;
                        ++j;
                    }
                    for (int k = 0; k < nBlanks; ++k) {
                        ca5[i] = 48;
                        ++i;
                    }
                    while (j < ca4.length) {
                        ca5[i] = ca4[j];
                        ++i;
                        ++j;
                    }
                }
            }
            return ca5;
        }

        private String printFFormat(double x) {
            String s = this.fFormatString(x);
            if (!this.precisionSet) {
                int i = 0;
                i = s.length() - 1;
                while (s.charAt(i) == '0') {
                    --i;
                }
                s = s.substring(0, i + 1);
            }
            return s;
        }

        private String printGFormat(double x) {
            char[] ca4;
            int savePrecision = this.precision;
            if (Double.isInfinite(x)) {
                ca4 = x == Double.POSITIVE_INFINITY ? (this.leadingSign ? INF_LEADING_SIGN : (this.leadingSpace ? INF_LEADING_SPACE : INF)) : INF_NEGATIVE;
            } else if (Double.isNaN(x)) {
                ca4 = this.leadingSign ? NAN_LEADING_SIGN : (this.leadingSpace ? NAN_LEADING_SPACE : NAN);
            } else {
                char[] ret;
                int j;
                char[] sx;
                if (!this.precisionSet) {
                    this.precision = 6;
                }
                if (this.precision == 0) {
                    this.precision = 1;
                }
                int ePos = -1;
                if (this.conversionCharacter == 'g') {
                    sx = PrintfFormat.trim(this.eFormatCharArray(x, 'e'));
                    ePos = -1;
                    for (j = 0; j < sx.length; ++j) {
                        if (sx[j] != 'e') continue;
                        ePos = j;
                        break;
                    }
                } else {
                    sx = PrintfFormat.trim(this.eFormatCharArray(x, 'E'));
                    ePos = -1;
                    for (j = 0; j < sx.length; ++j) {
                        if (sx[j] != 'e') continue;
                        ePos = j;
                        break;
                    }
                }
                int i = ePos + 1;
                int expon = 0;
                if (sx[i] == '-') {
                    ++i;
                    while (i < sx.length && sx[i] == '0') {
                        ++i;
                    }
                    if (i < sx.length) {
                        expon = -Integer.parseInt(new String(sx, i, sx.length - i));
                    }
                } else {
                    if (sx[i] == '+') {
                        ++i;
                    }
                    while (i < sx.length && sx[i] == '0') {
                        ++i;
                    }
                    if (i < sx.length) {
                        expon = Integer.parseInt(new String(sx, i, sx.length - i));
                    }
                }
                if (!this.alternateForm) {
                    char[] sz;
                    char[] sy;
                    if (expon >= -4 && expon < this.precision) {
                        sy = PrintfFormat.trim(this.fFormatCharArray(x));
                    } else {
                        sy = new char[ePos];
                        System.arraycopy(sx, 0, sy, 0, ePos);
                    }
                    for (i = sy.length - 1; i >= 0 && sy[i] == '0'; --i) {
                    }
                    if (i >= 0 && sy[i] == '.') {
                        --i;
                    }
                    if (i == -1) {
                        sz = new char[]{'0'};
                    } else if (!Character.isDigit(sy[i])) {
                        sz = new char[sy.length - (i + 2)];
                        System.arraycopy(sy, 0, sz, 0, sy.length - (i + 1));
                        sz[sz.length - 1] = 48;
                    } else {
                        sz = new char[i + 1];
                        System.arraycopy(sy, 0, sz, 0, i + 1);
                    }
                    if (expon >= -4 && expon < this.precision) {
                        ret = sz;
                    } else {
                        ret = new char[sz.length + sx.length - ePos];
                        System.arraycopy(sz, 0, ret, 0, sz.length);
                        System.arraycopy(sx, ePos, ret, sz.length, sx.length - ePos);
                    }
                } else {
                    ret = expon >= -4 && expon < this.precision ? PrintfFormat.trim(this.fFormatCharArray(x)) : sx;
                }
                if (this.leadingSpace && x >= 0.0) {
                    char[] temp = ret;
                    ret = new char[ret.length + 1];
                    ret[0] = 32;
                    System.arraycopy(temp, 0, ret, 1, temp.length);
                }
                ca4 = ret;
            }
            char[] ca5 = this.applyFloatPadding(ca4, false);
            this.precision = savePrecision;
            return new String(ca5);
        }

        private String printDFormat(int x) {
            return this.printDFormat(Integer.toString(x));
        }

        private String printDFormat(String sx) {
            char[] ca;
            block30: {
                int j;
                boolean neg;
                int jFirst;
                int i;
                int nLeadingZeros;
                block33: {
                    int nBlanks;
                    block31: {
                        block34: {
                            block32: {
                                block29: {
                                    int j2;
                                    nLeadingZeros = 0;
                                    nBlanks = 0;
                                    int n = 0;
                                    i = 0;
                                    jFirst = 0;
                                    boolean bl = neg = sx.charAt(0) == '-';
                                    if (sx.equals("0") && this.precisionSet && this.precision == 0) {
                                        sx = "";
                                    }
                                    if (!neg) {
                                        if (this.precisionSet && sx.length() < this.precision) {
                                            nLeadingZeros = this.precision - sx.length();
                                        }
                                    } else if (this.precisionSet && sx.length() - 1 < this.precision) {
                                        nLeadingZeros = this.precision - sx.length() + 1;
                                    }
                                    if (nLeadingZeros < 0) {
                                        nLeadingZeros = 0;
                                    }
                                    if (this.fieldWidthSet) {
                                        nBlanks = this.fieldWidth - nLeadingZeros - sx.length();
                                        if (!neg && (this.leadingSign || this.leadingSpace)) {
                                            --nBlanks;
                                        }
                                    }
                                    if (nBlanks < 0) {
                                        nBlanks = 0;
                                    }
                                    if (this.leadingSign) {
                                        ++n;
                                    } else if (this.leadingSpace) {
                                        ++n;
                                    }
                                    n += nBlanks;
                                    n += nLeadingZeros;
                                    ca = new char[n += sx.length()];
                                    if (!this.leftJustify) break block29;
                                    if (neg) {
                                        ca[i++] = 45;
                                    } else if (this.leadingSign) {
                                        ca[i++] = 43;
                                    } else if (this.leadingSpace) {
                                        ca[i++] = 32;
                                    }
                                    char[] csx = sx.toCharArray();
                                    jFirst = neg ? 1 : 0;
                                    for (j2 = 0; j2 < nLeadingZeros; ++j2) {
                                        ca[i] = 48;
                                        ++i;
                                    }
                                    j2 = jFirst;
                                    while (j2 < csx.length) {
                                        ca[i] = csx[j2];
                                        ++j2;
                                        ++i;
                                    }
                                    for (j2 = 0; j2 < nBlanks; ++j2) {
                                        ca[i] = 32;
                                        ++i;
                                    }
                                    break block30;
                                }
                                if (this.leadingZeros) break block31;
                                for (i = 0; i < nBlanks; ++i) {
                                    ca[i] = 32;
                                }
                                if (!neg) break block32;
                                ca[i++] = 45;
                                break block33;
                            }
                            if (!this.leadingSign) break block34;
                            ca[i++] = 43;
                            break block33;
                        }
                        if (!this.leadingSpace) break block33;
                        ca[i++] = 32;
                        break block33;
                    }
                    if (neg) {
                        ca[i++] = 45;
                    } else if (this.leadingSign) {
                        ca[i++] = 43;
                    } else if (this.leadingSpace) {
                        ca[i++] = 32;
                    }
                    j = 0;
                    while (j < nBlanks) {
                        ca[i] = 48;
                        ++j;
                        ++i;
                    }
                }
                j = 0;
                while (j < nLeadingZeros) {
                    ca[i] = 48;
                    ++j;
                    ++i;
                }
                char[] csx = sx.toCharArray();
                int j3 = jFirst = neg ? 1 : 0;
                while (j3 < csx.length) {
                    ca[i] = csx[j3];
                    ++j3;
                    ++i;
                }
            }
            return new String(ca);
        }

        private String printSFormat(DomainString x) {
            int nLeadingZeros = 0;
            int nPrint = x.length();
            int width = this.fieldWidth;
            if (this.precisionSet && nPrint > this.precision) {
                nPrint = this.precision;
            }
            if (!this.fieldWidthSet) {
                width = nPrint;
            }
            int n = 0;
            if (width > nPrint) {
                n += width - nPrint;
            }
            n = nPrint >= x.length() ? (n += x.length()) : (n += nPrint);
            if (this.leadingZeros) {
                nLeadingZeros = width - x.length();
            }
            char[] ca = new char[n];
            int i = 0;
            if (this.leftJustify) {
                char[] csx;
                if (nPrint >= x.length()) {
                    csx = x.toCharArray();
                    for (i = 0; i < x.length(); ++i) {
                        ca[i] = csx[i];
                    }
                } else {
                    csx = x.substring(0, nPrint).toCharArray();
                    for (i = 0; i < nPrint; ++i) {
                        ca[i] = csx[i];
                    }
                }
                int j = 0;
                while (j < width - nPrint) {
                    ca[i] = 32;
                    ++j;
                    ++i;
                }
            } else {
                if (!this.leadingZeros) {
                    for (i = 0; i < width - nPrint; ++i) {
                        ca[i] = 32;
                    }
                } else {
                    for (i = 0; i < width - nPrint; ++i) {
                        ca[i] = 48;
                    }
                }
                if (nPrint >= x.length()) {
                    char[] csx = x.toCharArray();
                    for (int j = 0; j < x.length(); ++j) {
                        ca[i] = csx[j];
                        ++i;
                    }
                } else {
                    char[] csx = x.substring(0, nPrint).toCharArray();
                    for (int j = 0; j < nPrint; ++j) {
                        ca[i] = csx[j];
                        ++i;
                    }
                }
            }
            return new String(ca);
        }

        private String printCFormat(String x) {
            int nPrint = x.length();
            int width = this.fieldWidth;
            if (this.precisionSet && this.precision > 0 && nPrint > this.precision) {
                x = x.substring(0, this.precision) + "." + x.substring(this.precision);
                ++nPrint;
            }
            if (!this.fieldWidthSet) {
                width = nPrint;
            }
            int n = 0;
            if (width > nPrint) {
                n += width - nPrint;
            }
            n = nPrint >= x.length() ? (n += x.length()) : (n += nPrint);
            char[] ca = new char[n];
            int i = 0;
            if (this.leftJustify) {
                char[] csx;
                if (nPrint >= x.length()) {
                    csx = x.toCharArray();
                    for (i = 0; i < x.length(); ++i) {
                        ca[i] = csx[i];
                    }
                } else {
                    csx = x.substring(0, nPrint).toCharArray();
                    for (i = 0; i < nPrint; ++i) {
                        ca[i] = csx[i];
                    }
                }
                int j = 0;
                while (j < width - nPrint) {
                    ca[i] = 32;
                    ++j;
                    ++i;
                }
            } else {
                for (i = 0; i < width - nPrint; ++i) {
                    ca[i] = 32;
                }
                if (nPrint >= x.length()) {
                    char[] csx = x.toCharArray();
                    for (int j = 0; j < x.length(); ++j) {
                        ca[i] = csx[j];
                        ++i;
                    }
                } else {
                    char[] csx = x.substring(0, nPrint).toCharArray();
                    for (int j = 0; j < nPrint; ++j) {
                        ca[i] = csx[j];
                        ++i;
                    }
                }
            }
            return new String(ca);
        }

        private boolean setConversionCharacter() {
            char c;
            boolean ret = false;
            this.conversionCharacter = '\u0000';
            if (this.pos < this.fmt.length && ((c = this.fmt[this.pos]) == 'i' || c == 'd' || c == 'm' || c == 'f' || c == 'g' || c == 'G' || c == 'c' || c == 's' || c == 't' || c == 'p' || c == '%')) {
                this.conversionCharacter = c;
                ++this.pos;
                ret = true;
            }
            return ret;
        }

        private void setOptionalL() {
            char c;
            this.optionalL = false;
            if (this.pos < this.fmt.length && (c = this.fmt[this.pos]) == 'l') {
                this.optionalL = true;
                ++this.pos;
            }
        }

        private void setPrecision() {
            int firstPos = this.pos;
            this.precisionSet = false;
            if (this.pos < this.fmt.length && this.fmt[this.pos] == '.') {
                char c;
                ++this.pos;
                if (this.pos < this.fmt.length && this.fmt[this.pos] == '*') {
                    ++this.pos;
                    if (!this.setPrecisionArgPosition()) {
                        this.variablePrecision = true;
                        this.precisionSet = true;
                    }
                    return;
                }
                while (this.pos < this.fmt.length && Character.isDigit(c = this.fmt[this.pos])) {
                    ++this.pos;
                }
                if (this.pos > firstPos + 1) {
                    String sz = new String(this.fmt, firstPos + 1, this.pos - (firstPos + 1));
                    this.precision = Integer.parseInt(sz);
                    this.precisionSet = true;
                }
            }
        }

        private void setFieldWidth() {
            int firstPos = this.pos;
            this.fieldWidth = 0;
            this.fieldWidthSet = false;
            if (this.pos < this.fmt.length && this.fmt[this.pos] == '*') {
                ++this.pos;
                if (!this.setFieldWidthArgPosition()) {
                    this.variableFieldWidth = true;
                    this.fieldWidthSet = true;
                }
            } else {
                char c;
                while (this.pos < this.fmt.length && Character.isDigit(c = this.fmt[this.pos])) {
                    ++this.pos;
                }
                if (firstPos < this.pos && firstPos < this.fmt.length) {
                    String sz = new String(this.fmt, firstPos, this.pos - firstPos);
                    this.fieldWidth = Integer.parseInt(sz);
                    this.fieldWidthSet = true;
                }
            }
        }

        private void setArgPosition() {
            int xPos;
            for (xPos = this.pos; xPos < this.fmt.length && Character.isDigit(this.fmt[xPos]); ++xPos) {
            }
            if (xPos > this.pos && xPos < this.fmt.length && this.fmt[xPos] == '$') {
                this.positionalSpecification = true;
                String tmpStr = new String(this.fmt, this.pos, xPos - this.pos);
                this.argumentPosition = Integer.parseInt(tmpStr);
                this.pos = xPos + 1;
            }
        }

        private boolean setFieldWidthArgPosition() {
            int xPos;
            boolean ret = false;
            for (xPos = this.pos; xPos < this.fmt.length && Character.isDigit(this.fmt[xPos]); ++xPos) {
            }
            if (xPos > this.pos && xPos < this.fmt.length && this.fmt[xPos] == '$') {
                this.positionalFieldWidth = true;
                String tmpStr = new String(this.fmt, this.pos, xPos - this.pos);
                this.argumentPositionForFieldWidth = Integer.parseInt(tmpStr);
                this.pos = xPos + 1;
                ret = true;
            }
            return ret;
        }

        private boolean setPrecisionArgPosition() {
            int xPos;
            boolean ret = false;
            for (xPos = this.pos; xPos < this.fmt.length && Character.isDigit(this.fmt[xPos]); ++xPos) {
            }
            if (xPos > this.pos && xPos < this.fmt.length && this.fmt[xPos] == '$') {
                this.positionalPrecision = true;
                String tmpStr = new String(this.fmt, this.pos, xPos - this.pos);
                this.argumentPositionForPrecision = Integer.parseInt(tmpStr);
                this.pos = xPos + 1;
                ret = true;
            }
            return ret;
        }

        boolean isPositionalSpecification() {
            return this.positionalSpecification;
        }

        int getArgumentPosition() {
            return this.argumentPosition;
        }

        boolean isPositionalFieldWidth() {
            return this.positionalFieldWidth;
        }

        int getArgumentPositionForFieldWidth() {
            return this.argumentPositionForFieldWidth;
        }

        boolean isPositionalPrecision() {
            return this.positionalPrecision;
        }

        int getArgumentPositionForPrecision() {
            return this.argumentPositionForPrecision;
        }

        private void setFlagCharacters() {
            this.thousands = false;
            this.leftJustify = false;
            this.leadingSign = false;
            this.leadingSpace = false;
            this.alternateForm = false;
            this.leadingZeros = false;
            while (this.pos < this.fmt.length) {
                char c = this.fmt[this.pos];
                if (c == '\'') {
                    this.thousands = true;
                } else if (c == '-') {
                    this.leftJustify = true;
                    this.leadingZeros = false;
                } else if (c == '+') {
                    this.leadingSign = true;
                    this.leadingSpace = false;
                } else if (c == ' ') {
                    if (!this.leadingSign) {
                        this.leadingSpace = true;
                    }
                } else if (c == '#') {
                    this.alternateForm = true;
                } else {
                    if (c != '0') break;
                    if (!this.leftJustify) {
                        this.leadingZeros = true;
                    }
                }
                ++this.pos;
            }
        }
    }
}

