/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain.db;

import com.mmmhis.domain.DomainException;
import com.mmmhis.domain.DomainInteger;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.DomainTable;
import com.mmmhis.domain.db.DBControl;
import com.mmmhis.domain.db.DBFile;
import com.mmmhis.domain.db.DBLPrimitive;
import com.mmmhis.domain.ec.EcQuark;
import com.mmmhis.domain.le.LEHandle;
import com.mmmhis.domain.table.TBLConvert;
import com.mmmhis.domain.table.TBLCursor;
import com.mmmhis.domain.table.TBLFile;
import com.mmmhis.domain.table.TBLHandle;
import com.mmmhis.domain.table.TBLTable;
import com.mmmhis.domain.td.TDFile;
import com.mmmhis.domain.td.TDHandle;
import com.mmmhis.domain.td.TDSection;
import com.mmmhis.domain.td.TDTag;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Writer;

public final class DBLHandle {
    public static final int DBL_UNKNOWN = 0;
    public static final int DBL_RESOURCE = 1;
    public static final int DBL_TABLE = 2;
    public static final int DBL_LINKED = 3;
    public static final int DBL_RUNTIME = 4;
    public static final int EXP_NONE = 0;
    public static final int EXP_VOID = 1;
    public static final int EXP_LOGICAL = 2;
    public static final int EXP_INTEGER = 3;
    public static final int EXP_STRING = 4;
    public static final int EXP_FLOAT = 5;
    public static final int EXP_CODE = 6;
    public static final int EXP_DATE = 7;
    public static final int EXP_CURRENCY = 8;
    public static final int EXP_FLOGICAL = 9;
    public static final int EXP_STRUCT = 10;
    public static final int EXP_REFERENCE = 11;
    public static final int EXP_BIT = 12;
    public static final int EXP_ENUM = 13;
    public static final int EXP_TABLE = 14;
    public static final int EXP_CURSOR = 15;
    public static final int EXP_ARRAY = 16;
    public static final int EXP_BITMEMBER = 17;
    public static final int EXP_PLOGICAL = 18;
    public static final int EXP_TIME = 19;
    public static final int EXP_JUMP = 20;
    public static final int EXP_LIST = 21;
    public static final int EXP_ELEMENT = 22;
    public static final int EXP_FSTRING = 23;
    public static final int EXP_STR_UPTO = 24;
    public static final int EXP_EXTDATE = 25;
    public static final int EXP_EXTTIME = 26;
    public static final int PATH_MAX = 256;
    TBLHandle tbl;
    TDHandle res;
    DBLPrimitive prm;
    TDSection section;
    String path;
    String tmppath;
    int type;
    boolean rw;
    int backup;
    RandomAccessFile exhandle;
    String expath;
    String origpath;
    DBControl dbControl;
    private String[][] pathlist = new String[][]{{"dvm.rcs", "kb/"}, {"dvm_site.rcs", "site/"}, {"dvm_user.rcs", "site/"}};

    public DBLHandle(DBControl dbControl) {
        this.dbControl = dbControl;
        this.prm = new DBLPrimitive(dbControl);
    }

    public void setPrimitive(DBLPrimitive _prm) {
        this.prm = _prm;
    }

    public void setType(int _type) {
        this.type = _type;
    }

    public void setRW(boolean _rw) {
        this.rw = _rw;
    }

    public void deleteHandle() {
        this.tbl = null;
    }

    public boolean getRW() {
        return this.rw;
    }

    public int load(String tag, DomainString localValue, int type) throws DomainException {
        return this.loadPrimitive(tag, localValue, false);
    }

    public int loadSection(String sectionName) throws DomainException {
        return this.loadPrimitive(sectionName, null, true);
    }

    public int loadPrimitive(String path, DomainString localValue, boolean isSection) throws DomainException {
        int status = 0;
        boolean root = !this.rw && (path.length() > 0 && path.charAt(0) == '/' || this.type == 0);
        path = path.toUpperCase();
        if (root) {
            if (path.startsWith("/RESOURCE")) {
                this.type = 1;
                path = path.substring("/RESOURCE".length());
                if (this.res == null) {
                    this.attachTDFile();
                }
            } else {
                if (this.prm != null && (status = this.prm.loadPrimitive(path, localValue, isSection)) == 0) {
                    this.type = 3;
                    return status;
                }
                if (this.tbl != null && (status = isSection ? this.tbl.findSection(path, 0, null) : this.tbl.findTag(path, localValue)) == 0) {
                    this.type = 2;
                    return status;
                }
                return isSection ? 108 : 106;
            }
        }
        switch (this.type) {
            case 1: 
            case 4: {
                if (isSection) {
                    status = this.res.setPositionToPath(path, false, null);
                    break;
                }
                TDTag[] tagArr = new TDTag[1];
                status = this.res.findTag(path, tagArr);
                if (status != 0 || localValue == null) break;
                localValue.setValue(tagArr[0].getValue());
                break;
            }
            case 2: {
                if (this.tbl != null) {
                    if (isSection) {
                        status = this.tbl.findSection(path, 0, null);
                        break;
                    }
                    status = this.tbl.findTag(path, localValue);
                    break;
                }
                status = 113;
                break;
            }
            case 3: {
                status = this.prm.loadPrimitive(path, localValue, isSection);
                break;
            }
            default: {
                status = 14;
            }
        }
        return status;
    }

    public int loadNext(DomainString tag, DomainString value) throws DomainException {
        int status = 0;
        switch (this.type) {
            case 1: 
            case 4: {
                TDTag[] tagArr = new TDTag[1];
                status = this.res.getNextTag(tagArr);
                if (status == 0) {
                    tag.setValue(tagArr[0].getName());
                    if (value == null) break;
                    value.setValue(tagArr[0].getValue());
                    break;
                }
                tag.reset();
                if (value == null) break;
                value.reset();
                break;
            }
            case 2: {
                status = this.tbl.nextTag();
                if (status != 0) break;
                this.tbl.thisTag(tag, value);
                break;
            }
            case 3: {
                status = this.prm.lpNext(tag, value);
                break;
            }
            default: {
                status = 106;
            }
        }
        return status;
    }

    public int loadFirst(DomainString tag, DomainString value) throws DomainException {
        int status = 0;
        switch (this.type) {
            case 1: 
            case 4: {
                TDTag[] tagArr = new TDTag[1];
                status = this.res.getFirstTag(tagArr);
                if (status == 0) {
                    tag.setValue(tagArr[0].getName());
                    if (value == null) break;
                    value.setValue(tagArr[0].getValue());
                    break;
                }
                tag.reset();
                if (value == null) break;
                value.reset();
                break;
            }
            case 2: {
                status = this.tbl.firstTag();
                if (status != 0) break;
                this.tbl.thisTag(tag, value);
                break;
            }
            case 3: {
                status = this.prm.lpFirst(tag, value);
                break;
            }
            default: {
                status = 106;
            }
        }
        return status;
    }

    public int loadLast(DomainString tag, DomainString value) throws DomainException {
        int status = 0;
        switch (this.type) {
            case 1: 
            case 4: {
                TDTag[] tagArr = new TDTag[1];
                status = this.res.getLastTag(tagArr);
                if (status == 0) {
                    tag.setValue(tagArr[0].getName());
                    if (value == null) break;
                    value.setValue(tagArr[0].getValue());
                    break;
                }
                tag.reset();
                if (value == null) break;
                value.reset();
                break;
            }
            case 2: {
                status = this.tbl.lastTag();
                if (status != 0) break;
                this.tbl.thisTag(tag, value);
                break;
            }
            case 3: {
                status = this.prm.lpLast(tag, value);
                break;
            }
            default: {
                status = 106;
            }
        }
        return status;
    }

    public int loadPrevious(DomainString tag, DomainString value) throws DomainException {
        int status = 0;
        switch (this.type) {
            case 1: 
            case 4: {
                TDTag[] tagArr = new TDTag[1];
                status = this.res.getPrevTag(tagArr);
                if (status == 0) {
                    tag.setValue(tagArr[0].getName());
                    if (value == null) break;
                    value.setValue(tagArr[0].getValue());
                    break;
                }
                tag.reset();
                if (value == null) break;
                value.reset();
                break;
            }
            case 2: {
                status = this.tbl.prevTag();
                if (status != 0) break;
                this.tbl.thisTag(tag, value);
                break;
            }
            case 3: {
                status = this.prm.lpPrev(tag, value);
                break;
            }
            default: {
                status = 106;
            }
        }
        return status;
    }

    public int loadNextSection(DomainString sectionName) throws DomainException {
        int status = 0;
        switch (this.type) {
            case 1: 
            case 4: {
                TDSection[] sectArr = new TDSection[1];
                status = this.res.getNextSection(sectArr);
                if (status != 0) break;
                sectionName.setValue(sectArr[0].getName());
                break;
            }
            case 2: {
                status = this.tbl.nextSection();
                if (status != 0) break;
                this.tbl.thisSection(sectionName);
                break;
            }
            case 3: {
                status = this.prm.lpNextSection(sectionName);
                break;
            }
            default: {
                status = 108;
            }
        }
        return status;
    }

    public int loadFirstSection(DomainString sectionName) throws DomainException {
        int status = 0;
        switch (this.type) {
            case 1: 
            case 4: {
                TDSection[] sectArr = new TDSection[1];
                status = this.res.getFirstSection(sectArr);
                if (status != 0) break;
                sectionName.setValue(sectArr[0].getName());
                break;
            }
            case 2: {
                status = this.tbl.firstSection();
                if (status != 0) break;
                this.tbl.thisSection(sectionName);
                break;
            }
            case 3: {
                status = this.prm.lpFirstSection(sectionName);
                break;
            }
            default: {
                status = 108;
            }
        }
        return status;
    }

    public int loadPrevSection(DomainString sectionName) throws DomainException {
        int status = 0;
        switch (this.type) {
            case 1: 
            case 4: {
                TDSection[] sectArr = new TDSection[1];
                status = this.res.getPrevSection(sectArr);
                if (status != 0) break;
                sectionName.setValue(sectArr[0].getName());
                break;
            }
            case 2: {
                status = this.tbl.prevSection();
                if (status != 0) break;
                this.tbl.thisSection(sectionName);
                break;
            }
            case 3: {
                status = this.prm.lpPrevSection(sectionName);
                break;
            }
            default: {
                status = 108;
            }
        }
        return status;
    }

    public int loadLastSection(DomainString sectionName) throws DomainException {
        int status = 0;
        switch (this.type) {
            case 1: 
            case 4: {
                TDSection[] sectArr = new TDSection[1];
                status = this.res.getLastSection(sectArr);
                if (status != 0) break;
                sectionName.setValue(sectArr[0].getName());
                break;
            }
            case 2: {
                status = this.tbl.lastSection();
                if (status != 0) break;
                this.tbl.thisSection(sectionName);
                break;
            }
            case 3: {
                status = this.prm.lpLastSection(sectionName);
                break;
            }
            default: {
                status = 108;
            }
        }
        return status;
    }

    public int reset() throws DomainException {
        int status = 0;
        switch (this.type) {
            case 1: 
            case 4: {
                status = this.res.seekToRoot();
                break;
            }
            case 2: {
                status = this.tbl.resetSection();
                break;
            }
            case 3: {
                status = this.prm.reset();
                break;
            }
            default: {
                status = 0;
            }
        }
        if (!this.rw) {
            this.type = 0;
        }
        return status;
    }

    public int closeLoad(String sectionName, boolean reopen) {
        if (sectionName != null) {
            if (this.res == null) {
                return 113;
            }
            int status = this.res.setPositionToPath(sectionName, false, null);
            if (status == 0) {
                TDSection sect = this.res.getSection();
                status = sect.getUserData() != 0 ? sect.sharedCloseFiles(this.dbControl) : 108;
            }
            if (status != 0) {
                return status;
            }
        }
        if (!reopen) {
            if (this.tbl != null) {
                this.tbl = null;
            }
            if (this.res != null) {
                this.res = null;
            }
            if (this.prm != null) {
                this.prm = null;
            }
        }
        return 0;
    }

    public int openLoad(String sectionName, boolean reopen) throws DomainException {
        if (sectionName != null) {
            TDSection sect;
            int status;
            if (this.res == null) {
                this.attachTDFile();
            }
            if ((status = this.res.setPositionToPath(sectionName, false, null)) == 0 && (sect = this.res.getSection()).getUserData() != 0) {
                status = sect.sharedOpenFiles(this.dbControl);
                if (status != 0) {
                    this.closeLoad(null, false);
                }
                return status;
            }
            if (!reopen) {
                this.closeLoad(null, false);
            }
            return 108;
        }
        return 0;
    }

    public int store(String name, String value) throws DomainException {
        DomainString tmpvalue = new DomainString();
        DomainString local = new DomainString();
        if (!this.rw) {
            return 113;
        }
        switch (this.type) {
            case 2: {
                int status;
                if (name.indexOf(47) != -1) {
                    status = this.tbl.findSection(name, 3, local);
                    if (status != 0) {
                        return status;
                    }
                } else {
                    local.setValue(name);
                }
                if ((status = this.tbl.findTag(local.toString(), tmpvalue)) == 0) {
                    return this.tbl.updateTag(value);
                }
                return this.tbl.newTag(local.toString(), value, false);
            }
            case 1: 
            case 4: {
                int status = this.res.setPositionToPath(name, true, local);
                TDTag[] tag = new TDTag[1];
                status = this.res.findTag(local.toString(), tag);
                if (status == 0) {
                    this.res.deleteTag();
                }
                return this.res.newTag(local.toString(), value, tag);
            }
        }
        return 113;
    }

    public int storeInsert(String name, String value) throws DomainException {
        DomainString local = new DomainString();
        if (!this.rw) {
            return 113;
        }
        switch (this.type) {
            case 2: {
                if (name.indexOf(47) != -1) {
                    int status = this.tbl.findSection(name, 3, local);
                    if (status != 0) {
                        return status;
                    }
                } else {
                    local.setValue(name);
                }
                return this.tbl.newTag(local.toString(), value, true);
            }
            case 1: 
            case 4: {
                int status = this.res.setPositionToPath(name, true, local);
                if (status != 0) {
                    return status;
                }
                TDTag[] tag = new TDTag[1];
                return this.res.newTag(local.toString(), value, tag);
            }
        }
        return 113;
    }

    public int storeSection(String sectionName) throws DomainException {
        if (!this.rw) {
            return 113;
        }
        switch (this.type) {
            case 2: {
                int status = this.tbl != null ? this.tbl.findSection(sectionName, 1, null) : 113;
                return status;
            }
            case 1: 
            case 4: {
                TDSection[] section = new TDSection[1];
                int status = this.res.findSection(sectionName, section);
                if (status == 0) break;
                return this.res.newSection(sectionName, section);
            }
        }
        return 113;
    }

    public int storeSectionInsert(String sectionName) throws DomainException {
        if (!this.rw) {
            return 113;
        }
        switch (this.type) {
            case 2: {
                int status = this.tbl != null ? this.tbl.findSection(sectionName, 4, null) : 113;
                return status;
            }
            case 1: 
            case 4: {
                TDSection section = new TDSection(sectionName);
                return this.res.insertSection(section);
            }
        }
        return 113;
    }

    public int storeSectionDelete(String old) throws DomainException {
        if (!this.rw) {
            return 113;
        }
        switch (this.type) {
            case 2: {
                int status = this.tbl.findSection(old, 0, null);
                if (status != 0) {
                    return status;
                }
                return this.tbl.deleteSection();
            }
            case 1: 
            case 4: {
                TDSection[] section = new TDSection[1];
                int status = this.res.findSection(old, section);
                if (status != 0) {
                    return status;
                }
                return this.res.deleteSection();
            }
        }
        return 113;
    }

    public int storeDelete(String old) throws DomainException {
        if (!this.rw) {
            return 113;
        }
        switch (this.type) {
            case 2: {
                return this.tbl.deleteTag(old);
            }
            case 1: 
            case 4: {
                TDTag[] tag = new TDTag[1];
                int status = this.res.findTag(old, tag);
                if (status != 0) {
                    return status;
                }
                return this.res.deleteTag();
            }
        }
        return 113;
    }

    public int storeSectionRename(String old, String newName) throws DomainException {
        if (!this.rw) {
            return 113;
        }
        switch (this.type) {
            case 2: {
                int status;
                if (this.tbl != null) {
                    status = this.tbl.findSection(old, 0, null);
                    if (status == 0) {
                        status = this.tbl.renameSection(newName);
                    }
                } else {
                    status = 113;
                }
                return status;
            }
            case 1: 
            case 4: {
                TDSection[] section = new TDSection[1];
                int status = this.res.findSection(old, section);
                if (status != 0) {
                    return status;
                }
                return this.res.renameSection(newName);
            }
        }
        return 113;
    }

    public int storeRename(String old, String newName) throws DomainException {
        DomainString value = new DomainString();
        if (!this.rw) {
            return 113;
        }
        switch (this.type) {
            case 2: {
                int status = this.tbl.findTag(old, value);
                if (status != 0) {
                    return status;
                }
                return this.tbl.renameTag(newName);
            }
            case 1: 
            case 4: {
                TDTag[] tag = new TDTag[1];
                int status = this.res.findTag(old, tag);
                if (status != 0) {
                    return status;
                }
                this.res.renameResetTag(newName, tag[0].getValue());
                return 0;
            }
        }
        return 113;
    }

    public int storeReset() throws DomainException {
        if (!this.rw) {
            return 113;
        }
        switch (this.type) {
            case 2: {
                if (this.tbl != null) {
                    return this.tbl.resetSection();
                }
                return 113;
            }
            case 1: 
            case 4: {
                return this.res.seekToRoot();
            }
        }
        return 113;
    }

    public int openStore(String orig, String locale, boolean shared, String opath, int tblsize, boolean rostatus) throws DomainException {
        int status;
        int rstatus = 0;
        if (orig == null) {
            status = 109;
        } else {
            status = 0;
            this.origpath = opath;
            String name = this.dbControl.resolvePathName(orig, this.type == 1, null);
            if (!shared) {
                this.expath = name + ".lck";
            }
            switch (this.type) {
                case 3: {
                    if (locale != null) {
                        this.backup = Integer.parseInt(locale);
                    }
                    DomainString str = new DomainString();
                    status = this.unlink(name, str);
                    this.tmppath = str.getValue();
                    if (status != 0) break;
                    this.path = orig;
                    name = this.tmppath;
                    this.type = 2;
                    this.section = this.dbControl.getTDHandle().getSection();
                }
                case 2: {
                    this.tbl = new TBLHandle();
                    TBLFile file = new TBLFile(this.dbControl);
                    status = file.open(name, rostatus, tblsize, 32);
                    if (rostatus) {
                        rstatus = 121;
                    }
                    if (status == 0) {
                        this.tbl.attachFile(file);
                        break;
                    }
                    this.deleteHandle();
                    break;
                }
                case 1: {
                    this.path = this.getPartialPath(name);
                    name = null;
                    this.res = new TDHandle();
                    this.res.attachFile(TDFile.open(false));
                    status = this.dbControl.openResourceSimple(this.path, null, this.res);
                    break;
                }
                default: {
                    name = null;
                    status = 113;
                }
            }
        }
        if (status != 0 && this.exhandle != null) {
            this.exclusiveClose();
            new File(this.expath).delete();
            this.expath = null;
        }
        return status == 0 ? rstatus : status;
    }

    public int flushStore() throws DomainException {
        TBLFile fd = this.tbl.detachFile();
        fd.flushTbl();
        return 0;
    }

    public int closeStore(boolean save) throws DomainException {
        int status = 0;
        int rstatus = 0;
        switch (this.type) {
            case 2: {
                if (this.tbl == null) {
                    return 113;
                }
                TBLFile fd = this.tbl.detachFile();
                if ((fd.getFileFlags() & 2) == 2) {
                    rstatus = 121;
                }
                fd.close();
                this.deleteHandle();
                if (this.path == null) {
                    if (rstatus != 0) {
                        status = rstatus;
                    }
                    if (save) break;
                    return 114;
                }
            }
            case 3: {
                if (save) {
                    String name;
                    if (this.backup != 0) {
                        String orig = this.linkBackup(this.path, this.backup);
                        name = this.dbControl.resolvePathName(orig, false, null);
                        status = this.link(this.tmppath, name);
                        if (status == 0) {
                            status = this.linkRewriteResource(this.section, orig);
                        }
                    } else {
                        name = this.dbControl.resolvePathName(this.path, false, null);
                        status = this.link(this.tmppath, name);
                    }
                    if (status != 0) {
                        return status;
                    }
                    DBFile.RemoveFileMap(name);
                }
                new File(this.tmppath).delete();
                this.tmppath = null;
                break;
            }
            case 1: {
                if (save && (status = this.linkWriteResourceFile(this.path, this.res.getFile().getRoot())) != 0) {
                    return status;
                }
                this.res.detachFile().close();
                this.res.deleteHandle();
                this.path = null;
                break;
            }
            case 4: {
                break;
            }
            default: {
                return 7;
            }
        }
        if (this.exhandle != null) {
            this.exclusiveClose();
            new File(this.expath).delete();
            this.expath = null;
        }
        return status;
    }

    String getPartialPath(String name) {
        String[] rootPath = new String[1];
        for (int i = 0; i < this.pathlist.length; ++i) {
            if (!this.pathlist[i][0].equals(name)) continue;
            String path = this.dbControl.getResource("Database/ResourceEdit", rootPath, null) ? rootPath[0] + this.pathlist[i][1] + name : this.dbControl.getProgramPath(this.pathlist[i][1], name, false);
            return path;
        }
        return name;
    }

    public boolean exclusiveOpen(String fileName) {
        try {
            this.exhandle = new RandomAccessFile(fileName, "rw");
            return this.exhandle != null;
        }
        catch (IOException ex) {
            try {
                if (this.exhandle != null) {
                    this.exhandle.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
    }

    public void exclusiveClose() {
    }

    public int loadTable(String tablePath, DomainTable table) throws DomainException {
        int status;
        if (table.getTblCursor() != null) {
            return 113;
        }
        if (tablePath != null && tablePath.length() != 0 && (status = this.loadPrimitive(tablePath, null, true)) != 0) {
            return status;
        }
        switch (this.type) {
            case 2: {
                TBLTable[] tableArr = new TBLTable[1];
                status = this.tbl.getSectionTable(tableArr, true);
                if (status != 0) {
                    return status;
                }
                if (tableArr[0] == null) {
                    return 116;
                }
                table.setTblCursor(new TBLCursor(tableArr[0], null));
                return 0;
            }
            case 3: {
                if (this.prm.fp == 0) {
                    return 116;
                }
                TBLTable[] tableArr = new TBLTable[1];
                status = TBLHandle.dbConnect(this.dbControl, this.prm.frame.fd, this.prm.fp, tableArr);
                if (status != 0) {
                    return status;
                }
                table.setTblCursor(new TBLCursor(tableArr[0], null));
                return 0;
            }
        }
        return 116;
    }

    public int DbLoadTableFP() {
        return this.prm.fp;
    }

    int unlink(String path, DomainString result) {
        int rc = 0;
        File tbl = null;
        try {
            tbl = File.createTempFile("dvm", null, null);
            rc = TBLConvert.convertCtlToTbl(path, tbl);
            if (rc != 0) {
                tbl.delete();
            } else {
                result.setValue(tbl.getAbsolutePath());
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return rc;
    }

    int link(String tbl, String result) {
        if (this.dbControl.getEcQuark() == null) {
            this.dbControl.setEcQuark(new EcQuark());
        }
        return LEHandle.convertTblToCtl(tbl, result, this.dbControl.getEcQuark());
    }

    String linkBackup(String path, int max) {
        int len;
        int curr;
        int nptr;
        if (this.origpath == null) {
            this.origpath = path;
        }
        int origlen = this.origpath.length();
        int ptr = path.lastIndexOf(46);
        if (ptr == -1) {
            ptr = path.length();
        }
        if ((nptr = this.origpath.lastIndexOf(46)) == -1) {
            nptr = origlen;
        }
        if (path.length() > origlen && Character.isDigit(path.charAt(ptr - 1))) {
            curr = Integer.parseInt(path.substring(nptr, ptr));
            len = nptr;
        } else {
            len = ptr;
            curr = 0;
        }
        if (++curr > max) {
            curr = 1;
        }
        return DomainString.format(this.dbControl.getEnv(), "%.*s%i%s", new Object[]{new DomainInteger(len), new DomainString(this.origpath), new DomainInteger(curr), new DomainString(path.toCharArray(), ptr, path.length() - ptr)}).toString();
    }

    int linkRewriteResource(TDSection section, String newname) throws DomainException {
        DomainString buffer = new DomainString(512);
        String resFile = this.dbControl.getProgramPath("site/", "dvm_site.rcs", false);
        if (resFile != null) {
            TDSection retSection;
            TDHandle handle = new TDHandle();
            handle.attachFile(TDFile.open(false));
            this.dbControl.openResourceSimple(resFile, null, handle);
            section.getPathName(buffer, 512);
            TDSection[] sectArr = new TDSection[1];
            TDTag[] tag = new TDTag[1];
            TDTag[] origtag = new TDTag[1];
            int status = this.dbControl.getTDHandle().findSection(buffer.toString(), sectArr);
            if (status == 0) {
                retSection = sectArr[0];
                status = this.dbControl.getTDHandle().findTag("PATH", tag);
                if (status == 0) {
                    this.dbControl.getTDHandle().deleteTag();
                }
                tag[0] = new TDTag("PATH", newname);
                if (tag[0] != null) {
                    status = this.dbControl.getTDHandle().insertTag(tag[0]);
                }
                if ((status = this.dbControl.getTDHandle().findTag("ORIGPATH", origtag)) != 0) {
                    this.dbControl.getTDHandle().newTag("ORIGPATH", this.origpath, origtag);
                }
                status = 0;
            }
            if (status == 0) {
                status = handle.findSection(buffer.toString(), sectArr);
                if (status != 0) {
                    status = handle.newSection(buffer.toString(), sectArr);
                }
                if (status == 0) {
                    retSection = sectArr[0];
                    status = handle.findTag("PATH", tag);
                    if (status == 0) {
                        handle.deleteTag();
                    }
                    tag[0] = new TDTag("PATH", newname);
                    if (tag[0] != null) {
                        status = handle.insertTag(tag[0]);
                    }
                    if ((status = handle.findTag("ORIGPATH", origtag)) != 0) {
                        handle.newTag("ORIGPATH", this.origpath, origtag);
                    }
                    status = 0;
                }
            }
            if (status == 0) {
                status = this.linkWriteResourceFile(resFile, handle.getFile().getRoot());
            }
            handle.detachFile().close();
            handle.deleteHandle();
            return status;
        }
        return 122;
    }

    int linkWriteResourceFile(String path, TDSection root) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(path));
            root.dumpData(writer, 0);
            ((Writer)writer).close();
            return 0;
        }
        catch (IOException ex) {
            return 7;
        }
    }

    public void attachTDFile() {
        this.res = new TDHandle();
        this.res.attachFile(this.dbControl.getTDFile());
    }

    public int createTableCopy(TBLCursor incursor, String section, DomainTable dest) {
        int rc = 0;
        if (!this.rw) {
            return 113;
        }
        if (section != null && section.length() != 0 && (rc = this.loadSection(section)) != 0) {
            return rc;
        }
        TBLTable[] tableArr = new TBLTable[1];
        rc = this.tbl.getSectionTable(tableArr, false);
        TBLTable outtbl = tableArr[0];
        if (outtbl != null) {
            return 45;
        }
        if (incursor == null) {
            return 113;
        }
        TBLTable intbl = incursor.getTable();
        if (intbl.getLayout() == null) {
            return 42;
        }
        intbl.getFile().TblCopyTablePrototypes(this.tbl.getTblFile());
        outtbl = this.tbl.getTblFile().TblCopyTable(intbl.getLayout(), intbl.getNextIndex(), null);
        rc = outtbl.TblCheckTable();
        if (rc != 0) {
            return rc;
        }
        rc = this.tbl.TblAttachTable(outtbl);
        outtbl.delete();
        if (rc != 0) {
            return rc;
        }
        tableArr = new TBLTable[1];
        rc = this.tbl.getSectionTable(tableArr, true);
        dest.setTblCursor(new TBLCursor(tableArr[0], null));
        return rc;
    }

    public static void main(String[] args) {
    }
}

