/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain.le;

import com.mmmhis.domain.DomainEcNumber;
import com.mmmhis.domain.DomainException;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.ec.EcIndex;
import com.mmmhis.domain.ec.EcQuark;
import com.mmmhis.domain.ec.EcUtil;
import com.mmmhis.domain.le.LEAttribute;
import com.mmmhis.domain.le.LECharConvert;
import com.mmmhis.domain.le.LENode;
import com.mmmhis.domain.le.LERoot;
import com.mmmhis.domain.table.TBLCompaction;
import com.mmmhis.domain.table.TBLFile;
import com.mmmhis.domain.td.TDFile;
import com.mmmhis.domain.td.TDHandle;
import com.mmmhis.domain.td.TDSection;
import com.mmmhis.domain.td.TDTag;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.Arrays;

public class LEHandle {
    EcQuark ecQuark;
    LENode leNodeComparator = new LENode();
    EcIndex ecIndexComparator = new EcIndex();
    RandomAccessFile out;
    LERoot rootIndex = new LERoot();
    LENode[] doneList;
    int doneSize;
    int doneLength;
    int charset;
    int frameType;
    int version;
    int options;
    String revision;
    String title;
    String mapfile;
    String outputfile;
    LECharConvert[] charConvert = new LECharConvert[]{new LECharConvert(null, null, "ISO 8859-1", 0), new LECharConvert(EcUtil.EcEBCDIC_to_ISO, EcUtil.EcISO_to_EBCDIC, "EBCDIC", 4), new LECharConvert(EcUtil.EcPC860_to_ISO, EcUtil.EcISO_to_PC860, "Code Page 860", 128), new LECharConvert(EcUtil.EcPC437_to_ISO, EcUtil.EcISO_to_PC437, "Code Page 437", 256), new LECharConvert(EcUtil.EcASCII_to_ISO, EcUtil.EcISO_to_ASCII, "ASCII (7 bit)", 512)};
    private static final int LePAGESIZE = 2048;
    private static final String LE_MAP_FRAME = "_MapFrame";
    private static final int LE_IS_STANDARD = 1;
    private static final int LE_IS_VERBOSE = 2;
    private static final int LE_IS_NOTEDB = 4;
    private static final int LE_IS_MAP = 8;
    private static final int LE_IS_STRIP = 16;
    private static final int LE_IS_NOINDEX = 32;
    private static final int LE_UNKNOWN = 0;
    private static final int LE_FRAME = 1;
    private static final int LE_INDEX = 2;
    private static final int LE_ROOT = 3;
    private static final int LE_INFO = 4;
    private static final int LE_TXTSRCH = 5;
    static final byte[] tableFrame = new byte[]{37, 65};
    private static final int LE_NOT_WRITTEN = 0;
    private static final int LE_IN_PROGRESS = 1;
    private static final int LE_WRITTEN = 2;
    private static final byte[] main = new byte[]{109, 97, 105, 110};
    private static final int MINSIZE = 1000;

    public LEHandle(boolean standard, boolean verbose, EcQuark ecQuark) {
        if (standard) {
            this.options |= 1;
        }
        if (verbose) {
            this.options |= 2;
        }
        this.ecQuark = ecQuark;
    }

    public static int convertTblToCtl(String inPath, String outPath, EcQuark ecQuark) throws DomainException {
        try {
            LEHandle le = new LEHandle(false, false, ecQuark);
            TBLFile tblFile = new TBLFile(null);
            int rc = tblFile.open(inPath, false, 0, 16);
            if (rc != 0) {
                return rc;
            }
            le.setFlags(2, 1);
            RandomAccessFile out = null;
            out = new RandomAccessFile(outPath, "rw");
            out.setLength(0L);
            le.setOutfile(out, outPath);
            rc = tblFile.compactLink(le);
            if (rc != 0) {
                return rc;
            }
            le.stringPhases();
            rc = tblFile.close();
            out.close();
            return 0;
        }
        catch (IOException ex) {
            return 7;
        }
    }

    void free() {
    }

    void setFlags(int frameType, int version) {
        this.frameType = frameType;
        this.version = version;
    }

    void setOutfile(RandomAccessFile out, String outPath) {
        this.out = out;
        this.outputfile = outPath;
    }

    void stringPhases() throws IOException, DomainException {
        LENode node;
        int q;
        long base = this.computeRootIndexSize();
        for (q = 0; q < this.doneLength; ++q) {
            node = this.doneList[q];
            if ((node.flags & 1) != 1) continue;
            base = this.processStringFrameI(node, base);
        }
        for (q = 0; q < this.doneLength; ++q) {
            node = this.doneList[q];
            if ((node.flags & 1) != 1 || (node.flags & 0x800) != 0) continue;
            base = this.processStringTablesI(node, base);
        }
        this.removeUnusedFrames();
        this.writeRoot();
        this.buildMainIndex();
        this.processStringsII();
        this.collateFileStats();
        this.mapFrame();
        this.buildMainIndex();
        this.calcStats();
        this.writeRoot();
    }

    void processStringsII() throws IOException, DomainException {
        LENode node;
        int q;
        for (q = 0; q < this.doneLength; ++q) {
            node = this.doneList[q];
            if (node.wstatus != 0 || (node.flags & 1) != 1) continue;
            this.processStringFrameII(node);
        }
        boolean done = false;
        while (!done) {
            done = true;
            for (q = 0; q < this.doneLength; ++q) {
                node = this.doneList[q];
                if (!node.redo) continue;
                done = false;
                this.processStringFrameII(node);
            }
        }
    }

    long processStringFrameI(LENode node, long base) throws DomainException {
        ++node.usecount;
        if ((node.flags & 0x800) == 2048) {
            node.objlength = node.length;
            node.fp = base;
            return base + (long)node.objlength + 5L;
        }
        this.convertISO(node.buffer, 0);
        TDFile file = TDFile.open(false);
        node.handle = new TDHandle();
        node.handle.attachFile(file);
        int ptr = 0;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(node.buffer)));
        node.handle.parse(reader, "<EOR>", '=', null);
        node.buffer = null;
        int len = node.sname.length() + 15 + 3;
        for (TDTag tag = node.handle.getFile().getRoot().getTags(); tag != null; tag = tag.getNext()) {
            len += tag.getName().length() + tag.getValue().length() + 2;
        }
        for (TDSection section = node.handle.getFile().getRoot().getKids(); section != null; section = section.getNext()) {
            len += (section.getName().length() + 5 + 1) * 5;
            String sectName = section.getName();
            byte[] path = new byte[node.sname.length() + sectName.length() + 2];
            byte[] iso = this.displayISO(node.sname.getBytes(), 0);
            ptr = 0;
            System.arraycopy(iso, 0, path, ptr, iso.length);
            ptr += iso.length;
            path[ptr++] = 47;
            System.arraycopy(sectName.getBytes(), 0, path, ptr, sectName.length());
            this.convertDest(path, 0);
            LENode child = this.getNode(new String(path, 0, ptr + sectName.length()));
            section.setUserData(child.qname);
            if (child.external) {
                throw new DomainException(2068, new Object[]{this.displayISO(path, 0)});
            }
            base = this.processStringFrameI(child, base);
            path = null;
        }
        node.objlength = 5 + len;
        node.fp = base;
        return base + (long)node.objlength;
    }

    void processStringFrameII(LENode node) throws IOException, DomainException {
        if ((node.flags & 1) == 1) {
            if ((node.flags & 0x800) == 0) {
                this.processStringFrame(node, null, null, null);
            } else {
                int[] tempLen = new int[]{node.wrotelen};
                node.fp = this.writeFrame(node.buffer, node.objlength, tempLen, 0L, true);
                node.wrotelen = tempLen[0];
                node.wstatus = 2;
            }
        }
    }

    int addSpecialSection(EcIndex ecIndex, String name, long fp) {
        ecIndex.first = name;
        this.convertDest(ecIndex.first.getBytes(), 0);
        ecIndex.index = fp;
        return 1;
    }

    void processStringFrame(LENode node, LENode parent, LENode older, LENode younger) throws IOException, DomainException {
        int i;
        TDSection section;
        int blen = 0;
        int wrotelen = 0;
        byte[] buffer = new byte[node.objlength];
        int ptr = 0;
        int local = node.sname.lastIndexOf(this.convertDestChar(47));
        local = local == -1 ? 0 : ++local;
        EcUtil.strcpy(buffer, ptr, node.sname.getBytes(), local);
        ptr += node.sname.length() - local + 1;
        if (node.redo) {
            if (node.anode != null) {
                this.processTableFrameII(node);
                ptr += EcUtil.putNumber(buffer, ptr, node.anode.fp);
            } else {
                ptr += EcUtil.putNumber(buffer, ptr, 0L);
            }
        } else {
            ptr += 5;
        }
        int first = ptr + 5;
        local = first + 1;
        for (TDTag tag = node.handle.getFile().getRoot().getTags(); tag != null; tag = tag.getNext()) {
            EcUtil.strcpy(buffer, local, tag.getName().getBytes(), 0);
            this.convertDest(buffer, local);
            EcUtil.strcpy(buffer, local += tag.getName().length() + 1, tag.getValue().getBytes(), 0);
            this.convertDest(buffer, local);
            local += tag.getValue().length() + 1;
        }
        int taglen = ++local - first;
        ptr += EcUtil.putNumber(buffer, ptr, taglen);
        System.arraycopy(buffer, first, buffer, ptr, taglen);
        ptr += taglen;
        int count = 0;
        for (section = node.handle.getFile().getRoot().getKids(); section != null; section = section.getNext()) {
            ++count;
        }
        EcIndex[] list = new EcIndex[count + 6];
        for (i = 0; i < list.length; ++i) {
            list[i] = new EcIndex();
        }
        section = node.handle.getFile().getRoot().getKids();
        TDSection prev = null;
        LENode oldest = null;
        LENode youngest = null;
        for (i = 0; i < count; ++i) {
            TDSection next = section.getNext();
            LENode child = this.getNodeQ(section.getUserData());
            if (i == 0) {
                oldest = child;
            }
            if (i + 1 == count) {
                youngest = child;
            }
            this.processStringFrame(child, node, i > 0 ? this.getNodeQ(prev.getUserData()) : null, i < count - 1 ? this.getNodeQ(next.getUserData()) : null);
            list[i].first = section.getName();
            this.convertDest(list[i].first.getBytes(), 0);
            list[i].index = child.fp;
            prev = section;
            section = next;
        }
        count += this.addSpecialSection(list[count], ".", node.redo ? node.fp : 0xFFFFFFFL);
        if (parent != null) {
            count += this.addSpecialSection(list[count], "..", node.redo ? parent.fp : 0xFFFFFFFL);
        }
        if (older != null) {
            count += this.addSpecialSection(list[count], "<", older.fp);
        }
        if (younger != null) {
            count += this.addSpecialSection(list[count], ">", node.redo ? younger.fp : 0xFFFFFFFL);
        }
        if (oldest != null) {
            count += this.addSpecialSection(list[count], ":", oldest.fp);
        }
        if (youngest != null) {
            count += this.addSpecialSection(list[count], ">>", youngest.fp);
        }
        Object buf = new byte[][]{buffer};
        int[] tempLen = new int[]{blen};
        this.buildIndex(node, list, count, (byte[][])buf, tempLen);
        blen = tempLen[0];
        int pos = ptr - 0;
        node.objlength = pos + blen;
        buffer = TBLCompaction.resizeArray(buffer, node.objlength);
        System.arraycopy(buf[0], 0, buffer, pos, blen);
        buf = null;
        tempLen = new int[]{wrotelen};
        node.fp = this.writeFrame(buffer, node.objlength, tempLen, node.redo ? node.fp : 0L, true);
        wrotelen = tempLen[0];
        node.wstatus = 2;
        if (node.redo) {
            if (wrotelen > node.wrotelen) {
                throw new DomainException(2076, new Object[]{node.sname, new Integer(wrotelen), new Integer(node.wrotelen)});
            }
            node.redo = false;
            node.handle.getFile().close();
            node.handle.deleteHandle();
        } else {
            node.wrotelen = wrotelen;
            node.redo = true;
        }
        buffer = null;
    }

    void buildIndex(LENode node, EcIndex[] list, int count, byte[][] retbuf, int[] length) throws IOException, DomainException {
        if (!node.redo) {
            node.index = this.out.length();
        }
        Arrays.sort(list, 0, count, this.ecIndexComparator);
        this.buildIndex(list, count, node.sname.getBytes(), node.index, retbuf, length);
        for (int i = 0; i < count; ++i) {
            list[i].first = null;
        }
        list = null;
    }

    long processStringTablesI(LENode node, long base) throws DomainException {
        base = this.processTableFrameI(node, base);
        for (TDSection section = node.handle.getFile().getRoot().getKids(); section != null; section = section.getNext()) {
            int index = 0;
            String sectName = section.getName();
            byte[] path = new byte[node.sname.length() + sectName.length() + 2];
            byte[] iso = this.displayISO(node.sname.getBytes(), 0);
            System.arraycopy(iso, 0, path, index, iso.length);
            index += iso.length;
            path[index++] = 47;
            System.arraycopy(sectName.getBytes(), 0, path, index, sectName.length());
            this.convertDest(path, 0);
            LENode child = this.getNode(new String(path, 0, index + sectName.length()));
            base = this.processStringTablesI(child, base);
            path = null;
        }
        return base;
    }

    long processTableFrameI(LENode node, long base) throws DomainException {
        int pages = 0;
        int[] count = new int[1];
        int nlen = node.sname.length();
        DomainString temp = new DomainString(nlen + 3);
        temp.append(node.sname);
        temp.append(new String(this.displayDest(tableFrame, 0)));
        int q = this.ecQuark.findQuark(temp.toString());
        temp = null;
        if (q == 0 || this.getNodeQ(q) == null) {
            return base;
        }
        block7: for (int i = 0; i < this.doneLength; ++i) {
            LENode tblnode = this.doneList[i];
            if ((tblnode.flags & 0x400) == 0 || tblnode.sname.length() < nlen || !tblnode.sname.substring(0, nlen).equals(node.sname) || this.convertCharToISO(tblnode.sname.charAt(nlen)) != '%') continue;
            byte[] buffer = tblnode.sname.getBytes();
            int index = nlen + 1;
            switch (this.convertCharToISO(buffer[index])) {
                case 'A': {
                    node.anode = tblnode;
                    buffer = tblnode.buffer;
                    index = 0;
                    node.pages = DomainEcNumber.EcGetNumber(buffer, index, count);
                    index += count[0];
                    pages = node.pages;
                    if (pages == 0) {
                        pages = 1;
                    }
                    node.tables = DomainEcNumber.EcGetNumber(buffer, index, count);
                    index += count[0];
                    node.tblarray = new LENode[node.tables];
                    node.pagearray = new LENode[pages];
                    tblnode.fp = base;
                    tblnode.objlength = (node.tables + pages + 2) * 5;
                    base += (long)(tblnode.objlength + 5);
                    continue block7;
                }
                case 'D': {
                    int n = this.getNumberFromChar(buffer, index + 1, 2);
                    node.tblarray[n] = tblnode;
                    ++tblnode.usecount;
                    tblnode.objlength = tblnode.length;
                    tblnode.fp = base;
                    base += (long)(tblnode.objlength + 5);
                    continue block7;
                }
                case 'P': {
                    int n = this.getNumberFromChar(buffer, index + 1, buffer.length - index - 1);
                    node.pagearray[n - 1] = tblnode;
                    ++tblnode.usecount;
                    tblnode.objlength = tblnode.length;
                    tblnode.fp = base;
                    base += (long)(tblnode.objlength + 5);
                    continue block7;
                }
                case 'T': {
                    node.pagearray[0] = tblnode;
                    ++tblnode.usecount;
                    tblnode.objlength = tblnode.length;
                    tblnode.fp = base;
                    base += (long)(tblnode.objlength + 5);
                    continue block7;
                }
                case 'Z': {
                    tblnode.flags |= 0x800;
                    continue block7;
                }
                default: {
                    throw new DomainException(2069, new Object[]{this.displayISO(tblnode.sname.getBytes(), 0)});
                }
            }
        }
        return base;
    }

    void _processTableFrameII(LENode tblnode) throws IOException, DomainException {
        int wrotelen = 0;
        if (tblnode == null) {
            return;
        }
        int[] tempLen = new int[]{wrotelen};
        tblnode.fp = this.writeFrame(tblnode.buffer, tblnode.objlength, tempLen, 0L, true);
        wrotelen = tempLen[0];
        tblnode.wstatus = 2;
        tblnode.wrotelen = wrotelen;
        tblnode.buffer = null;
    }

    void processTableFrameII(LENode node) throws IOException, DomainException {
        LENode tblnode;
        int i;
        int wrotelen = 0;
        byte[] buffer = new byte[node.anode.objlength];
        int ptr = 0;
        ptr += EcUtil.putNumber(buffer, ptr, node.tables);
        ptr += EcUtil.putNumber(buffer, ptr, node.pages);
        for (i = 0; i < node.tables; ++i) {
            tblnode = node.tblarray[i];
            this._processTableFrameII(tblnode);
            ptr += EcUtil.putNumber(buffer, ptr, tblnode.fp);
        }
        for (i = 0; i < node.pages; ++i) {
            tblnode = node.pagearray[i];
            this._processTableFrameII(tblnode);
            ptr += EcUtil.putNumber(buffer, ptr, tblnode.fp);
        }
        if (node.pages == 0) {
            tblnode = node.pagearray[0];
            this._processTableFrameII(tblnode);
            ptr += EcUtil.putNumber(buffer, ptr, tblnode.fp);
        }
        int[] tempLen = new int[]{wrotelen};
        node.anode.fp = this.writeFrame(buffer, ptr, tempLen, 0L, true);
        wrotelen = tempLen[0];
        node.anode.wstatus = 2;
        node.anode.wrotelen = wrotelen;
        node.tblarray = null;
        node.tables = 0;
        node.pagearray = null;
        node.pages = 0;
        buffer = null;
    }

    int getNumberFromChar(byte[] buffer, int index, int len) {
        int n = 0;
        int zero = this.convertDestChar(48);
        while (len > 0 && buffer[index] != 0) {
            n = 10 * n + ((buffer[index] & 0xFF) - zero);
            ++index;
            --len;
        }
        return n;
    }

    char convertCharToISO(int TextChar) {
        return (char)(this.charset == 0 ? TextChar : this.charConvert[this.charset].from[TextChar & 0xFF]);
    }

    void writeRoot() throws IOException, DomainException {
        int i;
        byte[] buffer = new byte[4096];
        int index = 0;
        int endptr = 2048 - ("This is an unpublished work containing 3M confidential and proprietary\ninformation. Disclosure, use, or reproduction without the written\nauthorization of 3M is prohibited. If publication occurs, the \nfollowing notice applies:\n\nCopyright \u00c2\u00a9 2011, 3M.  All rights reserved.\n".length() + 1);
        EcUtil.strcpy(buffer, endptr, "This is an unpublished work containing 3M confidential and proprietary\ninformation. Disclosure, use, or reproduction without the written\nauthorization of 3M is prohibited. If publication occurs, the \nfollowing notice applies:\n\nCopyright \u00c2\u00a9 2011, 3M.  All rights reserved.\n".getBytes(), 0);
        this.convertDest(buffer, endptr);
        long memoffset = 2048L;
        long pos = this.out.getFilePointer();
        long memsize = this.out.length() - memoffset;
        buffer[index++] = (byte)this.frameType;
        index += EcUtil.putNumber(buffer, index, this.rootIndex.compressed ? 1L : 0L);
        index += EcUtil.putNumber(buffer, index, this.rootIndex.longest);
        index += EcUtil.putNumber(buffer, index, this.version);
        index += EcUtil.putNumber(buffer, index, this.rootIndex.index);
        index += EcUtil.putNumber(buffer, index, memsize);
        index += EcUtil.putNumber(buffer, index, memoffset);
        index += EcUtil.putNumber(buffer, index, this.rootIndex.globals);
        if (this.rootIndex.grules != null) {
            index = LEHandle.loadRules(this.rootIndex.grules.getBytes(), 0, buffer, index);
        }
        index += EcUtil.putNumber(buffer, index, this.rootIndex.classSize);
        if (this.rootIndex.crules != null) {
            index = LEHandle.loadRules(this.rootIndex.crules.getBytes(), 0, buffer, index);
        }
        index += EcUtil.putNumber(buffer, index, this.rootIndex.attribs);
        index += EcUtil.putNumber(buffer, index, this.charset);
        if (this.revision != null) {
            EcUtil.strcpy(buffer, index, this.revision.getBytes(), 0);
            this.convertDest(buffer, index);
        } else {
            buffer[index] = 0;
        }
        index += EcUtil.strlen(buffer, index) + 1;
        index += EcUtil.putNumberWide(buffer, index, this.rootIndex.timestamp != null ? this.rootIndex.timestamp.getTime() : 0L);
        if (this.title != null) {
            EcUtil.strcpy(buffer, index, this.title.getBytes(), 0);
            this.convertDest(buffer, index);
        } else {
            buffer[index] = 0;
        }
        index += EcUtil.strlen(buffer, index) + 1;
        index += EcUtil.putNumber(buffer, index, this.rootIndex.map);
        int count = 0;
        for (i = 0; i < this.rootIndex.acount; ++i) {
            count += 3 + ((LEAttribute)this.rootIndex.alist.get((int)i)).count;
        }
        index += EcUtil.putNumber(buffer, index, count);
        index += EcUtil.putNumber(buffer, index, this.rootIndex.acount);
        for (i = 0; i < this.rootIndex.acount; ++i) {
            LEAttribute leAttr = (LEAttribute)this.rootIndex.alist.get(i);
            index += EcUtil.putNumber(buffer, index, leAttr.ident);
            index += EcUtil.putNumber(buffer, index, leAttr.length);
            if (endptr < (index += EcUtil.putNumber(buffer, index, leAttr.count))) {
                throw new DomainException(2065);
            }
            for (count = 0; count < leAttr.count; ++count) {
                long val = Integer.parseInt(leAttr.arg, 10);
                if (endptr >= (index += EcUtil.putNumber(buffer, index, val))) continue;
                throw new DomainException(2065);
            }
        }
        if (this.rootIndex.prefix != null) {
            EcUtil.strcpy(buffer, index, this.rootIndex.prefix.getBytes(), 0);
        } else {
            buffer[index] = 0;
        }
        index += EcUtil.strlen(buffer, index) + 1;
        if (endptr < index) {
            throw new DomainException(2065);
        }
        index += EcUtil.putNumber(buffer, index, this.rootIndex.text);
        index += EcUtil.putNumber(buffer, index, this.rootIndex.linear);
        index += EcUtil.putNumber(buffer, index, this.rootIndex.filemap);
        EcUtil.strcpy(buffer, index, "1.00.042.0".getBytes(), 0);
        index += EcUtil.strlen(buffer, index);
        if (endptr < index) {
            throw new DomainException(2065);
        }
        this.out.seek(0L);
        this.out.write(buffer, 0, 2048);
        buffer = null;
    }

    long writeFrame(byte[] addr, int addrlen, int[] wrotelen, long rewrite, boolean compress) throws IOException, DomainException {
        int wlen;
        byte[] buf = new byte[5];
        if (rewrite > 0L) {
            this.out.seek(rewrite);
        } else {
            this.out.seek(this.out.length());
        }
        long ret = this.out.getFilePointer();
        byte[] cbuf = addr;
        wrotelen[0] = addrlen;
        if (rewrite == 0L && this.rootIndex.compressed && compress) {
            addrlen += 10;
            wrotelen[0] = wrotelen[0] + 10;
        }
        if (this.frameType == 5 && addrlen < 5) {
            wrotelen[0] = addrlen = 5;
        }
        if ((long)addrlen == 0L) {
            throw new DomainException(2067);
        }
        int len = EcUtil.putNumber(buf, 0, addrlen);
        this.out.write(buf, 0, len);
        boolean clen = false;
        if (this.rootIndex.compressed && compress) {
            if (wrotelen[0] >= addrlen) {
                cbuf = null;
                cbuf = addr;
                wrotelen[0] = addrlen;
                wlen = EcUtil.putNumber(buf, 0, 0L);
                clen = false;
            } else {
                wlen = EcUtil.putNumber(buf, 0, wrotelen[0]);
                clen = true;
            }
            this.out.write(buf, 0, wlen);
        } else {
            wlen = 0;
            clen = false;
        }
        this.out.write(cbuf, 0, wrotelen[0]);
        if (clen) {
            cbuf = null;
        }
        wrotelen[0] = wrotelen[0] + (len + wlen);
        return ret;
    }

    static int loadRules(byte[] src, int srcIndex, byte[] dest, int destIndex) {
        if (src != null) {
            String srcStr = new String(src);
            long count = Integer.parseInt(srcStr, 10);
            destIndex += EcUtil.putNumber(dest, destIndex, count);
            for (long i = 0L; i < count; ++i) {
                destIndex += EcUtil.putNumber(dest, destIndex, count);
            }
        }
        return destIndex;
    }

    void buildMainIndex() throws IOException, DomainException {
        LENode node;
        int q;
        byte[] prefix = new byte[256];
        int count = 0;
        for (q = 0; q < this.doneLength; ++q) {
            node = this.doneList[q];
            if (node == null) {
                throw new DomainException("ASSERT(node)");
            }
            if ((node.flags & 1) != 1) continue;
            ++count;
        }
        if (count == 0) {
            throw new DomainException(2060);
        }
        Arrays.fill(prefix, (byte)0);
        EcIndex[] array = new EcIndex[count];
        int i = 0;
        for (q = 0; q < this.doneLength; ++q) {
            EcIndex ecIndex;
            node = this.doneList[q];
            if ((node.flags & 1) != 1) continue;
            if (new String(prefix).indexOf(node.sname.charAt(0)) == -1) {
                prefix[EcUtil.strlen((byte[])prefix, (int)0)] = (byte)node.sname.charAt(0);
            }
            array[i] = ecIndex = new EcIndex(node.sname, node.wstatus == 2 ? node.fp : 0xFFFFFFFL);
            ++i;
        }
        this.rootIndex.index = this.buildIndex(array, count, this.displayDest(main, 0), 2048L, null, null);
        if (this.rootIndex.prefix == null) {
            this.rootIndex.prefix = new String(prefix, 0, EcUtil.strlen(prefix, 0));
        }
        for (i = 0; i < count; ++i) {
            array[i] = null;
        }
        array = null;
    }

    long buildIndex(EcIndex[] array, int count, byte[] name, long base, byte[][] membuf, int[] memlen) throws IOException, DomainException {
        long result;
        int i;
        DomainString local = new DomainString(128);
        if (base == 0L) {
            base = this.out.length();
        }
        Arrays.sort(array, 0, count, this.ecIndexComparator);
        int rbase = 1;
        int len = 0;
        for (i = 0; i < count; ++i) {
            if ((len += array[i].first.length()) <= 2048) continue;
            ++rbase;
            len = 0;
        }
        if (rbase > 1) {
            EcIndex[] root = new EcIndex[rbase];
            int beg = 0;
            len = 0;
            int rcount = 0;
            i = 0;
            String lastframe = null;
            while (true) {
                boolean nextFrame = false;
                if (len > 2248 || len > 0 && i == count) {
                    if (i < count) {
                        if (lastframe == null) {
                            lastframe = array[i - 1].first;
                        }
                        if (array[i].first.startsWith(lastframe)) {
                            nextFrame = true;
                        }
                    }
                    if (!nextFrame) {
                        local.reset();
                        local.append(new String(this.displayISO(name, 0)));
                        local.append("__SI");
                        local.append(String.valueOf(rcount));
                        if (rcount >= rbase) {
                            EcIndex[] tempRoot = root;
                            root = new EcIndex[rbase += 10];
                            System.arraycopy(tempRoot, 0, root, 0, tempRoot.length);
                            tempRoot = null;
                        }
                        this.convertDest(local.toByteArray(), 0);
                        long[] resultArr = new long[1];
                        long[] baseArr = new long[]{base};
                        int found = this.buildIndexNode(array, beg, resultArr, i - beg, local.toString(), false, baseArr);
                        root[rcount] = new EcIndex(null, resultArr[0]);
                        base = baseArr[0];
                        root[rcount].first = array[beg + found - 1].first;
                        i = beg += found;
                        ++rcount;
                        len = 0;
                        lastframe = null;
                    }
                }
                if (i == count) break;
                len += array[i].first.length();
                ++i;
            }
            local.reset();
            local.append(new String(this.displayISO(name, 0)));
            local.append("_root");
            this.convertDest(local.toByteArray(), 0);
            if (membuf != null) {
                EcUtil.buildIndexTree(root, 0, rcount, membuf, memlen, true);
                result = root[rcount - 1].index;
            } else {
                long[] resultArr = new long[]{0L};
                long[] baseArr = new long[]{base};
                this.buildIndexNode(root, 0, resultArr, rcount, local.toString(), true, baseArr);
                result = resultArr[0];
                base = baseArr[0];
            }
            for (i = 0; i < rcount; ++i) {
                root[i].first = null;
            }
            root = null;
        } else {
            local.reset();
            local.append(new String(this.displayISO(name, 0)));
            local.append("_root");
            this.convertDest(local.toByteArray(), 0);
            if (membuf != null) {
                EcUtil.buildIndexTree(array, 0, count, membuf, memlen, false);
                result = 0L;
            } else {
                long[] resultArr = new long[]{0L};
                long[] baseArr = new long[]{base};
                this.buildIndexNode(array, 0, resultArr, count, local.toString(), false, baseArr);
                result = resultArr[0];
                base = baseArr[0];
            }
        }
        return result;
    }

    int buildIndexNode(EcIndex[] array, int arrIndex, long[] result, int count, String name, boolean branch, long[] base) throws IOException, DomainException {
        Object buf = new byte[1][];
        int[] blen = new int[1];
        EcUtil.buildIndexTree(array, arrIndex, count, buf, blen, branch);
        LENode node = this.getNode(name);
        int[] lenArr = new int[]{node.wrotelen};
        result[0] = this.writeFrame(buf[0], blen[0], lenArr, base[0], false);
        node.wrotelen = lenArr[0];
        base[0] = base[0] + (long)node.wrotelen;
        node.length = blen[0];
        node.fp = result[0];
        node.type = 2;
        node.wstatus = 2;
        node.external = false;
        buf = null;
        return count;
    }

    public int metaLinkWrite(byte[] nameBuffer, int nameIndex, byte[] buffer, int index, int len, int linkFlags) {
        int nameLen = EcUtil.strlen(nameBuffer, nameIndex);
        String name = new String(nameBuffer, nameIndex, nameLen);
        LENode node = this.getNode(name);
        node.buffer = new byte[len];
        System.arraycopy(buffer, index, node.buffer, 0, len);
        node.length = len;
        node.flags = linkFlags;
        node.external = false;
        node.type = 1;
        return len;
    }

    long computeRootIndexSize() {
        long base = 2048L;
        for (int q = 0; q < this.doneLength; ++q) {
            LENode node = this.doneList[q];
            if ((node.flags & 1) != 1) continue;
            base += (long)(node.sname.length() + 5 + 1);
        }
        return base;
    }

    void removeUnusedFrames() {
        for (int q = 0; q < this.doneLength; ++q) {
            LENode node = this.doneList[q];
            if (node.usecount != 0 || node.external) continue;
            node.buffer = null;
        }
    }

    byte[] displayISO(byte[] buffer, int index) {
        if (this.charset != 0) {
            byte[] ascii = new byte[buffer.length + 1];
            EcUtil.strcpy(ascii, 0, buffer, index);
            EcUtil.convertCharSet(ascii, index, this.charConvert[this.charset].from);
            return ascii;
        }
        return buffer;
    }

    byte[] displayDest(byte[] buffer, int index) {
        if (this.charset != 0) {
            byte[] ebcdic = new byte[buffer.length + 1];
            EcUtil.strcpy(ebcdic, 0, buffer, index);
            EcUtil.convertCharSet(ebcdic, index, this.charConvert[this.charset].to);
            return ebcdic;
        }
        return buffer;
    }

    void convertISO(byte[] buffer, int index) {
        if (this.charset != 0) {
            EcUtil.convertCharSet(buffer, index, this.charConvert[this.charset].from);
        }
    }

    void convertDest(byte[] buffer, int index) {
        if (this.charset != 0) {
            EcUtil.convertCharSet(buffer, index, this.charConvert[this.charset].to);
        }
    }

    int convertDestChar(int TextChar) {
        return this.charset == 0 ? TextChar : this.charConvert[this.charset].to[TextChar];
    }

    private LENode getNodeQ(int quark) throws DomainException {
        LENode local = new LENode(quark);
        if (this.doneSize <= 0) {
            throw new DomainException("ASSERT(le->DoneSize > 0)");
        }
        int index = Arrays.binarySearch(this.doneList, local, this.leNodeComparator);
        LENode node = index >= 0 ? this.doneList[index] : null;
        return node;
    }

    public static LENode[] resizeArray(LENode[] oldArray, int newSize) {
        int oldSize = oldArray.length;
        LENode[] newArray = new LENode[newSize];
        int preserveLenth = Math.min(oldSize, newSize);
        if (preserveLenth > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLenth);
        }
        return newArray;
    }

    public LENode getNode(String name) throws DomainException {
        int quark;
        LENode node;
        if (this.doneSize == 0) {
            this.doneSize = 1000;
            this.doneList = new LENode[this.doneSize];
        }
        if ((node = this.getNodeQ(quark = this.ecQuark.stringToQuark(name))) == null) {
            node = new LENode(quark);
            node.qname = quark;
            node.sname = name;
            node.external = true;
            byte[] b = name.getBytes();
            if (this.doneLength >= this.doneSize) {
                this.doneSize += 1000;
                this.doneList = LEHandle.resizeArray(this.doneList, this.doneSize);
            }
            this.doneList[this.doneLength++] = node;
            if (this.doneLength > 1 && this.doneList[this.doneLength - 2].qname > quark) {
                Arrays.sort(this.doneList, 0, this.doneLength, this.leNodeComparator);
            }
        }
        return node;
    }

    void calcStats() throws DomainException {
        long count = 0L;
        long length = 0L;
        this.rootIndex.longest = 0;
        long extra = 0L;
        for (int q = 0; q < this.doneLength; ++q) {
            LENode node = this.doneList[q];
            if (node == null) {
                throw new DomainException("ASSERT(node)");
            }
            if (node.wstatus == 2) {
                length += (long)node.objlength;
                if (node.objlength > this.rootIndex.longest) {
                    this.rootIndex.longest = node.objlength;
                }
                ++count;
                continue;
            }
            if (node.external || (node.flags & 0x800) != 0) continue;
            System.err.println("Frame not linked in: " + new String(this.displayISO(node.sname.getBytes(), 0)));
            ++extra;
        }
    }

    void mapFrame() throws IOException, DomainException {
        LENode node;
        int q;
        if ((this.options & 0x10) == 16) {
            return;
        }
        int size = 1;
        for (q = 0; q < this.doneLength; ++q) {
            node = this.doneList[q];
            if (node == null) {
                throw new DomainException("ASSERT(node)");
            }
            if (node.wstatus != 2) continue;
            size += node.sname.length() + 1 + 10;
        }
        byte[] map = new byte[size];
        int mptr = 0;
        for (q = 0; q < this.doneLength; ++q) {
            node = this.doneList[q];
            if (node == null) {
                throw new DomainException("ASSERT(node)");
            }
            if (node.wstatus != 2) continue;
            EcUtil.strcpy(map, mptr, node.sname.getBytes(), 0);
            mptr += node.sname.length() + 1;
            mptr += EcUtil.putNumber(map, mptr, node.fp);
            mptr += EcUtil.putNumber(map, mptr, node.flags);
        }
        node = this.getNode(new String(this.displayDest(LE_MAP_FRAME.getBytes(), 0)));
        node.length = ++mptr - 0;
        int[] tempLen = new int[]{node.wrotelen};
        this.rootIndex.map = this.writeFrame(map, node.length, tempLen, 0L, true);
        node.wrotelen = tempLen[0];
        node.fp = this.rootIndex.map;
        node.type = 2;
        node.wstatus = 2;
        node.external = false;
        node.flags = 0;
        map = null;
    }

    long writeFileFrame(int index, int count) throws IOException, DomainException {
        int i;
        int wrotelen = 0;
        int len = 1;
        for (i = index; i < index + count; ++i) {
            len += this.doneList[i].sname.length() + 11;
        }
        byte[] buf = new byte[len];
        int bptr = 0;
        for (i = index; i < index + count; ++i) {
            LENode node = this.doneList[i];
            System.arraycopy(node.sname.getBytes(), 0, buf, bptr, node.sname.length());
            bptr += node.sname.length() + 1;
            bptr += EcUtil.putNumber(buf, bptr, node.first);
            bptr += EcUtil.putNumber(buf, bptr, node.last);
        }
        buf[bptr++] = 0;
        int[] tempLen = new int[]{wrotelen};
        long result = this.writeFrame(buf, bptr, tempLen, 0L, false);
        wrotelen = tempLen[0];
        buf = null;
        return result;
    }

    static String fixupFrameName(String name) {
        int local = name.lastIndexOf(92);
        if (local != 0) {
            name = name.substring(local + 1);
        }
        if ((local = name.lastIndexOf(47)) != 0) {
            name = name.substring(local + 1);
        }
        return name;
    }

    void collateFileStats() throws IOException, DomainException {
        LENode node;
        int q;
        int sublist = 0;
        if ((this.options & 0x10) == 16) {
            return;
        }
        Arrays.sort(this.doneList, 0, this.doneLength, this.leNodeComparator);
        int count = 0;
        String curr = null;
        for (q = 0; q < this.doneLength; ++q) {
            node = this.doneList[q];
            if (node.external || node.file == null || curr.equals(node.file)) continue;
            curr = node.file;
            ++count;
        }
        if (count != 0) {
            EcIndex[] array = new EcIndex[count];
            curr = null;
            int i = 0;
            for (q = 0; q < this.doneLength; ++q) {
                node = this.doneList[q];
                if (node.external || node.file == null || curr.equals(node.file)) continue;
                if (curr != null) {
                    array[i].first = this.ecQuark.quarkToString(new Integer(curr));
                    array[i].first = LEHandle.fixupFrameName(array[i].first);
                    array[i].index = this.writeFileFrame(sublist, q - sublist);
                    ++i;
                }
                sublist = q;
                curr = node.file;
            }
            array[i].first = this.ecQuark.quarkToString(new Integer(curr));
            array[i].first = LEHandle.fixupFrameName(array[i].first);
            array[i].index = this.writeFileFrame(sublist, q - sublist);
            this.rootIndex.filemap = this.buildIndex(array, count, this.displayDest("file".getBytes(), 0), 0L, null, null);
            for (i = 0; i < count; ++i) {
                array[i].first = null;
            }
            array = null;
        }
        Arrays.sort(this.doneList, 0, this.doneLength, this.leNodeComparator);
    }
}

