/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain.table;

import com.mmmhis.domain.DomainByteArrayFileMap;
import com.mmmhis.domain.DomainException;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.db.DBControl;
import com.mmmhis.domain.db.DBHandle;
import com.mmmhis.domain.ec.EcUtil;
import com.mmmhis.domain.table.TBLFile;
import com.mmmhis.domain.table.TBLPage;
import com.mmmhis.domain.table.TBLTable;
import java.util.Arrays;

public final class TBLHandle {
    int flags;
    TBLFile tblFile;
    int rootSect;
    int curSect;
    int parSect;
    int subSect;
    int nextSect;
    int refSect;
    byte[] unmappedRefSectBuf;
    DomainByteArrayFileMap mappedRefSectBuf;
    int firstTag;
    int tableDef;
    int curTag;
    int nextTag;
    int refTag;
    char rootSlash;
    char dot;

    public TBLHandle(int[] xlate) {
        this.rootSlash = TBLTable.convertChar(47, xlate);
        this.dot = TBLTable.convertChar(46, xlate);
    }

    public TBLHandle() {
        this.rootSlash = (char)47;
        this.dot = (char)46;
    }

    public int attachFile(TBLFile file) throws DomainException {
        this.tblFile = file;
        this.rootSect = file.rootOffset;
        if ((file.fileFlags & 2) == 2) {
            this.flags |= 2;
        } else if (this.rootSect == 0) {
            String str = String.valueOf(this.rootSlash);
            int status = this.newSection(str, false);
            if (status != 0) {
                return status;
            }
            this.rootSect = this.curSect;
            this.tblFile.rootOffset = this.curSect;
        }
        return 0;
    }

    public boolean hasKids() {
        if (this.curSect == 0) {
            return false;
        }
        return this.subSect != 0;
    }

    public TBLFile detachFile() {
        return this.tblFile;
    }

    public TBLFile getTblFile() {
        return this.tblFile;
    }

    public int thisSection(DomainString pname) throws DomainException {
        int begin;
        if (this.curSect == 0) {
            return 43;
        }
        TBLPage[] pageArr = new TBLPage[1];
        int sect = this.tblFile.referSpace(this.curSect, pageArr);
        TBLPage sectPage = pageArr[0];
        if (sect == 0) {
            return 29;
        }
        int end = begin = sect + 21;
        if (sectPage.mappedBuffer != null) {
            while (sectPage.mappedBuffer.getByte(end) != 0) {
                ++end;
            }
            pname.setValue(sectPage.mappedBuffer, begin, end - begin);
        } else {
            while (sectPage.unmappedBuffer[end] != 0) {
                ++end;
            }
            pname.setValue(sectPage.unmappedBuffer, begin, end - begin);
        }
        return 0;
    }

    public int resetSection() throws DomainException {
        return this.loadSection(this.rootSect);
    }

    public int parentSection() throws DomainException {
        return this.loadSection(this.parSect);
    }

    public int firstSection() throws DomainException {
        return this.loadSection(this.subSect);
    }

    public int nextSection() throws DomainException {
        return this.loadSection(this.nextSect);
    }

    public int prevSection() throws DomainException {
        int target = this.curSect;
        int rc = this.loadSection(this.parSect);
        if (rc != 0) {
            return rc;
        }
        rc = this.loadSection(this.subSect);
        while (rc == 0) {
            if (this.curSect == target) {
                return 43;
            }
            if (this.nextSect == target) {
                return 0;
            }
            rc = this.loadSection(this.nextSect);
        }
        return rc;
    }

    public int lastSection() throws DomainException {
        int rc = this.loadSection(this.parSect);
        if (rc != 0) {
            return rc;
        }
        rc = this.loadSection(this.subSect);
        while (rc == 0) {
            if (this.nextSect == 0) {
                return 0;
            }
            rc = this.loadSection(this.nextSect);
        }
        return rc;
    }

    int getLink(boolean[] sibling, int[] link) throws DomainException {
        int target = this.curSect;
        if (target == 0) {
            return 43;
        }
        link[0] = this.nextSect;
        int rc = this.loadSection(this.parSect);
        if (rc != 0) {
            return rc;
        }
        if (this.subSect == target) {
            sibling[0] = false;
            return 0;
        }
        rc = this.loadSection(this.subSect);
        while (rc == 0 && this.nextSect != target) {
            rc = this.loadSection(this.nextSect);
        }
        if (rc != 0) {
            return rc;
        }
        sibling[0] = true;
        return 0;
    }

    public int deleteSection() throws DomainException {
        int[] next = new int[1];
        boolean[] sibling = new boolean[1];
        TBLPage[] pageArr = new TBLPage[1];
        if ((this.flags & 2) == 2) {
            return 36;
        }
        int rc = this.getLink(sibling, next);
        if (rc != 0) {
            return rc;
        }
        int sect = this.tblFile.referSpace(this.curSect, pageArr);
        TBLPage sectPage = pageArr[0];
        if (sect == 0) {
            return 40;
        }
        if (sectPage.mappedBuffer != null) {
            if (sibling[0]) {
                TBLTable.putLong(sectPage.mappedBuffer, sect + 1, (long)next[0]);
            } else {
                TBLTable.putLong(sectPage.mappedBuffer, sect + 9, (long)next[0]);
            }
        } else if (sibling[0]) {
            TBLTable.putLong(sectPage.unmappedBuffer, sect + 1, (long)next[0]);
        } else {
            TBLTable.putLong(sectPage.unmappedBuffer, sect + 9, (long)next[0]);
        }
        sectPage.modifiedPage();
        if (next[0] != 0) {
            return this.loadSection(next[0]);
        }
        this.nextSect = 0;
        return 0;
    }

    public int renameSection(String newname) throws DomainException {
        TBLPage[] pageArr = new TBLPage[1];
        int off = 0;
        int newLen = newname.length();
        if ((this.flags & 2) == 2) {
            return 36;
        }
        if (this.curSect == 0 || newLen <= 0 || newname.charAt(0) == '\u0000') {
            return 43;
        }
        if (newname.indexOf(this.rootSlash) >= 0) {
            return 55;
        }
        int sect = this.tblFile.referSpace(this.curSect, pageArr);
        TBLPage sectPage = pageArr[0];
        if (sect == 0) {
            return 29;
        }
        int oldname = sect + 21;
        int oldLen = 0;
        if (sectPage.mappedBuffer != null) {
            while (sectPage.mappedBuffer.getByte(oldname + oldLen) != 0) {
                ++oldLen;
            }
            if (newLen <= oldLen) {
                DomainByteArrayFileMap.arraycopy(newname.getBytes(), 0, sectPage.mappedBuffer, oldname, newLen);
                sectPage.mappedBuffer.putByte(oldname + newLen, (byte)0);
                sectPage.modifiedPage();
                return 0;
            }
        } else {
            while (sectPage.unmappedBuffer[oldname + oldLen] != 0) {
                ++oldLen;
            }
            if (newLen <= oldLen) {
                System.arraycopy(newname.getBytes(), 0, sectPage.unmappedBuffer, oldname, newLen);
                sectPage.unmappedBuffer[oldname + newLen] = 0;
                sectPage.modifiedPage();
                return 0;
            }
        }
        if ((off = this.tblFile.allocSpace(22 + newLen)) == 0) {
            return 40;
        }
        int newSect = this.tblFile.referSpace(off, pageArr);
        TBLPage newSectPage = pageArr[0];
        if (newSect == 0) {
            return 40;
        }
        if (sectPage.mappedBuffer != null) {
            DomainByteArrayFileMap.arraycopy(sectPage.mappedBuffer, sect, newSectPage.mappedBuffer, newSect, 22);
            sectPage.mappedBuffer.putByte(newSect + 22, (byte)0);
            DomainByteArrayFileMap.arraycopy(newname.getBytes(), 0, newSectPage.mappedBuffer, newSect + 21, newLen);
            newSectPage.mappedBuffer.putByte(newSect + 21 + newLen, (byte)0);
        } else {
            System.arraycopy(sectPage.unmappedBuffer, sect, newSectPage.unmappedBuffer, newSect, 22);
            sectPage.unmappedBuffer[newSect + 22] = 0;
            System.arraycopy(newname.getBytes(), 0, newSectPage.unmappedBuffer, newSect + 21, newLen);
            newSectPage.unmappedBuffer[newSect + 21 + newLen] = 0;
        }
        boolean[] sibling = new boolean[1];
        int[] next = new int[1];
        int rc = this.getLink(sibling, next);
        if (rc != 0) {
            return rc;
        }
        sect = this.tblFile.referSpace(this.curSect, pageArr);
        sectPage = pageArr[0];
        if (sect == 0) {
            return 40;
        }
        if (sectPage.mappedBuffer != null) {
            if (sibling[0]) {
                TBLTable.putLong(sectPage.mappedBuffer, sect + 1, (long)off);
            } else {
                TBLTable.putLong(sectPage.mappedBuffer, sect + 9, (long)off);
            }
        } else if (sibling[0]) {
            TBLTable.putLong(sectPage.unmappedBuffer, sect + 1, (long)off);
        } else {
            TBLTable.putLong(sectPage.unmappedBuffer, sect + 9, (long)off);
        }
        pageArr[0].modifiedPage();
        rc = this.loadSection(off);
        if (rc != 0) {
            return rc;
        }
        if (this.hasKids()) {
            if (pageArr[0].mappedBuffer != null) {
                rc = this.firstSection();
                while (rc == 0) {
                    sect = this.tblFile.referSpace(this.curSect, pageArr);
                    if (sect == 0) {
                        return 40;
                    }
                    TBLTable.putLong(pageArr[0].mappedBuffer, sect + 5, (long)off);
                    sectPage.modifiedPage();
                    rc = this.nextSection();
                }
            } else {
                rc = this.firstSection();
                while (rc == 0) {
                    sect = this.tblFile.referSpace(this.curSect, pageArr);
                    if (sect == 0) {
                        return 40;
                    }
                    TBLTable.putLong(pageArr[0].unmappedBuffer, sect + 5, (long)off);
                    sectPage.modifiedPage();
                    rc = this.nextSection();
                }
            }
            if ((rc = this.loadSection(off)) != 0) {
                return rc;
            }
        }
        return 0;
    }

    public int findSection(String path, int makenew, DomainString leftover) throws DomainException {
        int rc;
        char[] work = new char[128];
        int workIndex = 0;
        char[] buffer = path.toCharArray();
        int index = 0;
        if (path.length() <= 0 || path.charAt(0) == '\u0000') {
            return 43;
        }
        if (buffer[0] == this.rootSlash) {
            rc = this.loadSection(this.rootSect);
            if (rc != 0) {
                return rc;
            }
            ++index;
        }
        while (index < buffer.length) {
            if (leftover != null) {
                leftover.setValue(path.substring(index));
            }
            workIndex = 0;
            while (index < buffer.length && buffer[index] != this.rootSlash) {
                work[workIndex++] = buffer[index++];
            }
            if ((makenew & 2) == 2 && buffer[index] == '\u0000') {
                return 0;
            }
            if (work[0] == '\u0000') {
                return 44;
            }
            if (work[0] == this.dot) {
                if (work[1] == this.dot && this.parSect != 0) {
                    this.loadSection(this.parSect);
                }
            } else {
                int here = this.curSect;
                if ((makenew & 4) == 4 && this.parSect != 0) {
                    this.loadSection(this.parSect);
                }
                rc = this.loadSection(this.subSect);
                while (rc == 0) {
                    String bufStr;
                    int idx;
                    String workStr = new String(work, 0, workIndex);
                    if (this.mappedRefSectBuf != null) {
                        for (idx = this.refSect + 21; idx < this.mappedRefSectBuf.length() && this.mappedRefSectBuf.getByte(idx) != 0; ++idx) {
                        }
                        bufStr = new String(this.mappedRefSectBuf.getBytes(this.refSect + 21, idx - (this.refSect + 21)));
                        if (workStr.equals(bufStr)) {
                            break;
                        }
                    } else {
                        while (idx < this.unmappedRefSectBuf.length && this.unmappedRefSectBuf[idx] != 0) {
                            ++idx;
                        }
                        bufStr = new String(this.unmappedRefSectBuf, this.refSect + 21, idx - (this.refSect + 21));
                        if (workStr.equals(bufStr)) break;
                    }
                    rc = this.loadSection(this.nextSect);
                }
                if (rc != 0) {
                    int rlc = this.loadSection(here);
                    if (rlc != 0) {
                        return rlc;
                    }
                    if ((makenew & 1) != 1 && (makenew & 4) != 4) {
                        return rc;
                    }
                    rc = this.newSection(new String(work, 0, workIndex), (makenew & 1) != 1);
                    if (rc != 0) {
                        return rc;
                    }
                }
            }
            if (index >= buffer.length || buffer[index] != this.rootSlash) continue;
            ++index;
        }
        if (leftover != null) {
            leftover.reset();
        }
        return 0;
    }

    public int loadSection(int off) throws DomainException {
        if (off == 0) {
            return 43;
        }
        TBLPage[] pageArr = new TBLPage[1];
        int sect = this.tblFile.referSpace(off, pageArr);
        TBLPage sectPage = pageArr[0];
        if (sect == 0) {
            return 29;
        }
        if (sectPage.mappedBuffer != null) {
            if (sectPage.mappedBuffer.getByte(sect + 0) != 2) {
                return 29;
            }
            this.curSect = off;
            this.parSect = (int)TBLTable.getLong(sectPage.mappedBuffer, sect + 5);
            this.subSect = (int)TBLTable.getLong(sectPage.mappedBuffer, sect + 9);
            this.nextSect = (int)TBLTable.getLong(sectPage.mappedBuffer, sect + 1);
            this.firstTag = (int)TBLTable.getLong(sectPage.mappedBuffer, sect + 13);
            this.tableDef = (int)TBLTable.getLong(sectPage.mappedBuffer, sect + 17);
            this.refSect = sect;
            this.mappedRefSectBuf = sectPage.mappedBuffer;
        } else {
            if (sectPage.unmappedBuffer[sect + 0] != 2) {
                return 29;
            }
            this.curSect = off;
            this.parSect = (int)TBLTable.getLong(sectPage.unmappedBuffer, sect + 5);
            this.subSect = (int)TBLTable.getLong(sectPage.unmappedBuffer, sect + 9);
            this.nextSect = (int)TBLTable.getLong(sectPage.unmappedBuffer, sect + 1);
            this.firstTag = (int)TBLTable.getLong(sectPage.unmappedBuffer, sect + 13);
            this.tableDef = (int)TBLTable.getLong(sectPage.unmappedBuffer, sect + 17);
            this.refSect = sect;
            this.unmappedRefSectBuf = sectPage.unmappedBuffer;
        }
        this.curTag = 0;
        this.nextTag = 0;
        return 0;
    }

    public byte[] sectionPath() {
        byte[] buffer = null;
        int bufLen = 0;
        int alcLen = 0;
        if (this.curSect == 0) {
            return new byte[]{78, 111, 32, 115, 101, 99, 116, 105, 111, 110};
        }
        if (this.mappedRefSectBuf != null) {
            int off = this.curSect;
            while (off != 0) {
                TBLPage[] pageArr = new TBLPage[1];
                int sect = this.tblFile.referSpace(off, pageArr);
                TBLPage sectPage = pageArr[0];
                if (sect == 0 && buffer == null) {
                    return new byte[]{83, 101, 99, 116, 105, 111, 110, 32, 108, 111, 97, 100, 32, 101, 114, 114, 111, 114};
                }
                int index = sect + 21;
                int len = EcUtil.strlen(sectPage.mappedBuffer, index);
                if (bufLen > 0 && len == 1 && sectPage.mappedBuffer.getByte(index) == this.rootSlash) {
                    len = 0;
                }
                int holdLen = alcLen;
                byte[] hold = buffer;
                alcLen = len + bufLen + 1;
                buffer = new byte[alcLen];
                if (len != 0) {
                    DomainByteArrayFileMap.arraycopy(sectPage.mappedBuffer, index, buffer, 0, len);
                }
                buffer[len] = 0;
                if (bufLen != 0) {
                    buffer[len] = (byte)this.rootSlash;
                    System.arraycopy(hold, 0, buffer, len + 1, bufLen);
                    hold = null;
                }
                bufLen += len + 1;
                off = (int)TBLTable.getLong(sectPage.mappedBuffer, sect + 5);
            }
        } else {
            int off = this.curSect;
            while (off != 0) {
                TBLPage[] pageArr = new TBLPage[1];
                int sect = this.tblFile.referSpace(off, pageArr);
                TBLPage sectPage = pageArr[0];
                if (sect == 0 && buffer == null) {
                    return new byte[]{83, 101, 99, 116, 105, 111, 110, 32, 108, 111, 97, 100, 32, 101, 114, 114, 111, 114};
                }
                int index = sect + 21;
                int len = EcUtil.strlen(sectPage.unmappedBuffer, index);
                if (bufLen > 0 && len == 1 && sectPage.unmappedBuffer[index] == this.rootSlash) {
                    len = 0;
                }
                int holdLen = alcLen;
                byte[] hold = buffer;
                alcLen = len + bufLen + 1;
                buffer = new byte[alcLen];
                if (len != 0) {
                    System.arraycopy(sectPage.unmappedBuffer, index, buffer, 0, len);
                }
                buffer[len] = 0;
                if (bufLen != 0) {
                    buffer[len] = (byte)this.rootSlash;
                    System.arraycopy(hold, 0, buffer, len + 1, bufLen);
                    hold = null;
                }
                bufLen += len + 1;
                off = (int)TBLTable.getLong(sectPage.unmappedBuffer, sect + 5);
            }
        }
        return buffer;
    }

    public static int dbConnect(DBControl dbControl, int fd, int fp, TBLTable[] masterArr) throws DomainException {
        TBLTable index;
        int i;
        TBLFile tblFile = new TBLFile(dbControl);
        tblFile.fileFlags |= 0x22;
        tblFile.dbh = new DBHandle(fp, fd);
        tblFile.setEncoding(dbControl.getFile(fd).getEncoding());
        TBLTable master = new TBLTable();
        master.tblFlags = 42;
        master.tblType = 0;
        master.file = tblFile;
        dbControl.getFrame(tblFile.dbh);
        int numTab = tblFile.dbh.getNumber();
        tblFile.numpages = tblFile.dbh.getNumber();
        if (tblFile.numpages == 0) {
            tblFile.numpages = 1;
        }
        master.address = tblFile.dbh.getNumber();
        for (i = 1; i < numTab; ++i) {
            index = new TBLTable();
            index.file = tblFile;
            index.master = master;
            index.address = tblFile.dbh.getNumber();
            index.tblFlags = 34;
            if (master.lastIndex != null) {
                master.lastIndex.nextIndex = index;
            } else {
                master.nextIndex = index;
            }
            master.lastIndex = index;
        }
        tblFile.pageTrans = new int[tblFile.numpages];
        for (i = 0; i < tblFile.numpages; ++i) {
            tblFile.pageTrans[i] = tblFile.dbh.getNumber();
        }
        index = master;
        while (index != null) {
            tblFile.dbh.setPtr(index.address);
            dbControl.getFrame(tblFile.dbh);
            index.rootOffset = tblFile.dbh.getNumber();
            index.tblType = tblFile.dbh.getNumber();
            index.leafRowLen = tblFile.dbh.getNumber();
            index.strOff = tblFile.dbh.getNumber();
            index.strCount = tblFile.dbh.getNumber();
            index.brRowLen = tblFile.dbh.getNumber();
            index.keyLen = tblFile.dbh.getNumber();
            index.tblFlags |= tblFile.dbh.getNumber();
            index.strucId = tblFile.dbh.getNumber();
            index.recCount = tblFile.dbh.getNumber();
            index.numCols = tblFile.dbh.getNumber();
            index.formLen = tblFile.dbh.getNumber();
            index.delCount = (index.tblFlags & 0x1000) == 4096 ? tblFile.dbh.getNumber() : 0;
            if (index.formLen != 0) {
                index.colForm = tblFile.dbh.getByteArray(index.formLen);
            }
            index = index.nextIndex;
        }
        masterArr[0] = master;
        return 0;
    }

    public int newSection(String name, boolean insert) throws DomainException {
        TBLPage lagPage = null;
        TBLPage[] pageArr = new TBLPage[1];
        int nameLen = name.length();
        if ((this.flags & 2) == 2) {
            return 2;
        }
        if (nameLen <= 0 || name.charAt(0) == '\u0000') {
            return 43;
        }
        if (name.indexOf(this.rootSlash) > 0) {
            return 55;
        }
        int off = this.tblFile.allocSpace(22 + nameLen);
        if (off == 0) {
            return 40;
        }
        int sect = this.tblFile.referSpace(off, pageArr);
        TBLPage sectPage = pageArr[0];
        if (sect == 0) {
            return 40;
        }
        if (sectPage.mappedBuffer != null) {
            DomainByteArrayFileMap.fill(sectPage.mappedBuffer, sect, sect + 22 - 1, (byte)0);
            sectPage.mappedBuffer.putByte(sect + 0, (byte)2);
            DomainByteArrayFileMap.arraycopy(name.getBytes(), 0, sectPage.mappedBuffer, sect + 21, nameLen);
            sectPage.mappedBuffer.putByte(sect + 21 + nameLen, (byte)0);
            this.refSect = sect;
            this.mappedRefSectBuf = sectPage.mappedBuffer;
        } else {
            Arrays.fill(sectPage.unmappedBuffer, sect, sect + 22 - 1, (byte)0);
            sectPage.unmappedBuffer[sect + 0] = 2;
            System.arraycopy(name.getBytes(), 0, sectPage.unmappedBuffer, sect + 21, nameLen);
            sectPage.unmappedBuffer[sect + 21 + nameLen] = 0;
            this.refSect = sect;
            this.unmappedRefSectBuf = sectPage.unmappedBuffer;
        }
        if (this.curSect != 0) {
            int lag;
            TBLPage refPage;
            int ref;
            if (insert) {
                int roff;
                if (this.parSect == 0) {
                    return 45;
                }
                if (sectPage.mappedBuffer != null) {
                    TBLTable.putLong(sectPage.mappedBuffer, sect + 5, (long)this.parSect);
                    TBLTable.putLong(sectPage.mappedBuffer, sect + 1, (long)this.curSect);
                    ref = this.tblFile.referSpace(this.parSect, pageArr);
                    refPage = pageArr[0];
                    if (ref == 0) {
                        return 40;
                    }
                    lag = 0;
                    roff = (int)TBLTable.getLong(refPage.mappedBuffer, ref + 9);
                    while (roff != 0 && roff != this.curSect) {
                        ref = this.tblFile.referSpace(roff, pageArr);
                        refPage = pageArr[0];
                        if (ref == 0) {
                            return 40;
                        }
                        lag = ref;
                        lagPage = refPage;
                        roff = (int)TBLTable.getLong(refPage.mappedBuffer, ref + 1);
                    }
                } else {
                    TBLTable.putLong(sectPage.unmappedBuffer, sect + 5, (long)this.parSect);
                    TBLTable.putLong(sectPage.unmappedBuffer, sect + 1, (long)this.curSect);
                    ref = this.tblFile.referSpace(this.parSect, pageArr);
                    refPage = pageArr[0];
                    if (ref == 0) {
                        return 40;
                    }
                    lag = 0;
                    roff = (int)TBLTable.getLong(refPage.unmappedBuffer, ref + 9);
                    while (roff != 0 && roff != this.curSect) {
                        ref = this.tblFile.referSpace(roff, pageArr);
                        refPage = pageArr[0];
                        if (ref == 0) {
                            return 40;
                        }
                        lag = ref;
                        lagPage = refPage;
                        roff = (int)TBLTable.getLong(refPage.unmappedBuffer, ref + 1);
                    }
                }
                if (roff == 0) {
                    return 29;
                }
            } else if (sectPage.mappedBuffer != null) {
                TBLTable.putLong(sectPage.mappedBuffer, sect + 5, (long)this.curSect);
                this.parSect = this.curSect;
                ref = this.tblFile.referSpace(this.curSect, pageArr);
                refPage = pageArr[0];
                if (ref == 0) {
                    return 40;
                }
                lag = 0;
                int roff = this.subSect;
                while (roff != 0) {
                    ref = this.tblFile.referSpace(roff, pageArr);
                    refPage = pageArr[0];
                    if (ref == 0) {
                        return 40;
                    }
                    lag = ref;
                    lagPage = refPage;
                    roff = (int)TBLTable.getLong(refPage.mappedBuffer, ref + 1);
                }
            } else {
                TBLTable.putLong(sectPage.unmappedBuffer, sect + 5, (long)this.curSect);
                this.parSect = this.curSect;
                ref = this.tblFile.referSpace(this.curSect, pageArr);
                refPage = pageArr[0];
                if (ref == 0) {
                    return 40;
                }
                lag = 0;
                int roff = this.subSect;
                while (roff != 0) {
                    ref = this.tblFile.referSpace(roff, pageArr);
                    refPage = pageArr[0];
                    if (ref == 0) {
                        return 40;
                    }
                    lag = ref;
                    lagPage = refPage;
                    roff = (int)TBLTable.getLong(refPage.unmappedBuffer, ref + 1);
                }
            }
            if (refPage.mappedBuffer != null) {
                if (lag == 0) {
                    TBLTable.putLong(refPage.mappedBuffer, ref + 9, (long)off);
                    refPage.modifiedPage();
                } else {
                    TBLTable.putLong(lagPage.mappedBuffer, lag + 1, (long)off);
                    lagPage.modifiedPage();
                }
            } else if (lag == 0) {
                TBLTable.putLong(refPage.unmappedBuffer, ref + 9, (long)off);
                refPage.modifiedPage();
            } else {
                TBLTable.putLong(lagPage.unmappedBuffer, lag + 1, (long)off);
                lagPage.modifiedPage();
            }
        }
        this.curSect = off;
        this.refSect = sect;
        this.subSect = 0;
        this.nextSect = 0;
        this.firstTag = 0;
        this.tableDef = 0;
        this.curTag = 0;
        this.nextTag = 0;
        return 0;
    }

    public int getSectionTable(TBLTable[] table, boolean wantStructs) throws DomainException {
        int status;
        if (this.curSect == 0) {
            return 43;
        }
        if (this.tableDef == 0) {
            table[0] = null;
            return 0;
        }
        if (wantStructs && (status = this.tblFile.restorePrototypes()) != 0) {
            return status;
        }
        return this.tblFile.restoreTable(this.tableDef, null, table, wantStructs);
    }

    public int newTag(String name, String value, boolean insert) throws DomainException {
        TBLPage[] pageArr = new TBLPage[1];
        if ((this.flags & 2) == 2) {
            return 36;
        }
        if (name.indexOf(this.rootSlash) >= 0) {
            return 55;
        }
        if (this.curSect == 0) {
            return 45;
        }
        if (name.length() <= 0 || name.charAt(0) == '\u0000') {
            return 46;
        }
        int nlen = name.length();
        int vlen = value.length();
        int needed = 6 + nlen + vlen;
        int off = this.tblFile.allocSpace(needed);
        int tag = this.tblFile.referSpace(off, pageArr);
        TBLPage tagPage = pageArr[0];
        if (tag == 0) {
            return 38;
        }
        int ref = tag;
        TBLPage refPage = tagPage;
        if (refPage.mappedBuffer != null) {
            TBLTable.putLong(refPage.mappedBuffer, ref, 0L);
            DomainByteArrayFileMap.arraycopy(name.getBytes(), 0, refPage.mappedBuffer, ref += 4, nlen);
            refPage.mappedBuffer.putByte(ref + nlen, (byte)0);
            DomainByteArrayFileMap.arraycopy(value.getBytes(), 0, refPage.mappedBuffer, ref += nlen + 1, vlen);
            refPage.mappedBuffer.putByte(ref + vlen, (byte)0);
            if (this.firstTag == 0) {
                this.firstTag = off;
                ref = this.tblFile.referSpace(this.curSect, pageArr);
                refPage = pageArr[0];
                TBLTable.putLong(refPage.mappedBuffer, ref + 13, (long)off);
                refPage.modifiedPage();
                this.nextTag = 0;
            } else if (insert) {
                ref = 0;
                int bef = this.firstTag;
                while (bef != 0 && bef != this.curTag) {
                    ref = this.tblFile.referSpace(bef, pageArr);
                    refPage = pageArr[0];
                    bef = (int)TBLTable.getLong(pageArr[0].mappedBuffer, ref);
                }
                if (ref != 0) {
                    this.nextTag = (int)TBLTable.getLong(refPage.mappedBuffer, ref);
                    TBLTable.putLong(tagPage.mappedBuffer, tag, (long)this.nextTag);
                    TBLTable.putLong(refPage.mappedBuffer, ref, (long)off);
                    refPage.modifiedPage();
                } else {
                    ref = this.tblFile.referSpace(this.curSect, pageArr);
                    refPage = pageArr[0];
                    this.nextTag = (int)TBLTable.getLong(refPage.mappedBuffer, ref + 13);
                    TBLTable.putLong(tagPage.mappedBuffer, tag, (long)this.nextTag);
                    this.firstTag = off;
                    TBLTable.putLong(refPage.mappedBuffer, ref + 13, (long)off);
                    refPage.modifiedPage();
                }
            } else {
                int rc;
                if (this.curTag == 0 && (rc = this.lastTag()) != 0) {
                    return rc;
                }
                ref = this.tblFile.referSpace(this.curTag, pageArr);
                refPage = pageArr[0];
                this.nextTag = (int)TBLTable.getLong(refPage.mappedBuffer, ref);
                TBLTable.putLong(tagPage.mappedBuffer, tag, (long)this.nextTag);
                TBLTable.putLong(refPage.mappedBuffer, ref, (long)off);
                refPage.modifiedPage();
            }
        } else {
            TBLTable.putLong(refPage.unmappedBuffer, ref, 0L);
            System.arraycopy(name.getBytes(), 0, refPage.unmappedBuffer, ref += 4, nlen);
            refPage.unmappedBuffer[ref + nlen] = 0;
            System.arraycopy(value.getBytes(), 0, refPage.unmappedBuffer, ref += nlen + 1, vlen);
            refPage.unmappedBuffer[ref + vlen] = 0;
            if (this.firstTag == 0) {
                this.firstTag = off;
                ref = this.tblFile.referSpace(this.curSect, pageArr);
                refPage = pageArr[0];
                TBLTable.putLong(refPage.unmappedBuffer, ref + 13, (long)off);
                refPage.modifiedPage();
                this.nextTag = 0;
            } else if (insert) {
                ref = 0;
                int bef = this.firstTag;
                while (bef != 0 && bef != this.curTag) {
                    ref = this.tblFile.referSpace(bef, pageArr);
                    refPage = pageArr[0];
                    bef = (int)TBLTable.getLong(pageArr[0].unmappedBuffer, ref);
                }
                if (ref != 0) {
                    this.nextTag = (int)TBLTable.getLong(refPage.unmappedBuffer, ref);
                    TBLTable.putLong(tagPage.unmappedBuffer, tag, (long)this.nextTag);
                    TBLTable.putLong(refPage.unmappedBuffer, ref, (long)off);
                    refPage.modifiedPage();
                } else {
                    ref = this.tblFile.referSpace(this.curSect, pageArr);
                    refPage = pageArr[0];
                    this.nextTag = (int)TBLTable.getLong(refPage.unmappedBuffer, ref + 13);
                    TBLTable.putLong(tagPage.unmappedBuffer, tag, (long)this.nextTag);
                    this.firstTag = off;
                    TBLTable.putLong(refPage.unmappedBuffer, ref + 13, (long)off);
                    refPage.modifiedPage();
                }
            } else {
                int rc;
                if (this.curTag == 0 && (rc = this.lastTag()) != 0) {
                    return rc;
                }
                ref = this.tblFile.referSpace(this.curTag, pageArr);
                refPage = pageArr[0];
                this.nextTag = (int)TBLTable.getLong(refPage.unmappedBuffer, ref);
                TBLTable.putLong(tagPage.unmappedBuffer, tag, (long)this.nextTag);
                TBLTable.putLong(refPage.unmappedBuffer, ref, (long)off);
                refPage.modifiedPage();
            }
        }
        this.curTag = off;
        this.refTag = tag;
        return 0;
    }

    public int loadTag(int off) throws DomainException {
        return this.loadTag(off, null);
    }

    public int loadTag(int off, TBLPage[] pageArr) throws DomainException {
        if (pageArr == null) {
            pageArr = new TBLPage[1];
        }
        if (off == 0) {
            this.nextTag = 0;
            this.refTag = 0;
            return 46;
        }
        int tag = this.tblFile.referSpace(off, pageArr);
        TBLPage tagPage = pageArr[0];
        if (tag == 0) {
            return 46;
        }
        this.curTag = off;
        this.nextTag = tagPage.mappedBuffer != null ? (int)TBLTable.getLong(tagPage.mappedBuffer, tag) : (int)TBLTable.getLong(tagPage.unmappedBuffer, tag);
        this.refTag = tag;
        return 0;
    }

    public int thisTag(DomainString pname, DomainString pvalue) throws DomainException {
        if (this.curTag == 0) {
            return 46;
        }
        TBLPage[] pageArr = new TBLPage[1];
        int tag = this.tblFile.referSpace(this.curTag, pageArr);
        if (tag == 0) {
            return 46;
        }
        if (pageArr[0].mappedBuffer != null) {
            int end;
            int begin;
            if (pname != null) {
                end = begin = tag + 4;
                while (pageArr[0].mappedBuffer.getByte(end) != 0) {
                    ++end;
                }
                pname.setValue(pageArr[0].mappedBuffer, begin, end - begin);
            }
            if (pvalue != null) {
                end = begin = tag + 4 + pname.length() + 1;
                while (pageArr[0].mappedBuffer.getByte(end) != 0) {
                    ++end;
                }
                pvalue.setValue(pageArr[0].mappedBuffer, begin, end - begin);
            }
        } else {
            int end;
            int begin;
            if (pname != null) {
                end = begin = tag + 4;
                while (pageArr[0].unmappedBuffer[end] != 0) {
                    ++end;
                }
                pname.setValue(pageArr[0].unmappedBuffer, begin, end - begin);
            }
            if (pvalue != null) {
                end = begin = tag + 4 + pname.length() + 1;
                while (pageArr[0].unmappedBuffer[end] != 0) {
                    ++end;
                }
                pvalue.setValue(pageArr[0].unmappedBuffer, begin, end - begin);
            }
        }
        return 0;
    }

    public int firstTag() throws DomainException {
        return this.loadTag(this.firstTag);
    }

    public int nextTag() throws DomainException {
        return this.loadTag(this.nextTag);
    }

    public int prevTag() throws DomainException {
        int target = this.curTag;
        if (target == 0) {
            return 46;
        }
        int rc = this.loadTag(this.firstTag);
        while (rc == 0) {
            if (this.curTag == target) {
                return 46;
            }
            if (this.nextTag == target) {
                return 0;
            }
            rc = this.loadTag(this.nextTag);
        }
        return rc;
    }

    public int lastTag() throws DomainException {
        int rc = this.loadTag(this.firstTag);
        while (rc == 0) {
            if (this.nextTag == 0) {
                return 0;
            }
            rc = this.loadTag(this.nextTag);
        }
        return rc;
    }

    public int findTag(String name, DomainString pvalue) throws DomainException {
        int rc;
        DomainString leftover = new DomainString();
        if (name.length() <= 0 || name.charAt(0) == '\u0000') {
            return 46;
        }
        if (name.indexOf(this.rootSlash) != -1) {
            rc = this.findSection(name, 0, leftover);
            if (rc == 0) {
                return 46;
            }
            if (leftover.toString().indexOf(this.rootSlash) != -1) {
                return 43;
            }
            name = leftover.toString();
        }
        int nameLen = name.length();
        TBLPage[] pageArr = new TBLPage[1];
        rc = this.loadTag(this.firstTag, pageArr);
        while (rc == 0) {
            int i;
            boolean equals = true;
            if (pageArr[0].mappedBuffer != null) {
                for (i = 0; i < nameLen; ++i) {
                    if (Character.toUpperCase(name.charAt(i)) == pageArr[0].mappedBuffer.getByte(this.refTag + 4 + i)) continue;
                    equals = false;
                    break;
                }
                if (equals && pageArr[0].mappedBuffer.getByte(this.refTag + 4 + i) != 0) {
                    equals = false;
                }
                if (equals) {
                    if (pvalue != null) {
                        int begin;
                        int end = begin = this.refTag + 4 + nameLen + 1;
                        while (pageArr[0].mappedBuffer.getByte(end) != 0) {
                            ++end;
                        }
                        pvalue.setValue(pageArr[0].mappedBuffer, begin, end - begin);
                    }
                    return 0;
                }
            } else {
                for (i = 0; i < nameLen; ++i) {
                    if (Character.toUpperCase(name.charAt(i)) == pageArr[0].unmappedBuffer[this.refTag + 4 + i]) continue;
                    equals = false;
                    break;
                }
                if (equals && pageArr[0].unmappedBuffer[this.refTag + 4 + i] != 0) {
                    equals = false;
                }
                if (equals) {
                    if (pvalue != null) {
                        int begin;
                        int end = begin = this.refTag + 4 + nameLen + 1;
                        while (pageArr[0].unmappedBuffer[end] != 0) {
                            ++end;
                        }
                        pvalue.setValue(pageArr[0].unmappedBuffer, begin, end - begin);
                    }
                    return 0;
                }
            }
            rc = this.loadTag(this.nextTag, pageArr);
        }
        return 46;
    }

    public int deleteTag(String pname) throws DomainException {
        TBLPage refPage;
        int rc;
        DomainString leftover = new DomainString();
        if (pname.indexOf(this.rootSlash) != -1) {
            rc = this.findSection(pname, 0, leftover);
            if (rc == 0) {
                return 46;
            }
            if (leftover.toString().indexOf(this.rootSlash) != -1) {
                return 46;
            }
            pname = leftover.toString();
        }
        int lag = 0;
        int pnameLen = pname.length();
        TBLPage[] pageArr = new TBLPage[1];
        rc = this.loadTag(this.firstTag, pageArr);
        while (rc == 0) {
            int i;
            boolean equals = true;
            if (pageArr[0].mappedBuffer != null) {
                for (i = 0; i < pnameLen; ++i) {
                    if (Character.toUpperCase(pname.charAt(i)) == pageArr[0].mappedBuffer.getByte(this.refTag + i)) continue;
                    equals = false;
                    break;
                }
                if (equals && pageArr[0].mappedBuffer.getByte(i) != 0) {
                    equals = false;
                }
            } else {
                for (i = 0; i < pnameLen; ++i) {
                    if (Character.toUpperCase(pname.charAt(i)) == pageArr[0].unmappedBuffer[this.refTag + i]) continue;
                    equals = false;
                    break;
                }
                if (equals && pageArr[0].unmappedBuffer[i] != 0) {
                    equals = false;
                }
            }
            if (equals) break;
            lag = this.curTag;
            rc = this.loadTag(this.nextTag, pageArr);
        }
        if (rc != 0) {
            return rc;
        }
        int next = this.nextTag;
        if (pageArr[0].mappedBuffer != null) {
            if (lag != 0) {
                int ref = this.tblFile.referSpace(lag, pageArr);
                refPage = pageArr[0];
                TBLTable.putLong(refPage.mappedBuffer, ref, (long)next);
            } else {
                this.firstTag = next;
                int ref = this.tblFile.referSpace(this.curSect, pageArr);
                refPage = pageArr[0];
                TBLTable.putLong(refPage.mappedBuffer, ref + 13, (long)next);
            }
        } else if (lag != 0) {
            int ref = this.tblFile.referSpace(lag, pageArr);
            refPage = pageArr[0];
            TBLTable.putLong(refPage.unmappedBuffer, ref, (long)next);
        } else {
            this.firstTag = next;
            int ref = this.tblFile.referSpace(this.curSect, pageArr);
            refPage = pageArr[0];
            TBLTable.putLong(refPage.unmappedBuffer, ref + 13, (long)next);
        }
        refPage.modifiedPage();
        this.curTag = 0;
        this.nextTag = 0;
        this.refTag = 0;
        return 0;
    }

    public int replaceTag(String name, String value) throws DomainException {
        int target = this.curTag;
        if (target == 0) {
            return 46;
        }
        int nlen = name.length();
        int vlen = value.length();
        int needed = 6 + nlen + vlen;
        int off = this.tblFile.allocSpace(needed);
        TBLPage[] pageArr = new TBLPage[1];
        int tag = this.tblFile.referSpace(off, pageArr);
        TBLPage tagPage = pageArr[0];
        if (tag == 0) {
            return 38;
        }
        int ref = tag;
        TBLPage refPage = tagPage;
        if (refPage.mappedBuffer != null) {
            TBLTable.putLong(refPage.mappedBuffer, ref, (long)this.nextTag);
            DomainByteArrayFileMap.arraycopy(name.getBytes(), 0, refPage.mappedBuffer, ref += 4, nlen);
            pageArr[0].mappedBuffer.putByte(ref + nlen, (byte)0);
            DomainByteArrayFileMap.arraycopy(value.getBytes(), 0, refPage.mappedBuffer, ref += nlen + 1, vlen);
            pageArr[0].mappedBuffer.putByte(ref + vlen, (byte)0);
            if (this.firstTag == target) {
                ref = this.tblFile.referSpace(this.curSect, pageArr);
                refPage = pageArr[0];
                TBLTable.putLong(refPage.mappedBuffer, ref + 13, (long)off);
                refPage.modifiedPage();
                this.firstTag = off;
                return this.loadTag(off);
            }
            int rc = this.loadTag(this.firstTag);
            while (rc == 0 && this.nextTag != target) {
                rc = this.loadTag(this.nextTag);
            }
            if (rc != 0) {
                return rc;
            }
            ref = this.tblFile.referSpace(this.curTag, pageArr);
            refPage = pageArr[0];
            TBLTable.putLong(refPage.mappedBuffer, ref, (long)off);
            refPage.modifiedPage();
        } else {
            TBLTable.putLong(refPage.unmappedBuffer, ref, (long)this.nextTag);
            System.arraycopy(name.getBytes(), 0, refPage.unmappedBuffer, ref += 4, nlen);
            pageArr[0].unmappedBuffer[ref + nlen] = 0;
            System.arraycopy(value.getBytes(), 0, refPage.unmappedBuffer, ref += nlen + 1, vlen);
            pageArr[0].unmappedBuffer[ref + vlen] = 0;
            if (this.firstTag == target) {
                ref = this.tblFile.referSpace(this.curSect, pageArr);
                refPage = pageArr[0];
                TBLTable.putLong(refPage.unmappedBuffer, ref + 13, (long)off);
                refPage.modifiedPage();
                this.firstTag = off;
                return this.loadTag(off);
            }
            int rc = this.loadTag(this.firstTag);
            while (rc == 0 && this.nextTag != target) {
                rc = this.loadTag(this.nextTag);
            }
            if (rc != 0) {
                return rc;
            }
            ref = this.tblFile.referSpace(this.curTag, pageArr);
            refPage = pageArr[0];
            TBLTable.putLong(refPage.unmappedBuffer, ref, (long)off);
            refPage.modifiedPage();
        }
        return this.loadTag(off);
    }

    public int renameTag(String newname) throws DomainException {
        String oldvalue;
        int oldtag;
        int begin;
        if ((this.flags & 2) == 2) {
            return 36;
        }
        if (this.curTag == 0 || newname.length() <= 0 || newname.charAt(0) == '\u0000') {
            return 46;
        }
        if (newname.indexOf(this.rootSlash) > 0) {
            return 55;
        }
        TBLPage[] pageArr = new TBLPage[1];
        int tag = this.tblFile.referSpace(this.curTag, pageArr);
        TBLPage tagPage = pageArr[0];
        if (tag == 0) {
            return 46;
        }
        int end = begin = (oldtag = tag + 4);
        if (tagPage.mappedBuffer != null) {
            while (tagPage.mappedBuffer.getByte(end) != 0) {
                ++end;
            }
            String oldname = new String(tagPage.mappedBuffer.getBytes(begin, end - begin));
            end = begin = end + 1;
            while (tagPage.mappedBuffer.getByte(end) != 0) {
                ++end;
            }
            oldvalue = new String(tagPage.mappedBuffer.getBytes(begin, end - begin));
            int nlen = newname.length();
            if (oldname.length() >= nlen) {
                int vlen = oldvalue.length();
                DomainByteArrayFileMap.arraycopy(newname.getBytes(), 0, tagPage.mappedBuffer, oldtag, nlen);
                tagPage.mappedBuffer.putByte(oldtag + nlen, (byte)0);
                DomainByteArrayFileMap.arraycopy(oldvalue.getBytes(), 0, tagPage.mappedBuffer, begin, vlen + 1);
                tagPage.mappedBuffer.putByte(begin + vlen + 1, (byte)0);
                tagPage.modifiedPage();
                return 0;
            }
        } else {
            while (tagPage.unmappedBuffer[end] != 0) {
                ++end;
            }
            String oldname = new String(tagPage.unmappedBuffer, begin, end - begin);
            end = begin = end + 1;
            while (tagPage.unmappedBuffer[end] != 0) {
                ++end;
            }
            oldvalue = new String(tagPage.unmappedBuffer, begin, end - begin);
            int nlen = newname.length();
            if (oldname.length() >= nlen) {
                int vlen = oldvalue.length();
                System.arraycopy(newname.getBytes(), 0, tagPage.unmappedBuffer, oldtag, nlen);
                tagPage.unmappedBuffer[oldtag + nlen] = 0;
                System.arraycopy(oldvalue.getBytes(), 0, tagPage.unmappedBuffer, begin, vlen + 1);
                tagPage.unmappedBuffer[begin + vlen + 1] = 0;
                tagPage.modifiedPage();
                return 0;
            }
        }
        return this.replaceTag(newname, oldvalue);
    }

    public int updateTag(String newvalue) throws DomainException {
        String oldname;
        int begin;
        if ((this.flags & 2) == 2) {
            return 36;
        }
        if (this.curTag == 0) {
            return 46;
        }
        TBLPage[] pageArr = new TBLPage[1];
        int tag = this.tblFile.referSpace(this.curTag, pageArr);
        TBLPage tagPage = pageArr[0];
        if (tag == 0) {
            return 46;
        }
        int end = begin = tag + 4;
        if (tagPage.mappedBuffer != null) {
            while (tagPage.mappedBuffer.getByte(end) != 0) {
                ++end;
            }
            oldname = new String(tagPage.mappedBuffer.getBytes(begin, end - begin));
            end = begin = end + 1;
            while (tagPage.mappedBuffer.getByte(end) != 0) {
                ++end;
            }
            String oldvalue = new String(pageArr[0].mappedBuffer.getBytes(begin, end - begin));
            if (oldvalue.length() >= newvalue.length()) {
                DomainByteArrayFileMap.arraycopy(newvalue.getBytes(), 0, tagPage.mappedBuffer, begin, newvalue.length());
                tagPage.mappedBuffer.putByte(begin + newvalue.length(), (byte)0);
                tagPage.modifiedPage();
                return 0;
            }
        } else {
            while (tagPage.unmappedBuffer[end] != 0) {
                ++end;
            }
            oldname = new String(tagPage.unmappedBuffer, begin, end - begin);
            end = begin = end + 1;
            while (tagPage.unmappedBuffer[end] != 0) {
                ++end;
            }
            String oldvalue = new String(pageArr[0].unmappedBuffer, begin, end - begin);
            if (oldvalue.length() >= newvalue.length()) {
                System.arraycopy(newvalue.getBytes(), 0, tagPage.unmappedBuffer, begin, newvalue.length());
                tagPage.unmappedBuffer[begin + newvalue.length()] = 0;
                tagPage.modifiedPage();
                return 0;
            }
        }
        return this.replaceTag(oldname, newvalue);
    }

    public int TblAttachTable(TBLTable table) throws DomainException {
        if (table == null) {
            return 0;
        }
        if (this.tblFile == null) {
            throw new DomainException("ASSERT(th->tblfile)");
        }
        if (this.curSect == 0) {
            return 45;
        }
        TBLPage[] pages = new TBLPage[1];
        int rec = this.tblFile.referSpace(this.curSect, pages);
        TBLPage page = pages[0];
        if (rec == -1) {
            return 40;
        }
        this.tblFile.holdPage(page);
        int[] recAry = new int[]{rec + 17};
        int rc = this.tblFile.saveTable(0, page, recAry, table);
        if (rc != 0) {
            return rc;
        }
        this.tableDef = page.mappedBuffer != null ? (int)TBLTable.getLong(page.mappedBuffer, rec + 17) : (int)TBLTable.getLong(page.unmappedBuffer, rec + 17);
        page.modifiedPage();
        this.tblFile.releasePage(page);
        return 0;
    }
}

