/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain.table;

import com.mmmhis.domain.DomainException;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.table.TBLTable;

public final class TBLStruct {
    public static final int TblDEFN_LAYOUT = 0;
    public static final int TblDEFN_STRUCT = 1;
    public static final int TblDEFN_BITMASK = 2;
    public static final int TblDEFN_INDEX = 3;
    public static final int TblDEFN_ARRAY = 4;
    public static final int TblDEFN_COLUMN = 5;
    public static final int TblDEFN_KEY = 6;
    TBLStruct next;
    TBLStruct back;
    TBLStruct components;
    DomainString sname;
    TBLTable table;
    int type;
    int elements;
    int offset;
    int length;
    int bitmask;
    int datatype;
    int strix;
    int numstr;
    int coloff;
    int numcol;
    int precision;
    int srcOffset;
    int srcString;
    int srcColumn;
    boolean visited;
    public DomainString name;

    public static void Add(TBLStruct sParentHead, TBLTable tParentHead, TBLStruct head, TBLStruct newdef) {
        if (head == null) {
            if (sParentHead != null) {
                sParentHead.components = newdef;
            } else {
                tParentHead.layout = newdef;
            }
        } else {
            TBLStruct def = head;
            while (def.next != null) {
                def = def.next;
            }
            def.next = newdef;
        }
    }

    public void copy(TBLStruct from) {
        this.next = from.next;
        this.back = from.back;
        this.components = from.components;
        this.sname = from.sname != null ? new DomainString(from.sname) : null;
        this.table = from.table;
        this.type = from.type;
        this.elements = from.elements;
        this.offset = from.offset;
        this.length = from.length;
        this.bitmask = from.bitmask;
        this.datatype = from.datatype;
        this.strix = from.strix;
        this.numstr = from.numstr;
        this.coloff = from.coloff;
        this.numcol = from.numcol;
        this.precision = from.precision;
        this.srcOffset = from.srcOffset;
        this.srcString = from.srcString;
        this.srcColumn = from.srcColumn;
        this.visited = from.visited;
        this.name = from.name != null ? new DomainString(from.name) : null;
    }

    public int TblFormatCount(int index) {
        int count = 0;
        TBLStruct col = this.components;
        while (col != null) {
            ++count;
            switch (col.datatype) {
                case 13: 
                case 21: {
                    count += 2;
                    if (index == 0) break;
                    count += 5;
                    break;
                }
                case 15: 
                case 16: {
                    count += 6;
                    break;
                }
                case 10: {
                    count += 3 + col.name.length();
                    break;
                }
                case 17: {
                    count += 5 + col.components.TblFormatCount(index);
                    break;
                }
                case 11: {
                    count += 1 + col.components.TblFormatCount(index);
                    break;
                }
                case 12: {
                    count += 1 + col.elements * col.TblFormatCount(index);
                    break;
                }
                case 14: {
                    break;
                }
                default: {
                    if (index == 0) break;
                    count += 5;
                }
            }
            col = col.next;
        }
        return count;
    }

    public int TblFillColForm(byte[] po, int idx, int index) {
        TBLStruct col = this.components;
        while (col != null) {
            po[idx++] = (byte)col.datatype;
            switch (col.datatype) {
                case 13: 
                case 21: {
                    TBLTable.putShort(po, idx, (short)col.length);
                    idx += 2;
                    if (index == 0) break;
                    po[idx++] = 20;
                    TBLTable.putShort(po, idx, (short)col.srcOffset);
                    TBLTable.putShort(po, idx + 2, (short)col.srcColumn);
                    idx += 4;
                    break;
                }
                case 16: {
                    TBLTable.putShort(po, idx, (short)col.length);
                    TBLTable.putShort(po, idx + 2, (short)col.srcString);
                    TBLTable.putShort(po, idx + 4, (short)col.srcColumn);
                    idx += 6;
                    break;
                }
                case 15: {
                    TBLTable.putShort(po, idx, (short)col.precision);
                    TBLTable.putShort(po, idx + 2, (short)col.srcOffset);
                    TBLTable.putShort(po, idx + 4, (short)col.srcColumn);
                    idx += 6;
                    break;
                }
                case 10: {
                    int len = col.name.length();
                    po[idx] = (byte)col.offset;
                    po[idx + 1] = (byte)col.bitmask;
                    po[idx + 2] = (byte)len;
                    System.arraycopy(col.name.toByteArray(), 0, po, idx + 3, len);
                    idx += 3 + len;
                    break;
                }
                case 17: {
                    TBLTable.putShort(po, idx, (short)col.components.length);
                    int pend = col.components.TblFillColForm(po, idx + 4, index);
                    po[pend++] = 0;
                    int len = pend - idx;
                    TBLTable.putShort(po, idx + 2, (short)len);
                    idx = pend;
                    break;
                }
                case 11: {
                    idx = col.components.TblFillColForm(po, idx, index);
                    po[idx++] = 0;
                    break;
                }
                case 12: {
                    int len;
                    for (len = 0; len < col.elements; ++len) {
                        idx = col.TblFillColForm(po, idx, index);
                    }
                    po[idx++] = 0;
                    break;
                }
                case 14: {
                    break;
                }
                default: {
                    if (index == 0) break;
                    po[idx++] = 20;
                    TBLTable.putShort(po, idx, (short)col.srcOffset);
                    TBLTable.putShort(po, idx + 2, (short)col.srcColumn);
                    idx += 4;
                }
            }
            col = col.next;
        }
        return idx;
    }

    public int TblRowLayout() throws DomainException {
        this.length = 0;
        this.numstr = 0;
        this.numcol = 0;
        this.bitmask = 128;
        TBLStruct col = this.components;
        while (col != null) {
            col.offset = this.length;
            col.strix = this.numstr;
            col.coloff = this.numcol;
            col.numcol = 1;
            switch (col.datatype) {
                case 0: {
                    break;
                }
                case 1: {
                    col.length = 1;
                    break;
                }
                case 2: {
                    col.length = 2;
                    break;
                }
                case 3: {
                    col.length = 3;
                    break;
                }
                case 4: 
                case 7: 
                case 15: {
                    col.length = 4;
                    break;
                }
                case 5: 
                case 8: {
                    col.numstr = 1;
                    break;
                }
                case 6: 
                case 9: {
                    col.length = 8;
                    break;
                }
                case 13: 
                case 16: 
                case 21: {
                    break;
                }
                case 10: {
                    col.length = col.next == null ? 1 : 0;
                    col.bitmask = this.bitmask;
                    this.bitmask >>= 1;
                    if (this.bitmask != 0) break;
                    col.length = 1;
                    this.bitmask = 128;
                    break;
                }
                case 17: {
                    int rc;
                    TBLStruct sdef = col.components;
                    if (sdef == null) {
                        throw new DomainException("ASSERT(sdef)");
                    }
                    if (sdef.type != 2) {
                        throw new DomainException("ASSERT(sdef->type == TblDEFN_BITMASK)");
                    }
                    if (sdef.length == 0 && sdef.numstr == 0 && (rc = sdef.TblRowLayout()) != 0) {
                        return rc;
                    }
                    col.length = sdef.length;
                    col.numstr = sdef.numstr;
                    break;
                }
                case 11: {
                    int rc;
                    TBLStruct sdef = col.components;
                    if (sdef == null) {
                        throw new DomainException("ASSERT(sdef)");
                    }
                    if (sdef.type != 1) {
                        throw new DomainException("ASSERT(sdef->type == TblDEFN_STRUCT)");
                    }
                    if (sdef.length == 0 && sdef.numstr == 0 && (rc = sdef.TblRowLayout()) != 0) {
                        return rc;
                    }
                    col.length = sdef.length;
                    col.numstr = sdef.numstr;
                    col.numcol = sdef.numcol;
                    break;
                }
                case 12: {
                    int rc = col.TblRowLayout();
                    if (rc == 0) break;
                    return rc;
                }
            }
            this.length += col.elements * col.length;
            this.numstr += col.elements * col.numstr;
            this.numcol += col.elements * col.numcol;
            col = col.next;
        }
        return 0;
    }

    public TBLStruct find(DomainString name) {
        TBLStruct col = this;
        while (col != null && !name.equals(col.name)) {
            col = col.next;
        }
        return col;
    }

    public void delete() {
        TBLStruct struct = this;
        while (struct != null) {
            TBLStruct nextStruct = struct.next;
            switch (struct.type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (struct.components == null) break;
                    struct.components.delete();
                    break;
                }
            }
            struct = null;
            struct = nextStruct;
        }
    }
}

