/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.mainframe.utility;

import gov.agency.mainframe.utility.MainframeWrapperError;
import gov.agency.mainframe.utility.MainframeWrapperException;
import gov.agency.mainframe.utility.impl.WrappedComponent;
import gov.agency.mainframe.utility.util.MainframeProperties;
import gov.agency.mainframe.utility.util.StringUtilities;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;

public abstract class MainframeWrapper {
    private WrappedComponent wrappedComponent = null;
    private MainframeProperties properties = null;

    protected MainframeWrapper() {
    }

    public String process(String claimInputString) {
        try {
            this.initializeComponent();
        }
        catch (Exception exc1) {
            throw new MainframeWrapperError("Failed to initialize component", exc1);
        }
        try {
            this.loadProperties();
            claimInputString = this.convertCharSetInputString(claimInputString);
            return this.wrappedComponent.process(claimInputString);
        }
        catch (Exception exc) {
            return this.wrappedComponent.processException(exc, claimInputString);
        }
    }

    public String process(String claimInputString, MainframeProperties prop) {
        this.properties = prop;
        return this.process(claimInputString);
    }

    protected abstract WrappedComponent newComponent();

    protected MainframeProperties newProperties() {
        return new MainframeProperties();
    }

    private void loadProperties() throws IOException {
        if (this.properties == null) {
            this.properties = this.newProperties();
            Objects.requireNonNull(this.properties, "An instance of properties is required");
            this.properties.load();
        }
    }

    private void initializeComponent() throws MainframeWrapperException {
        if (this.wrappedComponent == null) {
            this.wrappedComponent = this.newComponent();
            this.wrappedComponent.initialize(this.properties);
        }
    }

    private String convertCharSetInputString(String claimInputString) {
        Optional<Charset> mayBeCharSet;
        if (this.properties != null && (mayBeCharSet = this.properties.getInputCharacterSet()).isPresent()) {
            return StringUtilities.convertFromCharacterSet(claimInputString, mayBeCharSet.get());
        }
        return claimInputString;
    }
}

