/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.ioce.legacy;

import com.mmm.his.cer.foundation.Processable;
import com.mmm.his.cer.foundation.exception.FoundationException;
import gov.cms.ioce.IoceOption;
import gov.cms.ioce.IoceRuntimeOption;
import gov.cms.ioce.legacy.IoceDomainComponentProcessor;
import gov.cms.ioce.transfer.IoceClaim;
import java.io.File;
import java.util.Date;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoceComponent
implements Processable<IoceClaim, IoceOption, IoceRuntimeOption> {
    private static final Logger logger = LoggerFactory.getLogger(IoceComponent.class);
    private IoceDomainComponentProcessor ioceDomainProcessor = null;
    private IoceRuntimeOption options;
    private File ctlPath;

    public IoceComponent() throws Exception {
        this(null, null);
    }

    public IoceComponent(IoceRuntimeOption options) throws Exception {
        this(options, null);
    }

    public IoceComponent(IoceRuntimeOption options, File ctlPath) throws Exception {
        this.ctlPath = ctlPath;
        this.reconfigure(options);
        this.initialize();
    }

    private final void initialize() {
        String pathToCtl = "/gapc.ctl";
        if (this.ctlPath != null) {
            pathToCtl = this.ctlPath.getAbsolutePath();
        }
        try {
            this.ioceDomainProcessor = new IoceDomainComponentProcessor(pathToCtl);
        }
        catch (FoundationException exc) {
            logger.error("Error encountered when initializing component.", exc);
            throw new RuntimeException(exc);
        }
    }

    @Override
    public final void process(IoceClaim claim) throws FoundationException {
        int returnCode = -1;
        try {
            Date timeStarted = new Date();
            returnCode = this.ioceDomainProcessor.process(claim);
            if (logger.isDebugEnabled()) {
                Date timeEnded = new Date();
                DatatypeFactory factory = DatatypeFactory.newInstance();
                Duration duration = factory.newDuration(timeEnded.getTime() - timeStarted.getTime());
                logger.debug("Claim processed in D:{},H:{},M:{},S:{}", duration.getDays(), duration.getHours(), duration.getMinutes(), duration.getSeconds());
            }
        }
        catch (Exception exc) {
            String message = "Error encountered when processing claim " + claim.getClaimId() + '.';
            logger.error(message, exc);
            throw new FoundationException(message, exc);
        }
    }

    @Override
    public final void close() {
        this.ioceDomainProcessor.close();
    }

    @Override
    public final void reconfigure(IoceRuntimeOption options) throws FoundationException {
        this.options = options;
    }

    public IoceRuntimeOption getOptions() {
        return this.options;
    }
}

