/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.ioce.legacy;

import com.mmm.his.cer.foundation.exception.FoundationException;
import com.mmmhis.domain.DomainEnvironment;
import com.mmmhis.domain.DomainException;
import com.mmmhis.domain.DomainInteger;
import com.mmmhis.domain.DomainString;
import gov.cms.ioce.transfer.IoceClaim;
import gov.cms.oce.gapc;
import gov.cms.oce.model.external.OceClaim;
import gov.cms.oce.model.external.OceClaimFactory;
import gov.cms.oce.model.external.OceClaimImpl;
import gov.cms.oce.model.external.OceClaimOutputSetterWrapper;
import gov.cms.oce.model.external.OceDiagnosisCode;
import gov.cms.oce.model.external.OceDiagnosisCodeImpl;
import gov.cms.oce.model.external.OceDiagnosisCodeOutputSetterWrapper;
import gov.cms.oce.model.external.OceHcpcsModifier;
import gov.cms.oce.model.external.OceHcpcsModifierImpl;
import gov.cms.oce.model.external.OceHcpcsModifierOutputSetterWrapper;
import gov.cms.oce.model.external.OceLineItem;
import gov.cms.oce.model.external.OceLineItemImpl;
import gov.cms.oce.model.external.OceLineItemOutputSetterWrapper;
import gov.cms.oce.model.external.OceValueCode;
import java.io.Closeable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IoceDomainComponentProcessor
implements Closeable,
Serializable {
    private static final long serialVersionUID = 262567832596837303L;
    private static final Logger logger = LoggerFactory.getLogger(IoceDomainComponentProcessor.class);
    private static final int CONDITION_CODE_COUNT = 30;
    private static final int VALUE_CODE_COUNT = 36;
    private static final int OCCURRENCE_CODE_COUNT = 30;
    private static final int RVDX_COUNT = 3;
    private static final int HCPCS_MOD_COUNT = 5;
    private static final int CONTRACTOR_EDIT_COUNT = 4;
    private static final int PDX_COUNT = 1;
    private static final int SDX_COUNT = 24;
    private static final int VALUE_CODE_LENGTH = 2;
    private static final int AMOUNT_LENGTH = 9;
    private static final int NO_NUMBER = -1;
    private String ctlPath;
    private transient gapc grouper;

    public IoceDomainComponentProcessor(String ctlPath) throws FoundationException {
        this.ctlPath = ctlPath;
        this.initialize();
    }

    @Override
    public final void close() {
        logger.debug("Closing IoceDomainComponentProcessor.");
        if (this.grouper != null) {
            this.grouper.GAPC_VarClose();
        }
    }

    public final void initialize() throws FoundationException {
        logger.debug("Initializing IoceDomainComponentProcessor with ctl = {}", (Object)this.ctlPath);
        try {
            String[] resources = new String[]{"database/path", this.ctlPath, null, null};
            DomainEnvironment env = new DomainEnvironment(null);
            this.grouper = new gapc(env, resources);
        }
        catch (DomainException exc) {
            logger.error("Domain Exception", exc);
            throw new FoundationException(exc);
        }
    }

    public final int process(IoceClaim claimWrapper) throws DomainException {
        logger.debug("Start Processing");
        OceClaimImpl claim = (OceClaimImpl)claimWrapper.getModel();
        logger.debug("Initialize Record: GAPC_VarInitRecord()");
        this.grouper.GAPC_VarInitRecord();
        this.grouperLoadDxCodes(claim.getReasonForVisitDiagnosisCodeList(), claim.getPrincipalDiagnosisCode(), claim.getSecondaryDiagnosisCodeList());
        int numberOfLinesTemp = 0;
        List<OceLineItem> items = claim.getLineItemList();
        if (items == null) {
            logger.debug("No Line Items Detected.");
        } else {
            logger.debug("Load Line Items: GAPC_VarLoadSgCode");
            int lineIndex = 0;
            for (OceLineItem oceLine : items) {
                if (oceLine == null) {
                    logger.info("Reached last line item.");
                    break;
                }
                this.grouperLoadLineItemSgCodeData(oceLine, lineIndex);
                ++lineIndex;
            }
            numberOfLinesTemp = lineIndex;
        }
        logger.debug("Lines Counted={}", (Object)numberOfLinesTemp);
        logger.debug("Prepare Domain output variables.");
        DomainInteger[] claimRejectionReasons = new DomainInteger[30];
        for (int i = 0; i < 30; ++i) {
            claimRejectionReasons[i] = new DomainInteger();
        }
        DomainInteger[] claimDenialReasons = new DomainInteger[30];
        for (int i = 0; i < 30; ++i) {
            claimDenialReasons[i] = new DomainInteger();
        }
        DomainInteger[] claimRtpReasons = new DomainInteger[30];
        for (int i = 0; i < 30; ++i) {
            claimRtpReasons[i] = new DomainInteger();
        }
        DomainInteger[] claimSuspensionReasons = new DomainInteger[30];
        for (int i = 0; i < 30; ++i) {
            claimSuspensionReasons[i] = new DomainInteger();
        }
        DomainInteger[] lineRejectionReasons = new DomainInteger[30];
        for (int i = 0; i < 30; ++i) {
            lineRejectionReasons[i] = new DomainInteger();
        }
        DomainInteger[] lineDenialReasons = new DomainInteger[30];
        for (int i = 0; i < 30; ++i) {
            lineDenialReasons[i] = new DomainInteger();
        }
        DomainInteger noppsBillFlag = new DomainInteger();
        DomainString valueCodeOutput = new DomainString();
        DomainString[] conditionCodeOutput = new DomainString[10];
        for (int i = 0; i < 10; ++i) {
            conditionCodeOutput[i] = new DomainString();
        }
        DomainString versionId = new DomainString();
        DomainInteger claimProcessed = new DomainInteger();
        DomainInteger numberOfLines = new DomainInteger();
        DomainInteger overallClaimDisposition = new DomainInteger();
        DomainInteger claimRejectionDisposition = new DomainInteger();
        DomainInteger claimDenialDisposition = new DomainInteger();
        DomainInteger claimRtpDisposition = new DomainInteger();
        DomainInteger claimSuspensionDisposition = new DomainInteger();
        DomainInteger lineRejectionDisposition = new DomainInteger();
        DomainInteger lineDenialDisposition = new DomainInteger();
        DomainInteger apcReturnFlag = new DomainInteger();
        int mainReturnCode = this.grouperOceApcCompute(claim, claimProcessed, numberOfLines, overallClaimDisposition, claimRejectionDisposition, claimDenialDisposition, claimRtpDisposition, claimSuspensionDisposition, lineRejectionDisposition, lineDenialDisposition, apcReturnFlag, versionId, claimRejectionReasons, claimDenialReasons, claimRtpReasons, claimSuspensionReasons, lineRejectionReasons, lineDenialReasons, noppsBillFlag, valueCodeOutput, conditionCodeOutput);
        OceClaimOutputSetterWrapper claimOutput = new OceClaimOutputSetterWrapper(claim);
        if (mainReturnCode != 0) {
            overallClaimDisposition.setValue(0);
            claimRejectionDisposition.setValue(0);
            claimDenialDisposition.setValue(0);
            claimRtpDisposition.setValue(0);
            claimSuspensionDisposition.setValue(0);
            lineRejectionDisposition.setValue(0);
            lineDenialDisposition.setValue(0);
            apcReturnFlag.setValue(0);
        }
        this.unloadClaimLevelOutputs(claimOutput, claimProcessed, overallClaimDisposition, apcReturnFlag, noppsBillFlag);
        this.unloadClaimDispEditOutputs(claimOutput, claimRejectionDisposition, claimDenialDisposition, claimRtpDisposition, claimSuspensionDisposition, lineRejectionDisposition, lineDenialDisposition, claimRejectionReasons, claimDenialReasons, claimRtpReasons, claimSuspensionReasons, lineRejectionReasons, lineDenialReasons);
        this.unloadOutputProcessingInfo(claim, numberOfLines, versionId);
        List<OceValueCode> valueCodeOutputs = this.convertOutputValueCodeData(valueCodeOutput);
        claimOutput.setValueCodeOutput(valueCodeOutputs);
        List<String> conditionOutput = this.convertOutputConditionCodesData(conditionCodeOutput);
        claimOutput.setConditionCodeOutput(conditionOutput);
        this.unloadDxOutputs(claim);
        if (items == null || items.isEmpty()) {
            logger.debug("No Lines Found.");
        } else {
            logger.debug("Line Output Information: GAPC_VarUnloadSgCode.");
            int counter2 = 0;
            for (OceLineItem item : items) {
                if (counter2 == numberOfLinesTemp) break;
                this.unloadLineOutputs(item, counter2);
                ++counter2;
            }
        }
        logger.debug("Complete.");
        return mainReturnCode;
    }

    private void grouperLoadDxCodes(List<OceDiagnosisCode> rvdx, OceDiagnosisCode pdx, List<OceDiagnosisCode> sdx) {
        int sdxIndex;
        int rvDxIndex;
        logger.debug("Load Rvdx List: GAPC_VarLoadDxCode");
        if (rvdx != null) {
            for (rvDxIndex = 0; rvDxIndex < rvdx.size(); ++rvDxIndex) {
                String code = "       ";
                String poa = " ";
                if (rvdx.get(rvDxIndex) != null) {
                    OceDiagnosisCode tempDxCode = rvdx.get(rvDxIndex);
                    if (tempDxCode.getDiagnosis() != null) {
                        code = tempDxCode.getDiagnosis();
                    }
                    if (tempDxCode.getPresentOnAdmission() != null) {
                        poa = tempDxCode.getPresentOnAdmission();
                    }
                }
                this.grouper.GAPC_VarLoadDxCode(rvDxIndex, IoceDomainComponentProcessor.emptyStringForNull(code), IoceDomainComponentProcessor.emptyStringForNull(poa));
            }
        }
        while (rvDxIndex < 3) {
            this.grouper.GAPC_VarLoadDxCode(rvDxIndex, "       ", " ");
            ++rvDxIndex;
        }
        int inputDxStartIndexOffset = 3;
        logger.debug("Load Pdx: GAPC_VarLoadDxCode");
        if (pdx != null) {
            String code = "       ";
            String poa = " ";
            if (pdx.getDiagnosis() != null) {
                code = pdx.getDiagnosis();
            }
            if (pdx.getPresentOnAdmission() != null) {
                poa = pdx.getPresentOnAdmission();
            }
            this.grouper.GAPC_VarLoadDxCode(inputDxStartIndexOffset, IoceDomainComponentProcessor.emptyStringForNull(code), IoceDomainComponentProcessor.emptyStringForNull(poa));
        } else {
            this.grouper.GAPC_VarLoadDxCode(inputDxStartIndexOffset, "       ", " ");
        }
        ++inputDxStartIndexOffset;
        logger.debug("Load Sdx List: GAPC_VarLoadDxCode");
        if (sdx != null && !sdx.isEmpty()) {
            for (sdxIndex = 0; sdxIndex < sdx.size(); ++sdxIndex) {
                String code = "       ";
                String poa = " ";
                if (sdx.get(sdxIndex) != null) {
                    if (sdx.get(sdxIndex).getDiagnosis() != null) {
                        code = sdx.get(sdxIndex).getDiagnosis();
                    }
                    if (sdx.get(sdxIndex).getPresentOnAdmission() != null) {
                        poa = sdx.get(sdxIndex).getPresentOnAdmission();
                    }
                }
                this.grouper.GAPC_VarLoadDxCode(sdxIndex + inputDxStartIndexOffset, IoceDomainComponentProcessor.emptyStringForNull(code), IoceDomainComponentProcessor.emptyStringForNull(poa));
            }
        }
        while (sdxIndex < 24) {
            this.grouper.GAPC_VarLoadDxCode(sdxIndex + inputDxStartIndexOffset, "       ", " ");
            ++sdxIndex;
        }
    }

    private void grouperLoadLineItemSgCodeData(OceLineItem oceLine, int lineIndex) {
        int contractorEditIndex;
        int hcpcsModIndex;
        if (logger.isDebugEnabled()) {
            int i;
            logger.debug("Load Line Items: GAPC_VarLoadSgCode");
            logger.debug("counter = {}", (Object)lineIndex);
            logger.debug("line hcpcs = {}", (Object)oceLine.getHcpcs());
            for (i = 0; i < oceLine.getHcpcsModifierInputList().size(); ++i) {
                logger.debug("line modifiers {} = {}", (Object)i, (Object)oceLine.getHcpcsModifierInputList().get(i));
            }
            logger.debug("line serviceDate = {}", (Object)oceLine.getServiceDate());
            logger.debug("line revenueCenter = {}", (Object)oceLine.getRevenueCode());
            logger.debug("line units = {}", (Object)oceLine.getUnitsInput());
            logger.debug("line charge = {}", (Object)oceLine.getCharge());
            logger.debug("line actionFlag = {}", (Object)oceLine.getActionFlagInput());
            for (i = 0; i < oceLine.getContractorEditBypassList().size(); ++i) {
                logger.debug("line ebEdits {} = {}", (Object)i, (Object)oceLine.getContractorEditBypassList().get(i));
            }
            logger.debug("line ebApc = {}", (Object)oceLine.getContractorApc());
            logger.debug("line ebStatusIndicator = {}", (Object)oceLine.getContractorStatusIndicator());
            logger.debug("line ebPaymentIndicator = {}", (Object)oceLine.getContractorPaymentIndicator());
            logger.debug("line ebDiscountingFormula = {}", (Object)oceLine.getContractorDiscountingFormula());
            logger.debug("line ebRejectionDenialFlag = {}", (Object)oceLine.getContractorRejectionDenialFlag());
            logger.debug("line ebPackagingFlag = {}", (Object)oceLine.getContractorPackagingFlag());
            logger.debug("line ebPaymentAdjustmentFlag = {}", (Object)oceLine.getContractorPaymentAdjustmentFlag01());
            logger.debug("line ebPaymentMethodFlag = {}", (Object)oceLine.getContractorPaymentMethodFlag());
        }
        String[] hcpcsMod = new String[5];
        List<OceHcpcsModifier> hcpcsModList = oceLine.getHcpcsModifierInputList();
        if (hcpcsModList != null) {
            for (hcpcsModIndex = 0; hcpcsModIndex < hcpcsModList.size(); ++hcpcsModIndex) {
                hcpcsMod[hcpcsModIndex] = hcpcsModList.get(hcpcsModIndex).getHcpcsModifier();
            }
        }
        while (hcpcsModIndex < 5) {
            hcpcsMod[hcpcsModIndex] = " ";
            ++hcpcsModIndex;
        }
        String[] contractorEdit = new String[4];
        List<String> contractorEditList = oceLine.getContractorEditBypassList();
        if (contractorEditList != null) {
            for (contractorEditIndex = 0; contractorEditIndex < contractorEditList.size(); ++contractorEditIndex) {
                contractorEdit[contractorEditIndex] = contractorEditList.get(contractorEditIndex);
            }
        }
        while (contractorEditIndex < 4) {
            contractorEdit[contractorEditIndex] = " ";
            ++contractorEditIndex;
        }
        int revenueCodeInt = oceLine.getRevenueCode() == null ? -1 : Integer.parseInt(oceLine.getRevenueCode());
        int contractorPaymentIndicatorInt = oceLine.getContractorPaymentIndicator() == null ? -1 : Integer.parseInt(oceLine.getContractorPaymentIndicator());
        this.grouper.GAPC_VarLoadSgCode(lineIndex, IoceDomainComponentProcessor.emptyStringForNull(oceLine.getHcpcs()), hcpcsMod, IoceDomainComponentProcessor.emptyStringForNull(oceLine.getServiceDate()), revenueCodeInt, IoceDomainComponentProcessor.emptyStringForNull(oceLine.getUnitsInput()), IoceDomainComponentProcessor.emptyStringForNull(oceLine.getCharge()), IoceDomainComponentProcessor.emptyStringForNull(oceLine.getActionFlagInput()), contractorEdit, IoceDomainComponentProcessor.emptyStringForNull(oceLine.getContractorApc()), IoceDomainComponentProcessor.emptyStringForNull(oceLine.getContractorStatusIndicator()), contractorPaymentIndicatorInt, IoceDomainComponentProcessor.emptyStringForNull(oceLine.getContractorDiscountingFormula()), IoceDomainComponentProcessor.emptyStringForNull(oceLine.getContractorRejectionDenialFlag()), IoceDomainComponentProcessor.emptyStringForNull(oceLine.getContractorPackagingFlag()), IoceDomainComponentProcessor.emptyStringForNull(oceLine.getContractorPaymentAdjustmentFlag01()), IoceDomainComponentProcessor.emptyStringForNull(oceLine.getContractorPaymentAdjustmentFlag02()), IoceDomainComponentProcessor.emptyStringForNull(oceLine.getContractorPaymentMethodFlag()));
    }

    private int grouperOceApcCompute(OceClaim claim, DomainInteger claimProcessed, DomainInteger numberOfLines, DomainInteger overallClaimDisposition, DomainInteger claimRejectionDisposition, DomainInteger claimDenialDisposition, DomainInteger claimRtpDisposition, DomainInteger claimSuspensionDisposition, DomainInteger lineRejectionDisposition, DomainInteger lineDenialDisposition, DomainInteger apcReturnFlag, DomainString versionId, DomainInteger[] claimRejectionReasons, DomainInteger[] claimDenialReasons, DomainInteger[] claimRtpReasons, DomainInteger[] claimSuspensionReasons, DomainInteger[] lineRejectionReasons, DomainInteger[] lineDenialReasons, DomainInteger noppsBillFlag, DomainString valueCodeOutput, DomainString[] conditionCodeOutput) {
        logger.debug("Load claim level demographic details into local variables.");
        logger.debug("Load Age.");
        Integer age = claim.getAge() == null ? -1 : Integer.valueOf(claim.getAge());
        logger.debug("Load Sex.");
        Integer sex = null;
        sex = claim.getSex() == null ? Integer.valueOf(-1) : (claim.getSex().trim().isEmpty() ? Integer.valueOf(0) : Integer.valueOf(claim.getSex()));
        logger.debug("Load From Date.");
        String fromDate = claim.getDateStarted() == null ? "        " : claim.getDateStarted();
        logger.debug("Load Through Date.");
        String thruDate = claim.getDateEnded() == null ? "        " : claim.getDateEnded();
        logger.debug("Load Patient Status.");
        String patientStatus = claim.getPatientStatus() == null ? "0" : String.valueOf(claim.getPatientStatus());
        logger.debug("Load OPPS Flag.");
        Integer opps = claim.getOppsFlag() == null ? 0 : Integer.valueOf(claim.getOppsFlag());
        logger.debug("Load Type of Bill.");
        String billType = claim.getBillType() == null ? "" : claim.getBillType();
        logger.debug("Load NPI & OSCAR.");
        String npi = claim.getNationalProviderId() == null ? "" : claim.getNationalProviderId();
        String oscar = claim.getCmsCertificationNumber() == null ? "" : claim.getCmsCertificationNumber();
        logger.debug("Load receipt date.");
        String receiptDate = claim.getReceiptDate() == null ? "        " : claim.getReceiptDate();
        logger.debug("Load condition code input list.");
        List<String> cci = claim.getConditionCodeInputList();
        if (cci == null) {
            logger.debug("Condition code input list is null.");
        } else if (cci.isEmpty()) {
            logger.debug("Condition code input list is empty.");
        } else {
            logger.debug("Condition code input list contains content.");
        }
        int ccCount = 0;
        String[] conditionCodes = new String[30];
        if (cci != null) {
            for (String cc : cci) {
                if (cc == null) break;
                conditionCodes[ccCount] = cc == null ? "  " : cc;
                ++ccCount;
            }
        }
        logger.debug("Condition code input list count = {}", (Object)ccCount);
        while (ccCount < 30) {
            conditionCodes[ccCount] = "  ";
            ++ccCount;
        }
        logger.debug("Load occurrence code input list.");
        List<String> oci = claim.getOccurrenceCodeInputList();
        if (oci == null) {
            logger.debug("Occurrence code input list is null.");
        } else if (oci.isEmpty()) {
            logger.debug("Occurrence code input list is empty.");
        } else {
            logger.debug("Occurrence code input list contains content.");
        }
        int ocCount = 0;
        String[] occurrenceCodes = new String[30];
        if (oci != null) {
            for (String oc : oci) {
                if (oc == null) break;
                occurrenceCodes[ocCount] = oc == null ? "  " : oc;
                ++ocCount;
            }
        }
        logger.debug("Occurrence code input list count = {}", (Object)ocCount);
        while (ocCount < 30) {
            occurrenceCodes[ocCount] = "  ";
            ++ocCount;
        }
        logger.debug("Load value code input list.");
        List<OceValueCode> vci = claim.getValueCodeInputList();
        if (vci == null) {
            logger.debug("Value code input list is null.");
        } else if (vci.isEmpty()) {
            logger.debug("Value code input list is empty.");
        } else {
            logger.debug("Value code input list contains content.");
        }
        int vcCount = 0;
        String[] valueCodes = new String[36];
        if (vci != null) {
            for (OceValueCode vc : vci) {
                if (vc == null) {
                    logger.debug("Value code object is null.");
                    break;
                }
                StringBuilder code = new StringBuilder(vc.getValue() == null ? "  " : vc.getValue());
                while (code.length() < 2) {
                    code.insert(0, " ");
                }
                StringBuilder amount = new StringBuilder(vc.getValue() == null ? "         " : vc.getValue());
                while (amount.length() < 9) {
                    amount.insert(0, " ");
                }
                valueCodes[vcCount] = code.append((CharSequence)amount).toString();
                ++vcCount;
            }
        }
        logger.debug("Value code input list count = {}", (Object)vcCount);
        while (vcCount < 36) {
            valueCodes[vcCount] = "           ";
            ++vcCount;
        }
        int mainReturnCode = -1;
        try {
            if (logger.isDebugEnabled()) {
                int i;
                logger.debug("Prepare Domain output variables.");
                logger.debug("age={}", (Object)age);
                logger.debug("sex={}", (Object)sex);
                logger.debug("fromDate={}", (Object)fromDate);
                logger.debug("thruDate={}", (Object)thruDate);
                for (i = 0; i < conditionCodes.length; ++i) {
                    logger.debug("conditionCodes {} = {}", (Object)i, (Object)conditionCodes[i]);
                }
                for (i = 0; i < occurrenceCodes.length; ++i) {
                    logger.debug("occurrenceCodes {} = {}", (Object)i, (Object)occurrenceCodes[i]);
                }
                for (i = 0; i < valueCodes.length; ++i) {
                    logger.debug("valueCodes {} = {}", (Object)i, (Object)valueCodes[i]);
                }
                logger.debug("billType={}", (Object)billType);
                logger.debug("npi={}", (Object)npi);
                logger.debug("oscar={}", (Object)oscar);
                logger.debug("patientStatus={}", (Object)patientStatus);
                logger.debug("opps={}", (Object)opps);
                logger.debug("claimProcessed={}", (Object)claimProcessed.getValue());
                logger.debug("numberOfLines={}", (Object)numberOfLines.getValue());
                logger.debug("overallClaimDisposition={}", (Object)overallClaimDisposition.getValue());
                logger.debug("claimRejectionDisposition={}", (Object)claimRejectionDisposition.getValue());
                logger.debug("claimDenialDisposition={}", (Object)claimDenialDisposition.getValue());
                logger.debug("claimRtpDisposition={}", (Object)claimRtpDisposition.getValue());
                logger.debug("claimSuspensionDisposition={}", (Object)claimSuspensionDisposition.getValue());
                logger.debug("lineRejectionDisposition={}", (Object)lineRejectionDisposition.getValue());
                logger.debug("lineDenialDisposition={}", (Object)lineDenialDisposition.getValue());
                for (i = 0; i < claimRejectionReasons.length; ++i) {
                    logger.debug("claimRejectionReasons {} = {}", (Object)i, (Object)claimRejectionReasons[i].getValue());
                }
                for (i = 0; i < claimDenialReasons.length; ++i) {
                    logger.debug("claimDenialReasons {} = {}", (Object)i, (Object)claimDenialReasons[i].getValue());
                }
                for (i = 0; i < claimRtpReasons.length; ++i) {
                    logger.debug("claimRtpReasons {} = {}", (Object)i, (Object)claimRtpReasons[i].getValue());
                }
                for (i = 0; i < claimSuspensionReasons.length; ++i) {
                    logger.debug("claimSuspensionReasons {} = {}", (Object)i, (Object)claimSuspensionReasons[i].getValue());
                }
                for (i = 0; i < lineRejectionReasons.length; ++i) {
                    logger.debug("lineRejectionReasons {} = {}", (Object)i, (Object)lineRejectionReasons[i].getValue());
                }
                for (i = 0; i < lineDenialReasons.length; ++i) {
                    logger.debug("lineDenialReasons {} = {}", (Object)i, (Object)lineDenialReasons[i].getValue());
                }
                logger.debug("apcReturnFlag={}", (Object)apcReturnFlag.getValue());
                logger.debug("versionId={}", (Object)versionId.getValue());
                logger.debug("noppsBillFlag={}", (Object)noppsBillFlag.getValue());
                logger.debug("valueCodeOutput={}", (Object)valueCodeOutput.getValue());
                for (i = 0; i < conditionCodeOutput.length; ++i) {
                    logger.debug("conditionCodeOutput {} = {}", (Object)i, (Object)conditionCodeOutput[i]);
                }
            }
            logger.debug("Process Claim: GAPC_VarOceApcCompute");
            mainReturnCode = this.grouper.GAPC_VarOceApcCompute(age, sex, fromDate, thruDate, receiptDate, conditionCodes, occurrenceCodes, valueCodes, billType, npi, oscar, patientStatus, opps, claimProcessed, numberOfLines, overallClaimDisposition, claimRejectionDisposition, claimDenialDisposition, claimRtpDisposition, claimSuspensionDisposition, lineRejectionDisposition, lineDenialDisposition, claimRejectionReasons, claimDenialReasons, claimRtpReasons, claimSuspensionReasons, lineRejectionReasons, lineDenialReasons, apcReturnFlag, versionId, noppsBillFlag, valueCodeOutput, conditionCodeOutput);
        }
        catch (DomainException exc) {
            logger.error("Domain Exception:", exc);
            claim.getProcessingInformation().setReturnCode(-1);
            throw new RuntimeException(exc);
        }
        catch (Exception exc) {
            logger.error("Domain Exception:", exc);
            claim.getProcessingInformation().setReturnCode(-1);
            throw exc;
        }
        finally {
            if (claim.getProcessingInformation().getReturnCode() == null) {
                claim.getProcessingInformation().setReturnCode(mainReturnCode);
            }
        }
        return mainReturnCode;
    }

    private void unloadOutputProcessingInfo(OceClaim claim, DomainInteger numberOfLines, DomainString versionId) {
        logger.debug("Unloading Processing Information");
        claim.getProcessingInformation().setVersion(versionId.getValue());
        claim.getProcessingInformation().setLinesProcessed(numberOfLines.getValue());
    }

    private void unloadClaimLevelOutputs(OceClaimOutputSetterWrapper claimOutput, DomainInteger claimProcessed, DomainInteger overallClaimDisposition, DomainInteger apcReturnFlag, DomainInteger noppsBillFlag) {
        logger.debug("Unloading Claim Level Information");
        claimOutput.setClaimProcessedFlag(String.valueOf(claimProcessed.getValue()));
        claimOutput.setClaimDisposition(String.valueOf(overallClaimDisposition.getValue()));
        claimOutput.setApcReturnBufferFlag(String.valueOf(apcReturnFlag.getValue()));
        claimOutput.setNoppsBillFlag(String.valueOf(noppsBillFlag.getValue()));
    }

    private List<OceValueCode> convertOutputValueCodeData(DomainString valueCodeOutput) {
        logger.debug("Unloading Value Code Output Information");
        int valueCodeCount = valueCodeOutput.length() / 11;
        ArrayList<OceValueCode> valueCodeOutputs = new ArrayList();
        for (int i = 0; i < valueCodeCount; ++i) {
            OceValueCode vs;
            int start = i * 11;
            int end = Math.min(start + 11, valueCodeOutput.getValue().length());
            String temp = valueCodeOutput.getValue().substring(start, end);
            String code = temp.substring(0, 2);
            if (code != null && !"".equals(code.trim())) {
                vs = OceClaimFactory.getInstance().createValueCode();
                vs.setCode(code);
                String value = IoceDomainComponentProcessor.leftTrim(temp.substring(2), 1, '0');
                vs.setValue(value);
                valueCodeOutputs.add(vs);
                continue;
            }
            vs = OceClaimFactory.getInstance().createValueCode();
            valueCodeOutputs.add(vs);
        }
        valueCodeOutputs = IoceDomainComponentProcessor.rightTrimList(valueCodeOutputs, element -> element.getCode() == null || element.getCode().trim().isEmpty());
        return valueCodeOutputs;
    }

    private List<String> convertOutputConditionCodesData(DomainString[] conditionCodeOutput) {
        logger.debug("Unloading Condition Code Output Information");
        ArrayList<String> conditionOutput = new ArrayList<String>();
        for (int i = 0; i < conditionCodeOutput.length && conditionCodeOutput[i] != null && conditionCodeOutput[i].getValue() != null && !"".equals(conditionCodeOutput[i].getValue()); ++i) {
            conditionOutput.add(conditionCodeOutput[i].getValue());
        }
        return conditionOutput;
    }

    private void unloadClaimDispEditOutputs(OceClaimOutputSetterWrapper claimOutput, DomainInteger claimRejectionDisposition, DomainInteger claimDenialDisposition, DomainInteger claimRtpDisposition, DomainInteger claimSuspensionDisposition, DomainInteger lineRejectionDisposition, DomainInteger lineDenialDisposition, DomainInteger[] claimRejectionReasons, DomainInteger[] claimDenialReasons, DomainInteger[] claimRtpReasons, DomainInteger[] claimSuspensionReasons, DomainInteger[] lineRejectionReasons, DomainInteger[] lineDenialReasons) {
        logger.debug("Unloading Claim Level Disposition/Edit Information");
        claimOutput.setClaimRejectionDisposition(String.valueOf(claimRejectionDisposition.getValue()));
        ArrayList<String> claimRejectionEdits = new ArrayList<String>();
        for (int i = 0; i < claimRejectionReasons.length && claimRejectionReasons[i] != null && claimRejectionReasons[i].getValue() != 0; ++i) {
            claimRejectionEdits.add(String.valueOf(claimRejectionReasons[i].getValue()));
        }
        claimOutput.setClaimRejectionEditList(claimRejectionEdits);
        claimOutput.setClaimDenialDisposition(String.valueOf(claimDenialDisposition.getValue()));
        ArrayList<String> claimDenialEdits = new ArrayList<String>();
        for (int i = 0; i < claimDenialReasons.length && claimDenialReasons[i] != null && claimDenialReasons[i].getValue() != 0; ++i) {
            claimDenialEdits.add(String.valueOf(claimDenialReasons[i].getValue()));
        }
        claimOutput.setClaimDenialEditList(claimDenialEdits);
        claimOutput.setClaimReturnToProviderDisposition(String.valueOf(claimRtpDisposition.getValue()));
        ArrayList<String> claimReturnToProviderEdits = new ArrayList<String>();
        for (int i = 0; i < claimRtpReasons.length && claimRtpReasons[i] != null && claimRtpReasons[i].getValue() != 0; ++i) {
            claimReturnToProviderEdits.add(String.valueOf(claimRtpReasons[i].getValue()));
        }
        claimOutput.setClaimReturnToProviderEditList(claimReturnToProviderEdits);
        claimOutput.setClaimSuspensionDisposition(String.valueOf(claimSuspensionDisposition.getValue()));
        ArrayList<String> claimSuspensionEdits = new ArrayList<String>();
        for (int i = 0; i < claimSuspensionReasons.length && claimSuspensionReasons[i] != null && claimSuspensionReasons[i].getValue() != 0; ++i) {
            claimSuspensionEdits.add(String.valueOf(claimSuspensionReasons[i].getValue()));
        }
        claimOutput.setClaimSuspensionEditList(claimSuspensionEdits);
        claimOutput.setLineRejectionDisposition(String.valueOf(lineRejectionDisposition.getValue()));
        ArrayList<String> lineRejectionEdits = new ArrayList<String>();
        for (int i = 0; i < lineRejectionReasons.length && lineRejectionReasons[i] != null && lineRejectionReasons[i].getValue() != 0; ++i) {
            lineRejectionEdits.add(String.valueOf(lineRejectionReasons[i].getValue()));
        }
        claimOutput.setLineRejectionEditList(lineRejectionEdits);
        claimOutput.setLineDenialDisposition(String.valueOf(lineDenialDisposition.getValue()));
        ArrayList<String> lineDenialEdits = new ArrayList<String>();
        for (int i = 0; i < lineDenialReasons.length && lineDenialReasons[i] != null && lineDenialReasons[i].getValue() != 0; ++i) {
            lineDenialEdits.add(String.valueOf(lineDenialReasons[i].getValue()));
        }
        claimOutput.setLineDenialEditList(lineDenialEdits);
    }

    private void unloadDxOutputs(OceClaim claim) {
        String e;
        Iterator iterator;
        boolean first;
        StringBuilder editSeries;
        int outputDxStartIndexOffset = 0;
        int returnCode = -1;
        logger.debug("Unloading Rvdx Edit Information: GAPC_VarUnloadDxCode");
        List<OceDiagnosisCode> rvdx = claim.getReasonForVisitDiagnosisCodeList();
        DomainInteger[] rvdxEdits = new DomainInteger[30];
        for (int outputRvDxIndex = 0; outputRvDxIndex < 3 && outputRvDxIndex < rvdx.size(); ++outputRvDxIndex) {
            for (int x = 0; x < rvdxEdits.length; ++x) {
                if (rvdxEdits[x] == null) {
                    rvdxEdits[x] = new DomainInteger();
                    continue;
                }
                if (rvdxEdits[x].getValue() == 0) break;
                rvdxEdits[x].setValue(0);
            }
            logger.debug("Unloading Rvdx {} Edit Information: GAPC_VarUnloadDxCode", (Object)outputRvDxIndex);
            returnCode = this.grouper.GAPC_VarUnloadDxCode(outputRvDxIndex + outputDxStartIndexOffset, rvdxEdits);
            if (returnCode != 0) {
                throw new DomainException("Non-zero return value found when retrieving Rvdx edits. Return Code:" + returnCode);
            }
            logger.debug("Transferring Edits to Rvdx {} model.", (Object)outputRvDxIndex);
            ArrayList<String> edits = new ArrayList<String>();
            int rvdxEditCounter = 0;
            for (rvdxEditCounter = 0; rvdxEditCounter < rvdxEdits.length && rvdxEdits[rvdxEditCounter] != null && rvdxEdits[rvdxEditCounter].getValue() != 0; ++rvdxEditCounter) {
                edits.add(String.valueOf(rvdxEdits[rvdxEditCounter].getValue()));
            }
            OceDiagnosisCodeOutputSetterWrapper rvdxOutput = new OceDiagnosisCodeOutputSetterWrapper((OceDiagnosisCodeImpl)rvdx.get(outputRvDxIndex));
            rvdxOutput.setEditList(edits);
            if (!logger.isDebugEnabled()) continue;
            if (0 < rvdxEditCounter) {
                editSeries = new StringBuilder();
                first = true;
                iterator = edits.iterator();
                while (iterator.hasNext() && (e = (String)iterator.next()) != null && !e.trim().isEmpty() && !e.trim().equals("0")) {
                    if (!first) {
                        editSeries.append(',').append(e);
                        continue;
                    }
                    editSeries.append(e);
                    first = false;
                }
                logger.trace("Rvdx {} Edit Count = {}, Edits = {}.", outputRvDxIndex, rvdxEditCounter, editSeries);
                continue;
            }
            logger.trace("Rvdx {} Edit Count = {}.", (Object)outputRvDxIndex, (Object)rvdxEditCounter);
        }
        outputDxStartIndexOffset += 3;
        logger.debug("Unloading Pdx Edit Information: GAPC_VarUnloadDxCode");
        DomainInteger[] pdxEdits = new DomainInteger[30];
        for (int x = 0; x < pdxEdits.length; ++x) {
            if (pdxEdits[x] == null) {
                pdxEdits[x] = new DomainInteger();
                continue;
            }
            if (pdxEdits[x].getValue() == 0) break;
            pdxEdits[x].setValue(0);
        }
        if ((returnCode = this.grouper.GAPC_VarUnloadDxCode(outputDxStartIndexOffset, pdxEdits)) != 0) {
            throw new DomainException("Non-zero return value found when retrieving Pdx edits. Return Code:" + returnCode);
        }
        logger.debug("Transferring Edits to Pdx model.");
        ArrayList<String> pedits = new ArrayList<String>();
        int pdxEditCounter = 0;
        for (pdxEditCounter = 0; pdxEditCounter < pdxEdits.length && pdxEdits[pdxEditCounter] != null && pdxEdits[pdxEditCounter].getValue() != 0; ++pdxEditCounter) {
            pedits.add(String.valueOf(pdxEdits[pdxEditCounter].getValue()));
        }
        OceDiagnosisCode pdx = claim.getPrincipalDiagnosisCode();
        if (pdx == null && !pedits.isEmpty()) {
            pdx = OceClaimFactory.getInstance().createDiagnosisCode();
            claim.setPrincipalDiagnosisCode(pdx);
        }
        if (pdx != null) {
            OceDiagnosisCodeOutputSetterWrapper pdxOutput = new OceDiagnosisCodeOutputSetterWrapper((OceDiagnosisCodeImpl)pdx);
            pdxOutput.setEditList(pedits);
        }
        if (logger.isDebugEnabled()) {
            if (0 < pdxEditCounter) {
                editSeries = new StringBuilder();
                first = true;
                iterator = pedits.iterator();
                while (iterator.hasNext() && (e = (String)iterator.next()) != null && !e.trim().isEmpty() && !e.trim().equals("0")) {
                    if (!first) {
                        editSeries.append(',').append(e);
                        continue;
                    }
                    editSeries.append(e);
                    first = false;
                }
                logger.trace("Pdx Edit Count = {}, Edits = {}.", (Object)pdxEditCounter, (Object)editSeries);
            } else {
                logger.trace("Pdx Edit Count = {}.", (Object)pdxEditCounter);
            }
        }
        ++outputDxStartIndexOffset;
        logger.debug("Unloading Sdx Edit Information: GAPC_VarUnloadDxCode");
        List<OceDiagnosisCode> sdx = claim.getSecondaryDiagnosisCodeList();
        DomainInteger[] sdxEdits = new DomainInteger[30];
        for (int outputSdxCodeIndex = 0; outputSdxCodeIndex < 24 && outputSdxCodeIndex < sdx.size(); ++outputSdxCodeIndex) {
            for (int x = 0; x < sdxEdits.length; ++x) {
                if (sdxEdits[x] == null) {
                    sdxEdits[x] = new DomainInteger();
                    continue;
                }
                if (sdxEdits[x].getValue() == 0) break;
                sdxEdits[x].setValue(0);
            }
            logger.debug("Unloading Sdx {} Edit Information: GAPC_VarUnloadDxCode.", (Object)outputSdxCodeIndex);
            returnCode = this.grouper.GAPC_VarUnloadDxCode(outputSdxCodeIndex + outputDxStartIndexOffset, sdxEdits);
            if (returnCode != 0) {
                throw new DomainException("Non-zero return value found when retrieving Sdx edits. Return Code:" + returnCode);
            }
            logger.debug("Transferring Edits to Sdx {} model.", (Object)outputSdxCodeIndex);
            ArrayList<String> edits = new ArrayList<String>();
            int sdxEditCounter = 0;
            for (sdxEditCounter = 0; sdxEditCounter < sdxEdits.length && sdxEdits[sdxEditCounter] != null && sdxEdits[sdxEditCounter].getValue() != 0; ++sdxEditCounter) {
                edits.add(String.valueOf(sdxEdits[sdxEditCounter]));
            }
            OceDiagnosisCodeOutputSetterWrapper sdxOutput = new OceDiagnosisCodeOutputSetterWrapper((OceDiagnosisCodeImpl)sdx.get(outputSdxCodeIndex));
            sdxOutput.setEditList(edits);
            if (!logger.isDebugEnabled()) continue;
            if (0 < sdxEditCounter) {
                String e2;
                StringBuilder editSeries2 = new StringBuilder();
                boolean first2 = true;
                Iterator iterator2 = edits.iterator();
                while (iterator2.hasNext() && (e2 = (String)iterator2.next()) != null && !e2.trim().isEmpty() && !e2.trim().equals("0")) {
                    if (!first2) {
                        editSeries2.append(',').append(e2);
                        continue;
                    }
                    editSeries2.append(e2);
                    first2 = false;
                }
                logger.trace("Sdx {} Edit Count = {}, Edits = {}.", outputSdxCodeIndex, sdxEditCounter, editSeries2);
                continue;
            }
            logger.trace("Sdx {} Edit Count = {}.", (Object)outputSdxCodeIndex, (Object)sdxEditCounter);
        }
    }

    private void unloadLineOutputs(OceLineItem item, int lineIndex) {
        DomainInteger[] procEdits = new DomainInteger[30];
        for (int i = 0; i < procEdits.length; ++i) {
            procEdits[i] = new DomainInteger();
        }
        DomainInteger[] modEdits = new DomainInteger[30];
        for (int i = 0; i < modEdits.length; ++i) {
            modEdits[i] = new DomainInteger();
        }
        DomainInteger[] dateEdits = new DomainInteger[30];
        for (int i = 0; i < dateEdits.length; ++i) {
            dateEdits[i] = new DomainInteger();
        }
        DomainInteger[] revenueEdits = new DomainInteger[30];
        for (int i = 0; i < revenueEdits.length; ++i) {
            revenueEdits[i] = new DomainInteger();
        }
        DomainString paymentApc = new DomainString();
        DomainString hcpcsApc = new DomainString();
        DomainString serviceIndicator = new DomainString();
        DomainInteger paymentIndicator = new DomainInteger();
        DomainInteger discountingFactor = new DomainInteger();
        DomainInteger lineDenialFlag = new DomainInteger();
        DomainInteger packagingFlag = new DomainInteger();
        DomainInteger payAdjFlag1 = new DomainInteger();
        DomainInteger payAdjFlag2 = new DomainInteger();
        DomainString payMethFlag = new DomainString();
        DomainString serviceUnitsOutput = new DomainString();
        DomainString actionFlagOutput = new DomainString();
        DomainString compAdjFlag = new DomainString();
        DomainString hcpcsPayerModifier01 = new DomainString();
        DomainString hcpcsPayerModifier02 = new DomainString();
        logger.debug("Unloading Line {} Output Information: GAPC_VarUnloadSgCode.", (Object)lineIndex);
        int returnCode = -1;
        returnCode = this.grouper.GAPC_VarUnloadSgCode(lineIndex, procEdits, modEdits, dateEdits, revenueEdits, paymentApc, hcpcsApc, serviceIndicator, paymentIndicator, discountingFactor, lineDenialFlag, packagingFlag, payAdjFlag1, payAdjFlag2, payMethFlag, serviceUnitsOutput, actionFlagOutput, compAdjFlag, hcpcsPayerModifier01, hcpcsPayerModifier02);
        if (returnCode != 0) {
            throw new DomainException("Non-zero return value found when retrieving line edits. Return Code:" + returnCode);
        }
        OceLineItemOutputSetterWrapper lineItemOutput = new OceLineItemOutputSetterWrapper((OceLineItemImpl)item);
        logger.debug("Transferring line {} output to model.", (Object)lineIndex);
        lineItemOutput.setPaymentApc(paymentApc.getValue());
        lineItemOutput.setHcpcsApc(hcpcsApc.getValue());
        lineItemOutput.setStatusIndicator(serviceIndicator.getValue());
        lineItemOutput.setPaymentIndicator(String.valueOf(paymentIndicator.getValue()));
        lineItemOutput.setDiscountingFormula(String.valueOf(discountingFactor.getValue()));
        lineItemOutput.setRejectionDenialFlag(String.valueOf(lineDenialFlag.getValue()));
        lineItemOutput.setPackagingFlag(String.valueOf(packagingFlag.getValue()));
        lineItemOutput.setPaymentAdjustmentFlag01(String.valueOf(payAdjFlag1.getValue()));
        lineItemOutput.setPaymentAdjustmentFlag02(String.valueOf(payAdjFlag2.getValue()));
        lineItemOutput.setPaymentMethodFlag(payMethFlag.getValue());
        String serviceUnitsValue = serviceUnitsOutput.getValue();
        if (serviceUnitsValue.equals("null")) {
            serviceUnitsValue = null;
        } else if (serviceUnitsValue.startsWith("0")) {
            serviceUnitsValue = IoceDomainComponentProcessor.leftTrim(serviceUnitsValue, 1, '0');
        }
        lineItemOutput.setUnitsOutput(serviceUnitsValue);
        lineItemOutput.setActionFlagOutput(actionFlagOutput.getValue());
        lineItemOutput.setCompositeAdjustmentFlag(compAdjFlag.getValue());
        if (logger.isDebugEnabled()) {
            logger.debug("PaymentApc = {}", (Object)item.getPaymentApc());
            logger.debug("HcpcsApc = {}", (Object)item.getHcpcsApc());
            logger.debug("StatusIndicator = {}", (Object)item.getStatusIndicator());
            logger.debug("PaymentIndicator = {}", (Object)item.getPaymentIndicator());
            logger.debug("DiscountingFormula = {}", (Object)item.getDiscountingFormula());
            logger.debug("RejectionDenialFlag = {}", (Object)item.getRejectionDenialFlag());
            logger.debug("PackagingFlag = {}", (Object)item.getPackagingFlag());
            logger.debug("PaymentAdjustmentFlag1 = {}", (Object)item.getPaymentAdjustmentFlag01());
            logger.debug("PaymentAdjustmentFlag2 = {}", (Object)item.getPaymentAdjustmentFlag02());
            logger.debug("PaymentMethodFlag = {}", (Object)item.getPaymentMethodFlag());
            logger.debug("Units = {}", (Object)item.getUnitsOutput());
            logger.debug("ActionFlag = {}", (Object)item.getActionFlagOutput());
            logger.debug("CompositeAdjustmentFlag = {}", (Object)item.getCompositeAdjustmentFlag());
        }
        logger.debug("Transferring {} procedure edits to line {} model.", (Object)procEdits.length, (Object)lineIndex);
        List<String> procEditList = new ArrayList<String>();
        for (int j = 0; j < procEdits.length; ++j) {
            DomainInteger procEdit = procEdits[j];
            if (procEdit == null) {
                procEditList.add(null);
                continue;
            }
            int procEditValue = procEdit.getValue();
            logger.trace("Assigning line {} procedure edit {} = {}.", lineIndex, j, procEditValue);
            procEditList.add(String.valueOf(procEditValue));
        }
        procEditList = IoceDomainComponentProcessor.rightTrimList(procEditList);
        lineItemOutput.setHcpcsEditList(procEditList);
        logger.debug("Transferring line {} modifier edits to model.", (Object)lineIndex);
        for (int modCounter = 0; modCounter < item.getHcpcsModifierInputList().size(); ++modCounter) {
            List<String> modEditList = new ArrayList<String>();
            int start = modCounter * 4;
            logger.debug("Transferring line {} modifier {} edits to model, starting from offset {}.", lineIndex, modCounter, start);
            for (int j = start; j < start + 4; ++j) {
                DomainInteger modEdit = modEdits[j];
                if (modEdit == null) {
                    modEditList.add(null);
                    continue;
                }
                int modEditValue = modEdit.getValue();
                logger.trace("Assigning line {} mod {} edit {} = {}.", lineIndex, modCounter, j, modEditValue);
                modEditList.add(String.valueOf(modEditValue));
            }
            OceHcpcsModifierImpl inputModifier = (OceHcpcsModifierImpl)item.getHcpcsModifierInputList().get(modCounter);
            OceHcpcsModifierOutputSetterWrapper wrapper = new OceHcpcsModifierOutputSetterWrapper(inputModifier);
            modEditList = IoceDomainComponentProcessor.rightTrimList(modEditList);
            wrapper.setEditList(modEditList);
        }
        logger.debug("Transferring {} date edits to line {} model.", (Object)dateEdits.length, (Object)lineIndex);
        List<String> dateEditList = new ArrayList<String>();
        for (int j = 0; j < dateEdits.length; ++j) {
            DomainInteger dateEdit = dateEdits[j];
            if (dateEdit == null) {
                dateEditList.add(null);
                continue;
            }
            int dateEditValue = dateEdit.getValue();
            logger.trace("Assigning line {} date edit {} = {}.", lineIndex, j, dateEditValue);
            dateEditList.add(String.valueOf(dateEditValue));
        }
        dateEditList = IoceDomainComponentProcessor.rightTrimList(dateEditList);
        lineItemOutput.setServiceDateEditList(dateEditList);
        logger.debug("Transferring {} revenue edits to line {} model.", (Object)revenueEdits.length, (Object)lineIndex);
        List<String> revenueEditList = new ArrayList<String>();
        for (int j = 0; j < revenueEdits.length; ++j) {
            DomainInteger revenueEdit = revenueEdits[j];
            if (revenueEdit == null) {
                revenueEditList.add(null);
                continue;
            }
            int revenueEditValue = revenueEdit.getValue();
            logger.trace("Assigning line {} revenue edit {} = {}.", lineIndex, j, revenueEditValue);
            revenueEditList.add(String.valueOf(revenueEditValue));
        }
        revenueEditList = IoceDomainComponentProcessor.rightTrimList(revenueEditList);
        lineItemOutput.setRevenueEditList(revenueEditList);
        logger.debug("Transferring HCPCS output modifiers to line {} model.", (Object)lineIndex);
        ArrayList<OceHcpcsModifier> hcpcsModifierOutput = new ArrayList<OceHcpcsModifier>();
        OceHcpcsModifier hcpcsModOutput1 = OceClaimFactory.getInstance().createHcpcsModifier();
        hcpcsModOutput1.setHcpcsModifier(hcpcsPayerModifier01.getValue());
        hcpcsModifierOutput.add(hcpcsModOutput1);
        OceHcpcsModifier hcpcsModOutput2 = OceClaimFactory.getInstance().createHcpcsModifier();
        hcpcsModOutput2.setHcpcsModifier(hcpcsPayerModifier02.getValue());
        hcpcsModifierOutput.add(hcpcsModOutput2);
        lineItemOutput.setHcpcsModifierOutputList(hcpcsModifierOutput);
    }

    public final String getDescription(int opt, String rnValue, String date, String codeType) throws DomainException {
        DomainString container = new DomainString();
        this.grouper.GAPC_VarClaimDescA(opt, IoceDomainComponentProcessor.emptyStringForNull(rnValue), IoceDomainComponentProcessor.emptyStringForNull(date), container, IoceDomainComponentProcessor.emptyStringForNull(codeType));
        return container.getValue();
    }

    private static List<String> rightTrimList(List<String> list) {
        return IoceDomainComponentProcessor.rightTrimList(list, element -> element.isEmpty() || element.equals("0"));
    }

    private static <E> List<E> rightTrimList(List<E> list, Predicate<E> trim) {
        E element;
        int lastNonEmptyOrNullElementIndex;
        for (lastNonEmptyOrNullElementIndex = list.size() - 1; lastNonEmptyOrNullElementIndex >= 0 && ((element = list.get(lastNonEmptyOrNullElementIndex)) == null || trim.test(element)); --lastNonEmptyOrNullElementIndex) {
        }
        return list.subList(0, lastNonEmptyOrNullElementIndex + 1);
    }

    public static String leftTrim(String stringToTrim, int preserveNumChars, char trimChar) {
        char charFromValueToTrim;
        int charIndex;
        for (charIndex = 0; charIndex < stringToTrim.length() && stringToTrim.length() - charIndex > preserveNumChars && (charFromValueToTrim = stringToTrim.charAt(charIndex)) == trimChar; ++charIndex) {
        }
        return stringToTrim.substring(charIndex);
    }

    private static String emptyStringForNull(String str) {
        return str == null ? "" : str;
    }
}

