/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.api;

import gov.cms.oce.api.OceClaimExecutor;
import gov.cms.oce.model.external.OceClaim;
import gov.cms.oce.util.FileProcessExecutor;
import gov.cms.oce.util.FileProcessor;
import gov.cms.oce.util.TimeTrap;
import gov.cms.oce.util.converter.OceClaimDefintion;
import gov.cms.oce.util.converter.OceClaimToTestClaimConverter;
import gov.cms.oce.util.converter.TestClaimToOceClaimConverter;
import gov.cms.oce.util.converter.rsc.ClaimModel;
import gov.cms.oce.util.converter.rsc.InvalidRecordException;
import gov.cms.oce.util.converter.rsc.TestClaimFileReader;
import gov.cms.oce.util.converter.rsc.TestClaimFileWriter;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BatchApi
implements FileProcessor {
    private static final Logger logger = LoggerFactory.getLogger(BatchApi.class);
    private final OceClaimExecutor claimExecutor = new OceClaimExecutor();

    private final void processClaim(OceClaimDefintion oceClaimDefinition, TestClaimFileReader reader, TestClaimFileWriter writer) {
        TestClaimToOceClaimConverter inputConverter = new TestClaimToOceClaimConverter(oceClaimDefinition.getClaimDefinition());
        OceClaimToTestClaimConverter outputConverter = new OceClaimToTestClaimConverter(oceClaimDefinition.getClaimDefinition());
        ClaimModel inputModel = null;
        while (true) {
            try {
                while ((inputModel = reader.next()) != null) {
                    OceClaim oceClaim = inputConverter.convert(inputModel);
                    this.claimExecutor.processClaim(oceClaim);
                    ClaimModel outputModel = outputConverter.convert(oceClaim);
                    writer.write(outputModel);
                }
            }
            catch (InvalidRecordException e) {
                logger.error("Invalid record encountered, skipping claim.", e);
                continue;
            }
            catch (IOException e) {
                logger.error("Failed to read or write data from file.", e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void process(String inputFilePath, String outputFilePath) {
        TestClaimFileReader reader = null;
        TestClaimFileWriter writer = null;
        try {
            OceClaimDefintion oceClaimDefinition = new OceClaimDefintion();
            reader = new TestClaimFileReader(inputFilePath, oceClaimDefinition.getClaimDefinition());
            writer = new TestClaimFileWriter(outputFilePath);
            reader.open();
            writer.open();
            TimeTrap timeTrap = null;
            if (logger.isWarnEnabled()) {
                timeTrap = new TimeTrap();
                timeTrap.setTimeStarted(System.currentTimeMillis());
            }
            this.processClaim(oceClaimDefinition, reader, writer);
            if (timeTrap != null && logger.isWarnEnabled()) {
                timeTrap.setTimeEnded(System.currentTimeMillis());
                logger.warn("{} claims processed in {} (HHHH:MM:SS:SSS).", (Object)writer.getCurrentClaimCount(), (Object)timeTrap.getDuration());
            }
        }
        catch (Exception e) {
            logger.error("Failed processing input file \"{}\": {}.", (Object)inputFilePath, (Object)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                    writer = null;
                }
                catch (IOException e) {
                    logger.error("Couldn't close writer.", e);
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                    reader = null;
                }
                catch (IOException e) {
                    logger.error("Couldn't close reader.", e);
                }
            }
        }
    }

    @Override
    public final void process(File inputFile, File outputFile) {
        this.process(inputFile.getAbsolutePath(), outputFile.getAbsolutePath());
    }

    public static final void main(String[] v) throws IOException {
        if (v.length != 2) {
            logger.error("java -jar BatchApi <path-to-input-file> <path-to-output-file>");
            return;
        }
        FileProcessExecutor fileProcessExecutor = new FileProcessExecutor();
        fileProcessExecutor.processFile(new BatchApi(), v[0], v[1]);
    }
}

