/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.data;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.data.DataApcDao;
import gov.cms.oce.dao.data.row.DataApcRowInternal;
import gov.cms.oce.dao.data.table.DataApcTableInternal;
import gov.cms.oce.model.internal.Apc;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.LineItemInternalTableData;
import gov.cms.oce.model.rsc.HardcodedApcSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.util.FlagSet;
import gov.cms.oce.util.StringUtilities;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataApcDaoImpl
implements DataApcDao {
    private static final Logger logger = LoggerFactory.getLogger(DataApcDaoImpl.class);

    @Override
    public final DataApcRowInternal getRow(String value, Short version) {
        if (StringUtilities.isEmpty(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("APC parameter value is null/empty.");
            }
            return null;
        }
        Map<DataApcTableInternal.DataApcTableKey, String> key = TableKeyBuilder.createTableKeyMap(DataApcTableInternal.DataApcTableKey.class);
        key.put(DataApcTableInternal.DataApcTableKey.APC, value);
        DataApcTableInternal table = BinaryDataProvider.getInstance().getDataApcTable();
        DataApcRowInternal row = table.getRowInternal(key, version);
        if (row == null && logger.isDebugEnabled()) {
            logger.debug("APC parameter value \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
        }
        return row;
    }

    @Override
    public final DataApcRowInternal getRow(Apc apc, Short version) {
        return this.getRow(apc.getValue(), version);
    }

    @Override
    public final void loadData(LineItemInternal line, Short version) {
        Apc defaultAPC = line.getTableData().getDefaultApc();
        DataApcRowInternal row = this.getRow(defaultAPC.getValue(), version);
        if (row != null) {
            FlagSet<LineFlags> flags = line.getFlags();
            if (row.isCapcSrs()) {
                flags.set(LineFlags.DATA_APC_CAPC_SRS);
            }
            if (row.isErVisit()) {
                flags.set(LineFlags.DATA_APC_ER_VISIT);
            }
            if (row.isMentalHealth()) {
                flags.set(LineFlags.DATA_APC_MENTAL_HEALTH);
            }
            LineItemInternalTableData tableData = line.getTableData();
            tableData.setApcStatusIndicator(row.getStatusIndicator());
            tableData.setApcPaymentIndicator(row.getPaymentIndicator());
            tableData.setApcPayment(row.getApcPayment());
            tableData.setComposite1(row.getComposite1Id());
            tableData.setComposite2(row.getComposite2Id());
            tableData.setComposite3(row.getComposite3Id());
        }
    }

    @Override
    public final boolean checkHardcodedApcSet() {
        boolean abort = false;
        DataApcTableInternal table = BinaryDataProvider.getInstance().getDataApcTable();
        Map<DataApcTableInternal.DataApcTableKey, String> key = TableKeyBuilder.createTableKeyMap(DataApcTableInternal.DataApcTableKey.class);
        for (HardcodedApcSet e : HardcodedApcSet.values()) {
            if (e == HardcodedApcSet.APC_ZERO) continue;
            key.put(DataApcTableInternal.DataApcTableKey.APC, e.getApc());
            List<DataApcRowInternal> rowSet = table.getRowInternal(key);
            if (rowSet.isEmpty()) {
                abort = true;
                logger.error("Did not find any rows for APC \"{}\" in the Data_APC table.", (Object)e.getApc());
                continue;
            }
            for (DataApcRowInternal row : rowSet) {
                if (row.getLoVersion() < e.getVersionStarted()) {
                    abort = true;
                    logger.error("Earliest version of APC \"{}\" in Data_APC table (version \"{}\") is earlier than hardcoded APC earliest version \"{}\".", e.getApc(), row.getLoVersion(), e.getVersionStarted());
                }
                if (0 >= e.getVersionEnded() || e.getVersionEnded() >= row.getHiVersion()) continue;
                abort = true;
                logger.error("Latest version of APC \"{}\" in Data_APC table (version \"{}\") is later than hardcoded APC latest version \"{}\".", e.getApc(), row.getHiVersion(), e.getVersionEnded());
            }
        }
        return abort;
    }
}

