/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.data;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.data.DataCapcDao;
import gov.cms.oce.dao.data.row.DataCapcRowInternal;
import gov.cms.oce.dao.data.table.DataCapcTableInternal;
import gov.cms.oce.model.internal.Hcpcs;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.LineItemInternalTableData;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.util.FlagSet;
import gov.cms.oce.util.StringUtilities;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataCapcDaoImpl
implements DataCapcDao {
    private static final Logger logger = LoggerFactory.getLogger(DataCapcDaoImpl.class);

    @Override
    public final DataCapcRowInternal getRow(String value, Short version) {
        if (StringUtilities.isEmpty(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("CPT/HCPCS parameter value is null/empty.");
            }
            return null;
        }
        Map<DataCapcTableInternal.DataCapcTableKey, String> key = TableKeyBuilder.createTableKeyMap(DataCapcTableInternal.DataCapcTableKey.class);
        key.put(DataCapcTableInternal.DataCapcTableKey.HCPCS, value);
        DataCapcTableInternal table = BinaryDataProvider.getInstance().getDataCapcTable();
        DataCapcRowInternal row = table.getRowInternal(key, version);
        if (logger.isDebugEnabled()) {
            logger.debug("CPT/HCPCS parameter value \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
        }
        return row;
    }

    @Override
    public final DataCapcRowInternal getRow(Hcpcs hcpcs, Short version) {
        return this.getRow(hcpcs.getValue(), version);
    }

    @Override
    public final void loadData(LineItemInternal line, Short version) {
        if (line.getFlags().anySet(LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS)) {
            if (logger.isDebugEnabled()) {
                logger.debug("No table data loaded as the CPT/HCPCS is either blank or invalid.");
            }
        } else {
            Hcpcs hcpcs = line.getHcpcs();
            Map<DataCapcTableInternal.DataCapcTableKey, String> key = TableKeyBuilder.createTableKeyMap(DataCapcTableInternal.DataCapcTableKey.class);
            key.put(DataCapcTableInternal.DataCapcTableKey.HCPCS, hcpcs.getValue());
            DataCapcTableInternal table = BinaryDataProvider.getInstance().getDataCapcTable();
            DataCapcRowInternal row = table.getRowInternal(key, version);
            if (row == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("CPT/HCPCS value \"{}\" is missing from data_capc table.", (Object)hcpcs.getValue());
                }
            } else {
                FlagSet<LineFlags> flags = line.getFlags();
                if (row.isComplexityAdjustment()) {
                    flags.set(LineFlags.DATA_CAPC_COMPLEXITY_ADJUSTMENT);
                }
                LineItemInternalTableData tableData = line.getTableData();
                tableData.setRank(row.getRank());
            }
        }
    }
}

