/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.data;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.data.MapBiosimilarDao;
import gov.cms.oce.dao.data.row.MapBiosimilarRowInternal;
import gov.cms.oce.dao.data.table.MapBiosimilarTableInternal;
import gov.cms.oce.model.internal.Hcpcs;
import gov.cms.oce.model.internal.HcpcsModifier;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.util.StringUtilities;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapBiosimilarDaoImpl
implements MapBiosimilarDao {
    private static final Logger logger = LoggerFactory.getLogger(MapBiosimilarDaoImpl.class);

    @Override
    public final MapBiosimilarRowInternal getRow(String hcpcs, String hcpcsModifier, Short version) {
        if (StringUtilities.isEmpty(hcpcs)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Biosimilar CPT/HCPCS parameter value is null/empty.");
            }
            return null;
        }
        if (StringUtilities.isEmpty(hcpcsModifier)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Biosimilar CPT/HCPCS modifier parameter value is null/empty.");
            }
            return null;
        }
        Map<MapBiosimilarTableInternal.MapBiosimilarTableKey, String> key = TableKeyBuilder.createTableKeyMap(MapBiosimilarTableInternal.MapBiosimilarTableKey.class);
        key.put(MapBiosimilarTableInternal.MapBiosimilarTableKey.HCPCS, hcpcs);
        key.put(MapBiosimilarTableInternal.MapBiosimilarTableKey.MODIFIER, hcpcsModifier);
        MapBiosimilarTableInternal table = BinaryDataProvider.getInstance().getMapBiosimilarTable();
        return table.getRowInternal(key, version);
    }

    @Override
    public final MapBiosimilarRowInternal getRow(Hcpcs hcpcs, HcpcsModifier hcpcsModifier, Short version) {
        return this.getRow(hcpcs.getValue(), hcpcsModifier.getValue(), version);
    }

    @Override
    public final MapBiosimilarRowInternal getRow(LineItemInternal line, Short version) {
        if (line.getFlags().noneSet(LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS) && 0 < line.getHcpcsModifierInputList().getCount()) {
            Map<MapBiosimilarTableInternal.MapBiosimilarTableKey, String> key = TableKeyBuilder.createTableKeyMap(MapBiosimilarTableInternal.MapBiosimilarTableKey.class);
            key.put(MapBiosimilarTableInternal.MapBiosimilarTableKey.HCPCS, line.getHcpcs().getValue());
            MapBiosimilarTableInternal table = BinaryDataProvider.getInstance().getMapBiosimilarTable();
            MapBiosimilarRowInternal row = null;
            for (HcpcsModifier modifier : line.getHcpcsModifierInputList().getValue()) {
                key.put(MapBiosimilarTableInternal.MapBiosimilarTableKey.MODIFIER, modifier.getValue());
                row = table.getRowInternal(key, version);
                if (row == null) continue;
                break;
            }
            return row;
        }
        return null;
    }
}

