/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.desc;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.binary.BinaryDescriptionProvider;
import gov.cms.oce.dao.data.table.VersionRangeTableInternal;
import gov.cms.oce.dao.desc.row.DscApcRowInternal;
import gov.cms.oce.dao.desc.table.DscApcTableInternal;
import gov.cms.oce.dao.dsc.DscApcDao;
import gov.cms.oce.model.internal.Apc;
import gov.cms.oce.util.StringUtilities;
import gov.cms.oce.util.VersionRange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscApcDaoImpl
implements DscApcDao {
    private static final Logger logger = LoggerFactory.getLogger(DscApcDaoImpl.class);

    @Override
    public final String getDescription(String value, Short version) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("APC value is null/empty.");
            }
            return "";
        }
        Map<DscApcTableInternal.DscApcTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscApcTableInternal.DscApcTableKey.class);
        key.put(DscApcTableInternal.DscApcTableKey.APC, value);
        DscApcTableInternal table = BinaryDescriptionProvider.getInstance().getDscApcTable();
        DscApcRowInternal row = table.getRowInternal(key, version);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Description for APC \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getDescription());
    }

    @Override
    public final String getDescription(Apc apc, Short version) {
        String description = this.getDescription(apc.getValue(), version);
        apc.setDescription(description);
        return description;
    }

    @Override
    public final String getLatestDescription(String value) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("APC value is null/empty.");
            }
            return "";
        }
        Map<DscApcTableInternal.DscApcTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscApcTableInternal.DscApcTableKey.class);
        key.put(DscApcTableInternal.DscApcTableKey.APC, value);
        DscApcTableInternal table = BinaryDescriptionProvider.getInstance().getDscApcTable();
        VersionRangeTableInternal versionTable = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRange versionRange = versionTable.getVersionRange();
        short firstRow = versionRange.getEarliestVersion();
        for (short indexRow = versionRange.getLatestVersion(); firstRow <= indexRow; indexRow = (short)(indexRow - 1)) {
            DscApcRowInternal row = table.getRowInternal(key, indexRow);
            if (row == null) continue;
            return StringUtilities.toNonNullString(row.getDescription());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Description for claim processing flag \"{}\" is missing from table.", (Object)value);
        }
        return "";
    }

    @Override
    public final String getLatestDescription(Apc apc) {
        String description = this.getLatestDescription(apc.getValue());
        apc.setDescription(description);
        return description;
    }
}

