/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.desc;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.binary.BinaryDescriptionProvider;
import gov.cms.oce.dao.data.table.VersionRangeTableInternal;
import gov.cms.oce.dao.desc.row.DscEditRowInternal;
import gov.cms.oce.dao.desc.table.DscEditTableInternal;
import gov.cms.oce.dao.dsc.DscEditDao;
import gov.cms.oce.model.rsc.Edit;
import gov.cms.oce.util.StringUtilities;
import gov.cms.oce.util.VersionRange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscEditDaoImpl
implements DscEditDao {
    private static final Logger logger = LoggerFactory.getLogger(DscEditDaoImpl.class);

    private final DscEditRowInternal getRow(String value, Short version) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Edit parameter is null/empty.");
            }
            return null;
        }
        Map<DscEditTableInternal.DscEditTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscEditTableInternal.DscEditTableKey.class);
        key.put(DscEditTableInternal.DscEditTableKey.EDIT, value);
        DscEditTableInternal table = BinaryDescriptionProvider.getInstance().getDscEditTable();
        return table.getRowInternal(key, version);
    }

    @Override
    public final String getDispositionId(String value, Short version) {
        DscEditRowInternal row = this.getRow(value, version);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Disposition ID for edit \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
            }
            return "";
        }
        return StringUtilities.toNonNullString(String.valueOf(row.getDispositionId()));
    }

    @Override
    public final String getName(String value, Short version) {
        DscEditRowInternal row = this.getRow(value, version);
        if (row == null) {
            logger.debug("Name for edit \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
            return "";
        }
        return StringUtilities.toNonNullString(row.getName());
    }

    @Override
    public final String getDescription(String value, Short version) {
        DscEditRowInternal row = this.getRow(value, version);
        if (row == null) {
            logger.debug("Description for edit \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
            return "";
        }
        return StringUtilities.toNonNullString(row.getDescription());
    }

    @Override
    public final String getDescription(Edit edit, Short version) {
        String description = this.getDescription(String.valueOf(edit.getEditValue().getValue()), version);
        edit.setDescription(description);
        return description;
    }

    private final DscEditRowInternal getLatestRow(String value) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Edit parameter is null/empty.");
            }
            return null;
        }
        Map<DscEditTableInternal.DscEditTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscEditTableInternal.DscEditTableKey.class);
        key.put(DscEditTableInternal.DscEditTableKey.EDIT, value);
        DscEditTableInternal table = BinaryDescriptionProvider.getInstance().getDscEditTable();
        VersionRangeTableInternal versionTable = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRange versionRange = versionTable.getVersionRange();
        short firstRow = versionRange.getEarliestVersion();
        for (short indexRow = versionRange.getLatestVersion(); firstRow <= indexRow; indexRow = (short)(indexRow - 1)) {
            DscEditRowInternal row = table.getRowInternal(key, indexRow);
            if (row == null) continue;
            return row;
        }
        return null;
    }

    @Override
    public final String getLatestDispositionId(String value) {
        DscEditRowInternal row = this.getLatestRow(value);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Disposition ID for edit \"{}\" is missing from table.", (Object)value);
            }
            return "";
        }
        return StringUtilities.toNonNullString(String.valueOf(row.getDispositionId()));
    }

    @Override
    public final String getLatestName(String value) {
        DscEditRowInternal row = this.getLatestRow(value);
        if (row == null) {
            logger.debug("Name for edit \"{}\" is missing from table.", (Object)value);
            return "";
        }
        return StringUtilities.toNonNullString(row.getName());
    }

    @Override
    public final String getLatestDescription(String value) {
        DscEditRowInternal row = this.getLatestRow(value);
        if (row == null) {
            logger.debug("Description for edit \"{}\" is missing from table.", (Object)value);
            return "";
        }
        return StringUtilities.toNonNullString(row.getDescription());
    }

    @Override
    public final String getLatestDescription(Edit edit) {
        String description = this.getLatestDescription(String.valueOf(edit.getEditValue().getValue()));
        edit.setDescription(description);
        return description;
    }
}

