/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.desc;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.binary.BinaryDescriptionProvider;
import gov.cms.oce.dao.data.table.VersionRangeTableInternal;
import gov.cms.oce.dao.desc.row.DscPaymentIndicatorRowInternal;
import gov.cms.oce.dao.desc.table.DscPaymentIndicatorTableInternal;
import gov.cms.oce.dao.dsc.DscPaymentIndicatorDao;
import gov.cms.oce.model.internal.PaymentIndicator;
import gov.cms.oce.util.StringUtilities;
import gov.cms.oce.util.VersionRange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscPaymentIndicatorDaoImpl
implements DscPaymentIndicatorDao {
    private static final Logger logger = LoggerFactory.getLogger(DscPaymentIndicatorDaoImpl.class);

    @Override
    public final String getDescription(String value, Short version) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Payment indicator parameter is null/empty.");
            }
            return "";
        }
        Map<DscPaymentIndicatorTableInternal.DscPaymentIndicatorTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscPaymentIndicatorTableInternal.DscPaymentIndicatorTableKey.class);
        key.put(DscPaymentIndicatorTableInternal.DscPaymentIndicatorTableKey.PAYMENT_INDICATOR, value);
        DscPaymentIndicatorTableInternal table = BinaryDescriptionProvider.getInstance().getDscPaymentIndicatorTable();
        DscPaymentIndicatorRowInternal row = table.getRowInternal(key, version);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Description for payment indicator \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getDescription());
    }

    @Override
    public final String getDescription(PaymentIndicator paymentIndicator, Short version) {
        String description = this.getDescription(String.valueOf(paymentIndicator.getValue()), version);
        paymentIndicator.setDescription(description);
        return description;
    }

    @Override
    public final String getLatestDescription(String value) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Payment indicator parameter is null/empty.");
            }
            return "";
        }
        Map<DscPaymentIndicatorTableInternal.DscPaymentIndicatorTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscPaymentIndicatorTableInternal.DscPaymentIndicatorTableKey.class);
        key.put(DscPaymentIndicatorTableInternal.DscPaymentIndicatorTableKey.PAYMENT_INDICATOR, value);
        DscPaymentIndicatorTableInternal table = BinaryDescriptionProvider.getInstance().getDscPaymentIndicatorTable();
        VersionRangeTableInternal versionTable = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRange versionRange = versionTable.getVersionRange();
        short firstRow = versionRange.getEarliestVersion();
        for (short indexRow = versionRange.getLatestVersion(); firstRow <= indexRow; indexRow = (short)(indexRow - 1)) {
            DscPaymentIndicatorRowInternal row = table.getRowInternal(key, indexRow);
            if (row == null) continue;
            return StringUtilities.toNonNullString(row.getDescription());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Description for payment indicator \"{}\" is missing from table.", (Object)value);
        }
        return "";
    }

    @Override
    public final String getLatestDescription(PaymentIndicator paymentIndicator) {
        String description = this.getLatestDescription(String.valueOf(paymentIndicator.getValue()));
        paymentIndicator.setDescription(description);
        return description;
    }
}

