/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.binary.desc;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.binary.BinaryDataProvider;
import gov.cms.oce.dao.binary.BinaryDescriptionProvider;
import gov.cms.oce.dao.data.table.VersionRangeTableInternal;
import gov.cms.oce.dao.desc.row.DscPmfRowInternal;
import gov.cms.oce.dao.desc.table.DscPmfTableInternal;
import gov.cms.oce.dao.dsc.DscPmfDao;
import gov.cms.oce.model.internal.PaymentMethodFlag;
import gov.cms.oce.util.StringUtilities;
import gov.cms.oce.util.VersionRange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscPmfDaoImpl
implements DscPmfDao {
    private static final Logger logger = LoggerFactory.getLogger(DscPmfDaoImpl.class);

    @Override
    public final String getDescription(String value, Short version) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Payment method flag parameter is null/empty.");
            }
            return "";
        }
        Map<DscPmfTableInternal.DscPmfTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscPmfTableInternal.DscPmfTableKey.class);
        key.put(DscPmfTableInternal.DscPmfTableKey.VALUE, value);
        DscPmfTableInternal table = BinaryDescriptionProvider.getInstance().getDscPmfTable();
        DscPmfRowInternal row = table.getRowInternal(key, version);
        if (row == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Description for payment method flag \"{}\" is missing from table for version \"{}\".", (Object)value, (Object)version);
            }
            return "";
        }
        return StringUtilities.toNonNullString(row.getDescription());
    }

    @Override
    public final String getDescription(PaymentMethodFlag paymentMethodFlag, Short version) {
        String description = this.getDescription(paymentMethodFlag.getValue(), version);
        paymentMethodFlag.setDescription(description);
        return description;
    }

    @Override
    public final String getLatestDescription(String value) {
        if ("".equals(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Payment method flag parameter is null/empty.");
            }
            return "";
        }
        Map<DscPmfTableInternal.DscPmfTableKey, String> key = TableKeyBuilder.createTableKeyMap(DscPmfTableInternal.DscPmfTableKey.class);
        key.put(DscPmfTableInternal.DscPmfTableKey.VALUE, value);
        DscPmfTableInternal table = BinaryDescriptionProvider.getInstance().getDscPmfTable();
        VersionRangeTableInternal versionTable = BinaryDataProvider.getInstance().getVersionRangeTable();
        VersionRange versionRange = versionTable.getVersionRange();
        short firstRow = versionRange.getEarliestVersion();
        for (short indexRow = versionRange.getLatestVersion(); firstRow <= indexRow; indexRow = (short)(indexRow - 1)) {
            DscPmfRowInternal row = table.getRowInternal(key, indexRow);
            if (row == null) continue;
            return StringUtilities.toNonNullString(row.getDescription());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Description for payment method flag \"{}\" is missing from table.", (Object)value);
        }
        return "";
    }

    @Override
    public final String getLatestDescription(PaymentMethodFlag paymentMethodFlag) {
        String description = this.getLatestDescription(String.valueOf(paymentMethodFlag.getValue()));
        paymentMethodFlag.setDescription(description);
        return description;
    }
}

