/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.dao.data.table;

import gov.cms.oce.dao.TableKeyBuilder;
import gov.cms.oce.dao.data.row.DataModifierRowInternal;
import gov.cms.oce.model.rsc.TableFlags;
import gov.cms.oce.util.FlagSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataModifierTableInternal {
    private static final Logger logger = LoggerFactory.getLogger(DataModifierTableInternal.class);
    private FlagSet<TableFlags> flags = new FlagSet<TableFlags>(TableFlags.class);
    private Map<String, List<DataModifierRowInternal>> table;

    private DataModifierTableInternal() {
        this(null);
    }

    public DataModifierTableInternal(Map<String, List<DataModifierRowInternal>> table) {
        this.table = table;
    }

    public final FlagSet<TableFlags> getFlags() {
        return this.flags;
    }

    public final List<DataModifierRowInternal> getRowInternal(Map<DataModifierTableKey, String> tableKey) {
        List<DataModifierRowInternal> rowSet = this.table.get(TableKeyBuilder.createTableKey(tableKey));
        return rowSet == null || rowSet.isEmpty() ? Collections.emptyList() : rowSet;
    }

    public final DataModifierRowInternal getRowInternal(Map<DataModifierTableKey, String> tableKey, short version) {
        for (DataModifierRowInternal row : this.getRowInternal(tableKey)) {
            if (row.getLoVersion() > version || version > row.getHiVersion()) continue;
            return row;
        }
        return null;
    }

    public static enum DataModifierTableKey {
        MODIFIER;

    }
}

