/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDescriptionTableDefinition;
import gov.cms.oce.ext.table.desc.DescriptionSchema;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BinaryDescriptionTableCreator {
    private static final Logger logger = LoggerFactory.getLogger(BinaryDescriptionTableCreator.class);

    private final File getFile(String filePath) {
        return new File(filePath);
    }

    public final void load(DescriptionSchema.Builder schemaBuilder, BinaryDescriptionTableDefinition binaryTableDefinition) {
        File source = this.getFile(binaryTableDefinition.getFilePath());
        if (source == null || !source.exists()) {
            logger.error("File: \"{}\" failed to be loaded (does not exist).", (Object)binaryTableDefinition.getFilePath());
            return;
        }
        try (LineNumberReader r = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(source), StandardCharsets.UTF_8));){
            StringBuilder dataBuffer = new StringBuilder(512);
            boolean inQuote = false;
            String line = null;
            while ((line = r.readLine()) != null) {
                if (r.getLineNumber() == 1) continue;
                binaryTableDefinition.initialize();
                int columnIndex = 0;
                char p = '\u0000';
                for (int i = 0; i < line.length(); ++i) {
                    char c = line.charAt(i);
                    if (inQuote) {
                        if (i == line.length() - 1 || c == ',' && p == '\"') {
                            binaryTableDefinition.addColumnData(r.getLineNumber(), columnIndex, dataBuffer.toString());
                            dataBuffer.delete(0, dataBuffer.length());
                            inQuote = false;
                            ++columnIndex;
                        } else if (c != '\"') {
                            if (0 < dataBuffer.length() && p == '\"') {
                                dataBuffer.append(p);
                            }
                            dataBuffer.append(c);
                        }
                    } else if (c == '\"') {
                        inQuote = true;
                    }
                    p = c;
                }
                binaryTableDefinition.finalizeRow();
            }
            binaryTableDefinition.attachTable(schemaBuilder);
        }
        catch (FileNotFoundException e) {
            logger.error("File not found.", e);
        }
        catch (IOException e) {
            logger.error("File failed to be read.", e);
        }
        catch (Exception e) {
            logger.error("Unspecified exception.", e);
        }
    }
}

