/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDataTableCreator;
import gov.cms.oce.ext.table.builder.BinaryDataTableDefinition;
import gov.cms.oce.ext.table.builder.BinaryDescriptionTableCreator;
import gov.cms.oce.ext.table.builder.BinaryDescriptionTableDefinition;
import gov.cms.oce.ext.table.builder.DataApcTableDefinition;
import gov.cms.oce.ext.table.builder.DataCapcTableDefinition;
import gov.cms.oce.ext.table.builder.DataDiscountFormulaTableDefinition;
import gov.cms.oce.ext.table.builder.DataDx10TableDefinition;
import gov.cms.oce.ext.table.builder.DataEditBypassTableDefinition;
import gov.cms.oce.ext.table.builder.DataHcpcsTableDefinition;
import gov.cms.oce.ext.table.builder.DataModifierTableDefinition;
import gov.cms.oce.ext.table.builder.DataRevenueTableDefinition;
import gov.cms.oce.ext.table.builder.DscClaimDispositionTableDefinition;
import gov.cms.oce.ext.table.builder.DscClaimDispositionValueTableDefinition;
import gov.cms.oce.ext.table.builder.DscCpfTableDefinition;
import gov.cms.oce.ext.table.builder.DscEditDispositionTableDefinition;
import gov.cms.oce.ext.table.builder.DscEditTableDefinition;
import gov.cms.oce.ext.table.builder.DscErrorTableDefinition;
import gov.cms.oce.ext.table.builder.DscLiafTableDefinition;
import gov.cms.oce.ext.table.builder.DscLidrfTableDefinition;
import gov.cms.oce.ext.table.builder.DscPafTableDefinition;
import gov.cms.oce.ext.table.builder.DscPaymentIndicatorTableDefinition;
import gov.cms.oce.ext.table.builder.DscPkgTableDefinition;
import gov.cms.oce.ext.table.builder.DscPmfTableDefinition;
import gov.cms.oce.ext.table.builder.DscStatusIndicatorTableDefinition;
import gov.cms.oce.ext.table.builder.DscValueCodeTableDefinition;
import gov.cms.oce.ext.table.builder.MapAddonCovidLabTableDefinition;
import gov.cms.oce.ext.table.builder.MapAddonDrugAdminTableDefinition;
import gov.cms.oce.ext.table.builder.MapAddonPhTableDefinition;
import gov.cms.oce.ext.table.builder.MapAddonType1TableDefinition;
import gov.cms.oce.ext.table.builder.MapAddonType2TableDefinition;
import gov.cms.oce.ext.table.builder.MapAddonType3TableDefinition;
import gov.cms.oce.ext.table.builder.MapBiosimilarTableDefinition;
import gov.cms.oce.ext.table.builder.MapCapcTableDefinition;
import gov.cms.oce.ext.table.builder.MapCompositeTableDefinition;
import gov.cms.oce.ext.table.builder.MapConflictRhcTableDefinition;
import gov.cms.oce.ext.table.builder.MapFqhcVisitTableDefinition;
import gov.cms.oce.ext.table.builder.MapModifierConflictTableDefinition;
import gov.cms.oce.ext.table.builder.MapNcciTableLeftCodesDefinition;
import gov.cms.oce.ext.table.builder.MapNcciTableRightCodesDefinition;
import gov.cms.oce.ext.table.builder.MapS603OverrideTableDefinition;
import gov.cms.oce.ext.table.builder.OffsetApcTableDefinition;
import gov.cms.oce.ext.table.builder.OffsetCodepairTableDefinition;
import gov.cms.oce.ext.table.builder.OffsetHcpcsTableDefinition;
import gov.cms.oce.ext.table.builder.VersionRangeTableDefinition;
import gov.cms.oce.ext.table.data.DataSchema;
import gov.cms.oce.ext.table.desc.DescriptionSchema;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BinarySchemaCreator {
    private static final Logger logger = LoggerFactory.getLogger(BinarySchemaCreator.class);

    private BinarySchemaCreator() {
    }

    public static final boolean isValid(String filePath) {
        File directory;
        if (filePath != null && !"".equals(filePath.trim()) && (directory = new File(filePath)).exists() && directory.isDirectory()) {
            return true;
        }
        logger.error("Parameters must be valid directory paths.");
        return false;
    }

    public static final void main(String[] filePaths) {
        if (filePaths.length != 2) {
            logger.error("Two parameters required: 1. path to input directory for tables (*.txt); 2. path to output directory for schema (*.bin)");
        }
        if (BinarySchemaCreator.isValid(filePaths[0]) && BinarySchemaCreator.isValid(filePaths[1])) {
            String inputPath = filePaths[0].replace('\\', '/');
            String outputPath = filePaths[1].replace('\\', '/');
            DataSchema.Builder dataSchemaBuilder = DataSchema.newBuilder();
            ArrayList<BinaryDataTableDefinition> dataTableDefinitionList = new ArrayList<BinaryDataTableDefinition>();
            dataTableDefinitionList.add(new DataApcTableDefinition(inputPath + "Data_APC.txt"));
            dataTableDefinitionList.add(new DataCapcTableDefinition(inputPath + "Data_CAPC.txt"));
            dataTableDefinitionList.add(new DataDiscountFormulaTableDefinition(inputPath + "Data_Discount_Formula.txt"));
            dataTableDefinitionList.add(new DataDx10TableDefinition(inputPath + "Data_DX10.txt"));
            dataTableDefinitionList.add(new DataEditBypassTableDefinition(inputPath + "Data_Edit_Bypass.txt"));
            dataTableDefinitionList.add(new DataHcpcsTableDefinition(inputPath + "Data_HCPCS.txt"));
            dataTableDefinitionList.add(new DataModifierTableDefinition(inputPath + "Data_Modifier.txt"));
            dataTableDefinitionList.add(new DataRevenueTableDefinition(inputPath + "Data_Revenue.txt"));
            dataTableDefinitionList.add(new MapAddonCovidLabTableDefinition(inputPath + "Map_Addon_Covid_Lab.txt"));
            dataTableDefinitionList.add(new MapAddonDrugAdminTableDefinition(inputPath + "Map_Addon_Drug_Admin.txt"));
            dataTableDefinitionList.add(new MapAddonPhTableDefinition(inputPath + "Map_PH_Addon.txt"));
            dataTableDefinitionList.add(new MapAddonType1TableDefinition(inputPath + "Map_Addon_Type1.txt"));
            dataTableDefinitionList.add(new MapAddonType2TableDefinition(inputPath + "Map_Addon_Type2.txt"));
            dataTableDefinitionList.add(new MapAddonType3TableDefinition(inputPath + "Map_Addon_Type3.txt"));
            dataTableDefinitionList.add(new MapBiosimilarTableDefinition(inputPath + "Map_Biosimilar.txt"));
            dataTableDefinitionList.add(new MapCapcTableDefinition(inputPath + "Map_CAPC.txt"));
            dataTableDefinitionList.add(new MapCompositeTableDefinition(inputPath + "Map_Composite.txt"));
            dataTableDefinitionList.add(new MapConflictRhcTableDefinition(inputPath + "Map_Conflict_RHC.txt"));
            dataTableDefinitionList.add(new MapFqhcVisitTableDefinition(inputPath + "Map_FQHC_Visit.txt"));
            dataTableDefinitionList.add(new MapModifierConflictTableDefinition(inputPath + "Map_Modifier_Conflict.txt"));
            dataTableDefinitionList.add(new MapS603OverrideTableDefinition(inputPath + "Map_S603_Override.txt"));
            dataTableDefinitionList.add(new OffsetApcTableDefinition(inputPath + "Offset_APC.txt"));
            dataTableDefinitionList.add(new OffsetCodepairTableDefinition(inputPath + "Offset_Codepair.txt"));
            dataTableDefinitionList.add(new OffsetHcpcsTableDefinition(inputPath + "Offset_HCPCS.txt"));
            dataTableDefinitionList.add(new VersionRangeTableDefinition(inputPath + "Version_Range.txt"));
            dataTableDefinitionList.add(new MapNcciTableLeftCodesDefinition(inputPath + "Map_NCCI_leftCodes.txt"));
            dataTableDefinitionList.add(new MapNcciTableRightCodesDefinition(inputPath + "Map_NCCI_rightCodes.txt"));
            BinaryDataTableCreator dataTableCreator = new BinaryDataTableCreator();
            for (BinaryDataTableDefinition binaryDataTableDefinition : dataTableDefinitionList) {
                if (logger.isInfoEnabled()) {
                    logger.info("Compiling \"{}\"", (Object)binaryDataTableDefinition.getFilePath());
                }
                dataTableCreator.load(dataSchemaBuilder, binaryDataTableDefinition);
            }
            try {
                Throwable throwable = null;
                try (FileOutputStream fileOutputStream = new FileOutputStream(outputPath + "ioce-data.bin");){
                    dataSchemaBuilder.build().writeTo(fileOutputStream);
                    if (logger.isInfoEnabled()) {
                        logger.info("Data tables compiled to {}ioce-data.bin.{}", (Object)outputPath, (Object)System.lineSeparator());
                    }
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e) {
                logger.error("IOException:", e);
            }
            DescriptionSchema.Builder descriptionSchemaBuilder = DescriptionSchema.newBuilder();
            ArrayList<BinaryDescriptionTableDefinition> arrayList = new ArrayList<BinaryDescriptionTableDefinition>();
            arrayList.add(new DscClaimDispositionTableDefinition(inputPath + "DSC_Claim_Disposition.txt"));
            arrayList.add(new DscClaimDispositionValueTableDefinition(inputPath + "DSC_Claim_Disposition_Value.txt"));
            arrayList.add(new DscCpfTableDefinition(inputPath + "DSC_CPF.txt"));
            arrayList.add(new DscEditTableDefinition(inputPath + "DSC_Edit.txt"));
            arrayList.add(new DscEditDispositionTableDefinition(inputPath + "DSC_Edit_Disposition.txt"));
            arrayList.add(new DscErrorTableDefinition(inputPath + "DSC_Error.txt"));
            arrayList.add(new DscLiafTableDefinition(inputPath + "DSC_LIAF.txt"));
            arrayList.add(new DscLidrfTableDefinition(inputPath + "DSC_LIDRF.txt"));
            arrayList.add(new DscPafTableDefinition(inputPath + "DSC_PAF.txt"));
            arrayList.add(new DscPkgTableDefinition(inputPath + "DSC_PKG.txt"));
            arrayList.add(new DscPmfTableDefinition(inputPath + "DSC_PMF.txt"));
            arrayList.add(new DscValueCodeTableDefinition(inputPath + "DSC_Value_Code.txt"));
            arrayList.add(new DscPaymentIndicatorTableDefinition(inputPath + "Data_Payment_Indicator.txt"));
            arrayList.add(new DscStatusIndicatorTableDefinition(inputPath + "Data_Status_Indicator.txt"));
            BinaryDescriptionTableCreator descriptionTableCreator = new BinaryDescriptionTableCreator();
            for (BinaryDescriptionTableDefinition binaryTableDefinition : arrayList) {
                if (logger.isInfoEnabled()) {
                    logger.info("Compiling \"{}\"", (Object)binaryTableDefinition.getFilePath());
                }
                descriptionTableCreator.load(descriptionSchemaBuilder, binaryTableDefinition);
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(outputPath + "ioce-desc.bin");){
                descriptionSchemaBuilder.build().writeTo(fileOutputStream);
                if (logger.isInfoEnabled()) {
                    logger.info("Descripton tables compiled to {}ioce-desc.bin.{}", (Object)outputPath, (Object)System.lineSeparator());
                }
            }
            catch (IOException e) {
                logger.error("IOException:", e);
            }
            if (logger.isInfoEnabled()) {
                logger.info("All tables compiled.");
            }
        }
    }
}

