/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDataTableDefinition;
import gov.cms.oce.ext.table.data.DataEditBypassRow;
import gov.cms.oce.ext.table.data.DataEditBypassTable;
import gov.cms.oce.ext.table.data.DataSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataEditBypassTableDefinition
implements BinaryDataTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(DataEditBypassTableDefinition.class);
    private final String filePath;
    private final DataEditBypassTable.Builder tableBuilder;
    private final DataEditBypassRow.Builder rowBuilder;

    DataEditBypassTableDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = DataEditBypassTable.newBuilder();
        this.rowBuilder = DataEditBypassRow.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DataSchema.Builder schemaBuilder) {
        schemaBuilder.setDataEditBypassTable(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case EDIT: {
                this.rowBuilder.setEdit(Integer.parseInt(data, 10));
                break;
            }
            case LO_VERSION: {
                this.rowBuilder.setLoVersion(Integer.parseInt(data, 10));
                break;
            }
            case HI_VERSION: {
                this.rowBuilder.setHiVersion(Integer.parseInt(data, 10));
                break;
            }
            case LINE_BYPASS_REQUIRED: {
                this.rowBuilder.setLineBypassRequired("1".equals(data));
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        EDIT,
        LO_VERSION,
        HI_VERSION,
        LINE_BYPASS_REQUIRED;

    }
}

