/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDataTableDefinition;
import gov.cms.oce.ext.table.data.DataHcpcsRow;
import gov.cms.oce.ext.table.data.DataHcpcsTable;
import gov.cms.oce.ext.table.data.DataSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataHcpcsTableDefinition
implements BinaryDataTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(DataHcpcsTableDefinition.class);
    private final String filePath;
    private final DataHcpcsTable.Builder tableBuilder;
    private final DataHcpcsRow.Builder rowBuilder;

    DataHcpcsTableDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = DataHcpcsTable.newBuilder();
        this.rowBuilder = DataHcpcsRow.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DataSchema.Builder schemaBuilder) {
        schemaBuilder.setDataHcpcsTable(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case HCPCS: {
                this.rowBuilder.setHcpcs(data);
                break;
            }
            case LO_VERSION: {
                this.rowBuilder.setLoVersion(Integer.parseInt(data, 10));
                break;
            }
            case HI_VERSION: {
                this.rowBuilder.setHiVersion(Integer.parseInt(data, 10));
                break;
            }
            case DESCRIPTION: {
                this.rowBuilder.setDescription(data);
                break;
            }
            case APC: {
                this.rowBuilder.setApc(data);
                break;
            }
            case LO_AGE: {
                this.rowBuilder.setLoAge(Integer.parseInt(data, 10));
                break;
            }
            case HI_AGE: {
                this.rowBuilder.setHiAge(Integer.parseInt(data, 10));
                break;
            }
            case SEX: {
                this.rowBuilder.setSex(Integer.parseInt(data, 10));
                break;
            }
            case STATUS_INDICATOR: {
                this.rowBuilder.setStatusIndicator(data);
                break;
            }
            case PAYMENT_INDICATOR: {
                this.rowBuilder.setPaymentIndicator(Integer.parseInt(data, 10));
                break;
            }
            case QUESTIONABLE: {
                this.rowBuilder.setQuestionable("1".equals(data));
                break;
            }
            case NOT_RECOGNIZED_MCARE: {
                this.rowBuilder.setNotRecognizedMcare("1".equals(data));
                break;
            }
            case NOT_RECOGNIZED_OPPS: {
                this.rowBuilder.setNotRecognizedOpps("1".equals(data));
                break;
            }
            case NON_COVERED: {
                this.rowBuilder.setNonCovered("1".equals(data));
                break;
            }
            case NON_REPORTABLE_SITE: {
                this.rowBuilder.setNonReportableSite("1".equals(data));
                break;
            }
            case BILATERAL_CONDITIONAL: {
                this.rowBuilder.setBilateralConditional("1".equals(data));
                break;
            }
            case BILATERAL_INDEPENDENT: {
                this.rowBuilder.setBilateralIndependent("1".equals(data));
                break;
            }
            case BILATERAL_INHERENT: {
                this.rowBuilder.setBilateralInherent("1".equals(data));
                break;
            }
            case NCCI_CODE1: {
                this.rowBuilder.setNcciCode1("1".equals(data));
                break;
            }
            case NCCI_CODE2: {
                this.rowBuilder.setNcciCode2("1".equals(data));
                break;
            }
            case VACCINE: {
                this.rowBuilder.setVaccine("1".equals(data));
                break;
            }
            case ANTIGEN: {
                this.rowBuilder.setAntigen("1".equals(data));
                break;
            }
            case SPLINT: {
                this.rowBuilder.setSplint("1".equals(data));
                break;
            }
            case CAST: {
                this.rowBuilder.setCast("1".equals(data));
                break;
            }
            case NEGATIVE_PRESSURE_WOUND_THERAPY: {
                this.rowBuilder.setNegativePressureWoundTherapy("1".equals(data));
                break;
            }
            case SOMETIMES_THERAPY: {
                this.rowBuilder.setSometimesTherapy("1".equals(data));
                break;
            }
            case ACTIVITY_THERAPY: {
                this.rowBuilder.setActivityTherapy("1".equals(data));
                break;
            }
            case OCCUPATIONAL_THERAPY: {
                this.rowBuilder.setOccupationalTherapy("1".equals(data));
                break;
            }
            case DEDUCTIBLE_NA: {
                this.rowBuilder.setDeductibleNa("1".equals(data));
                break;
            }
            case DEDUCTIBLE_COINS_NA: {
                this.rowBuilder.setDeductibleCoinsNa("1".equals(data));
                break;
            }
            case COINS_NA: {
                this.rowBuilder.setCoinsNa("1".equals(data));
                break;
            }
            case BLOOD_SERVICE: {
                this.rowBuilder.setBloodService("1".equals(data));
                break;
            }
            case BLOOD_PRODUCT: {
                this.rowBuilder.setBloodProduct("1".equals(data));
                break;
            }
            case PACKED_RED_CELLS: {
                this.rowBuilder.setPackedRedCells("1".equals(data));
                break;
            }
            case WHOLE_BLOOD: {
                this.rowBuilder.setWholeBlood("1".equals(data));
                break;
            }
            case EDUCATIONAL: {
                this.rowBuilder.setEducational("1".equals(data));
                break;
            }
            case OBSERVATION: {
                this.rowBuilder.setObservation("1".equals(data));
                break;
            }
            case OBSERVATION_HOURLY: {
                this.rowBuilder.setObservationHourly("1".equals(data));
                break;
            }
            case OBSERVATION_DIRECT_ADMIT: {
                this.rowBuilder.setObservationDirectAdmit("1".equals(data));
                break;
            }
            case OBSERVATION_HOSPITAL_ONLY: {
                this.rowBuilder.setObservationHospitalOnly("1".equals(data));
                break;
            }
            case TRAUMA_REVENUE_CODE: {
                this.rowBuilder.setTraumaRevenueCode("1".equals(data));
                break;
            }
            case TRAUMA_CRITICAL_CARE: {
                this.rowBuilder.setTraumaCriticalCare("1".equals(data));
                break;
            }
            case CRITICAL_CARE_ANCILLARY: {
                this.rowBuilder.setCriticalCareAncillary("1".equals(data));
                break;
            }
            case STV_PACKAGED: {
                this.rowBuilder.setStvPackaged("1".equals(data));
                break;
            }
            case T_PACKAGED: {
                this.rowBuilder.setTPackaged("1".equals(data));
                break;
            }
            case HAS_DEV_REQ_PROC: {
                this.rowBuilder.setHasDevReqProc("1".equals(data));
                break;
            }
            case SEPARATE_PROCEDURE: {
                this.rowBuilder.setSeparateProcedure("1".equals(data));
                break;
            }
            case STATUTORY_EXCLUSION: {
                this.rowBuilder.setStatutoryExclusion("1".equals(data));
                break;
            }
            case DMERC_BILLABLE_ONLY: {
                this.rowBuilder.setDmercBillableOnly("1".equals(data));
                break;
            }
            case UNCLASSIFIED_DRUG: {
                this.rowBuilder.setUnclassifiedDrug("1".equals(data));
                break;
            }
            case RADIO_PHARM: {
                this.rowBuilder.setRadioPharm("1".equals(data));
                break;
            }
            case NUCLEAR_MED: {
                this.rowBuilder.setNuclearMed("1".equals(data));
                break;
            }
            case MID_QUARTER_DATE_EDIT: {
                this.rowBuilder.setMidQuarterDateEdit(Integer.parseInt(data, 10));
                break;
            }
            case DATE_APPROVED: {
                this.rowBuilder.setDateApproved(Integer.parseInt(data, 10));
                break;
            }
            case DATE_TERMINATED: {
                this.rowBuilder.setDateTerminated(Integer.parseInt(data, 10));
                break;
            }
            case NON_BILLABLE_MAC: {
                this.rowBuilder.setNonBillableMac("1".equals(data));
                break;
            }
            case HAS_DEVICE_PAIR1: {
                this.rowBuilder.setHasDevicePair1("1".equals(data));
                break;
            }
            case HAS_DEVICE_PAIR2: {
                this.rowBuilder.setHasDevicePair2("1".equals(data));
                break;
            }
            case PH_PRIMARY: {
                this.rowBuilder.setPhPrimary("1".equals(data));
                break;
            }
            case PH_SERVICE: {
                this.rowBuilder.setPhService("1".equals(data));
                break;
            }
            case DAILY_MENTAL_HEALTH: {
                this.rowBuilder.setDailyMentalHealth("1".equals(data));
                break;
            }
            case MH_NOT_PH: {
                this.rowBuilder.setMhNotPh("1".equals(data));
                break;
            }
            case PH_NOT_MH: {
                this.rowBuilder.setPhNotMh("1".equals(data));
                break;
            }
            case PH_DURATION: {
                this.rowBuilder.setPhDuration(Integer.parseInt(data, 10));
                break;
            }
            case PH_ADDON: {
                this.rowBuilder.setPhAddon("1".equals(data));
                break;
            }
            case TOKEN_CHARGE_ONLY: {
                this.rowBuilder.setTokenChargeOnly("1".equals(data));
                break;
            }
            case SKIN_SUBSTITUTE_SG: {
                this.rowBuilder.setSkinSubstituteSg("1".equals(data));
                break;
            }
            case SKIN_SUBSTITUTE: {
                this.rowBuilder.setSkinSubstitute("1".equals(data));
                break;
            }
            case CAPC_EXCLUSION: {
                this.rowBuilder.setCapcExclusion("1".equals(data));
                break;
            }
            case CAPC_SRS_PLAN_AND_PREP: {
                this.rowBuilder.setCapcSrsPlanAndPrep("1".equals(data));
                break;
            }
            case DEVICE_PROCEDURE: {
                this.rowBuilder.setDeviceProcedure("1".equals(data));
                break;
            }
            case DEVICE: {
                this.rowBuilder.setDevice("1".equals(data));
                break;
            }
            case SKIN_SUBSTITUTE_SG_LO: {
                this.rowBuilder.setSkinSubstituteSgLo("1".equals(data));
                break;
            }
            case SKIN_SUBSTITUTE_LO: {
                this.rowBuilder.setSkinSubstituteLo("1".equals(data));
                break;
            }
            case SKIN_SUBSTITUTE_SG_HI: {
                this.rowBuilder.setSkinSubstituteSgHi("1".equals(data));
                break;
            }
            case SKIN_SUBSTITUTE_HI: {
                this.rowBuilder.setSkinSubstituteHi("1".equals(data));
                break;
            }
            case LAB_SERVICE: {
                this.rowBuilder.setLabService("1".equals(data));
                break;
            }
            case FQHC_PREVENTIVE: {
                this.rowBuilder.setFqhcPreventive("1".equals(data));
                break;
            }
            case FQHC_FLU_PPV: {
                this.rowBuilder.setFqhcFluPpv("1".equals(data));
                break;
            }
            case FQHC_NON_COVERED: {
                this.rowBuilder.setFqhcNonCovered("1".equals(data));
                break;
            }
            case FQHC_ADDON: {
                this.rowBuilder.setFqhcAddon("1".equals(data));
                break;
            }
            case FQHC_PRIMARY: {
                this.rowBuilder.setFqhcPrimary("1".equals(data));
                break;
            }
            case FQHC_CHRONIC_CARE: {
                this.rowBuilder.setFqhcChronicCare("1".equals(data));
                break;
            }
            case RHC_MODIFIER_CONFLICT: {
                this.rowBuilder.setRhcModifierConflict("1".equals(data));
                break;
            }
            case BYPASS_E72_FQHC_RHC: {
                this.rowBuilder.setBypassE72FqhcRhc("1".equals(data));
                break;
            }
            case DEV_PROC_BYPASS: {
                this.rowBuilder.setDevProcBypass("1".equals(data));
                break;
            }
            case CORNEA_TRANSPLANT: {
                this.rowBuilder.setCorneaTransplant("1".equals(data));
                break;
            }
            case CORNEA_TISSUE_PROCESSING: {
                this.rowBuilder.setCorneaTissueProcessing("1".equals(data));
                break;
            }
            case ADVANCE_CARE_PLANNING: {
                this.rowBuilder.setAdvanceCarePlanning("1".equals(data));
                break;
            }
            case ANNUAL_WELLNESS_VISIT: {
                this.rowBuilder.setAnnualWellnessvisit("1".equals(data));
                break;
            }
            case TERMINATED_DEVICE_PROCEDURE: {
                this.rowBuilder.setTerminatedDeviceProcedure("1".equals(data));
                break;
            }
            case PASSTHROUGH_DEVICE: {
                this.rowBuilder.setPassthroughDevice("1".equals(data));
                break;
            }
            case PASSTHROUGH_RADIOPHARM: {
                this.rowBuilder.setPassthroughRadiopharm("1".equals(data));
                break;
            }
            case PASSTHROUGH_SKIN_PRODUCT: {
                this.rowBuilder.setPassthroughSkinProduct("1".equals(data));
                break;
            }
            case PASSTHROUGH_CONTRAST: {
                this.rowBuilder.setPassthroughContrast("1".equals(data));
                break;
            }
            case PASSTHROUGH_STRESS_AGENT: {
                this.rowBuilder.setPassthroughStressAgent("1".equals(data));
                break;
            }
            case NON_STANDARD_CT_SCAN: {
                this.rowBuilder.setNonStandardCtScan("1".equals(data));
                break;
            }
            case FILM_XRAY: {
                this.rowBuilder.setFilmXray("1".equals(data));
                break;
            }
            case ALLOGENEIC_TRANSPLANT: {
                this.rowBuilder.setAllogeneicTransplant("1".equals(data));
                break;
            }
            case BYPASS_E99: {
                this.rowBuilder.setBypassE99("1".equals(data));
                break;
            }
            case OVERRIDE_SECTION_603: {
                this.rowBuilder.setOverrideSection603("1".equals(data));
                break;
            }
            case ADDON_TYPE1: {
                this.rowBuilder.setAddonType1("1".equals(data));
                break;
            }
            case ADDON_TYPE2: {
                this.rowBuilder.setAddonType2("1".equals(data));
                break;
            }
            case ADDON_TYPE3: {
                this.rowBuilder.setAddonType3("1".equals(data));
                break;
            }
            case BIOSIMILAR: {
                this.rowBuilder.setBiosimilar("1".equals(data));
                break;
            }
            case BUNDLED_IN_BIOLOGICAL: {
                this.rowBuilder.setBundledInBiological("1".equals(data));
                break;
            }
            case BYPASS_E92_MODIFIER: {
                this.rowBuilder.setBypassE92Modifier("1".equals(data));
                break;
            }
            case ADDON_DRUG_ADMIN: {
                this.rowBuilder.setAddonDrugAdmin("1".equals(data));
                break;
            }
            case INFORMATION_ONLY: {
                this.rowBuilder.setInformationOnly("1".equals(data));
                break;
            }
            case RADIATION_ONCOLOGY_MODEL: {
                this.rowBuilder.setRadiationOncologyModel("1".equals(data));
                break;
            }
            case COINSURANCE_DEDUCTIBLE_WAIVER_ELIGIBLE: {
                this.rowBuilder.setCoinsuranceDeductibleWaiverEligible("1".equals(data));
                break;
            }
            case ADDON_COVID_LAB: {
                this.rowBuilder.setAddonCovidLab("1".equals(data));
                break;
            }
            case OPIOID_TREATMENT_PROGRAM: {
                this.rowBuilder.setOpioidTreatmentProgram("1".equals(data));
                break;
            }
            case OPIOID_USE_DISORDER: {
                this.rowBuilder.setOpioidUseDisorder("1".equals(data));
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        HCPCS,
        LO_VERSION,
        HI_VERSION,
        DESCRIPTION,
        APC,
        LO_AGE,
        HI_AGE,
        SEX,
        STATUS_INDICATOR,
        PAYMENT_INDICATOR,
        QUESTIONABLE,
        NOT_RECOGNIZED_MCARE,
        NOT_RECOGNIZED_OPPS,
        NON_COVERED,
        NON_REPORTABLE_SITE,
        BILATERAL_CONDITIONAL,
        BILATERAL_INDEPENDENT,
        BILATERAL_INHERENT,
        NCCI_CODE1,
        NCCI_CODE2,
        VACCINE,
        ANTIGEN,
        SPLINT,
        CAST,
        NEGATIVE_PRESSURE_WOUND_THERAPY,
        SOMETIMES_THERAPY,
        ACTIVITY_THERAPY,
        OCCUPATIONAL_THERAPY,
        DEDUCTIBLE_NA,
        DEDUCTIBLE_COINS_NA,
        COINS_NA,
        BLOOD_SERVICE,
        BLOOD_PRODUCT,
        PACKED_RED_CELLS,
        WHOLE_BLOOD,
        EDUCATIONAL,
        OBSERVATION,
        OBSERVATION_HOURLY,
        OBSERVATION_DIRECT_ADMIT,
        OBSERVATION_HOSPITAL_ONLY,
        TRAUMA_REVENUE_CODE,
        TRAUMA_CRITICAL_CARE,
        CRITICAL_CARE_ANCILLARY,
        STV_PACKAGED,
        T_PACKAGED,
        HAS_DEV_REQ_PROC,
        SEPARATE_PROCEDURE,
        STATUTORY_EXCLUSION,
        DMERC_BILLABLE_ONLY,
        UNCLASSIFIED_DRUG,
        RADIO_PHARM,
        NUCLEAR_MED,
        MID_QUARTER_DATE_EDIT,
        DATE_APPROVED,
        DATE_TERMINATED,
        NON_BILLABLE_MAC,
        HAS_DEVICE_PAIR1,
        HAS_DEVICE_PAIR2,
        PH_PRIMARY,
        PH_SERVICE,
        DAILY_MENTAL_HEALTH,
        MH_NOT_PH,
        PH_NOT_MH,
        PH_DURATION,
        PH_ADDON,
        TOKEN_CHARGE_ONLY,
        SKIN_SUBSTITUTE_SG,
        SKIN_SUBSTITUTE,
        CAPC_EXCLUSION,
        CAPC_SRS_PLAN_AND_PREP,
        DEVICE_PROCEDURE,
        DEVICE,
        SKIN_SUBSTITUTE_SG_LO,
        SKIN_SUBSTITUTE_LO,
        SKIN_SUBSTITUTE_SG_HI,
        SKIN_SUBSTITUTE_HI,
        LAB_SERVICE,
        FQHC_PREVENTIVE,
        FQHC_FLU_PPV,
        FQHC_NON_COVERED,
        FQHC_ADDON,
        FQHC_PRIMARY,
        FQHC_CHRONIC_CARE,
        RHC_MODIFIER_CONFLICT,
        BYPASS_E72_FQHC_RHC,
        DEV_PROC_BYPASS,
        CORNEA_TRANSPLANT,
        CORNEA_TISSUE_PROCESSING,
        ADVANCE_CARE_PLANNING,
        ANNUAL_WELLNESS_VISIT,
        TERMINATED_DEVICE_PROCEDURE,
        PASSTHROUGH_DEVICE,
        PASSTHROUGH_RADIOPHARM,
        PASSTHROUGH_SKIN_PRODUCT,
        PASSTHROUGH_CONTRAST,
        PASSTHROUGH_STRESS_AGENT,
        NON_STANDARD_CT_SCAN,
        FILM_XRAY,
        ALLOGENEIC_TRANSPLANT,
        BYPASS_E99,
        OVERRIDE_SECTION_603,
        ADDON_TYPE1,
        ADDON_TYPE2,
        ADDON_TYPE3,
        BIOSIMILAR,
        BUNDLED_IN_BIOLOGICAL,
        BYPASS_E92_MODIFIER,
        ADDON_DRUG_ADMIN,
        INFORMATION_ONLY,
        RADIATION_ONCOLOGY_MODEL,
        COINSURANCE_DEDUCTIBLE_WAIVER_ELIGIBLE,
        ADDON_COVID_LAB,
        OPIOID_TREATMENT_PROGRAM,
        OPIOID_USE_DISORDER;

    }
}

