/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDescriptionTableDefinition;
import gov.cms.oce.ext.table.desc.DescriptionSchema;
import gov.cms.oce.ext.table.desc.DscClaimDispositionValueRow;
import gov.cms.oce.ext.table.desc.DscClaimDispositionValueTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscClaimDispositionValueTableDefinition
implements BinaryDescriptionTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(DscClaimDispositionValueTableDefinition.class);
    private final String filePath;
    private final DscClaimDispositionValueTable.Builder tableBuilder;
    private final DscClaimDispositionValueRow.Builder rowBuilder;

    DscClaimDispositionValueTableDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = DscClaimDispositionValueTable.newBuilder();
        this.rowBuilder = DscClaimDispositionValueRow.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DescriptionSchema.Builder schemaBuilder) {
        schemaBuilder.setDscClaimDispositionValueTable(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case CLAIM_DISPOSITION_ID: {
                this.rowBuilder.setClaimDispositionId(Integer.parseInt(data, 10));
                break;
            }
            case VALUE: {
                this.rowBuilder.setValue(Integer.parseInt(data, 10));
                break;
            }
            case LO_VERSION: {
                this.rowBuilder.setLoVersion(Integer.parseInt(data, 10));
                break;
            }
            case HI_VERSION: {
                this.rowBuilder.setHiVersion(Integer.parseInt(data, 10));
                break;
            }
            case DESCRIPTION: {
                this.rowBuilder.setDescription(data);
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        CLAIM_DISPOSITION_ID,
        VALUE,
        LO_VERSION,
        HI_VERSION,
        DESCRIPTION;

    }
}

