/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDescriptionTableDefinition;
import gov.cms.oce.ext.table.desc.DescriptionSchema;
import gov.cms.oce.ext.table.desc.DscEditRow;
import gov.cms.oce.ext.table.desc.DscEditTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscEditTableDefinition
implements BinaryDescriptionTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(DscEditTableDefinition.class);
    private final String filePath;
    private final DscEditTable.Builder tableBuilder;
    private final DscEditRow.Builder rowBuilder;

    DscEditTableDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = DscEditTable.newBuilder();
        this.rowBuilder = DscEditRow.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DescriptionSchema.Builder schemaBuilder) {
        schemaBuilder.setDscEditTable(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case EDIT: {
                this.rowBuilder.setEdit(Integer.parseInt(data, 10));
                break;
            }
            case LO_VERSION: {
                this.rowBuilder.setLoVersion(Integer.parseInt(data, 10));
                break;
            }
            case HI_VERSION: {
                this.rowBuilder.setHiVersion(Integer.parseInt(data, 10));
                break;
            }
            case DISPOSITION_ID: {
                this.rowBuilder.setDispositionId(Integer.parseInt(data, 10));
                break;
            }
            case BUFFER: {
                this.rowBuilder.setBuffer(data);
                break;
            }
            case NAME: {
                this.rowBuilder.setName(data);
                break;
            }
            case DESCRIPTION: {
                this.rowBuilder.setDescription(data);
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        EDIT,
        LO_VERSION,
        HI_VERSION,
        DISPOSITION_ID,
        BUFFER,
        NAME,
        DESCRIPTION;

    }
}

