/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDescriptionTableDefinition;
import gov.cms.oce.ext.table.desc.DescriptionSchema;
import gov.cms.oce.ext.table.desc.DscStatusIndicatorRow;
import gov.cms.oce.ext.table.desc.DscStatusIndicatorTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DscStatusIndicatorTableDefinition
implements BinaryDescriptionTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(DscStatusIndicatorTableDefinition.class);
    private final String filePath;
    private final DscStatusIndicatorTable.Builder tableBuilder;
    private final DscStatusIndicatorRow.Builder rowBuilder;

    DscStatusIndicatorTableDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = DscStatusIndicatorTable.newBuilder();
        this.rowBuilder = DscStatusIndicatorRow.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DescriptionSchema.Builder schemaBuilder) {
        schemaBuilder.setDscStatusIndicatorTable(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case STATUS_INDICATOR: {
                this.rowBuilder.setStatusIndicator(data);
                break;
            }
            case LO_VERSION: {
                this.rowBuilder.setLoVersion(Integer.parseInt(data, 10));
                break;
            }
            case HI_VERSION: {
                this.rowBuilder.setHiVersion(Integer.parseInt(data, 10));
                break;
            }
            case DESCRIPTION: {
                this.rowBuilder.setDescription(data);
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        STATUS_INDICATOR,
        LO_VERSION,
        HI_VERSION,
        DESCRIPTION;

    }
}

