/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDataTableDefinition;
import gov.cms.oce.ext.table.data.DataSchema;
import gov.cms.oce.ext.table.data.MapConflictRhcRow;
import gov.cms.oce.ext.table.data.MapConflictRhcTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapConflictRhcTableDefinition
implements BinaryDataTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(MapConflictRhcTableDefinition.class);
    private final String filePath;
    private final MapConflictRhcTable.Builder tableBuilder;
    private final MapConflictRhcRow.Builder rowBuilder;

    MapConflictRhcTableDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = MapConflictRhcTable.newBuilder();
        this.rowBuilder = MapConflictRhcRow.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DataSchema.Builder schemaBuilder) {
        schemaBuilder.setMapConflictRhcTable(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case HCPCS: {
                this.rowBuilder.setHcpcs(data);
                break;
            }
            case MODIFIER: {
                this.rowBuilder.setModifier(data);
                break;
            }
            case LO_VERSION: {
                this.rowBuilder.setLoVersion(Integer.parseInt(data, 10));
                break;
            }
            case HI_VERSION: {
                this.rowBuilder.setHiVersion(Integer.parseInt(data, 10));
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        HCPCS,
        MODIFIER,
        LO_VERSION,
        HI_VERSION;

    }
}

