/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDataTableDefinition;
import gov.cms.oce.ext.table.data.DataSchema;
import gov.cms.oce.ext.table.data.MapFqhcVisitRow;
import gov.cms.oce.ext.table.data.MapFqhcVisitTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapFqhcVisitTableDefinition
implements BinaryDataTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(MapFqhcVisitTableDefinition.class);
    private final String filePath;
    private final MapFqhcVisitTable.Builder tableBuilder;
    private final MapFqhcVisitRow.Builder rowBuilder;

    MapFqhcVisitTableDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = MapFqhcVisitTable.newBuilder();
        this.rowBuilder = MapFqhcVisitRow.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DataSchema.Builder schemaBuilder) {
        schemaBuilder.setMapFqhcVisitTable(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case CODE1: {
                this.rowBuilder.setCode1(data);
                break;
            }
            case CODE2: {
                this.rowBuilder.setCode2(data);
                break;
            }
            case LO_VERSION: {
                this.rowBuilder.setLoVersion(Integer.parseInt(data, 10));
                break;
            }
            case HI_VERSION: {
                this.rowBuilder.setHiVersion(Integer.parseInt(data, 10));
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        CODE1,
        CODE2,
        LO_VERSION,
        HI_VERSION;

    }
}

