/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDataTableDefinition;
import gov.cms.oce.ext.table.data.DataSchema;
import gov.cms.oce.ext.table.data.MapNcciRowLeftCodes;
import gov.cms.oce.ext.table.data.MapNcciTableLeftCodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapNcciTableLeftCodesDefinition
implements BinaryDataTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(MapNcciTableLeftCodesDefinition.class);
    private final String filePath;
    private final MapNcciTableLeftCodes.Builder tableBuilder;
    private final MapNcciRowLeftCodes.Builder rowBuilder;

    MapNcciTableLeftCodesDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = MapNcciTableLeftCodes.newBuilder();
        this.rowBuilder = MapNcciRowLeftCodes.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DataSchema.Builder schemaBuilder) {
        schemaBuilder.setMapNcciTableLeftCodes(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case CODE: {
                this.rowBuilder.setCode(data);
                break;
            }
            case LO_VERSION: {
                this.rowBuilder.setLoVersion(Integer.parseInt(data, 10));
                break;
            }
            case HI_VERSION: {
                this.rowBuilder.setHiVersion(Integer.parseInt(data, 10));
                break;
            }
            case MOD_INDICATOR: {
                this.rowBuilder.setModIndicator("1".equals(data));
                break;
            }
            case GROUP_ID: {
                this.rowBuilder.setGroupId(Integer.parseInt(data));
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        CODE,
        LO_VERSION,
        HI_VERSION,
        MOD_INDICATOR,
        GROUP_ID;

    }
}

