/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDataTableDefinition;
import gov.cms.oce.ext.table.data.DataSchema;
import gov.cms.oce.ext.table.data.MapNcciRowRightCodes;
import gov.cms.oce.ext.table.data.MapNcciTableRightCodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapNcciTableRightCodesDefinition
implements BinaryDataTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(MapNcciTableRightCodesDefinition.class);
    private final String filePath;
    private final MapNcciTableRightCodes.Builder tableBuilder;
    private final MapNcciRowRightCodes.Builder rowBuilder;

    MapNcciTableRightCodesDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = MapNcciTableRightCodes.newBuilder();
        this.rowBuilder = MapNcciRowRightCodes.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DataSchema.Builder schemaBuilder) {
        schemaBuilder.setMapNcciTableRightCodes(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case GROUP_ID: {
                this.rowBuilder.setGroupId(Integer.parseInt(data));
                break;
            }
            case CODE: {
                this.rowBuilder.setCode(data);
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        GROUP_ID,
        CODE;

    }
}

