/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDataTableDefinition;
import gov.cms.oce.ext.table.data.DataSchema;
import gov.cms.oce.ext.table.data.MapS603OverrideRow;
import gov.cms.oce.ext.table.data.MapS603OverrideTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapS603OverrideTableDefinition
implements BinaryDataTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(MapS603OverrideTableDefinition.class);
    private final String filePath;
    private final MapS603OverrideTable.Builder tableBuilder;
    private final MapS603OverrideRow.Builder rowBuilder;

    MapS603OverrideTableDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = MapS603OverrideTable.newBuilder();
        this.rowBuilder = MapS603OverrideRow.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DataSchema.Builder schemaBuilder) {
        schemaBuilder.setMapS603OverrideTable(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case HCPCS: {
                this.rowBuilder.setHcpcs(data);
                break;
            }
            case LO_VERSION: {
                this.rowBuilder.setLoVersion(Integer.parseInt(data, 10));
                break;
            }
            case HI_VERSION: {
                this.rowBuilder.setHiVersion(Integer.parseInt(data, 10));
                break;
            }
            case APC: {
                this.rowBuilder.setApc(data);
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        HCPCS,
        LO_VERSION,
        HI_VERSION,
        APC;

    }
}

