/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.builder;

import gov.cms.oce.ext.table.builder.BinaryDataTableDefinition;
import gov.cms.oce.ext.table.data.DataSchema;
import gov.cms.oce.ext.table.data.OffsetCodepairRow;
import gov.cms.oce.ext.table.data.OffsetCodepairTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OffsetCodepairTableDefinition
implements BinaryDataTableDefinition {
    private static final Logger logger = LoggerFactory.getLogger(OffsetCodepairTableDefinition.class);
    private final String filePath;
    private final OffsetCodepairTable.Builder tableBuilder;
    private final OffsetCodepairRow.Builder rowBuilder;

    OffsetCodepairTableDefinition(String filePath) {
        this.filePath = filePath;
        this.tableBuilder = OffsetCodepairTable.newBuilder();
        this.rowBuilder = OffsetCodepairRow.newBuilder();
    }

    @Override
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    public final void attachTable(DataSchema.Builder schemaBuilder) {
        schemaBuilder.setOffsetCodepairTable(this.tableBuilder.build());
    }

    @Override
    public void initialize() {
        this.rowBuilder.clear();
    }

    @Override
    public void finalizeRow() {
        if (this.rowBuilder.isInitialized()) {
            this.tableBuilder.addRow(this.rowBuilder.build());
        } else {
            logger.error(this.rowBuilder.getClass().getSimpleName() + " not fully initialized. Some fields are missing.");
        }
    }

    @Override
    public final void addColumnData(int rowIndex, int columnIndex, String data) {
        switch (ColumnSet.values()[columnIndex]) {
            case LIST_ID: {
                this.rowBuilder.setListId(Integer.parseInt(data, 10));
                break;
            }
            case CODE1: {
                this.rowBuilder.setCode1(data);
                break;
            }
            case LO_VERSION: {
                this.rowBuilder.setLoVersion(Integer.parseInt(data, 10));
                break;
            }
            case HI_VERSION: {
                this.rowBuilder.setHiVersion(Integer.parseInt(data, 10));
                break;
            }
            case CODE2: {
                this.rowBuilder.setCode2(data);
                break;
            }
            case AMOUNT: {
                this.rowBuilder.setAmount(Integer.parseInt(data, 10));
                break;
            }
            case DATE_ACTIVATED: {
                this.rowBuilder.setDateActivated(Integer.parseInt(data, 10));
                break;
            }
            default: {
                logger.error("No column defined for column index \"{}\"", (Object)columnIndex);
            }
        }
    }

    public static enum ColumnSet {
        LIST_ID,
        CODE1,
        CODE2,
        LO_VERSION,
        HI_VERSION,
        AMOUNT,
        DATE_ACTIVATED;

    }
}

