/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public final class Combination<D> {
    private final Set<D> left;
    private final Set<D> right;

    private Combination() {
        this(null, null);
    }

    private Combination(Collection<D> left, Collection<D> right) {
        this.left = left == null ? Collections.emptySet() : Collections.unmodifiableSet(new LinkedHashSet<D>(left));
        this.right = right == null ? Collections.emptySet() : Collections.unmodifiableSet(new LinkedHashSet<D>(right));
    }

    public static <D> CombinationBuilder<D> builder(Class<D> elementValueType) {
        return new CombinationBuilder();
    }

    public static <D> CombinationBuilder<D> builder() {
        return new CombinationBuilder();
    }

    public CombinationBuilder<D> toBuilder() {
        return new CombinationBuilder(this);
    }

    public Set<D> getLeft() {
        return this.left;
    }

    public Set<D> getRight() {
        return this.right;
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Combination codeObj = (Combination)obj;
        return Objects.equals(this.left, codeObj.left) && Objects.equals(this.right, codeObj.right);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.left);
        sb.append(" : ");
        sb.append(this.right);
        return sb.toString();
    }

    public static class CombinationBuilder<D> {
        private Collection<D> left;
        private Collection<D> right;

        public CombinationBuilder() {
            this.left = new LinkedHashSet<D>();
            this.right = new LinkedHashSet<D>();
        }

        public CombinationBuilder(Combination<D> combination) {
            this.left = new LinkedHashSet<D>(combination.getLeft());
            this.right = new LinkedHashSet<D>(combination.getRight());
        }

        public CombinationBuilder<D> withLeft(Collection<D> codesLeft) {
            this.left = codesLeft;
            return this;
        }

        public CombinationBuilder<D> withRight(Collection<D> codesRight) {
            this.right = codesRight;
            return this;
        }

        public CombinationBuilder<D> addLeft(D code) {
            this.left.add(code);
            return this;
        }

        public CombinationBuilder<D> addAllLeft(Collection<D> codes) {
            this.left.addAll(codes);
            return this;
        }

        public CombinationBuilder<D> addRight(D code) {
            this.right.add(code);
            return this;
        }

        public CombinationBuilder<D> addAllRight(Collection<D> codes) {
            this.right.addAll(codes);
            return this;
        }

        public Combination<D> build() {
            return new Combination(this.left, this.right);
        }
    }
}

