/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.ext.table.util;

import gov.cms.oce.ext.table.util.Combination;
import gov.cms.oce.ext.table.util.CombinationOptimizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CombinationUtil {
    public static final Logger logger = LoggerFactory.getLogger(CombinationUtil.class);

    private CombinationUtil() {
    }

    public static <D> Map<D, LinkedList<D>> groupByLeftCode(Collection<Combination<D>> codeCombinations) {
        CombinationOptimizer.LinkedHashMultimap<D, D> grouped = new CombinationOptimizer.LinkedHashMultimap<D, D>();
        for (Combination<D> combination : codeCombinations) {
            for (D left : combination.getLeft()) {
                for (D right : combination.getRight()) {
                    grouped.putSingle(left, right);
                }
            }
        }
        return grouped;
    }

    public static <D> Map<D, LinkedList<D>> groupByLeftCode(List<D[]> expanded) {
        CombinationOptimizer.LinkedHashMultimap<D, D> grouped = new CombinationOptimizer.LinkedHashMultimap<D, D>();
        for (D[] combination : expanded) {
            if (combination.length != 2) {
                throw new RuntimeException("Combination element does not contain two entries");
            }
            D left = combination[0];
            D right = combination[1];
            grouped.putSingle(left, right);
        }
        return grouped;
    }

    public static <D> Set<Combination<D>> combine(Map<D, LinkedList<D>> rightForLeft) {
        LinkedHashSet<Combination<D>> combined = new LinkedHashSet<Combination<D>>();
        for (Map.Entry<D, LinkedList<D>> multimapEntry : rightForLeft.entrySet()) {
            LinkedHashSet<D> leftSet = new LinkedHashSet<D>();
            leftSet.add(multimapEntry.getKey());
            Combination entry = Combination.builder().withLeft(leftSet).withRight((Collection)multimapEntry.getValue()).build();
            combined.add(entry);
        }
        return combined;
    }

    public static <D> List<D[]> expand(Map<D, LinkedList<D>> rightForLeft, BiFunction<D, D, D[]> arrayFactory) {
        ArrayList<D[]> expanded = new ArrayList<D[]>();
        for (Map.Entry<D, LinkedList<D>> combo : rightForLeft.entrySet()) {
            D left = combo.getKey();
            for (Object right : combo.getValue()) {
                expanded.add(arrayFactory.apply(left, right));
            }
        }
        return expanded;
    }

    public static <D> List<D[]> expand(Collection<Combination<D>> codeCombinations, BiFunction<D, D, D[]> arrayFactory) {
        ArrayList<D[]> expanded = new ArrayList<D[]>();
        for (Combination<D> combo : codeCombinations) {
            Set<D> leftCodes = combo.getLeft();
            for (D left : leftCodes) {
                for (D right : combo.getRight()) {
                    expanded.add(arrayFactory.apply(left, right));
                }
            }
        }
        return expanded;
    }

    public static <D> long count(Collection<? extends Combination<D>> combos, Function<Combination<D>, Collection<D>> leftRight) {
        return combos.stream().flatMap(combo -> ((Collection)leftRight.apply((Combination)combo)).stream()).count();
    }

    public static <D> long count(Combination<D> combo, Function<Combination<D>, Collection<D>> leftRight) {
        return leftRight.apply(combo).stream().count();
    }
}

