/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic;

import gov.cms.oce.logic.EmptyLogicPhasePath;
import gov.cms.oce.logic.LogicPhase;
import gov.cms.oce.logic.LogicPhasePath;
import gov.cms.oce.logic.LogicPhasePathFactory;
import gov.cms.oce.logic.finalization.OceFinalizationLogicPhasePath;
import gov.cms.oce.logic.initialization.OceInitializationLogicPhasePath;
import gov.cms.oce.logic.postprocessing.OcePostProcessingLogicPhasePath;
import gov.cms.oce.logic.preprocessing.OcePreProcessingLogicPhasePath;
import gov.cms.oce.logic.processing.OceProcessingLogicPhasePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OceLogicPhasePathFactory
implements LogicPhasePathFactory {
    private static final Logger logger = LoggerFactory.getLogger(OceLogicPhasePathFactory.class);
    private static final OceLogicPhasePathFactory FACTORY = new OceLogicPhasePathFactory();

    private OceLogicPhasePathFactory() {
    }

    public static final LogicPhasePathFactory getInstance() {
        return FACTORY;
    }

    @Override
    public final LogicPhasePath createLogicPhasePath(LogicPhase logicPhase) {
        if (logger.isTraceEnabled()) {
            logger.trace("Creating new phase \"{}\" from logic phase path factory \"{}\".", (Object)logicPhase.name(), (Object)this.getClass().getSimpleName());
        }
        switch (logicPhase) {
            case INITIALIZATION: {
                return new OceInitializationLogicPhasePath();
            }
            case PREPROCESSING: {
                return new OcePreProcessingLogicPhasePath();
            }
            case PROCESSING: {
                return new OceProcessingLogicPhasePath();
            }
            case POSTPROCESSING: {
                return new OcePostProcessingLogicPhasePath();
            }
            case FINALIZATION: {
                return new OceFinalizationLogicPhasePath();
            }
        }
        return new EmptyLogicPhasePath();
    }
}

