/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.initialization;

import gov.cms.oce.dao.data.DataApcDao;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.ReturnCode;
import gov.cms.oce.processor.ClaimProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidateHardcodedApc
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(ValidateHardcodedApc.class);

    ValidateHardcodedApc() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        DataApcDao dao = processor.getResourceManager().getDataDaoFactory().getDataApcDao();
        boolean abort = dao.checkHardcodedApcSet();
        if (abort) {
            OceClaimInternal claim = processor.getInternalClaim();
            if (claim.getFlags().isNotSet(ClaimFlags.FATAL_HARDCODED_APC_MISMATCH)) {
                claim.getFlags().set(ClaimFlags.FATAL_HARDCODED_APC_MISMATCH);
            }
            logger.error("Hardcoded APC missing from table. Please review log for details.");
            claim.setReturnCode(ReturnCode.BAD_ROT_READ);
        }
        return abort;
    }
}

