/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.initialization;

import gov.cms.oce.dao.data.DataRevenueDao;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.ReturnCode;
import gov.cms.oce.processor.ClaimProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidateHardcodedRevenueCode
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(ValidateHardcodedRevenueCode.class);

    ValidateHardcodedRevenueCode() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        DataRevenueDao dao = processor.getResourceManager().getDataDaoFactory().getDataRevenueDao();
        boolean abort = dao.checkHardcodedRevenueCodeSet();
        if (abort) {
            OceClaimInternal claim = processor.getInternalClaim();
            if (claim.getFlags().isNotSet(ClaimFlags.FATAL_HARDCODED_REVENUE_CODE_MISMATCH)) {
                claim.getFlags().set(ClaimFlags.FATAL_HARDCODED_REVENUE_CODE_MISMATCH);
            }
            logger.error("Hardcoded revenue code missing from table. Please review log for details.");
            claim.setReturnCode(ReturnCode.BAD_ROT_READ);
        }
        return abort;
    }
}

