/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.postprocessing;

import gov.cms.oce.dao.data.DataApcDao;
import gov.cms.oce.dao.data.DataDiscountFormulaDao;
import gov.cms.oce.dao.data.row.DataApcRowInternal;
import gov.cms.oce.dao.data.row.DataDiscountFormulaRowInternal;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.ModifierFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CalculateDiscount
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(CalculateDiscount.class);

    CalculateDiscount() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        if (!navigator.isInitialized()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Skipping logic block because required navigator isn't available");
            }
            return false;
        }
        DataDiscountFormulaDao discountFormulaDao = processor.getResourceManager().getDataDaoFactory().getDataDiscountFormulaDao();
        DataApcDao dataApcDao = processor.getResourceManager().getDataDaoFactory().getDataApcDao();
        short version = claim.getVersionAsPrimitive();
        for (Day day : navigator.getDayList()) {
            ArrayList<LineItemInternal> discountLineList = new ArrayList<LineItemInternal>();
            LineItemInternal highestLine = null;
            int highestLinePayment = -1;
            for (LineItemInternal line : day.getLineItemList()) {
                if (!OceClaimUtility.qualifiesForDiscount(line)) continue;
                discountLineList.add(line);
                int linePayment = 0;
                DataApcRowInternal row = dataApcDao.getRow(line.getPaymentApc(), (Short)claim.getVersionAsPrimitive());
                if (row != null) {
                    linePayment = row.getApcPayment();
                }
                if (line.isHcpcsModifierPresent("52", "73")) {
                    linePayment /= 2;
                }
                if (highestLinePayment >= linePayment) continue;
                highestLinePayment = linePayment;
                highestLine = line;
            }
            for (LineItemInternal line : discountLineList) {
                if (line.isHcpcsModifierFlagSet(ModifierFlags.DATA_MODIFIER_NON_DISCOUNT) && (line.matchesStatusIndicator("T") || !line.isHcpcsModifierPresent("52", "73"))) continue;
                boolean ignore50 = false;
                ignore50 = line.isHcpcsModifierPresent("50") && line.getFlags().anySet(LineFlags.DATA_HCPCS_BILATERAL_CONDITIONAL, LineFlags.DATA_HCPCS_BILATERAL_INDEPENDENT) && !line.isHcpcsModifierPresent("52", "73") && line.isNotPackaged() && (claim.getPrimaryComprehensive() != null && line.equals(claim.getPrimaryComprehensive()) || line.isCompositeAdjustmentFlagSet() || line.getFlags().anySet(LineFlags.DATA_HCPCS_STV_PACKAGED, LineFlags.DATA_HCPCS_T_PACKAGED) && !line.matchesStatusIndicator("Q1", "Q2"));
                StringBuilder key = new StringBuilder(3);
                key.replace(0, key.length(), highestLine != null && line.equals(highestLine) ? "H" : "N");
                key.append(line.isHcpcsModifierPresent("52", "73") ? "Y" : "N");
                key.append(line.isHcpcsModifierPresent("50") && !ignore50 ? "Y" : "N");
                DataDiscountFormulaRowInternal row = discountFormulaDao.getRow(key.toString(), (Short)version);
                if (row == null) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("No discount row found for key {}", (Object)key);
                    continue;
                }
                int columnIndex = 0;
                columnIndex = line.matchesStatusIndicator("T") ? (line.getFlags().anySet(LineFlags.DATA_HCPCS_BILATERAL_INDEPENDENT, LineFlags.DATA_HCPCS_BILATERAL_CONDITIONAL) ? 0 : 1) : (line.getFlags().isSet(LineFlags.DATA_HCPCS_BILATERAL_INDEPENDENT) ? 2 : (line.getFlags().isSet(LineFlags.DATA_HCPCS_BILATERAL_CONDITIONAL) ? 3 : 4));
                String discountCode = Integer.toString(row.getDiscountFormula()).substring(columnIndex, columnIndex + 1);
                line.setDiscountingFormula(Byte.valueOf(discountCode));
            }
        }
        return false;
    }
}

