/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.postprocessing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.DayFlags;
import gov.cms.oce.model.rsc.EditDisposition;
import gov.cms.oce.model.rsc.EditPaymentType;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CalculateDisposition
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(CalculateDisposition.class);

    CalculateDisposition() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        if (!claim.isClaimProcessed()) {
            return false;
        }
        Navigator navigator = processor.getResourceManager().getNavigator();
        if (!navigator.isInitialized()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Skipping logic block because required navigator isn't available");
            }
            return false;
        }
        boolean dayRejected = false;
        boolean dayDenied = false;
        boolean claimLevel = false;
        boolean dayLevel = false;
        boolean lineLevel = false;
        for (Day day : navigator.getDayList()) {
            if (!day.getFlags().anySet(DayFlags.DAY_DENIED, DayFlags.DAY_REJECTED)) continue;
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.isNotIgnored() || line.getRejectionDenialFlag().getValue() != 0) continue;
                line.getRejectionDenialFlag().setValue((byte)2);
            }
            if (!dayRejected && day.getFlags().isSet(DayFlags.DAY_REJECTED)) {
                dayRejected = true;
            }
            if (dayDenied || !day.getFlags().isSet(DayFlags.DAY_DENIED)) continue;
            dayDenied = true;
        }
        if (claim.isEditDispositionPresent(EditDisposition.CLAIM_REJECTION)) {
            claim.getClaimRejectionDisposition().setValue((byte)1);
            claimLevel = true;
        } else if (dayRejected) {
            claim.getClaimRejectionDisposition().setValue((byte)2);
            if (1 < navigator.getDayCount()) {
                dayLevel = true;
            } else {
                claimLevel = true;
            }
        }
        if (claim.isEditDispositionPresent(EditDisposition.CLAIM_DENIAL)) {
            claim.getClaimDenialDisposition().setValue((byte)1);
            claimLevel = true;
        } else if (dayDenied) {
            claim.getClaimDenialDisposition().setValue((byte)2);
            if (1 < navigator.getDayCount()) {
                dayLevel = true;
            } else {
                claimLevel = true;
            }
        }
        if (claim.isEditDispositionPresent(EditDisposition.CLAIM_RETURN_TO_PROVIDER)) {
            claim.getClaimReturnToProviderDisposition().setValue((byte)1);
            claimLevel = true;
        }
        if (claim.isEditDispositionPresent(EditDisposition.CLAIM_SUSPENSION)) {
            claim.getClaimSuspensionDisposition().setValue((byte)1);
            claimLevel = true;
        }
        if (claim.isEditDispositionPresent(EditDisposition.LINE_REJECTION)) {
            claim.getLineRejectionDisposition().setValue((byte)1);
            lineLevel = true;
        }
        if (claim.isEditDispositionPresent(EditDisposition.LINE_DENIAL)) {
            claim.getLineDenialDisposition().setValue((byte)1);
            lineLevel = true;
        }
        if (claimLevel) {
            if (claim.isEditPaymentTypePresent(EditPaymentType.CLAIM_PREPAYMENT)) {
                if (claim.isEditPaymentTypePresent(EditPaymentType.CLAIM_POSTPAYMENT)) {
                    claim.getClaimDisposition().setValue((byte)5);
                } else {
                    claim.getClaimDisposition().setValue((byte)4);
                }
            } else {
                claim.getClaimDisposition().setValue((byte)3);
            }
        } else if (dayLevel) {
            claim.getClaimDisposition().setValue((byte)2);
        } else if (lineLevel) {
            claim.getClaimDisposition().setValue((byte)1);
        } else {
            claim.getClaimDisposition().setValue((byte)0);
        }
        return false;
    }
}

