/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.postprocessing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.HardcodedApcSet;
import gov.cms.oce.model.rsc.HardcodedHcpcsSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CalculatePaymentMethodFlag
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(CalculatePaymentMethodFlag.class);

    CalculatePaymentMethodFlag() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        if (!claim.isClaimProcessed() || claim.getVersionAsPrimitive() == 0) {
            return false;
        }
        if (claim.isOpps()) {
            boolean cc07OddPath;
            boolean bl = cc07OddPath = claim.isConditionCodePresent("07") && claim.getFlags().anySet(ClaimFlags.ANTIGEN, ClaimFlags.CAST, ClaimFlags.SPLINT) && !claim.matchesBillType("43", "71", "77", "87");
            if (claim.matchesBillType("13")) {
                block99: for (LineItemInternal line : claim.getLineItemList().getValue()) {
                    if (!line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF)) continue;
                    switch (line.getStatusIndicator().getValue()) {
                        case "A": 
                        case "F": 
                        case "L": {
                            line.getPaymentMethodFlag().setValue(line.isRejectedDenied() ? "3" : "2");
                            line.getPaymentApc().setValue(HardcodedApcSet.APC_ZERO.getApc());
                            continue block99;
                        }
                        case "B": 
                        case "C": 
                        case "E": 
                        case "E1": 
                        case "E2": 
                        case "M": 
                        case "Q1": 
                        case "Q2": 
                        case "Q3": 
                        case "Q4": 
                        case "W": 
                        case "Y": 
                        case "Z": {
                            line.getPaymentMethodFlag().setValue("1");
                            line.getPaymentApc().setValue(HardcodedApcSet.APC_ZERO.getApc());
                            continue block99;
                        }
                    }
                    if (claim.isClaimVersionAfter(61) && line.matchesStatusIndicator("G", "K")) {
                        line.getPaymentMethodFlag().setValue(line.isRejectedDenied() ? "3" : "2");
                        continue;
                    }
                    line.getPaymentMethodFlag().setValue("0");
                }
            } else if (claim.matchesBillType("12", "14")) {
                if (claim.isConditionCodePresent("41")) {
                    for (LineItemInternal line : claim.getLineItemList().getValue()) {
                        if (!line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF)) continue;
                        line.getPaymentMethodFlag().setValue("1");
                        line.getPaymentApc().setValue(HardcodedApcSet.APC_ZERO.getApc());
                    }
                } else {
                    block101: for (LineItemInternal line : claim.getLineItemList().getValue()) {
                        if (!line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF)) continue;
                        switch (line.getStatusIndicator().getValue()) {
                            case "A": 
                            case "F": 
                            case "L": {
                                line.getPaymentMethodFlag().setValue(line.isRejectedDenied() ? "3" : "2");
                                line.getPaymentApc().setValue(HardcodedApcSet.APC_ZERO.getApc());
                                continue block101;
                            }
                            case "B": 
                            case "C": 
                            case "E": 
                            case "E1": 
                            case "E2": 
                            case "M": 
                            case "Q1": 
                            case "Q2": 
                            case "Q3": 
                            case "Q4": 
                            case "W": 
                            case "Y": 
                            case "Z": {
                                line.getPaymentMethodFlag().setValue("1");
                                line.getPaymentApc().setValue(HardcodedApcSet.APC_ZERO.getApc());
                                continue block101;
                            }
                        }
                        if (claim.isClaimVersionAfter(61) && line.matchesStatusIndicator("G", "K")) {
                            line.getPaymentMethodFlag().setValue(line.isRejectedDenied() ? "3" : "2");
                            continue;
                        }
                        line.getPaymentMethodFlag().setValue("0");
                    }
                }
            } else if (claim.matchesBillType("34")) {
                block102: for (LineItemInternal line : claim.getLineItemList().getValue()) {
                    if (!line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF)) continue;
                    if (line.getFlags().anySet((LineFlags)new LineFlags[]{LineFlags.DATA_HCPCS_ANTIGEN, LineFlags.DATA_HCPCS_CAST, LineFlags.DATA_HCPCS_SPLINT, LineFlags.DATA_HCPCS_VACCINE, LineFlags.DATA_HCPCS_NEGATIVE_PRESSURE_WOUND_THERAPY})) {
                        line.getPaymentMethodFlag().setValue("0");
                        continue;
                    }
                    switch (line.getStatusIndicator().getValue()) {
                        case "C": 
                        case "E": 
                        case "E1": 
                        case "E2": 
                        case "M": 
                        case "W": 
                        case "Y": 
                        case "Z": {
                            line.getPaymentMethodFlag().setValue("1");
                            line.getPaymentApc().setValue(HardcodedApcSet.APC_ZERO.getApc());
                            continue block102;
                        }
                    }
                    line.getPaymentMethodFlag().setValue(line.isRejectedDenied() ? "3" : "2");
                    line.getPaymentApc().setValue(HardcodedApcSet.APC_ZERO.getApc());
                }
            } else if (claim.matchesBillType("75")) {
                block103: for (LineItemInternal line : claim.getLineItemList().getValue()) {
                    if (!line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF)) continue;
                    if (cc07OddPath && line.getFlags().anySet(LineFlags.DATA_HCPCS_ANTIGEN, LineFlags.DATA_HCPCS_CAST, LineFlags.DATA_HCPCS_SPLINT)) {
                        line.getPaymentMethodFlag().setValue("0");
                        continue;
                    }
                    switch (line.getStatusIndicator().getValue()) {
                        case "C": 
                        case "E": 
                        case "E1": 
                        case "E2": 
                        case "M": 
                        case "W": 
                        case "Y": 
                        case "Z": {
                            line.getPaymentMethodFlag().setValue("1");
                            line.getPaymentApc().setValue(HardcodedApcSet.APC_ZERO.getApc());
                            continue block103;
                        }
                    }
                    line.getPaymentMethodFlag().setValue(line.isRejectedDenied() ? "3" : "2");
                    line.getPaymentApc().setValue(HardcodedApcSet.APC_ZERO.getApc());
                }
            } else if (claim.matchesBillType("76")) {
                boolean ccMYPath = false;
                boolean cc66Path = false;
                if (claim.isClaimVersionAfter(65)) {
                    ccMYPath = claim.isConditionCodePresent("MY");
                    cc66Path = claim.isConditionCodePresent("66");
                }
                block104: for (LineItemInternal line : claim.getLineItemList().getValue()) {
                    if (!line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF)) continue;
                    if (line.isPackaged() || line.getFlags().isSet(LineFlags.DATA_HCPCS_PH_SERVICE)) {
                        if (ccMYPath) {
                            line.getPaymentMethodFlag().setValue("9");
                            continue;
                        }
                        if (cc66Path) {
                            line.getPaymentMethodFlag().setValue("6");
                            continue;
                        }
                        line.getPaymentMethodFlag().setValue("0");
                        continue;
                    }
                    if (line.getFlags().isNotSet(LineFlags.INPUT_INVALID_HCPCS) && (HardcodedHcpcsSet.TELEHEALTH_G2025.getHcpcs().equals(line.getHcpcs().getValue()) || HardcodedHcpcsSet.TELEHEALTH_Q3041.getHcpcs().equals(line.getHcpcs().getValue()))) {
                        line.getPaymentMethodFlag().setValue(line.isRejectedDenied() ? "3" : "2");
                        line.getPaymentApc().setValue(HardcodedApcSet.APC_ZERO.getApc());
                        continue;
                    }
                    HardcodedApcSet hardcodedApc = HardcodedApcSet.getHardcodedApc(line.getPaymentApc().getValue());
                    if (hardcodedApc == null) {
                        hardcodedApc = HardcodedApcSet.APC_ZERO;
                    }
                    switch (hardcodedApc) {
                        case PH_APC1_2009: 
                        case PH_APC2_2009: 
                        case PH_APC1_2011: 
                        case PH_APC2_2011: 
                        case PH_APC1_2016: 
                        case PH_APC2_2016: 
                        case PH_APC_2017: 
                        case CMHC_APC1_2016: 
                        case CMHC_APC2_2016: {
                            if (ccMYPath) {
                                line.getPaymentMethodFlag().setValue("9");
                                continue block104;
                            }
                            if (cc66Path) {
                                line.getPaymentMethodFlag().setValue("6");
                                continue block104;
                            }
                            line.getPaymentMethodFlag().setValue("0");
                            continue block104;
                        }
                    }
                    line.getPaymentMethodFlag().setValue("1");
                    line.getPaymentApc().setValue(HardcodedApcSet.APC_ZERO.getApc());
                }
            } else if (claim.isClaimVersionAfter(56) && claim.matchesBillType("77") && !claim.isConditionCodePresent("65")) {
                for (LineItemInternal line : claim.getLineItemList().getValue()) {
                    if (!line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF)) continue;
                    line.getPaymentMethodFlag().setValue("5");
                    line.getPaymentApc().setValue(HardcodedApcSet.APC_ZERO.getApc());
                }
            } else {
                block106: for (LineItemInternal line : claim.getLineItemList().getValue()) {
                    if (!line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF)) continue;
                    if (cc07OddPath && line.getFlags().anySet(LineFlags.DATA_HCPCS_ANTIGEN, LineFlags.DATA_HCPCS_CAST, LineFlags.DATA_HCPCS_SPLINT)) {
                        line.getPaymentMethodFlag().setValue("0");
                        continue;
                    }
                    switch (line.getStatusIndicator().getValue()) {
                        case "C": 
                        case "E": 
                        case "E1": 
                        case "E2": 
                        case "M": 
                        case "W": 
                        case "Y": 
                        case "Z": {
                            line.getPaymentMethodFlag().setValue("1");
                            line.getPaymentApc().setValue(HardcodedApcSet.APC_ZERO.getApc());
                            continue block106;
                        }
                    }
                    line.getPaymentMethodFlag().setValue(line.isRejectedDenied() ? "3" : "2");
                    line.getPaymentApc().setValue(HardcodedApcSet.APC_ZERO.getApc());
                }
            }
        } else {
            block107: for (LineItemInternal line : claim.getLineItemList().getValue()) {
                if (!line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF)) continue;
                switch (line.getStatusIndicator().getValue()) {
                    case "C": 
                    case "E": 
                    case "E1": 
                    case "E2": 
                    case "M": 
                    case "W": 
                    case "Y": 
                    case "Z": {
                        line.getPaymentMethodFlag().setValue("1");
                        line.getPaymentApc().setValue(HardcodedApcSet.APC_ZERO.getApc());
                        continue block107;
                    }
                }
                line.getPaymentMethodFlag().setValue(line.isRejectedDenied() ? "3" : "2");
                line.getPaymentApc().setValue(HardcodedApcSet.APC_ZERO.getApc());
            }
        }
        return false;
    }
}

