/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.postprocessing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.HardcodedHcpcsSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.FlagSet;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InitializePaymentAdjustmentFlag
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(InitializePaymentAdjustmentFlag.class);

    InitializePaymentAdjustmentFlag() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        if (!navigator.isInitialized()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Skipping logic block because required navigator isn't available");
            }
            return false;
        }
        for (LineItemInternal line : navigator.getLineItemList()) {
            boolean adjustable = !line.isPackaged() || !line.isZeroCharge();
            FlagSet<LineFlags> flags = line.getFlags();
            if (line.isNotPackaged() && flags.isSet(LineFlags.DATA_HCPCS_FILM_XRAY) && line.isHcpcsModifierPresent("FX")) {
                if (flags.isSet(LineFlags.DATA_HCPCS_DEDUCTIBLE_COINS_NA)) {
                    flags.set(LineFlags.PAYMENT_ADJUSTMENT_FILM_XRAY_COINS);
                } else {
                    flags.set(LineFlags.PAYMENT_ADJUSTMENT_FILM_XRAY_REDUCTION);
                }
            }
            if (line.isNotPackaged() && flags.isSet(LineFlags.DATA_HCPCS_FILM_XRAY) && line.isHcpcsModifierPresent("FY")) {
                if (flags.isSet(LineFlags.DATA_HCPCS_DEDUCTIBLE_COINS_NA)) {
                    flags.set(LineFlags.PAYMENT_ADJUSTMENT_COMPUTED_RADIOGRAPHY_COINS);
                } else {
                    flags.set(LineFlags.PAYMENT_ADJUSTMENT_COMPUTED_RADIOGRAPHY_REDUCTION);
                }
            }
            if (adjustable && (claim.isConditionCodePresent("MA") || flags.isSet(LineFlags.DATA_HCPCS_DEDUCTIBLE_NA))) {
                flags.set(LineFlags.PAYMENT_ADJUSTMENT_DEDUCTIBLE_NA);
            }
            if (adjustable && (flags.anySet(LineFlags.DATA_HCPCS_DEDUCTIBLE_COINS_NA) || line.isHcpcsModifierPresent("Q3") || OceClaimUtility.isCsModifierApplicable(line) && line.isHcpcsModifierPresent("CS") && claim.matchesBillType("13") && !claim.isConditionCodePresent("41") && (line.matchesStatusIndicator("V", "J2") || line.matchesStatusIndicator("S") && line.matchesHcpcs(HardcodedHcpcsSet.CRITICAL_CARE, HardcodedHcpcsSet.COVID_19_SPECIMEN_COLLECTION)))) {
                flags.set(LineFlags.PAYMENT_ADJUSTMENT_DEDUCTIBLE_COINS_NA);
            }
            if (adjustable && claim.isClaimVersionAfter(61) && flags.anySet((LineFlags)new LineFlags[]{LineFlags.DATA_HCPCS_COINS_NA, LineFlags.DATA_HCPCS_PASSTHROUGH_CONTRAST, LineFlags.DATA_HCPCS_PASSTHROUGH_RADIOPHARM, LineFlags.DATA_HCPCS_PASSTHROUGH_STRESS_AGENT, LineFlags.DATA_HCPCS_PASSTHROUGH_SKIN_PRODUCT})) {
                flags.set(LineFlags.PAYMENT_ADJUSTMENT_COINS_NA);
            }
            if (claim.isClaimVersionBefore(65)) {
                if (line.matchesStatusIndicator("G")) {
                    flags.set(LineFlags.PAYMENT_ADJUSTMENT_PASSTHRU_DRUG_OR_BIOLOGICAL);
                } else if (line.matchesStatusIndicator("H")) {
                    flags.set(LineFlags.PAYMENT_ADJUSTMENT_ADJUSTED_TO_COST);
                } else if (line.matchesStatusIndicator("J")) {
                    flags.set(LineFlags.PAYMENT_ADJUSTMENT_NEW_DRUG_OR_BIOLOGICAL);
                }
            }
            if (!claim.isClaimVersionAfter(82) || !claim.matchesBillType("13", "76") || !claim.isConditionCodePresent("M5") || !line.isNotIgnored() || !line.isNotPackaged() || !line.getFlags().isSet(LineFlags.DATA_HCPCS_OPIOID_USE_DISORDER)) continue;
            flags.set(LineFlags.PAYMENT_ADJUSTMENT_DEDUCTIBLE_COINS_NA);
        }
        if (claim.isClaimVersionBefore(86)) {
            boolean ptModifierPresent = false;
            for (Day day : navigator.getDayList()) {
                ptModifierPresent = false;
                for (LineItemInternal line : day.getLineItemList()) {
                    if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS) || !line.isHcpcsModifierPresent("PT") || !HardcodedHcpcsSet.isSurgicalCode(line.getHcpcs())) continue;
                    ptModifierPresent = true;
                    break;
                }
                if (!ptModifierPresent) continue;
                for (LineItemInternal line : day.getLineItemList()) {
                    if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS) || line.isPackaged() && line.isZeroCharge() || !HardcodedHcpcsSet.isSurgicalCode(line.getHcpcs())) continue;
                    line.getFlags().set(LineFlags.PAYMENT_ADJUSTMENT_DEDUCTIBLE_NA);
                }
            }
        } else {
            boolean ptModifierPresent = false;
            for (Day day : navigator.getDayList()) {
                ptModifierPresent = false;
                for (LineItemInternal line : day.getLineItemList()) {
                    if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS) || !line.isHcpcsModifierPresent("PT") || !HardcodedHcpcsSet.isSurgicalCode(line.getHcpcs()) && !HardcodedHcpcsSet.isExtendedSurgicalCode(line.getHcpcs())) continue;
                    ptModifierPresent = true;
                    break;
                }
                if (!ptModifierPresent) continue;
                for (LineItemInternal line : day.getLineItemList()) {
                    if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS) || line.isPackaged() && line.isZeroCharge() || !HardcodedHcpcsSet.isSurgicalCode(line.getHcpcs()) && !HardcodedHcpcsSet.isExtendedSurgicalCode(line.getHcpcs())) continue;
                    line.getFlags().set(LineFlags.PAYMENT_ADJUSTMENT_DEDUCTIBLE_NA_COINS_REDUCED);
                }
            }
        }
        return false;
    }
}

