/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.postprocessing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.HcpcsModifier;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ReturnCode;
import gov.cms.oce.processor.ClaimProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReturnCodeCheck
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(ReturnCodeCheck.class);

    ReturnCodeCheck() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Integer returnCode = claim.getProcessingInformation().getReturnCode();
        if (returnCode == null || returnCode == ReturnCode.UNKNOWN.code) {
            claim.setReturnCode(ReturnCode.OK);
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace("Return code present, clear line-level output values and editing buffers.");
            }
            Byte zero = 0;
            claim.getClaimRejectionDisposition().setValue(zero);
            claim.getClaimDenialDisposition().setValue(zero);
            claim.getClaimReturnToProviderDisposition().setValue(zero);
            claim.getClaimSuspensionDisposition().setValue(zero);
            claim.getLineRejectionDisposition().setValue(zero);
            claim.getLineDenialDisposition().setValue(zero);
            if (returnCode != ReturnCode.BAD_FROM_DATE.code && returnCode != ReturnCode.BAD_THRU_DATE.code && returnCode != ReturnCode.BAD_DATE_SEQUENCE.code && returnCode != ReturnCode.BAD_LINE_DATE.code && returnCode != ReturnCode.DATE_VERSION.code && returnCode != ReturnCode.BILL_TYPE_NOT_OPPS.code && returnCode != ReturnCode.CC41_NA_TOB.code && returnCode != ReturnCode.INVALID_EDIT_BYPASS.code && returnCode != ReturnCode.INVALID_BYPASS_VALUE.code && returnCode != ReturnCode.INVALID_VALUE_CODE_INPUT.code && returnCode != ReturnCode.INVALID_RECEIPT_DATE.code) {
                for (LineItemInternal line : claim.getLineItemList().getValue()) {
                    line.getEditList().clear();
                    for (HcpcsModifier hcpcsModifier : line.getHcpcsModifierInputList().getValue()) {
                        hcpcsModifier.getEditList().clear();
                    }
                }
            }
        }
        return false;
    }
}

