/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.preprocessing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.HardcodedApcSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InitializeClaim
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(InitializeClaim.class);

    InitializeClaim() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        String billType = claim.getBillType().getValue();
        if (billType == null || "".equals(billType.trim())) {
            claim.getFlags().set(ClaimFlags.INPUT_EMPTY_BILL_TYPE);
            claim.getFlags().set(ClaimFlags.INPUT_INVALID_BILL_TYPE);
        } else if (billType.trim().length() != 3) {
            claim.getFlags().set(ClaimFlags.INPUT_INVALID_BILL_TYPE);
        }
        if (claim.getAge().getValue().intValue() < 0 || 124 < claim.getAge().getValue().intValue()) {
            claim.getFlags().set(ClaimFlags.INPUT_INVALID_AGE);
        }
        if (claim.getSex().getValue().intValue() < 0 || 2 < claim.getSex().getValue().intValue()) {
            claim.getFlags().set(ClaimFlags.INPUT_INVALID_SEX);
        }
        if (claim.getDateStarted().isValid() && claim.getDateEnded().isValid()) {
            if (claim.getDateEnded().getValueAsDate().isBefore(claim.getDateStarted().getValueAsDate())) {
                claim.getFlags().set(ClaimFlags.INPUT_DATE_STARTED_AFTER_DATE_ENDED);
            }
        } else {
            if (!claim.getDateStarted().isValid()) {
                claim.getFlags().set(ClaimFlags.INPUT_INVALID_DATE_STARTED);
            }
            if (!claim.getDateEnded().isValid()) {
                claim.getFlags().set(ClaimFlags.INPUT_INVALID_DATE_ENDED);
            }
        }
        if (claim.getReceiptDate().getValue() != null && !claim.getReceiptDate().isValid()) {
            claim.getFlags().set(ClaimFlags.INPUT_INVALID_RECEIPT_DATE);
        }
        boolean byte_zero = false;
        List<LineItemInternal> lineItemList = claim.getLineItemList().getValue();
        if (lineItemList.isEmpty()) {
            claim.getFlags().set(ClaimFlags.INPUT_CLAIM_HAS_NO_LINES);
        } else {
            for (LineItemInternal lineItem : lineItemList) {
                BigDecimal charge;
                Integer units;
                String hcpcs;
                Short revenueCode;
                String serviceDate = lineItem.getServiceDate().getValue();
                if (serviceDate == null || "".equals(serviceDate.trim())) {
                    lineItem.getFlags().set((LineFlags)new LineFlags[]{LineFlags.INPUT_EMPTY_SERVICE_DATE, LineFlags.INPUT_INVALID_SERVICE_DATE});
                }
                if ((revenueCode = lineItem.getRevenueCode().getValue()) == null) {
                    lineItem.getFlags().set(LineFlags.INPUT_INVALID_REVENUE_CODE);
                }
                if ((hcpcs = lineItem.getHcpcs().getValue()) == null || "".equals(hcpcs.trim())) {
                    lineItem.getFlags().set(LineFlags.INPUT_EMPTY_HCPCS);
                }
                if ((units = lineItem.getUnits().getValue()) == null || units < 1) {
                    lineItem.getFlags().set(LineFlags.INPUT_UNITS_ADJUSTED);
                    lineItem.getUnits().setValue(1);
                }
                if ((charge = lineItem.getCharge().getValue()) == null || charge.compareTo(BigDecimal.ZERO) < 0) {
                    lineItem.getFlags().set(LineFlags.INPUT_CHARGE_ADJUSTED);
                    lineItem.getCharge().setValue(BigDecimal.ZERO);
                }
                lineItem.getStatusIndicator().setValue("W");
                lineItem.getPaymentIndicator().setValue((byte)3);
                lineItem.getDiscountingFormula().setValue((byte)1);
                lineItem.getCompositeAdjustmentFlag().setValue("00");
                lineItem.setHcpcsApc(HardcodedApcSet.APC_ZERO.getApc());
                lineItem.setPaymentApc(HardcodedApcSet.APC_ZERO.getApc());
                lineItem.getPackagingFlag().setValue((byte)0);
                lineItem.getPaymentMethodFlag().setValue("0");
                lineItem.getRejectionDenialFlag().setValue((byte)0);
                lineItem.getPaymentAdjustmentFlag01().setValue((byte)0);
                lineItem.getPaymentAdjustmentFlag02().setValue((byte)0);
                if (lineItem.getActionFlag().getValue() == null) {
                    lineItem.getActionFlag().setValue((byte)0);
                    continue;
                }
                switch (lineItem.getActionFlag().getValue().intValue()) {
                    case 1: {
                        lineItem.getFlags().set(LineFlags.INPUT_LINE_EDIT_BYPASS);
                        break;
                    }
                    case 2: 
                    case 3: {
                        lineItem.getPaymentMethodFlag().setValue("4");
                    }
                    case 4: {
                        lineItem.getFlags().set(LineFlags.INPUT_LINE_IGNORED_BY_LIAF);
                        break;
                    }
                }
            }
        }
        claim.getClaimProcessedFlag().setValue((byte)0);
        claim.getClaimDisposition().setValue((byte)0);
        claim.getClaimReturnToProviderDisposition().setValue((byte)0);
        claim.getClaimSuspensionDisposition().setValue((byte)0);
        claim.getClaimDenialDisposition().setValue((byte)0);
        claim.getClaimRejectionDisposition().setValue((byte)0);
        claim.getLineDenialDisposition().setValue((byte)0);
        claim.getLineRejectionDisposition().setValue((byte)0);
        if (claim.isNonOpps()) {
            claim.getNoppsBillFlag().setValue((byte)2);
        } else {
            claim.getNoppsBillFlag().setValue((byte)0);
        }
        return false;
    }
}

